/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.role;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.ActionTypes;
import org.elasticsearch.xpack.core.security.action.role.QueryRoleRequest;
import org.elasticsearch.xpack.core.security.action.role.QueryRoleResponse;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;
import org.elasticsearch.xpack.security.support.FieldNameTranslators;
import org.elasticsearch.xpack.security.support.RoleBoolQueryBuilder;

public class TransportQueryRoleAction
extends TransportAction<QueryRoleRequest, QueryRoleResponse> {
    public static final String ROLE_NAME_RUNTIME_MAPPING_FIELD = "runtime_role_name";
    private static final Map<String, Object> ROLE_NAME_RUNTIME_MAPPING = Map.of("runtime_role_name", Map.of("type", "keyword", "script", Map.of("source", "emit(params._fields['_id'].value.substring(5));")));
    private final NativeRolesStore nativeRolesStore;

    @Inject
    public TransportQueryRoleAction(ActionFilters actionFilters, NativeRolesStore nativeRolesStore, TransportService transportService) {
        super(ActionTypes.QUERY_ROLE_ACTION.name(), actionFilters, transportService.getTaskManager(), (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.nativeRolesStore = nativeRolesStore;
    }

    protected void doExecute(Task task, QueryRoleRequest request, ActionListener<QueryRoleResponse> listener) {
        SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.searchSource().version(Boolean.valueOf(false)).fetchSource(true).trackTotalHits(true);
        if (request.getFrom() != null) {
            searchSourceBuilder.from(request.getFrom().intValue());
        }
        if (request.getSize() != null) {
            searchSourceBuilder.size(request.getSize().intValue());
        }
        if (request.getSearchAfterBuilder() != null) {
            searchSourceBuilder.searchAfter(request.getSearchAfterBuilder().getSortValues());
        }
        AtomicBoolean accessesMetadata = new AtomicBoolean(false);
        AtomicBoolean accessesRoleName = new AtomicBoolean(false);
        searchSourceBuilder.query((QueryBuilder)RoleBoolQueryBuilder.build(request.getQueryBuilder(), indexFieldName -> {
            if (indexFieldName.startsWith("metadata_flattened")) {
                accessesMetadata.set(true);
            } else if (indexFieldName.equals(ROLE_NAME_RUNTIME_MAPPING_FIELD)) {
                accessesRoleName.set(true);
            }
        }));
        if (request.getFieldSortBuilders() != null) {
            FieldNameTranslators.ROLE_FIELD_NAME_TRANSLATORS.translateFieldSortBuilders(request.getFieldSortBuilders(), searchSourceBuilder, indexFieldName -> {
                if (indexFieldName.startsWith("metadata_flattened")) {
                    accessesMetadata.set(true);
                } else if (indexFieldName.equals(ROLE_NAME_RUNTIME_MAPPING_FIELD)) {
                    accessesRoleName.set(true);
                }
            });
        }
        if (accessesMetadata.get() && !this.nativeRolesStore.isMetadataSearchable()) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Cannot query or sort role metadata until automatic migration completed", RestStatus.SERVICE_UNAVAILABLE, new Object[0]));
            return;
        }
        if (accessesRoleName.get()) {
            searchSourceBuilder.runtimeMappings(ROLE_NAME_RUNTIME_MAPPING);
        }
        this.nativeRolesStore.queryRoleDescriptors(searchSourceBuilder, (ActionListener<QueryRoleResponse.QueryRoleResult>)ActionListener.wrap(queryRoleResults -> listener.onResponse((Object)new QueryRoleResponse(queryRoleResults.total(), queryRoleResults.items())), arg_0 -> listener.onFailure(arg_0)));
    }
}

