/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceFieldConfig;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceParseHelper;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.spatial.search.aggregations.GeoLineAggregatorFactory;

public class GeoLineAggregationBuilder
extends MultiValuesSourceAggregationBuilder.LeafOnly<GeoLineAggregationBuilder> {
    static final ParseField POINT_FIELD = new ParseField("point", new String[0]);
    static final ParseField SORT_FIELD = new ParseField("sort", new String[0]);
    static final ParseField ORDER_FIELD = new ParseField("sort_order", new String[0]);
    static final ParseField INCLUDE_SORT_FIELD = new ParseField("include_sort", new String[0]);
    static final ParseField SIZE_FIELD = new ParseField("size", new String[0]);
    public static final String NAME = "geo_line";
    public static final ObjectParser<GeoLineAggregationBuilder, String> PARSER = ObjectParser.fromBuilder((String)"geo_line", GeoLineAggregationBuilder::new);
    private boolean includeSort;
    private SortOrder sortOrder = SortOrder.ASC;
    private int size = 10000;
    static final int MAX_PATH_SIZE = 10000;

    public static void registerUsage(ValuesSourceRegistry.Builder builder) {
        builder.registerUsage(NAME, (ValuesSourceType)CoreValuesSourceType.GEOPOINT);
    }

    public GeoLineAggregationBuilder(String name) {
        super(name);
    }

    private GeoLineAggregationBuilder(GeoLineAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super((MultiValuesSourceAggregationBuilder.LeafOnly)clone, factoriesBuilder, metaData);
    }

    public GeoLineAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.sortOrder = SortOrder.readFromStream((StreamInput)in);
        this.includeSort = in.readBoolean();
        this.size = in.readVInt();
    }

    public GeoLineAggregationBuilder includeSort(boolean includeSort) {
        this.includeSort = includeSort;
        return this;
    }

    public GeoLineAggregationBuilder sortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }

    public GeoLineAggregationBuilder size(int size) {
        if (size <= 0 || size > 10000) {
            throw new IllegalArgumentException("invalid [size] value [" + size + "] must be a positive integer <= 10000");
        }
        this.size = size;
        return this;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new GeoLineAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.NONE;
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        this.sortOrder.writeTo(out);
        out.writeBoolean(this.includeSort);
        out.writeVInt(this.size);
    }

    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.NUMERIC;
    }

    protected MultiValuesSourceAggregatorFactory innerBuild(AggregationContext aggregationContext, Map<String, ValuesSourceConfig> configs, Map<String, QueryBuilder> filters, DocValueFormat format, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        this.validateTimeSeriesConfigs(aggregationContext, configs);
        return new GeoLineAggregatorFactory(this.name, configs, format, aggregationContext, parent, subFactoriesBuilder, this.metadata, this.includeSort, this.sortOrder, this.size);
    }

    private void validateTimeSeriesConfigs(AggregationContext context, Map<String, ValuesSourceConfig> configs) {
        ValuesSourceConfig sourceConfig = configs.get(SORT_FIELD.getPreferredName());
        if (context.isInSortOrderExecutionRequired()) {
            if (sourceConfig == null) {
                MultiValuesSourceFieldConfig fieldConfig = new MultiValuesSourceFieldConfig.Builder().setFieldName("@timestamp").build();
                sourceConfig = ValuesSourceConfig.resolveUnregistered((AggregationContext)context, null, (String)fieldConfig.getFieldName(), (Script)fieldConfig.getScript(), (Object)fieldConfig.getMissing(), (ZoneId)fieldConfig.getTimeZone(), null, (ValuesSourceType)this.defaultValueSourceType());
                configs.put(SORT_FIELD.getPreferredName(), sourceConfig);
            } else if (!sourceConfig.fieldContext().field().equals("@timestamp")) {
                throw new IllegalArgumentException("invalid field [" + SORT_FIELD.getPreferredName() + "]='" + sourceConfig.fieldContext().field() + "' configured for time-series aggregations");
            }
        } else if (sourceConfig == null) {
            throw new IllegalArgumentException("missing field [" + SORT_FIELD.getPreferredName() + "] configured for geo_line aggregations");
        }
    }

    public GeoLineAggregationBuilder point(MultiValuesSourceFieldConfig pointConfig) {
        pointConfig = Objects.requireNonNull(pointConfig, "Configuration for field [" + String.valueOf(POINT_FIELD) + "] cannot be null");
        this.field(POINT_FIELD.getPreferredName(), pointConfig);
        return this;
    }

    public GeoLineAggregationBuilder sort(MultiValuesSourceFieldConfig sortConfig) {
        sortConfig = Objects.requireNonNull(sortConfig, "Configuration for field [" + String.valueOf(SORT_FIELD) + "] cannot be null");
        this.field(SORT_FIELD.getPreferredName(), sortConfig);
        return this;
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) {
        return builder;
    }

    public String getType() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ZERO;
    }

    static {
        MultiValuesSourceParseHelper.declareCommon(PARSER, (boolean)true, (ValueType)ValueType.NUMERIC);
        MultiValuesSourceParseHelper.declareField((String)POINT_FIELD.getPreferredName(), PARSER, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        MultiValuesSourceParseHelper.declareField((String)SORT_FIELD.getPreferredName(), PARSER, (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false);
        PARSER.declareString((builder, order) -> builder.sortOrder(SortOrder.fromString((String)order)), ORDER_FIELD);
        PARSER.declareBoolean(GeoLineAggregationBuilder::includeSort, INCLUDE_SORT_FIELD);
        PARSER.declareInt(GeoLineAggregationBuilder::size, SIZE_FIELD);
    }
}

