/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import java.util.function.Supplier;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.telemetry.apm.APMMeterRegistry;
import org.elasticsearch.telemetry.apm.internal.APMAgentSettings;

public class APMMeterService
extends AbstractLifecycleComponent {
    private final APMMeterRegistry meterRegistry;
    private final Supplier<Meter> otelMeterSupplier;
    private final Supplier<Meter> noopMeterSupplier;
    protected volatile boolean enabled;

    public APMMeterService(Settings settings) {
        this(settings, APMMeterService.otelMeter(), APMMeterService.noopMeter());
    }

    public APMMeterService(Settings settings, Supplier<Meter> otelMeterSupplier, Supplier<Meter> noopMeterSupplier) {
        this((Boolean)APMAgentSettings.TELEMETRY_METRICS_ENABLED_SETTING.get(settings), otelMeterSupplier, noopMeterSupplier);
    }

    public APMMeterService(boolean enabled, Supplier<Meter> otelMeterSupplier, Supplier<Meter> noopMeterSupplier) {
        this.enabled = enabled;
        this.otelMeterSupplier = otelMeterSupplier;
        this.noopMeterSupplier = noopMeterSupplier;
        this.meterRegistry = new APMMeterRegistry(enabled ? this.createOtelMeter() : this.createNoopMeter());
    }

    public APMMeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.meterRegistry.setProvider(this.createOtelMeter());
        } else {
            this.meterRegistry.setProvider(this.createNoopMeter());
        }
    }

    protected void doStart() {
    }

    protected void doStop() {
        this.meterRegistry.setProvider(this.createNoopMeter());
    }

    protected void doClose() {
    }

    protected Meter createOtelMeter() {
        assert (this.enabled);
        return this.otelMeterSupplier.get();
    }

    protected Meter createNoopMeter() {
        return this.noopMeterSupplier.get();
    }

    protected static Supplier<Meter> noopMeter() {
        return () -> OpenTelemetry.noop().getMeter("noop");
    }

    private static Supplier<Meter> otelMeter() {
        OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
        Meter meter = openTelemetry.getMeter("elasticsearch");
        return () -> meter;
    }
}

