/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentValueValidator;
import com.unboundid.util.args.TimestampArgument;
import java.io.Serializable;
import java.util.Date;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TimestampRangeArgumentValueValidator
extends ArgumentValueValidator
implements Serializable {
    private static final long serialVersionUID = 7248120077176469324L;
    @Nullable
    private final Date mostRecentAllowedDate;
    @Nullable
    private final Date oldestAllowedDate;

    public TimestampRangeArgumentValueValidator(@Nullable Date oldestAllowedDate, @Nullable Date mostRecentAllowedDate) {
        this.oldestAllowedDate = oldestAllowedDate;
        this.mostRecentAllowedDate = mostRecentAllowedDate;
    }

    @Nullable
    public Date getOldestAllowedDate() {
        return this.oldestAllowedDate;
    }

    @Nullable
    public Date getMostRecentAllowedDate() {
        return this.mostRecentAllowedDate;
    }

    @Override
    public void validateArgumentValue(@NotNull Argument argument, @NotNull String valueString) throws ArgumentException {
        Date parsedDate;
        try {
            parsedDate = TimestampArgument.parseTimestamp(valueString);
        }
        catch (Exception e) {
            throw new ArgumentException(ArgsMessages.ERR_TIMESTAMP_VALUE_NOT_TIMESTAMP.get(valueString, argument.getIdentifierString()), e);
        }
        long parsedTime = parsedDate.getTime();
        if (this.oldestAllowedDate != null && parsedTime < this.oldestAllowedDate.getTime()) {
            throw new ArgumentException(ArgsMessages.ERR_TIMESTAMP_RANGE_VALIDATOR_TOO_OLD.get(valueString, argument.getIdentifierString(), StaticUtils.encodeGeneralizedTime(this.oldestAllowedDate)));
        }
        if (this.mostRecentAllowedDate != null && parsedTime > this.mostRecentAllowedDate.getTime()) {
            throw new ArgumentException(ArgsMessages.ERR_TIMESTAMP_RANGE_VALIDATOR_TOO_NEW.get(valueString, argument.getIdentifierString(), StaticUtils.encodeGeneralizedTime(this.mostRecentAllowedDate)));
        }
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("TimestampRangeArgumentValueValidator(");
        if (this.oldestAllowedDate != null) {
            buffer.append("oldestAllowedDate='");
            buffer.append(StaticUtils.encodeGeneralizedTime(this.oldestAllowedDate));
            buffer.append('\'');
            if (this.mostRecentAllowedDate != null) {
                buffer.append(", mostRecentAllowedDate='");
                buffer.append(StaticUtils.encodeGeneralizedTime(this.mostRecentAllowedDate));
                buffer.append('\'');
            }
        } else if (this.mostRecentAllowedDate != null) {
            buffer.append("mostRecentAllowedDate='");
            buffer.append(StaticUtils.encodeGeneralizedTime(this.mostRecentAllowedDate));
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

