/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class OAUTHBEARERBindResult
extends BindResult {
    @NotNull
    private static final String FAILURE_DETAILS_FIELD_AUTHZ_ERROR_CODE = "status";
    @NotNull
    private static final String FAILURE_DETAILS_FIELD_OPENID_CONFIG_URL = "openid-configuration";
    @NotNull
    private static final String FAILURE_DETAILS_FIELD_SCOPE = "scope";
    private static final long serialVersionUID = 6513765034667496311L;
    @Nullable
    private final BindResult finalBindResult;
    @NotNull
    private final BindResult initialBindResult;
    @Nullable
    private final JSONObject failureDetailsObject;
    @NotNull
    private final Set<String> scopes;
    @Nullable
    private final String authorizationErrorCode;
    @Nullable
    private final String openIDConfigurationURL;

    public OAUTHBEARERBindResult(@NotNull BindResult bindResult) {
        this(bindResult, null);
    }

    public OAUTHBEARERBindResult(@NotNull BindResult initialBindResult, @Nullable BindResult finalBindResult) {
        super(OAUTHBEARERBindResult.mergeBindResults(initialBindResult, finalBindResult));
        JSONObject credentialsObject;
        this.initialBindResult = initialBindResult;
        this.finalBindResult = finalBindResult;
        ASN1OctetString serverSASLCredentials = initialBindResult.getServerSASLCredentials();
        if (serverSASLCredentials == null) {
            this.failureDetailsObject = null;
            this.authorizationErrorCode = null;
            this.scopes = Collections.emptySet();
            this.openIDConfigurationURL = null;
            return;
        }
        try {
            credentialsObject = new JSONObject(serverSASLCredentials.stringValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.failureDetailsObject = null;
            this.authorizationErrorCode = null;
            this.scopes = Collections.emptySet();
            this.openIDConfigurationURL = null;
            return;
        }
        this.failureDetailsObject = credentialsObject;
        this.authorizationErrorCode = credentialsObject.getFieldAsString(FAILURE_DETAILS_FIELD_AUTHZ_ERROR_CODE);
        this.openIDConfigurationURL = credentialsObject.getFieldAsString(FAILURE_DETAILS_FIELD_OPENID_CONFIG_URL);
        String scopeStr = credentialsObject.getFieldAsString(FAILURE_DETAILS_FIELD_SCOPE);
        if (scopeStr == null) {
            this.scopes = Collections.emptySet();
            return;
        }
        LinkedHashSet<String> scopeSet = new LinkedHashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(scopeStr, " ");
        while (tokenizer.hasMoreTokens()) {
            scopeSet.add(tokenizer.nextToken());
        }
        this.scopes = Collections.unmodifiableSet(scopeSet);
    }

    @NotNull
    private static BindResult mergeBindResults(@NotNull BindResult initialBindResult, @Nullable BindResult finalBindResult) {
        if (finalBindResult == null) {
            return initialBindResult;
        }
        return new BindResult(finalBindResult.getMessageID(), finalBindResult.getResultCode(), finalBindResult.getDiagnosticMessage(), finalBindResult.getMatchedDN(), finalBindResult.getReferralURLs(), finalBindResult.getResponseControls(), initialBindResult.getServerSASLCredentials());
    }

    @NotNull
    public BindResult getInitialBindResult() {
        return this.initialBindResult;
    }

    @Nullable
    public BindResult getFinalBindResult() {
        return this.finalBindResult;
    }

    @Nullable
    public JSONObject getFailureDetailsObject() {
        return this.failureDetailsObject;
    }

    @Nullable
    public String getAuthorizationErrorCode() {
        return this.authorizationErrorCode;
    }

    @NotNull
    public Set<String> getScopes() {
        return this.scopes;
    }

    @Nullable
    public String getOpenIDConfigurationURL() {
        return this.openIDConfigurationURL;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("OAUTHBEARERBindResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        buffer.append(", hasServerSASLCredentials=");
        buffer.append(this.getServerSASLCredentials() != null);
        if (this.finalBindResult != null) {
            buffer.append(", initialBindResult=");
            this.initialBindResult.toString(buffer);
            buffer.append(", finalBindResult=");
            this.finalBindResult.toString(buffer);
        }
        if (this.failureDetailsObject != null) {
            buffer.append(", failureDetailsObject=");
            this.failureDetailsObject.toSingleLineString(buffer);
        }
        if (this.authorizationErrorCode != null) {
            buffer.append(", authorizationErrorCode='");
            buffer.append(this.authorizationErrorCode);
            buffer.append('\'');
        }
        if (!this.scopes.isEmpty()) {
            buffer.append(", scopes={");
            Iterator<String> iterator = this.scopes.iterator();
            while (iterator.hasNext()) {
                buffer.append(' ');
                buffer.append(iterator.next());
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append(" }");
        }
        if (this.openIDConfigurationURL != null) {
            buffer.append(", openIDConfigURL='");
            buffer.append(this.openIDConfigurationURL);
            buffer.append('\'');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

