/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.rest;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.datastreams.UpdateDataStreamSettingsAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;
import org.elasticsearch.xcontent.XContentParser;

@ServerlessScope(value=Scope.PUBLIC)
public class RestUpdateDataStreamSettingsAction
extends BaseRestHandler {
    public String getName() {
        return "update_data_stream_settings_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_data_stream/{name}/_settings"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        Settings settings;
        try (XContentParser parser = request.contentParser();){
            settings = Settings.fromXContent((XContentParser)parser);
        }
        boolean dryRun = request.paramAsBoolean("dry_run", false);
        UpdateDataStreamSettingsAction.Request putDataStreamRequest = new UpdateDataStreamSettingsAction.Request(settings, dryRun, RestUtils.getMasterNodeTimeout((RestRequest)request), RestUtils.getAckTimeout((RestRequest)request)).indices(Strings.splitStringByCommaToArray((String)request.param("name")));
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).execute((ActionType)UpdateDataStreamSettingsAction.INSTANCE, (ActionRequest)putDataStreamRequest, (ActionListener)new RestRefCountedChunkedToXContentListener(channel));
    }
}

