/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.SubstringFunctionPipe;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.SubstringFunctionProcessor;

public class Substring
extends ScalarFunction {
    private final Expression input;
    private final Expression start;
    private final Expression length;

    public Substring(Source source, Expression input, Expression start, Expression length) {
        super(source, Arrays.asList(input, start, length));
        this.input = input;
        this.start = start;
        this.length = length;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution sourceResolution = TypeResolutions.isStringAndExact((Expression)this.input, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (sourceResolution.unresolved()) {
            return sourceResolution;
        }
        Expression.TypeResolution startResolution = TypeResolutions.isInteger((Expression)this.start, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        if (startResolution.unresolved()) {
            return startResolution;
        }
        return TypeResolutions.isInteger((Expression)this.length, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD);
    }

    protected Pipe makePipe() {
        return new SubstringFunctionPipe(this.source(), (Expression)this, Expressions.pipe((Expression)this.input), Expressions.pipe((Expression)this.start), Expressions.pipe((Expression)this.length));
    }

    public boolean foldable() {
        return this.input.foldable() && this.start.foldable() && this.length.foldable();
    }

    public Object fold() {
        return SubstringFunctionProcessor.doProcess(this.input.fold(), this.start.fold(), this.length.fold());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Substring::new, (Object)this.input, (Object)this.start, (Object)this.length);
    }

    public ScriptTemplate asScript() {
        ScriptTemplate inputScript = this.asScript(this.input);
        ScriptTemplate startScript = this.asScript(this.start);
        ScriptTemplate lengthScript = this.asScript(this.length);
        return this.asScriptFrom(inputScript, startScript, lengthScript);
    }

    protected ScriptTemplate asScriptFrom(ScriptTemplate inputScript, ScriptTemplate startScript, ScriptTemplate lengthScript) {
        return new ScriptTemplate(String.format(Locale.ROOT, this.formatTemplate("{sql}.%s(%s,%s,%s)"), "substring", inputScript.template(), startScript.template(), lengthScript.template()), ParamsBuilder.paramsBuilder().script(inputScript.params()).script(startScript.params()).script(lengthScript.params()).build(), this.dataType());
    }

    public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable((Object)field.exactAttribute().name()).build(), this.dataType());
    }

    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Substring(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }
}

