/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.license.License;
import org.elasticsearch.license.internal.TrialLicenseVersion;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public class LicensesMetadata
extends AbstractNamedDiffable<Metadata.ClusterCustom>
implements Metadata.ClusterCustom {
    public static final String TYPE = "licenses";
    public static final License LICENSE_TOMBSTONE = License.builder().type(License.LicenseType.TRIAL).issuer("elasticsearch").uid("TOMBSTONE").issuedTo("").maxNodes(0).issueDate(0L).expiryDate(0L).build();
    private final License license;
    @Nullable
    private TrialLicenseVersion trialLicenseVersion;

    public LicensesMetadata(License license, TrialLicenseVersion trialLicenseVersion) {
        this.license = license;
        this.trialLicenseVersion = trialLicenseVersion;
    }

    public License getLicense() {
        return this.license;
    }

    boolean isEligibleForTrial() {
        if (this.trialLicenseVersion == null) {
            return true;
        }
        return this.trialLicenseVersion.ableToStartNewTrial();
    }

    TrialLicenseVersion getMostRecentTrialVersion() {
        return this.trialLicenseVersion;
    }

    public String toString() {
        return "LicensesMetadata{license=" + String.valueOf(this.license) + ", trialVersion=" + String.valueOf(this.trialLicenseVersion) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LicensesMetadata that = (LicensesMetadata)((Object)o);
        return Objects.equals(this.license, that.license) && Objects.equals(this.trialLicenseVersion, that.trialLicenseVersion);
    }

    public int hashCode() {
        int result = this.license != null ? this.license.hashCode() : 0;
        result = 31 * result + (this.trialLicenseVersion != null ? this.trialLicenseVersion.hashCode() : 0);
        return result;
    }

    public String getWriteableName() {
        return TYPE;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.MINIMUM_COMPATIBLE;
    }

    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.GATEWAY);
    }

    public static LicensesMetadata fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        License license = LICENSE_TOMBSTONE;
        TrialLicenseVersion trialLicense = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            String fieldName;
            if (token != XContentParser.Token.FIELD_NAME || (fieldName = parser.currentName()) == null) continue;
            if (fieldName.equals("license")) {
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    license = License.fromXContent(parser);
                    continue;
                }
                if (token != XContentParser.Token.VALUE_NULL) continue;
                license = LICENSE_TOMBSTONE;
                continue;
            }
            if (!fieldName.equals("trial_license")) continue;
            parser.nextToken();
            trialLicense = TrialLicenseVersion.fromXContent(parser.text());
        }
        return new LicensesMetadata(license, trialLicense);
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.single((builder, params) -> {
            if (this.license == LICENSE_TOMBSTONE) {
                builder.nullField("license");
            } else {
                builder.startObject("license");
                this.license.toInnerXContent(builder, params);
                builder.endObject();
            }
            if (this.trialLicenseVersion != null) {
                builder.field("trial_license", this.trialLicenseVersion.toString());
            }
            return builder;
        });
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        if (this.license == LICENSE_TOMBSTONE) {
            streamOutput.writeBoolean(false);
        } else {
            streamOutput.writeBoolean(true);
            this.license.writeTo(streamOutput);
        }
        if (this.trialLicenseVersion == null) {
            streamOutput.writeBoolean(false);
        } else {
            streamOutput.writeBoolean(true);
            this.trialLicenseVersion.writeTo(streamOutput);
        }
    }

    public LicensesMetadata(StreamInput streamInput) throws IOException {
        this.license = streamInput.readBoolean() ? License.readLicense(streamInput) : LICENSE_TOMBSTONE;
        boolean hasExercisedTrial = streamInput.readBoolean();
        if (hasExercisedTrial) {
            this.trialLicenseVersion = new TrialLicenseVersion(streamInput);
        }
    }

    public static NamedDiff<Metadata.ClusterCustom> readDiffFrom(StreamInput streamInput) throws IOException {
        return LicensesMetadata.readDiffFrom(Metadata.ClusterCustom.class, (String)TYPE, (StreamInput)streamInput);
    }

    public static License extractLicense(LicensesMetadata licensesMetadata) {
        if (licensesMetadata != null) {
            License license = licensesMetadata.getLicense();
            if (license == LICENSE_TOMBSTONE) {
                return null;
            }
            return license;
        }
        return null;
    }

    private static final class Fields {
        private static final String LICENSE = "license";
        private static final String TRIAL_LICENSE = "trial_license";

        private Fields() {
        }
    }
}

