/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip.stats;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.ingest.geoip.stats.CacheStats;
import org.elasticsearch.ingest.geoip.stats.GeoIpDownloaderStats;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GeoIpStatsAction {
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:monitor/ingest/geoip/stats");

    private GeoIpStatsAction() {
    }

    public static class NodeResponse
    extends BaseNodeResponse {
        private final GeoIpDownloaderStats downloaderStats;
        private final CacheStats cacheStats;
        private final Set<String> databases;
        private final Set<String> filesInTemp;
        private final Set<String> configDatabases;

        protected NodeResponse(StreamInput in) throws IOException {
            super(in);
            GeoIpDownloaderStats geoIpDownloaderStats = this.downloaderStats = in.readBoolean() ? new GeoIpDownloaderStats(in) : null;
            this.cacheStats = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0) ? (in.readBoolean() ? new CacheStats(in) : null) : null;
            this.databases = in.readCollectionAsImmutableSet(StreamInput::readString);
            this.filesInTemp = in.readCollectionAsImmutableSet(StreamInput::readString);
            this.configDatabases = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_0_0) ? in.readCollectionAsImmutableSet(StreamInput::readString) : null;
        }

        protected NodeResponse(DiscoveryNode node, GeoIpDownloaderStats downloaderStats, CacheStats cacheStats, Set<String> databases, Set<String> filesInTemp, Set<String> configDatabases) {
            super(node);
            this.downloaderStats = downloaderStats;
            this.cacheStats = cacheStats;
            this.databases = Set.copyOf(databases);
            this.filesInTemp = Set.copyOf(filesInTemp);
            this.configDatabases = Set.copyOf(configDatabases);
        }

        public GeoIpDownloaderStats getDownloaderStats() {
            return this.downloaderStats;
        }

        public Set<String> getDatabases() {
            return this.databases;
        }

        public Set<String> getFilesInTemp() {
            return this.filesInTemp;
        }

        public Set<String> getConfigDatabases() {
            return this.configDatabases;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.downloaderStats != null);
            if (this.downloaderStats != null) {
                this.downloaderStats.writeTo(out);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0)) {
                out.writeBoolean(this.cacheStats != null);
                if (this.cacheStats != null) {
                    this.cacheStats.writeTo(out);
                }
            }
            out.writeStringCollection(this.databases);
            out.writeStringCollection(this.filesInTemp);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_0_0)) {
                out.writeStringCollection(this.configDatabases);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            NodeResponse that = (NodeResponse)((Object)o);
            return this.downloaderStats.equals(that.downloaderStats) && Objects.equals(this.cacheStats, that.cacheStats) && this.databases.equals(that.databases) && this.filesInTemp.equals(that.filesInTemp) && Objects.equals(this.configDatabases, that.configDatabases);
        }

        public int hashCode() {
            return Objects.hash(this.downloaderStats, this.cacheStats, this.databases, this.filesInTemp, this.configDatabases);
        }
    }

    public static class Response
    extends BaseNodesResponse<NodeResponse>
    implements Writeable,
    ToXContentObject {
        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(ClusterName clusterName, List<NodeResponse> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        public GeoIpDownloaderStats getDownloaderStats() {
            return this.getNodes().stream().map(n -> n.downloaderStats).filter(Objects::nonNull).findFirst().orElse(GeoIpDownloaderStats.EMPTY);
        }

        protected List<NodeResponse> readNodesFrom(StreamInput in) throws IOException {
            return in.readCollectionAsList(NodeResponse::new);
        }

        protected void writeNodesTo(StreamOutput out, List<NodeResponse> nodes) throws IOException {
            out.writeCollection(nodes);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            GeoIpDownloaderStats stats = this.getDownloaderStats();
            builder.startObject();
            builder.field("stats", (ToXContent)stats);
            builder.startObject("nodes");
            for (Map.Entry e : this.getNodesMap().entrySet()) {
                NodeResponse response = (NodeResponse)((Object)e.getValue());
                if (response.filesInTemp.isEmpty() && response.databases.isEmpty() && response.configDatabases.isEmpty()) continue;
                builder.startObject((String)e.getKey());
                if (!response.databases.isEmpty()) {
                    builder.startArray("databases");
                    for (String database : response.databases) {
                        builder.startObject();
                        builder.field("name", database);
                        builder.endObject();
                    }
                    builder.endArray();
                }
                if (!response.filesInTemp.isEmpty()) {
                    builder.array("files_in_temp", (String[])response.filesInTemp.toArray(String[]::new));
                }
                if (!response.configDatabases.isEmpty()) {
                    builder.array("config_databases", (String[])response.configDatabases.toArray(String[]::new));
                }
                builder.startObject("cache_stats");
                CacheStats cacheStats = response.cacheStats;
                builder.field("count", cacheStats.count());
                builder.field("hits", cacheStats.hits());
                builder.field("misses", cacheStats.misses());
                builder.field("evictions", cacheStats.evictions());
                builder.humanReadableField("hits_time_in_millis", "hits_time", (Object)new TimeValue(cacheStats.hitsTimeInMillis()));
                builder.humanReadableField("misses_time_in_millis", "misses_time", (Object)new TimeValue(cacheStats.missesTimeInMillis()));
                builder.endObject();
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return Objects.equals(this.getNodes(), that.getNodes()) && Objects.equals(this.failures(), that.failures());
        }

        public int hashCode() {
            return Objects.hash(this.getNodes(), this.failures());
        }
    }

    public static class NodeRequest
    extends AbstractTransportRequest {
        public NodeRequest(StreamInput in) throws IOException {
            super(in);
        }

        public NodeRequest() {
        }
    }

    public static class Request
    extends BaseNodesRequest
    implements ToXContentObject {
        public Request() {
            super((String[])null);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hashCode(INSTANCE.name());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return ((Object)((Object)this)).getClass() == obj.getClass();
        }
    }
}

