/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.CompositeBytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.network.HandlingTimeTracker;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Streams;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BytesTransportMessage;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.ResponseStatsConsumer;
import org.elasticsearch.transport.StatsTracker;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TcpHeader;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportLogger;
import org.elasticsearch.transport.TransportMessageListener;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportStatus;

public final class OutboundHandler {
    private static final Logger logger = LogManager.getLogger(OutboundHandler.class);
    private final String nodeName;
    private final TransportVersion version;
    private final StatsTracker statsTracker;
    private final ThreadPool threadPool;
    private final Recycler<BytesRef> recycler;
    private final HandlingTimeTracker handlingTimeTracker;
    private final boolean rstOnClose;
    private volatile long slowLogThresholdMs = Long.MAX_VALUE;
    private volatile TransportMessageListener messageListener = TransportMessageListener.NOOP_LISTENER;

    OutboundHandler(String nodeName, TransportVersion version, StatsTracker statsTracker, ThreadPool threadPool, Recycler<BytesRef> recycler, HandlingTimeTracker handlingTimeTracker, boolean rstOnClose) {
        this.nodeName = nodeName;
        this.version = version;
        this.statsTracker = statsTracker;
        this.threadPool = threadPool;
        this.recycler = recycler;
        this.handlingTimeTracker = handlingTimeTracker;
        this.rstOnClose = rstOnClose;
    }

    void setSlowLogThreshold(TimeValue slowLogThreshold) {
        this.slowLogThresholdMs = slowLogThreshold.getMillis();
    }

    void sendBytes(TcpChannel channel, BytesReference bytes, ActionListener<Void> listener) {
        this.internalSend(channel, bytes, () -> "raw bytes", listener);
    }

    void sendRequest(DiscoveryNode node, TcpChannel channel, long requestId, String action, TransportRequest request, TransportRequestOptions options, TransportVersion transportVersion, Compression.Scheme compressionScheme, boolean isHandshake) throws IOException, TransportException {
        assert (this.assertValidTransportVersion(transportVersion));
        this.sendMessage(channel, MessageDirection.REQUEST, action, request, requestId, isHandshake, compressionScheme, transportVersion, ResponseStatsConsumer.NONE, () -> this.messageListener.onRequestSent(node, requestId, action, request, options));
    }

    void sendResponse(TransportVersion transportVersion, TcpChannel channel, long requestId, String action, TransportResponse response, Compression.Scheme compressionScheme, boolean isHandshake, ResponseStatsConsumer responseStatsConsumer) {
        assert (this.assertValidTransportVersion(transportVersion));
        assert (response.hasReferences());
        try {
            this.sendMessage(channel, MessageDirection.RESPONSE, action, response, requestId, isHandshake, compressionScheme, transportVersion, responseStatsConsumer, () -> this.messageListener.onResponseSent(requestId, action));
        }
        catch (Exception ex) {
            if (isHandshake) {
                logger.error(() -> Strings.format((String)"Failed to send handshake response version [%s] received on [%s], closing channel", (Object[])new Object[]{transportVersion, channel}), (Throwable)ex);
                channel.setCloseException(ex);
                channel.close();
            }
            this.sendErrorResponse(transportVersion, channel, requestId, action, responseStatsConsumer, ex);
        }
    }

    void sendErrorResponse(TransportVersion transportVersion, TcpChannel channel, long requestId, String action, ResponseStatsConsumer responseStatsConsumer, Exception error) {
        assert (this.assertValidTransportVersion(transportVersion));
        RemoteTransportException msg = new RemoteTransportException(this.nodeName, channel.getLocalAddress(), action, (Throwable)error);
        try {
            this.sendMessage(channel, MessageDirection.RESPONSE_ERROR, action, msg, requestId, false, null, transportVersion, responseStatsConsumer, () -> this.messageListener.onResponseSent(requestId, action, error));
        }
        catch (Exception sendException) {
            sendException.addSuppressed(error);
            logger.error(() -> Strings.format((String)"Failed to send error response on channel [%s], closing channel", (Object[])new Object[]{channel}), (Throwable)sendException);
            channel.setCloseException(sendException);
            channel.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendMessage(TcpChannel channel, MessageDirection messageDirection, String action, Writeable writeable, long requestId, boolean isHandshake, Compression.Scheme possibleCompressionScheme, TransportVersion version, ResponseStatsConsumer responseStatsConsumer, Releasable onAfter) throws IOException {
        Releasable releasable;
        BytesReference message;
        RecyclerBytesStreamOutput byteStreamOutput;
        Compression.Scheme compressionScheme;
        block8: {
            assert (action != null);
            compressionScheme = writeable instanceof BytesTransportMessage ? null : possibleCompressionScheme;
            boolean serializeSuccess = false;
            byteStreamOutput = new RecyclerBytesStreamOutput(this.recycler);
            try {
                message = OutboundHandler.serialize(messageDirection, action, requestId, isHandshake, version, compressionScheme, writeable, this.threadPool.getThreadContext(), byteStreamOutput);
                serializeSuccess = true;
                if (serializeSuccess) break block8;
            }
            catch (Exception e) {
                try {
                    logger.warn(() -> "failed to serialize outbound message [" + String.valueOf(writeable) + "]", (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    if (!serializeSuccess) {
                        Releasables.close((Releasable[])new Releasable[]{byteStreamOutput, onAfter});
                    }
                    throw throwable;
                }
            }
            Releasables.close((Releasable[])new Releasable[]{byteStreamOutput, onAfter});
        }
        responseStatsConsumer.addResponseStats(message.length());
        Class<?> messageType = writeable.getClass();
        Supplier<String> supplier = () -> (messageDirection == MessageDirection.REQUEST ? "Request{" : "Response{") + action + "}{id=" + requestId + "}{err=" + (messageDirection == MessageDirection.RESPONSE_ERROR) + "}{cs=" + String.valueOf((Object)compressionScheme) + "}{hs=" + isHandshake + "}{t=" + String.valueOf(messageType) + "}";
        if (message instanceof ReleasableBytesReference) {
            ReleasableBytesReference r = (ReleasableBytesReference)message;
            releasable = Releasables.wrap((Releasable[])new Releasable[]{byteStreamOutput, onAfter, r});
        } else {
            releasable = Releasables.wrap((Releasable[])new Releasable[]{byteStreamOutput, onAfter});
        }
        this.internalSend(channel, message, supplier, ActionListener.releasing(releasable));
    }

    public static BytesReference serialize(MessageDirection messageDirection, String action, long requestId, boolean isHandshake, TransportVersion version, Compression.Scheme compressionScheme, Writeable writeable, ThreadContext threadContext, RecyclerBytesStreamOutput byteStreamOutput) throws IOException {
        assert (action != null);
        assert (byteStreamOutput.position() == 0L);
        byteStreamOutput.setTransportVersion(version);
        byteStreamOutput.skip(23);
        threadContext.writeTo(byteStreamOutput);
        if (messageDirection == MessageDirection.REQUEST) {
            if (version.before(TransportVersions.V_8_0_0)) {
                byteStreamOutput.writeStringArray(org.elasticsearch.common.Strings.EMPTY_ARRAY);
            }
            byteStreamOutput.writeString(action);
        }
        int variableHeaderLength = Math.toIntExact(byteStreamOutput.position() - 23L);
        BytesReference message = OutboundHandler.serializeMessageBody(writeable, compressionScheme, version, byteStreamOutput);
        byte status = 0;
        if (messageDirection != MessageDirection.REQUEST) {
            status = TransportStatus.setResponse(status);
        }
        if (isHandshake) {
            status = TransportStatus.setHandshake(status);
        }
        if (messageDirection == MessageDirection.RESPONSE_ERROR) {
            status = TransportStatus.setError(status);
        }
        if (compressionScheme != null) {
            status = TransportStatus.setCompress(status);
        }
        byteStreamOutput.seek(0L);
        TcpHeader.writeHeader(byteStreamOutput, requestId, status, version, message.length() - 23, variableHeaderLength);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BytesReference serializeMessageBody(Writeable writeable, Compression.Scheme compressionScheme, TransportVersion version, RecyclerBytesStreamOutput byteStreamOutput) throws IOException {
        ReleasableBytesReference zeroCopyBuffer;
        RecyclerBytesStreamOutput stream = compressionScheme != null ? OutboundHandler.wrapCompressed(compressionScheme, byteStreamOutput) : byteStreamOutput;
        try {
            stream.setTransportVersion(version);
            if (writeable instanceof BytesTransportMessage) {
                BytesTransportMessage bRequest = (BytesTransportMessage)((Object)writeable);
                assert (stream == byteStreamOutput);
                assert (compressionScheme == null);
                bRequest.writeThin(stream);
                zeroCopyBuffer = bRequest.bytes();
            } else if (writeable instanceof RemoteTransportException) {
                RemoteTransportException remoteTransportException = (RemoteTransportException)writeable;
                stream.writeException(remoteTransportException);
                zeroCopyBuffer = ReleasableBytesReference.empty();
            } else {
                writeable.writeTo(stream);
                zeroCopyBuffer = ReleasableBytesReference.empty();
            }
        }
        finally {
            if (compressionScheme != null) {
                ((StreamOutput)stream).close();
            }
        }
        BytesReference msg = byteStreamOutput.bytes();
        if (zeroCopyBuffer.length() == 0) {
            return msg;
        }
        zeroCopyBuffer.mustIncRef();
        return new ReleasableBytesReference(CompositeBytesReference.of(msg, zeroCopyBuffer), zeroCopyBuffer);
    }

    private static StreamOutput wrapCompressed(Compression.Scheme compressionScheme, RecyclerBytesStreamOutput bytesStream) throws IOException {
        if (compressionScheme == Compression.Scheme.DEFLATE) {
            return new OutputStreamStreamOutput(CompressorFactory.COMPRESSOR.threadLocalOutputStream(Streams.noCloseStream((OutputStream)bytesStream)));
        }
        if (compressionScheme == Compression.Scheme.LZ4) {
            return new OutputStreamStreamOutput(Compression.Scheme.lz4OutputStream(Streams.noCloseStream((OutputStream)bytesStream)));
        }
        throw new IllegalArgumentException("Invalid compression scheme: " + String.valueOf((Object)compressionScheme));
    }

    private void internalSend(final TcpChannel channel, BytesReference reference, final Supplier<String> messageDescription, final ActionListener<Void> listener) {
        final long startTime = this.threadPool.rawRelativeTimeInMillis();
        channel.getChannelStats().markAccessed(startTime);
        final long messageSize = reference.length();
        TransportLogger.logOutboundMessage(channel, reference);
        try (ThreadContext.StoredContext ignored = this.threadPool.getThreadContext().newEmptyContext();){
            channel.sendMessage(reference, new ActionListener<Void>(){

                @Override
                public void onResponse(Void v) {
                    OutboundHandler.this.statsTracker.markBytesWritten(messageSize);
                    listener.onResponse(v);
                    this.maybeLogSlowMessage(true);
                }

                @Override
                public void onFailure(Exception e) {
                    Level closeConnectionExceptionLevel = NetworkExceptionHelper.getCloseConnectionExceptionLevel(e, OutboundHandler.this.rstOnClose);
                    if (closeConnectionExceptionLevel == Level.OFF) {
                        logger.warn(() -> "send message failed [channel: " + String.valueOf(channel) + "]", (Throwable)e);
                    } else if (closeConnectionExceptionLevel == Level.INFO && !logger.isDebugEnabled()) {
                        logger.info("send message failed [channel: {}]: {}", (Object)channel, (Object)e.getMessage());
                    } else {
                        logger.log(closeConnectionExceptionLevel, () -> "send message failed [channel: " + String.valueOf(channel) + "]", (Throwable)e);
                    }
                    listener.onFailure(e);
                    this.maybeLogSlowMessage(false);
                }

                private void maybeLogSlowMessage(boolean success) {
                    long logThreshold = OutboundHandler.this.slowLogThresholdMs;
                    if (logThreshold > 0L) {
                        long took = OutboundHandler.this.threadPool.rawRelativeTimeInMillis() - startTime;
                        OutboundHandler.this.handlingTimeTracker.addObservation(took);
                        if (took > logThreshold) {
                            logger.warn("sending transport message [{}] of size [{}] on [{}] took [{}ms] which is above the warn threshold of [{}ms] with success [{}]", messageDescription.get(), (Object)messageSize, (Object)channel, (Object)took, (Object)logThreshold, (Object)success);
                        }
                    }
                }
            });
        }
        catch (RuntimeException ex) {
            channel.setCloseException(ex);
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{() -> listener.onFailure(ex), () -> CloseableChannel.closeChannel(channel)});
            throw ex;
        }
    }

    void setMessageListener(TransportMessageListener listener) {
        if (this.messageListener != TransportMessageListener.NOOP_LISTENER) {
            throw new IllegalStateException("Cannot set message listener twice");
        }
        this.messageListener = listener;
    }

    public boolean rstOnClose() {
        return this.rstOnClose;
    }

    private boolean assertValidTransportVersion(TransportVersion transportVersion) {
        assert (this.version.before(TransportVersions.MINIMUM_COMPATIBLE) || this.version.onOrAfter(transportVersion)) : String.valueOf(this.version) + " vs " + String.valueOf(transportVersion);
        return true;
    }

    public static enum MessageDirection {
        REQUEST,
        RESPONSE,
        RESPONSE_ERROR;

    }
}

