/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.TransportDecompressor;

public class DeflateTransportDecompressor
extends TransportDecompressor {
    private final Inflater inflater = new Inflater(true);

    public DeflateTransportDecompressor(Recycler<BytesRef> recycler) {
        super(recycler);
    }

    @Override
    public int decompress(BytesReference bytesReference) throws IOException {
        BytesRef ref;
        int bytesConsumed = 0;
        if (!this.hasSkippedHeader) {
            this.hasSkippedHeader = true;
            int headerLength = 4;
            bytesReference = bytesReference.slice(headerLength, bytesReference.length() - headerLength);
            bytesConsumed += headerLength;
        }
        BytesRefIterator refIterator = bytesReference.iterator();
        while ((ref = refIterator.next()) != null) {
            this.inflater.setInput(ref.bytes, ref.offset, ref.length);
            bytesConsumed += ref.length;
            boolean continueInflating = true;
            while (continueInflating) {
                boolean isNewPage = this.maybeAddNewPage();
                Recycler.V page = (Recycler.V)this.pages.getLast();
                BytesRef output = (BytesRef)page.v();
                try {
                    int bytesInflated = this.inflater.inflate(output.bytes, output.offset + this.pageOffset, this.pageLength - this.pageOffset);
                    this.pageOffset += bytesInflated;
                    if (isNewPage && bytesInflated == 0) {
                        Recycler.V removed = (Recycler.V)this.pages.pollLast();
                        assert (removed == page);
                        removed.close();
                        this.pageOffset = 16384;
                    }
                }
                catch (DataFormatException e) {
                    throw new IOException("Exception while inflating bytes", e);
                }
                if (this.inflater.needsInput()) {
                    continueInflating = false;
                }
                if (this.inflater.finished()) {
                    bytesConsumed -= this.inflater.getRemaining();
                    continueInflating = false;
                }
                assert (!this.inflater.needsDictionary());
            }
        }
        return bytesConsumed;
    }

    public boolean isEOS() {
        return this.inflater.finished();
    }

    @Override
    public Compression.Scheme getScheme() {
        return Compression.Scheme.DEFLATE;
    }

    @Override
    public void close() {
        this.inflater.end();
        super.close();
    }
}

