/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.persistent.ClusterPersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasks;
import org.elasticsearch.persistent.PersistentTasksExecutorRegistry;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class PersistentTasksCustomMetadata
extends AbstractNamedDiffable<Metadata.ProjectCustom>
implements Metadata.ProjectCustom,
PersistentTasks {
    public static final String TYPE = "persistent_tasks";
    private final Map<String, PersistentTask<?>> tasks;
    private final long lastAllocationId;
    private static final ObjectParser<Builder, Void> PERSISTENT_TASKS_PARSER = new ObjectParser("persistent_tasks", Builder::new);

    public PersistentTasksCustomMetadata(long lastAllocationId, Map<String, PersistentTask<?>> tasks) {
        this.lastAllocationId = lastAllocationId;
        this.tasks = tasks;
    }

    @Deprecated(forRemoval=true)
    public static PersistentTasksCustomMetadata getPersistentTasksCustomMetadata(ClusterState clusterState) {
        return PersistentTasksCustomMetadata.get(clusterState.metadata().getProject());
    }

    public static PersistentTasksCustomMetadata get(ProjectMetadata projectMetadata) {
        return (PersistentTasksCustomMetadata)projectMetadata.custom(TYPE);
    }

    @Override
    public long getLastAllocationId() {
        return this.lastAllocationId;
    }

    @Override
    public Map<String, PersistentTask<?>> taskMap() {
        return this.tasks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentTasksCustomMetadata that = (PersistentTasksCustomMetadata)o;
        return this.lastAllocationId == that.lastAllocationId && Objects.equals(this.tasks, that.tasks);
    }

    public int hashCode() {
        return Objects.hash(this.tasks, this.lastAllocationId);
    }

    public String toString() {
        return Strings.toString(this);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.MINIMUM_COMPATIBLE;
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public static PersistentTasksCustomMetadata fromXContent(XContentParser parser) {
        return ((Builder)PERSISTENT_TASKS_PARSER.apply(parser, null)).build();
    }

    @Deprecated(forRemoval=true)
    public static <Params extends PersistentTaskParams> PersistentTask<Params> getTaskWithId(ClusterState clusterState, String taskId) {
        return PersistentTasksCustomMetadata.getTaskWithId(clusterState.metadata().getProject(), taskId);
    }

    public static <Params extends PersistentTaskParams> PersistentTask<Params> getTaskWithId(ProjectMetadata project, String taskId) {
        PersistentTasksCustomMetadata tasks = PersistentTasksCustomMetadata.get(project);
        if (tasks != null) {
            return tasks.getTask(taskId);
        }
        return null;
    }

    public static ClusterState disassociateDeadNodes(ClusterState clusterState) {
        ClusterState updatedClusterState = clusterState;
        updatedClusterState = PersistentTasksCustomMetadata.disassociateDeadNodesForClusterOrSingleProject(updatedClusterState, null);
        for (ProjectId projectId : clusterState.metadata().projects().keySet()) {
            updatedClusterState = PersistentTasksCustomMetadata.disassociateDeadNodesForClusterOrSingleProject(updatedClusterState, projectId);
        }
        return updatedClusterState;
    }

    private static ClusterState disassociateDeadNodesForClusterOrSingleProject(ClusterState clusterState, @Nullable ProjectId projectId) {
        PersistentTasks tasks = PersistentTasks.getTasks(clusterState, projectId);
        if (tasks == null) {
            return clusterState;
        }
        Object taskBuilder = tasks.toBuilder().setLastAllocationId(clusterState);
        for (PersistentTask<?> task : tasks.tasks()) {
            if (task.getAssignment().getExecutorNode() == null || clusterState.nodes().nodeExists(task.getAssignment().getExecutorNode())) continue;
            ((PersistentTasks.Builder)taskBuilder).reassignTask(task.getId(), LOST_NODE_ASSIGNMENT);
        }
        if (!((PersistentTasks.Builder)taskBuilder).isChanged()) {
            return clusterState;
        }
        return ((PersistentTasks.Builder)taskBuilder).buildAndUpdate(clusterState, projectId);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    public PersistentTasksCustomMetadata(StreamInput in) throws IOException {
        this.lastAllocationId = in.readLong();
        this.tasks = in.readMap(PersistentTask::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.doWriteTo(out);
    }

    public static NamedDiff<Metadata.ProjectCustom> readDiffFrom(StreamInput in) throws IOException {
        return PersistentTasksCustomMetadata.readDiffFrom(Metadata.ProjectCustom.class, TYPE, in);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return this.doToXContentChunked();
    }

    public Builder toBuilder() {
        return PersistentTasksCustomMetadata.builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PersistentTasksCustomMetadata tasks) {
        return new Builder(tasks);
    }

    public Tuple<ClusterPersistentTasksCustomMetadata, PersistentTasksCustomMetadata> split() {
        HashMap clusterTasks = new HashMap();
        HashMap projectTasks = new HashMap();
        for (Map.Entry<String, PersistentTask<?>> entry : this.tasks.entrySet()) {
            PersistentTask<?> task = entry.getValue();
            if (PersistentTasksExecutorRegistry.isClusterScopedTask(task.getTaskName())) {
                clusterTasks.put(entry.getKey(), task);
                continue;
            }
            projectTasks.put(entry.getKey(), task);
        }
        return new Tuple((Object)new ClusterPersistentTasksCustomMetadata(this.lastAllocationId, Map.copyOf(clusterTasks)), (Object)new PersistentTasksCustomMetadata(this.lastAllocationId, Map.copyOf(projectTasks)));
    }

    @Nullable
    public static PersistentTasksCustomMetadata combine(@Nullable ClusterPersistentTasksCustomMetadata clusterTasksMetadata, @Nullable PersistentTasksCustomMetadata projectTasksMetadata) {
        if (clusterTasksMetadata == null && projectTasksMetadata == null) {
            return null;
        }
        if (clusterTasksMetadata == null) {
            return projectTasksMetadata;
        }
        if (projectTasksMetadata == null) {
            return new PersistentTasksCustomMetadata(clusterTasksMetadata.getLastAllocationId(), clusterTasksMetadata.taskMap());
        }
        long allocationId = Math.max(clusterTasksMetadata.getLastAllocationId(), projectTasksMetadata.getLastAllocationId());
        HashMap allTasks = new HashMap(clusterTasksMetadata.taskMap());
        allTasks.putAll(projectTasksMetadata.taskMap());
        PersistentTasksCustomMetadata combinedTasksMetadata = new PersistentTasksCustomMetadata(allocationId, Map.copyOf(allTasks));
        assert (PersistentTasksCustomMetadata.assertAllocationIdsConsistencyForOnePersistentTasks(combinedTasksMetadata));
        return combinedTasksMetadata;
    }

    static boolean assertAllocationIdsConsistencyForOnePersistentTasks(PersistentTasks persistentTasks) {
        if (persistentTasks == null) {
            return true;
        }
        List<Long> allocationIds = PersistentTasksCustomMetadata.getNonZeroAllocationIds(persistentTasks);
        assert (allocationIds.size() == Set.copyOf(allocationIds).size()) : persistentTasks.getClass().getSimpleName() + ": duplicated allocationIds [" + String.valueOf(persistentTasks) + "]";
        assert (persistentTasks.getLastAllocationId() >= allocationIds.stream().max(Long::compare).orElse(0L)) : persistentTasks.getClass().getSimpleName() + ": lastAllocationId is less than one of the allocationId for individual tasks [" + String.valueOf(persistentTasks) + "]";
        return true;
    }

    static List<Long> getNonZeroAllocationIds(PersistentTasks persistentTasks) {
        return persistentTasks.tasks().stream().map(PersistentTask::getAllocationId).filter(id -> id != 0L).toList();
    }

    static {
        PERSISTENT_TASKS_PARSER.declareLong(PersistentTasks.Builder::setLastAllocationId, new ParseField("last_allocation_id", new String[0]));
        PERSISTENT_TASKS_PARSER.declareObjectArray(PersistentTasks.Builder::setTasks, PersistentTasks.Parsers.PERSISTENT_TASK_PARSER, new ParseField("tasks", new String[0]));
    }

    public static class Builder
    extends PersistentTasks.Builder<Builder> {
        protected Builder() {
        }

        protected Builder(PersistentTasks tasksInProgress) {
            super(tasksInProgress);
        }

        @Override
        public PersistentTasksCustomMetadata build() {
            return new PersistentTasksCustomMetadata(this.getLastAllocationId(), Collections.unmodifiableMap(this.getCurrentTasks()));
        }

        @Override
        protected ClusterState doBuildAndUpdate(ClusterState currentState, ProjectId projectId) {
            return ClusterState.builder(currentState).putProjectMetadata(ProjectMetadata.builder(currentState.metadata().getProject(projectId)).putCustom(PersistentTasksCustomMetadata.TYPE, this.build())).build();
        }
    }

    public static class PersistentTask<P extends PersistentTaskParams>
    implements Writeable,
    ToXContentObject {
        private final String id;
        private final long allocationId;
        private final String taskName;
        private final P params;
        @Nullable
        private final PersistentTaskState state;
        private final Assignment assignment;
        @Nullable
        private final Long allocationIdOnLastStatusUpdate;

        public PersistentTask(String id, String name, P params, long allocationId, Assignment assignment) {
            this(id, allocationId, name, params, null, assignment, null);
        }

        public PersistentTask(PersistentTask<P> task, long allocationId, Assignment assignment) {
            this(task.id, allocationId, task.taskName, task.params, task.state, assignment, task.allocationId);
        }

        public PersistentTask(PersistentTask<P> task, PersistentTaskState state) {
            this(task.id, task.allocationId, task.taskName, task.params, state, task.assignment, task.allocationId);
        }

        PersistentTask(String id, long allocationId, String name, P params, PersistentTaskState state, Assignment assignment, Long allocationIdOnLastStatusUpdate) {
            this.id = id;
            this.allocationId = allocationId;
            this.taskName = name;
            this.params = params;
            this.state = state;
            this.assignment = assignment;
            this.allocationIdOnLastStatusUpdate = allocationIdOnLastStatusUpdate;
            if (params != null && !params.getWriteableName().equals(this.taskName)) {
                throw new IllegalArgumentException("params have to have the same writeable name as task. params: " + params.getWriteableName() + " task: " + this.taskName);
            }
            if (state != null && !state.getWriteableName().equals(this.taskName)) {
                throw new IllegalArgumentException("status has to have the same writeable name as task. status: " + state.getWriteableName() + " task: " + this.taskName);
            }
        }

        public PersistentTask(StreamInput in) throws IOException {
            this.id = in.readString();
            this.allocationId = in.readLong();
            this.taskName = in.readString();
            this.params = in.readNamedWriteable(PersistentTaskParams.class);
            this.state = in.readOptionalNamedWriteable(PersistentTaskState.class);
            this.assignment = new Assignment(in.readOptionalString(), in.readString());
            this.allocationIdOnLastStatusUpdate = in.readOptionalLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.id);
            out.writeLong(this.allocationId);
            out.writeString(this.taskName);
            out.writeNamedWriteable((NamedWriteable)this.params);
            out.writeOptionalNamedWriteable(this.state);
            out.writeOptionalString(this.assignment.executorNode);
            out.writeString(this.assignment.explanation);
            out.writeOptionalLong(this.allocationIdOnLastStatusUpdate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersistentTask that = (PersistentTask)o;
            return Objects.equals(this.id, that.id) && this.allocationId == that.allocationId && Objects.equals(this.taskName, that.taskName) && Objects.equals(this.params, that.params) && Objects.equals(this.state, that.state) && Objects.equals(this.assignment, that.assignment) && Objects.equals(this.allocationIdOnLastStatusUpdate, that.allocationIdOnLastStatusUpdate);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.allocationId, this.taskName, this.params, this.state, this.assignment, this.allocationIdOnLastStatusUpdate);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public String getId() {
            return this.id;
        }

        public long getAllocationId() {
            return this.allocationId;
        }

        public String getTaskName() {
            return this.taskName;
        }

        @Nullable
        public P getParams() {
            return this.params;
        }

        @Nullable
        public String getExecutorNode() {
            return this.assignment.executorNode;
        }

        public Assignment getAssignment() {
            return this.assignment;
        }

        public boolean isAssigned() {
            return this.assignment.isAssigned();
        }

        @Nullable
        public PersistentTaskState getState() {
            return this.state;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params xParams) throws IOException {
            builder.startObject();
            builder.field("id", this.id);
            builder.startObject("task");
            builder.startObject(this.taskName);
            if (this.params != null) {
                builder.field("params", this.params, xParams);
            }
            if (this.state != null) {
                builder.field("state", (ToXContent)this.state, xParams);
            }
            builder.endObject();
            builder.endObject();
            if (PersistentTasks.API_CONTEXT.equals(xParams.param("context_mode", PersistentTasks.API_CONTEXT))) {
                builder.field("allocation_id", this.allocationId);
                builder.startObject("assignment");
                builder.field("executor_node", this.assignment.executorNode);
                builder.field("explanation", this.assignment.explanation);
                builder.endObject();
                if (this.allocationIdOnLastStatusUpdate != null) {
                    builder.field("allocation_id_on_last_status_update", this.allocationIdOnLastStatusUpdate);
                }
            }
            builder.endObject();
            return builder;
        }
    }

    public static class Assignment {
        @Nullable
        private final String executorNode;
        private final String explanation;

        public Assignment(String executorNode, String explanation) {
            this.executorNode = executorNode;
            assert (explanation != null);
            this.explanation = explanation;
        }

        @Nullable
        public String getExecutorNode() {
            return this.executorNode;
        }

        public String getExplanation() {
            return this.explanation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Assignment that = (Assignment)o;
            return Objects.equals(this.executorNode, that.executorNode) && Objects.equals(this.explanation, that.explanation);
        }

        public int hashCode() {
            return Objects.hash(this.executorNode, this.explanation);
        }

        public boolean isAssigned() {
            return this.executorNode != null;
        }

        public String toString() {
            return "node: [" + this.executorNode + "], explanation: [" + this.explanation + "]";
        }
    }
}

