/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.persistent;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasks;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public final class ClusterPersistentTasksCustomMetadata
extends AbstractNamedDiffable<Metadata.ClusterCustom>
implements Metadata.ClusterCustom,
PersistentTasks {
    public static final String TYPE = "cluster_persistent_tasks";
    static final ObjectParser<Builder, Void> PERSISTENT_TASKS_PARSER = new ObjectParser("cluster_persistent_tasks", Builder::new);
    private final Map<String, PersistentTasksCustomMetadata.PersistentTask<?>> tasks;
    private final long lastAllocationId;

    @Deprecated(forRemoval=true)
    public static ClusterPersistentTasksCustomMetadata getPersistentTasksCustomMetadata(ClusterState clusterState) {
        return ClusterPersistentTasksCustomMetadata.get(clusterState.metadata());
    }

    public static ClusterPersistentTasksCustomMetadata get(Metadata metadata) {
        return (ClusterPersistentTasksCustomMetadata)metadata.custom(TYPE);
    }

    public ClusterPersistentTasksCustomMetadata(long lastAllocationId, Map<String, PersistentTasksCustomMetadata.PersistentTask<?>> tasks) {
        this.lastAllocationId = lastAllocationId;
        this.tasks = tasks;
    }

    public ClusterPersistentTasksCustomMetadata(StreamInput in) throws IOException {
        this.lastAllocationId = in.readLong();
        this.tasks = in.readMap(PersistentTasksCustomMetadata.PersistentTask::new);
    }

    public static ClusterPersistentTasksCustomMetadata fromXContent(XContentParser parser) {
        return ((Builder)PERSISTENT_TASKS_PARSER.apply(parser, null)).build();
    }

    public static <Params extends PersistentTaskParams> PersistentTasksCustomMetadata.PersistentTask<Params> getTaskWithId(ClusterState clusterState, String taskId) {
        ClusterPersistentTasksCustomMetadata tasks = ClusterPersistentTasksCustomMetadata.get(clusterState.metadata());
        if (tasks != null) {
            return tasks.getTask(taskId);
        }
        return null;
    }

    @Override
    public long getLastAllocationId() {
        return this.lastAllocationId;
    }

    @Override
    public Map<String, PersistentTasksCustomMetadata.PersistentTask<?>> taskMap() {
        return this.tasks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterPersistentTasksCustomMetadata that = (ClusterPersistentTasksCustomMetadata)o;
        return this.lastAllocationId == that.lastAllocationId && Objects.equals(this.tasks, that.tasks);
    }

    public int hashCode() {
        return Objects.hash(this.tasks, this.lastAllocationId);
    }

    public String toString() {
        return Strings.toString(this);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.MINIMUM_COMPATIBLE;
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.doWriteTo(out);
    }

    public static NamedDiff<Metadata.ClusterCustom> readDiffFrom(StreamInput in) throws IOException {
        return ClusterPersistentTasksCustomMetadata.readDiffFrom(Metadata.ClusterCustom.class, TYPE, in);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return this.doToXContentChunked();
    }

    public Builder toBuilder() {
        return ClusterPersistentTasksCustomMetadata.builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterPersistentTasksCustomMetadata tasks) {
        return new Builder(tasks);
    }

    static {
        PERSISTENT_TASKS_PARSER.declareLong(PersistentTasks.Builder::setLastAllocationId, new ParseField("last_allocation_id", new String[0]));
        PERSISTENT_TASKS_PARSER.declareObjectArray(PersistentTasks.Builder::setTasks, PersistentTasks.Parsers.PERSISTENT_TASK_PARSER, new ParseField("tasks", new String[0]));
    }

    public static class Builder
    extends PersistentTasks.Builder<Builder> {
        protected Builder() {
        }

        protected Builder(PersistentTasks tasksInProgress) {
            super(tasksInProgress);
        }

        @Override
        public ClusterPersistentTasksCustomMetadata build() {
            return new ClusterPersistentTasksCustomMetadata(this.getLastAllocationId(), Collections.unmodifiableMap(this.getCurrentTasks()));
        }

        @Override
        protected ClusterState doBuildAndUpdate(ClusterState currentState, ProjectId projectId) {
            return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).putCustom(ClusterPersistentTasksCustomMetadata.TYPE, this.build())).build();
        }
    }
}

