/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SoftDeletesRetentionMergePolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.InfoStream;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.service.ClusterApplierService;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.lucene.LoggerInfoStream;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.uid.VersionsAndSeqNoResolver;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.AsyncIOProcessor;
import org.elasticsearch.common.util.concurrent.KeyedLock;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.cache.query.TrivialQueryCachingPolicy;
import org.elasticsearch.index.engine.CombinedDeletionPolicy;
import org.elasticsearch.index.engine.CombinedDocValues;
import org.elasticsearch.index.engine.CompletionStatsCache;
import org.elasticsearch.index.engine.DeleteVersionValue;
import org.elasticsearch.index.engine.ElasticsearchConcurrentMergeScheduler;
import org.elasticsearch.index.engine.ElasticsearchMergeScheduler;
import org.elasticsearch.index.engine.ElasticsearchReaderManager;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineCreationFailureException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.FlushFailedEngineException;
import org.elasticsearch.index.engine.FlushListeners;
import org.elasticsearch.index.engine.IdStoredFieldLoader;
import org.elasticsearch.index.engine.IndexVersionValue;
import org.elasticsearch.index.engine.LiveVersionMap;
import org.elasticsearch.index.engine.LiveVersionMapArchive;
import org.elasticsearch.index.engine.LuceneChangesSnapshot;
import org.elasticsearch.index.engine.LuceneSyntheticSourceChangesSnapshot;
import org.elasticsearch.index.engine.MergeMemoryEstimator;
import org.elasticsearch.index.engine.MergeMetrics;
import org.elasticsearch.index.engine.PrunePostingsMergePolicy;
import org.elasticsearch.index.engine.RecoverySourcePruneMergePolicy;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.SafeCommitInfo;
import org.elasticsearch.index.engine.SearchBasedChangesSnapshot;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.engine.ShuffleForcedMergePolicy;
import org.elasticsearch.index.engine.SoftDeletesPolicy;
import org.elasticsearch.index.engine.ThreadPoolMergeExecutorService;
import org.elasticsearch.index.engine.ThreadPoolMergeScheduler;
import org.elasticsearch.index.engine.TranslogDirectoryReader;
import org.elasticsearch.index.engine.TranslogOperationAsserter;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.engine.VersionValue;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SeqNoFieldMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.OnGoingMerge;
import org.elasticsearch.index.seqno.LocalCheckpointTracker;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardLongFieldRange;
import org.elasticsearch.index.shard.ShardSplittingQuery;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogCorruptedException;
import org.elasticsearch.index.translog.TranslogDeletionPolicy;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.search.suggest.completion.CompletionStats;

public class InternalEngine
extends Engine {
    private volatile long lastDeleteVersionPruneTimeMSec;
    private final Translog translog;
    private final ElasticsearchMergeScheduler mergeScheduler;
    private final IndexWriter indexWriter;
    private final ExternalReaderManager externalReaderManager;
    private final ElasticsearchReaderManager internalReaderManager;
    private final ReentrantLock flushLock;
    private final ReentrantLock optimizeLock;
    private final LiveVersionMap versionMap;
    private final LiveVersionMapArchive liveVersionMapArchive;
    private final AtomicLong lastUnsafeSegmentGenerationForGets;
    private final AtomicLong preCommitSegmentGeneration;
    private volatile SegmentInfos lastCommittedSegmentInfos;
    private final Engine.IndexThrottle throttle;
    private final LocalCheckpointTracker localCheckpointTracker;
    private final CombinedDeletionPolicy combinedDeletionPolicy;
    private final AtomicInteger throttleRequestCount;
    private final AtomicBoolean pendingTranslogRecovery;
    private final AtomicLong maxUnsafeAutoIdTimestamp;
    private final AtomicLong maxSeenAutoIdTimestamp;
    private final AtomicLong maxSeqNoOfUpdatesOrDeletes;
    private final CounterMetric numVersionLookups;
    private final CounterMetric numIndexVersionsLookups;
    private final CounterMetric numDocDeletes;
    private final CounterMetric numDocAppends;
    private final CounterMetric numDocUpdates;
    private final MeanMetric totalFlushTimeExcludingWaitingOnLock;
    private final NumericDocValuesField softDeletesField;
    private final SoftDeletesPolicy softDeletesPolicy;
    private final LastRefreshedCheckpointListener lastRefreshedCheckpointListener;
    private final FlushListeners flushListener;
    private final AsyncIOProcessor<Tuple<Long, Translog.Location>> translogSyncProcessor;
    private final CompletionStatsCache completionStatsCache;
    private final AtomicBoolean trackTranslogLocation;
    private final KeyedLock<Long> noOpKeyedLock;
    private final AtomicBoolean shouldPeriodicallyFlushAfterBigMerge;
    private final AtomicLong inFlightDocCount;
    private final int maxDocs;
    @Nullable
    private final String historyUUID;
    @Nullable
    private volatile String forceMergeUUID;
    private final LongSupplier relativeTimeInNanosSupplier;
    private volatile long lastFlushTimestamp;
    private final ByteSizeValue totalDiskSpace;
    protected static final String REAL_TIME_GET_REFRESH_SOURCE = "realtime_get";
    protected static final String UNSAFE_VERSION_MAP_REFRESH_SOURCE = "unsafe_version_map";
    public final AtomicLong translogGetCount;
    public final AtomicLong translogInMemorySegmentsCount;
    private static final boolean TESTS_VERBOSE = Boolean.parseBoolean(System.getProperty("tests.verbose"));
    private static final boolean SHUFFLE_FORCE_MERGE = Booleans.parseBoolean((String)System.getProperty("es.shuffle_forced_merge", Boolean.TRUE.toString()));
    private final Object refreshIfNeededMutex;

    public InternalEngine(EngineConfig engineConfig) {
        this(engineConfig, 0x7FFFFF7F, LocalCheckpointTracker::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    InternalEngine(EngineConfig engineConfig, int maxDocs, BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier) {
        block23: {
            super(engineConfig);
            this.flushLock = new ReentrantLock();
            this.optimizeLock = new ReentrantLock();
            this.preCommitSegmentGeneration = new AtomicLong(-1L);
            this.throttleRequestCount = new AtomicInteger();
            this.pendingTranslogRecovery = new AtomicBoolean(false);
            this.maxUnsafeAutoIdTimestamp = new AtomicLong(-1L);
            this.maxSeenAutoIdTimestamp = new AtomicLong(-1L);
            this.numVersionLookups = new CounterMetric();
            this.numIndexVersionsLookups = new CounterMetric();
            this.numDocDeletes = new CounterMetric();
            this.numDocAppends = new CounterMetric();
            this.numDocUpdates = new CounterMetric();
            this.totalFlushTimeExcludingWaitingOnLock = new MeanMetric();
            this.softDeletesField = Lucene.newSoftDeletesField();
            this.trackTranslogLocation = new AtomicBoolean(false);
            this.noOpKeyedLock = new KeyedLock();
            this.shouldPeriodicallyFlushAfterBigMerge = new AtomicBoolean(false);
            this.inFlightDocCount = new AtomicLong();
            this.translogGetCount = new AtomicLong();
            this.translogInMemorySegmentsCount = new AtomicLong();
            this.refreshIfNeededMutex = new Object();
            this.maxDocs = maxDocs;
            this.relativeTimeInNanosSupplier = this.config().getRelativeTimeInNanosSupplier();
            this.lastFlushTimestamp = this.relativeTimeInNanosSupplier.getAsLong();
            this.liveVersionMapArchive = this.createLiveVersionMapArchive();
            this.versionMap = new LiveVersionMap(this.liveVersionMapArchive);
            TranslogDeletionPolicy translogDeletionPolicy = new TranslogDeletionPolicy();
            this.store.incRef();
            IndexWriter writer = null;
            Translog translog = null;
            ExternalReaderManager externalReaderManager = null;
            ElasticsearchReaderManager internalReaderManager = null;
            MergeScheduler scheduler = null;
            boolean success = false;
            try {
                this.lastDeleteVersionPruneTimeMSec = engineConfig.getThreadPool().relativeTimeInMillis();
                this.mergeScheduler = this.createMergeScheduler(engineConfig.getShardId(), engineConfig.getIndexSettings(), engineConfig.getThreadPoolMergeExecutorService(), engineConfig.getMergeMetrics());
                scheduler = this.mergeScheduler.getMergeScheduler();
                this.throttle = new Engine.IndexThrottle(this.pauseIndexingOnThrottle);
                try {
                    this.store.trimUnsafeCommits(this.config().getTranslogConfig().getTranslogPath());
                    translog = this.openTranslog(engineConfig, translogDeletionPolicy, engineConfig.getGlobalCheckpointSupplier(), this.translogPersistedSeqNoConsumer());
                    assert (translog.getGeneration() != null);
                    this.translog = translog;
                    this.totalDiskSpace = ByteSizeValue.of(Environment.getFileStore(translog.location()).getTotalSpace(), ByteSizeUnit.BYTES);
                    this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
                    this.softDeletesPolicy = this.newSoftDeletesPolicy();
                    this.combinedDeletionPolicy = new CombinedDeletionPolicy(this.logger, translogDeletionPolicy, this.softDeletesPolicy, translog::getLastSyncedGlobalCheckpoint, this.newCommitsListener());
                    this.localCheckpointTracker = this.createLocalCheckpointTracker(localCheckpointTrackerSupplier);
                    writer = this.createWriter();
                    this.bootstrapAppendOnlyInfoFromWriter(writer);
                    Map<String, String> commitData = InternalEngine.commitDataAsMap(writer);
                    this.historyUUID = InternalEngine.loadHistoryUUID(commitData);
                    this.forceMergeUUID = commitData.get("force_merge_uuid");
                    this.indexWriter = writer;
                }
                catch (IOException | TranslogCorruptedException e) {
                    throw new EngineCreationFailureException(this.shardId, "failed to create engine", e);
                }
                catch (AssertionError e) {
                    if (ExceptionsHelper.stackTrace((Throwable)((Object)e)).contains("org.apache.lucene.index.IndexWriter.filesExist")) {
                        throw new EngineCreationFailureException(this.shardId, "failed to create engine", (Throwable)((Object)e));
                    }
                    throw e;
                }
                externalReaderManager = this.createReaderManager(new RefreshWarmerListener(this.logger, this.isClosed, engineConfig));
                internalReaderManager = externalReaderManager.internalReaderManager;
                this.internalReaderManager = InternalEngine.wrapForAssertions(internalReaderManager, engineConfig);
                this.externalReaderManager = InternalEngine.wrapForAssertions(externalReaderManager, engineConfig);
                internalReaderManager.addListener(this.versionMap);
                this.lastUnsafeSegmentGenerationForGets = new AtomicLong(this.lastCommittedSegmentInfos.getGeneration());
                assert (!this.pendingTranslogRecovery.get()) : "translog recovery can't be pending before we set it";
                this.pendingTranslogRecovery.set(true);
                for (ReferenceManager.RefreshListener listener : engineConfig.getExternalRefreshListener()) {
                    this.externalReaderManager.addListener(listener);
                }
                for (ReferenceManager.RefreshListener listener : engineConfig.getInternalRefreshListener()) {
                    this.internalReaderManager.addListener(listener);
                }
                this.lastRefreshedCheckpointListener = new LastRefreshedCheckpointListener(this.localCheckpointTracker.getProcessedCheckpoint());
                this.internalReaderManager.addListener(this.lastRefreshedCheckpointListener);
                this.maxSeqNoOfUpdatesOrDeletes = new AtomicLong(SequenceNumbers.max(this.localCheckpointTracker.getMaxSeqNo(), translog.getMaxSeqNo()));
                if (this.localCheckpointTracker.getPersistedCheckpoint() < this.localCheckpointTracker.getMaxSeqNo()) {
                    try (Engine.Searcher searcher = this.acquireSearcher("restore_version_map_and_checkpoint_tracker", Engine.SearcherScope.INTERNAL);){
                        this.restoreVersionMapAndCheckpointTracker(Lucene.wrapAllDocsLive(searcher.getDirectoryReader()), engineConfig.getIndexSettings().getIndexVersionCreated());
                    }
                    catch (IOException e) {
                        throw new EngineCreationFailureException(this.config().getShardId(), "failed to restore version map and local checkpoint tracker", e);
                    }
                }
                this.completionStatsCache = new CompletionStatsCache(() -> this.acquireSearcher("completion_stats"));
                this.externalReaderManager.addListener(this.completionStatsCache);
                this.flushListener = new FlushListeners(this.logger, engineConfig.getThreadPool().getThreadContext());
                this.translogSyncProcessor = this.createTranslogSyncProcessor(this.logger, engineConfig.getThreadPool().getThreadContext());
                success = true;
                if (success) break block23;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{writer, translog, internalReaderManager, externalReaderManager, scheduler});
                    if (!this.isClosed.get()) {
                        this.store.decRef();
                    }
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{writer, translog, internalReaderManager, externalReaderManager, scheduler});
            if (!this.isClosed.get()) {
                this.store.decRef();
            }
        }
        this.logger.trace("created new InternalEngine");
    }

    private LocalCheckpointTracker createLocalCheckpointTracker(BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier) throws IOException {
        SequenceNumbers.CommitInfo seqNoStats = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(this.lastCommittedSegmentInfos.userData.entrySet());
        long maxSeqNo = seqNoStats.maxSeqNo();
        long localCheckpoint = seqNoStats.localCheckpoint();
        this.logger.trace("recovered maximum sequence number [{}] and local checkpoint [{}]", (Object)maxSeqNo, (Object)localCheckpoint);
        return localCheckpointTrackerSupplier.apply(maxSeqNo, localCheckpoint);
    }

    protected LongConsumer translogPersistedSeqNoConsumer() {
        return seqNo -> {
            LocalCheckpointTracker tracker = this.getLocalCheckpointTracker();
            assert (tracker != null || !this.getTranslog().isOpen());
            if (tracker != null) {
                tracker.markSeqNoAsPersisted(seqNo);
            }
        };
    }

    private SoftDeletesPolicy newSoftDeletesPolicy() throws IOException {
        Map commitUserData = this.lastCommittedSegmentInfos.userData;
        long lastMinRetainedSeqNo = commitUserData.containsKey("min_retained_seq_no") ? Long.parseLong((String)commitUserData.get("min_retained_seq_no")) : Long.parseLong((String)commitUserData.get("max_seq_no")) + 1L;
        return new SoftDeletesPolicy(this.translog::getLastSyncedGlobalCheckpoint, lastMinRetainedSeqNo, this.engineConfig.getIndexSettings().getSoftDeleteRetentionOperations(), this.engineConfig.retentionLeasesSupplier());
    }

    @Nullable
    private CombinedDeletionPolicy.CommitsListener newCommitsListener() {
        Engine.IndexCommitListener listener = this.engineConfig.getIndexCommitListener();
        if (listener != null) {
            final Engine.IndexCommitListener wrappedListener = Assertions.ENABLED ? this.assertingCommitsOrderListener(listener) : listener;
            return new CombinedDeletionPolicy.CommitsListener(){

                @Override
                public void onNewAcquiredCommit(IndexCommit commit, Set<String> additionalFiles) {
                    Engine.IndexCommitRef indexCommitRef = InternalEngine.this.acquireIndexCommitRef(() -> commit);
                    long primaryTerm = InternalEngine.this.config().getPrimaryTermSupplier().getAsLong();
                    assert (indexCommitRef.getIndexCommit() == commit);
                    wrappedListener.onNewCommit(InternalEngine.this.shardId, InternalEngine.this.store, primaryTerm, indexCommitRef, additionalFiles);
                }

                @Override
                public void onDeletedCommit(IndexCommit commit) {
                    wrappedListener.onIndexCommitDelete(InternalEngine.this.shardId, commit);
                }
            };
        }
        return null;
    }

    private Engine.IndexCommitListener assertingCommitsOrderListener(final Engine.IndexCommitListener listener) {
        final AtomicLong generation = new AtomicLong(0L);
        return new Engine.IndexCommitListener(){

            @Override
            public void onNewCommit(ShardId shardId, Store store, long primaryTerm, Engine.IndexCommitRef indexCommitRef, Set<String> additionalFiles) {
                long nextGen = indexCommitRef.getIndexCommit().getGeneration();
                long prevGen = generation.getAndSet(nextGen);
                assert (prevGen < nextGen) : "Expect new commit generation " + nextGen + " to be greater than previous commit generation " + prevGen + " for shard " + String.valueOf(shardId);
                listener.onNewCommit(shardId, store, primaryTerm, indexCommitRef, additionalFiles);
            }

            @Override
            public void onIndexCommitDelete(ShardId shardId, IndexCommit deletedCommit) {
                listener.onIndexCommitDelete(shardId, deletedCommit);
            }
        };
    }

    @Override
    public CompletionStats completionStats(String ... fieldNamePatterns) {
        return this.completionStatsCache.get(fieldNamePatterns);
    }

    @Override
    final boolean assertSearcherIsWarmedUp(String source, Engine.SearcherScope scope) {
        if (scope == Engine.SearcherScope.EXTERNAL) {
            switch (source) {
                case "segments": 
                case "segments_stats": {
                    break;
                }
                default: {
                    assert (this.externalReaderManager.isWarmedUp) : "searcher was not warmed up yet for source[" + source + "]";
                    break;
                }
            }
        }
        return true;
    }

    @Override
    public int restoreLocalHistoryFromTranslog(Engine.TranslogRecoveryRunner translogRecoveryRunner) throws IOException {
        try (Releasable ignored = this.acquireEnsureOpenRef();){
            int n;
            block12: {
                long localCheckpoint = this.localCheckpointTracker.getProcessedCheckpoint();
                Translog.Snapshot snapshot = this.getTranslog().newSnapshot(localCheckpoint + 1L, Long.MAX_VALUE);
                try {
                    n = translogRecoveryRunner.run(this, snapshot);
                    if (snapshot == null) break block12;
                }
                catch (Throwable throwable) {
                    if (snapshot != null) {
                        try {
                            snapshot.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                snapshot.close();
            }
            return n;
        }
    }

    @Override
    public int fillSeqNoGaps(long primaryTerm) throws IOException {
        try (Releasable ignored = this.acquireEnsureOpenRef();){
            long localCheckpoint = this.localCheckpointTracker.getProcessedCheckpoint();
            long maxSeqNo = this.localCheckpointTracker.getMaxSeqNo();
            int numNoOpsAdded = 0;
            long seqNo = localCheckpoint + 1L;
            while (seqNo <= maxSeqNo) {
                this.innerNoOp(new Engine.NoOp(seqNo, primaryTerm, Engine.Operation.Origin.PRIMARY, System.nanoTime(), "filling gaps"));
                ++numNoOpsAdded;
                assert (seqNo <= this.localCheckpointTracker.getProcessedCheckpoint()) : "local checkpoint did not advance; was [" + seqNo + "], now [" + this.localCheckpointTracker.getProcessedCheckpoint() + "]";
                seqNo = this.localCheckpointTracker.getProcessedCheckpoint() + 1L;
            }
            this.syncTranslog();
            assert (this.localCheckpointTracker.getPersistedCheckpoint() == maxSeqNo) : "persisted local checkpoint did not advance to max seq no; is [" + this.localCheckpointTracker.getPersistedCheckpoint() + "], max seq no [" + maxSeqNo + "]";
            int n = numNoOpsAdded;
            return n;
        }
    }

    private void bootstrapAppendOnlyInfoFromWriter(IndexWriter writer) {
        for (Map.Entry entry : writer.getLiveCommitData()) {
            if (!"max_unsafe_auto_id_timestamp".equals(entry.getKey())) continue;
            assert (this.maxUnsafeAutoIdTimestamp.get() == -1L) : "max unsafe timestamp was assigned already [" + this.maxUnsafeAutoIdTimestamp.get() + "]";
            this.updateAutoIdTimestamp(Long.parseLong((String)entry.getValue()), true);
        }
    }

    @Override
    public void recoverFromTranslog(Engine.TranslogRecoveryRunner translogRecoveryRunner, long recoverUpToSeqNo, ActionListener<Void> listener) {
        ActionListener.runWithResource(listener, this::acquireEnsureOpenRef, (l, ignoredRef) -> {
            if (!this.pendingTranslogRecovery.get()) {
                throw new IllegalStateException("Engine has already been recovered");
            }
            this.recoverFromTranslogInternal(translogRecoveryRunner, recoverUpToSeqNo, l.delegateResponse((ll, e) -> {
                try {
                    this.pendingTranslogRecovery.set(true);
                    this.failEngine("failed to recover from translog", (Exception)e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                ll.onFailure((Exception)e);
            }));
        });
    }

    @Override
    public void skipTranslogRecovery() {
        assert (this.pendingTranslogRecovery.get()) : "translogRecovery is not pending but should be";
        this.pendingTranslogRecovery.set(false);
    }

    private void recoverFromTranslogInternal(Engine.TranslogRecoveryRunner translogRecoveryRunner, long recoverUpToSeqNo, ActionListener<Void> listener) {
        ActionListener.run(listener, l -> {
            int opsRecovered;
            block10: {
                long localCheckpoint = this.getProcessedLocalCheckpoint();
                if (localCheckpoint < recoverUpToSeqNo) {
                    try (Translog.Snapshot snapshot = this.newTranslogSnapshot(localCheckpoint + 1L, recoverUpToSeqNo);){
                        opsRecovered = translogRecoveryRunner.run(this, snapshot);
                        break block10;
                    }
                    catch (Exception e) {
                        throw new EngineException(this.shardId, "failed to recover from translog", e, new Object[0]);
                    }
                }
                opsRecovered = 0;
            }
            assert (this.pendingTranslogRecovery.get()) : "translogRecovery is not pending but should be";
            this.pendingTranslogRecovery.set(false);
            this.logger.trace(() -> Strings.format((String)"flushing post recovery from translog: ops recovered [%s], current translog generation [%s]", (Object[])new Object[]{opsRecovered, this.translog.currentFileGeneration()}));
            SubscribableListener<Engine.FlushResult> flushListener = new SubscribableListener<Engine.FlushResult>();
            this.flush(false, true, flushListener);
            flushListener.addListener(l.delegateFailureAndWrap((ll, r) -> {
                this.translog.trimUnreferencedReaders();
                ll.onResponse(null);
            }), this.engineConfig.getThreadPool().generic(), null);
        });
    }

    protected Translog.Snapshot newTranslogSnapshot(long fromSeqNo, long toSeqNo) throws IOException {
        return this.translog.newSnapshot(fromSeqNo, toSeqNo);
    }

    private Translog openTranslog(EngineConfig engineConfig, TranslogDeletionPolicy translogDeletionPolicy, LongSupplier globalCheckpointSupplier, LongConsumer persistedSequenceNumberConsumer) throws IOException {
        TranslogConfig translogConfig = engineConfig.getTranslogConfig();
        Map userData = this.store.readLastCommittedSegmentsInfo().getUserData();
        String translogUUID = Objects.requireNonNull((String)userData.get("translog_uuid"));
        return new Translog(translogConfig, translogUUID, translogDeletionPolicy, globalCheckpointSupplier, engineConfig.getPrimaryTermSupplier(), persistedSequenceNumberConsumer, TranslogOperationAsserter.withEngineConfig(engineConfig));
    }

    Translog getTranslog() {
        this.ensureOpen();
        return this.translog;
    }

    boolean hasAcquiredIndexCommitsForTesting() {
        return this.combinedDeletionPolicy.hasAcquiredIndexCommitsForTesting();
    }

    @Override
    public boolean isTranslogSyncNeeded() {
        return this.getTranslog().syncNeeded();
    }

    private AsyncIOProcessor<Tuple<Long, Translog.Location>> createTranslogSyncProcessor(final Logger logger, ThreadContext threadContext) {
        return new AsyncIOProcessor<Tuple<Long, Translog.Location>>(logger, 1024, threadContext){

            @Override
            protected void write(List<Tuple<Tuple<Long, Translog.Location>, Consumer<Exception>>> candidates) throws IOException {
                try {
                    Translog.Location location = Translog.Location.EMPTY;
                    long processGlobalCheckpoint = -2L;
                    for (Tuple<Tuple<Long, Translog.Location>, Consumer<Exception>> syncMarkers : candidates) {
                        Tuple marker = (Tuple)syncMarkers.v1();
                        long globalCheckpointToSync = (Long)marker.v1();
                        if (globalCheckpointToSync != -2L) {
                            processGlobalCheckpoint = SequenceNumbers.max(processGlobalCheckpoint, globalCheckpointToSync);
                        }
                        location = location.compareTo((Translog.Location)marker.v2()) >= 0 ? location : (Translog.Location)marker.v2();
                    }
                    boolean synced = InternalEngine.this.translog.ensureSynced(location, processGlobalCheckpoint);
                    if (synced) {
                        InternalEngine.this.revisitIndexDeletionPolicyOnTranslogSynced();
                    }
                }
                catch (AlreadyClosedException location) {
                }
                catch (IOException ex) {
                    logger.debug("failed to sync translog", (Throwable)ex);
                    throw ex;
                }
            }
        };
    }

    @Override
    public void asyncEnsureTranslogSynced(Translog.Location location, Consumer<Exception> listener) {
        this.translogSyncProcessor.put((Tuple<Long, Translog.Location>)new Tuple((Object)-1L, (Object)location), listener);
    }

    @Override
    public void asyncEnsureGlobalCheckpointSynced(long globalCheckpoint, Consumer<Exception> listener) {
        this.translogSyncProcessor.put((Tuple<Long, Translog.Location>)new Tuple((Object)globalCheckpoint, (Object)Translog.Location.EMPTY), listener);
    }

    @Override
    public void syncTranslog() throws IOException {
        this.translog.sync();
        this.revisitIndexDeletionPolicyOnTranslogSynced();
    }

    @Override
    public TranslogStats getTranslogStats() {
        return this.getTranslog().stats();
    }

    @Override
    public Translog.Location getTranslogLastWriteLocation() {
        return this.getTranslog().getLastWriteLocation();
    }

    private void revisitIndexDeletionPolicyOnTranslogSynced() throws IOException {
        if (this.combinedDeletionPolicy.hasUnreferencedCommits()) {
            this.indexWriter.deleteUnusedFiles();
        }
        this.translog.trimUnreferencedReaders();
    }

    @Override
    public String getHistoryUUID() {
        return this.historyUUID;
    }

    @Nullable
    public String getForceMergeUUID() {
        return this.forceMergeUUID;
    }

    @Override
    public long getWritingBytes() {
        return this.indexWriter.getFlushingBytes() + this.versionMap.getRefreshingBytes();
    }

    private static String loadHistoryUUID(Map<String, String> commitData) {
        String uuid = commitData.get("history_uuid");
        if (uuid == null) {
            throw new IllegalStateException("commit doesn't contain history uuid");
        }
        return uuid;
    }

    private ExternalReaderManager createReaderManager(RefreshWarmerListener externalRefreshListener) throws EngineException {
        ExternalReaderManager externalReaderManager;
        block7: {
            Object reader;
            boolean success = false;
            ElasticsearchDirectoryReader directoryReader = null;
            ElasticsearchReaderManager internalReaderManager = null;
            try {
                directoryReader = ElasticsearchDirectoryReader.wrap(DirectoryReader.open((IndexWriter)this.indexWriter), this.shardId);
                internalReaderManager = this.createInternalReaderManager(directoryReader);
                ExternalReaderManager externalReaderManager2 = new ExternalReaderManager(internalReaderManager, externalRefreshListener);
                success = true;
                externalReaderManager = externalReaderManager2;
                if (success) break block7;
                reader = internalReaderManager == null ? directoryReader : internalReaderManager;
            }
            catch (IOException e) {
                try {
                    this.maybeFailEngine("start", e);
                    try {
                        this.indexWriter.rollback();
                    }
                    catch (IOException inner) {
                        e.addSuppressed(inner);
                    }
                    throw new EngineCreationFailureException(this.shardId, "failed to open reader on writer", e);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        ElasticsearchDirectoryReader reader2 = internalReaderManager == null ? directoryReader : internalReaderManager;
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader2, this.indexWriter});
                    }
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader, this.indexWriter});
        }
        return externalReaderManager;
    }

    protected ElasticsearchReaderManager createInternalReaderManager(ElasticsearchDirectoryReader directoryReader) {
        return new ElasticsearchReaderManager(directoryReader);
    }

    private Engine.GetResult getFromTranslog(Engine.Get get, Translog.Index index, MappingLookup mappingLookup, DocumentParser documentParser, Function<Engine.Searcher, Engine.Searcher> searcherWrapper) throws IOException {
        assert (get.isReadFromTranslog());
        this.translogGetCount.incrementAndGet();
        DirectoryReader inMemoryReader = TranslogDirectoryReader.create(this.shardId, index, mappingLookup, documentParser, this.config(), this.translogInMemorySegmentsCount::incrementAndGet, false);
        Engine.Searcher searcher = new Engine.Searcher(REAL_TIME_GET_REFRESH_SOURCE, (IndexReader)ElasticsearchDirectoryReader.wrap(inMemoryReader, this.shardId), this.config().getSimilarity(), null, TrivialQueryCachingPolicy.NEVER, (Closeable)inMemoryReader);
        Engine.Searcher wrappedSearcher = searcherWrapper.apply(searcher);
        return this.getFromSearcher(get, wrappedSearcher, true);
    }

    @Override
    public Engine.GetResult get(Engine.Get get, MappingLookup mappingLookup, DocumentParser documentParser, Function<Engine.Searcher, Engine.Searcher> searcherWrapper) {
        try (Releasable ignored = this.acquireEnsureOpenRef();){
            if (get.realtime()) {
                Engine.GetResult result = this.realtimeGetUnderLock(get, mappingLookup, documentParser, searcherWrapper, true);
                assert (result != null) : "real-time get result must not be null";
                Engine.GetResult getResult = result;
                return getResult;
            }
            Engine.GetResult getResult = this.getFromSearcher(get, this.acquireSearcher("get", Engine.SearcherScope.EXTERNAL, searcherWrapper), false);
            return getResult;
        }
    }

    @Override
    public Engine.GetResult getFromTranslog(Engine.Get get, MappingLookup mappingLookup, DocumentParser documentParser, Function<Engine.Searcher, Engine.Searcher> searcherWrapper) {
        try (Releasable ignored = this.acquireEnsureOpenRef();){
            Engine.GetResult getResult = this.realtimeGetUnderLock(get, mappingLookup, documentParser, searcherWrapper, false);
            return getResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Engine.GetResult realtimeGetUnderLock(Engine.Get get, MappingLookup mappingLookup, DocumentParser documentParser, Function<Engine.Searcher, Engine.Searcher> searcherWrapper, boolean getFromSearcher) {
        VersionValue versionValue;
        assert (!this.isDrainedForClose());
        assert (get.realtime());
        try (Releasable ignore = this.versionMap.acquireLock(get.uid());){
            versionValue = this.getVersionFromMap(get.uid());
        }
        try {
            Engine.GetResult getResult;
            boolean getFromSearcherIfNotInTranslog = getFromSearcher;
            if (versionValue != null) {
                block27: {
                    getFromSearcherIfNotInTranslog = true;
                    if (versionValue.isDelete()) {
                        Engine.GetResult getResult2 = Engine.GetResult.NOT_EXISTS;
                        return getResult2;
                    }
                    if (get.versionType().isVersionConflictForReads(versionValue.version, get.version())) {
                        throw new VersionConflictEngineException(this.shardId, "[" + get.id() + "]", get.versionType().explainConflictForReads(versionValue.version, get.version()));
                    }
                    if (get.getIfSeqNo() != -2L && (get.getIfSeqNo() != versionValue.seqNo || get.getIfPrimaryTerm() != versionValue.term)) {
                        throw new VersionConflictEngineException(this.shardId, get.id(), get.getIfSeqNo(), get.getIfPrimaryTerm(), versionValue.seqNo, versionValue.term);
                    }
                    if (get.isReadFromTranslog()) {
                        if (versionValue.getLocation() != null) {
                            try {
                                Translog.Operation operation = this.translog.readOperation(versionValue.getLocation());
                                if (operation != null) {
                                    Engine.GetResult getResult3 = this.getFromTranslog(get, (Translog.Index)operation, mappingLookup, documentParser, searcherWrapper);
                                    return getResult3;
                                }
                                break block27;
                            }
                            catch (IOException e) {
                                this.maybeFailEngine(REAL_TIME_GET_REFRESH_SOURCE, e);
                                throw new EngineException(this.shardId, "failed to read operation from translog", e, new Object[0]);
                            }
                        }
                        this.trackTranslogLocation.set(true);
                    }
                }
                assert (versionValue.seqNo >= 0L) : versionValue;
                this.refreshIfNeeded(REAL_TIME_GET_REFRESH_SOURCE, versionValue.seqNo);
            }
            if (getFromSearcherIfNotInTranslog) {
                getResult = this.getFromSearcher(get, this.acquireSearcher(REAL_TIME_GET_REFRESH_SOURCE, Engine.SearcherScope.INTERNAL, searcherWrapper), false);
                return getResult;
            }
            getResult = null;
            return getResult;
        }
        finally {
            assert (!this.isDrainedForClose());
        }
    }

    private static OpVsLuceneDocStatus compareOpToVersionMapOnSeqNo(String id, long seqNo, long primaryTerm, VersionValue versionValue) {
        Objects.requireNonNull(versionValue);
        if (seqNo > versionValue.seqNo) {
            return OpVsLuceneDocStatus.OP_NEWER;
        }
        if (seqNo == versionValue.seqNo) {
            assert (versionValue.term == primaryTerm) : "primary term not matched; id=" + id + " seq_no=" + seqNo + " op_term=" + primaryTerm + " existing_term=" + versionValue.term;
            return OpVsLuceneDocStatus.OP_STALE_OR_EQUAL;
        }
        return OpVsLuceneDocStatus.OP_STALE_OR_EQUAL;
    }

    private OpVsLuceneDocStatus compareOpToLuceneDocBasedOnSeqNo(Engine.Operation op) throws IOException {
        OpVsLuceneDocStatus status;
        assert (op.seqNo() != -2L) : "resolving ops based on seq# but no seqNo is found";
        VersionValue versionValue = this.getVersionFromMap(op.uid());
        assert (this.incrementVersionLookup());
        if (versionValue != null) {
            status = InternalEngine.compareOpToVersionMapOnSeqNo(op.id(), op.seqNo(), op.primaryTerm(), versionValue);
        } else {
            assert (this.incrementIndexVersionLookup());
            try (Engine.Searcher searcher = this.acquireSearcher("load_seq_no", Engine.SearcherScope.INTERNAL);){
                VersionsAndSeqNoResolver.DocIdAndSeqNo docAndSeqNo = VersionsAndSeqNoResolver.loadDocIdAndSeqNo(searcher.getIndexReader(), op.uid());
                if (docAndSeqNo == null) {
                    status = OpVsLuceneDocStatus.LUCENE_DOC_NOT_FOUND;
                } else if (op.seqNo() > docAndSeqNo.seqNo) {
                    status = OpVsLuceneDocStatus.OP_NEWER;
                } else if (op.seqNo() == docAndSeqNo.seqNo) {
                    assert (this.localCheckpointTracker.hasProcessed(op.seqNo())) : "local checkpoint tracker is not updated seq_no=" + op.seqNo() + " id=" + op.id();
                    status = OpVsLuceneDocStatus.OP_STALE_OR_EQUAL;
                } else {
                    status = OpVsLuceneDocStatus.OP_STALE_OR_EQUAL;
                }
            }
        }
        return status;
    }

    private VersionValue resolveDocVersion(Engine.Operation op, boolean loadSeqNo) throws IOException {
        assert (this.incrementVersionLookup());
        VersionValue versionValue = this.getVersionFromMap(op.uid());
        if (versionValue == null) {
            assert (this.incrementIndexVersionLookup());
            VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion = (VersionsAndSeqNoResolver.DocIdAndVersion)this.performActionWithDirectoryReader(Engine.SearcherScope.INTERNAL, directoryReader -> {
                if (this.engineConfig.getIndexSettings().getMode() == IndexMode.TIME_SERIES) {
                    assert (this.engineConfig.getLeafSorter() == DataStream.TIMESERIES_LEAF_READERS_SORTER);
                    return VersionsAndSeqNoResolver.timeSeriesLoadDocIdAndVersion((IndexReader)directoryReader, op.uid(), op.id(), loadSeqNo);
                }
                return VersionsAndSeqNoResolver.timeSeriesLoadDocIdAndVersion((IndexReader)directoryReader, op.uid(), loadSeqNo);
            });
            if (docIdAndVersion != null) {
                versionValue = new IndexVersionValue(null, docIdAndVersion.version, docIdAndVersion.seqNo, docIdAndVersion.primaryTerm);
            }
        } else if (this.engineConfig.isEnableGcDeletes() && versionValue.isDelete() && this.engineConfig.getThreadPool().relativeTimeInMillis() - ((DeleteVersionValue)versionValue).time > this.getGcDeletesInMillis()) {
            versionValue = null;
        }
        return versionValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VersionValue getVersionFromMap(BytesRef id) {
        if (this.versionMap.isUnsafe()) {
            LiveVersionMap liveVersionMap = this.versionMap;
            synchronized (liveVersionMap) {
                if (this.versionMap.isUnsafe()) {
                    this.refreshInternalSearcher(UNSAFE_VERSION_MAP_REFRESH_SOURCE, true);
                    this.lastUnsafeSegmentGenerationForGets.set(this.lastCommittedSegmentInfos.getGeneration());
                }
                this.versionMap.enforceSafeAccess();
            }
        }
        return this.versionMap.getUnderLock(id);
    }

    private boolean canOptimizeAddDocument(Engine.Index index) {
        if (index.getAutoGeneratedIdTimestamp() != -1L) {
            assert (index.getAutoGeneratedIdTimestamp() >= 0L) : "autoGeneratedIdTimestamp must be positive but was: " + index.getAutoGeneratedIdTimestamp();
            return switch (index.origin()) {
                default -> throw new MatchException(null, null);
                case Engine.Operation.Origin.PRIMARY -> {
                    if (!$assertionsDisabled && !this.assertPrimaryCanOptimizeAddDocument(index)) {
                        throw new AssertionError();
                    }
                    yield true;
                }
                case Engine.Operation.Origin.PEER_RECOVERY, Engine.Operation.Origin.REPLICA -> {
                    if (!($assertionsDisabled || index.version() == 1L && index.versionType() == null)) {
                        throw new AssertionError((Object)("version: " + index.version() + " type: " + String.valueOf(index.versionType())));
                    }
                    yield true;
                }
                case Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY, Engine.Operation.Origin.LOCAL_RESET -> {
                    if (!$assertionsDisabled && !index.isRetry()) {
                        throw new AssertionError();
                    }
                    yield true;
                }
            };
        }
        return false;
    }

    protected boolean assertPrimaryCanOptimizeAddDocument(Engine.Index index) {
        assert ((index.version() == -4L || index.version() == -3L) && index.versionType() == VersionType.INTERNAL) : "version: " + index.version() + " type: " + String.valueOf(index.versionType());
        return true;
    }

    private boolean assertIncomingSequenceNumber(Engine.Operation.Origin origin, long seqNo) {
        if (origin == Engine.Operation.Origin.PRIMARY) {
            assert (this.assertPrimaryIncomingSequenceNumber(origin, seqNo));
        } else assert (seqNo >= 0L) : "recovery or replica ops should have an assigned seq no.; origin: " + String.valueOf((Object)origin);
        return true;
    }

    protected boolean assertPrimaryIncomingSequenceNumber(Engine.Operation.Origin origin, long seqNo) {
        assert (seqNo == -2L) : "primary operations must never have an assigned sequence number but was [" + seqNo + "]";
        return true;
    }

    protected long generateSeqNoForOperationOnPrimary(Engine.Operation operation) {
        assert (operation.origin() == Engine.Operation.Origin.PRIMARY);
        assert (operation.seqNo() == -2L) : "ops should not have an assigned seq no. but was: " + operation.seqNo();
        return this.doGenerateSeqNoForOperation(operation);
    }

    protected void advanceMaxSeqNoOfUpdatesOnPrimary(long seqNo) {
        this.advanceMaxSeqNoOfUpdatesOrDeletes(seqNo);
    }

    protected void advanceMaxSeqNoOfDeletesOnPrimary(long seqNo) {
        this.advanceMaxSeqNoOfUpdatesOrDeletes(seqNo);
    }

    long doGenerateSeqNoForOperation(Engine.Operation operation) {
        return this.localCheckpointTracker.generateSeqNo();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Engine.IndexResult index(Engine.Index index) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final IndexingStrategy planIndexingAsNonPrimary(Engine.Index index) throws IOException {
        IndexingStrategy plan;
        assert (this.assertNonPrimaryOrigin(index));
        if (this.canOptimizeAddDocument(index)) {
            this.mayHaveBeenIndexedBefore(index);
        }
        long maxSeqNoOfUpdatesOrDeletes = this.getMaxSeqNoOfUpdatesOrDeletes();
        if (this.hasBeenProcessedBefore(index)) {
            plan = IndexingStrategy.processButSkipLucene(false, index.version());
        } else if (maxSeqNoOfUpdatesOrDeletes <= this.localCheckpointTracker.getProcessedCheckpoint()) {
            assert (maxSeqNoOfUpdatesOrDeletes < index.seqNo()) : index.seqNo() + ">=" + maxSeqNoOfUpdatesOrDeletes;
            plan = IndexingStrategy.optimizedAppendOnly(index.version(), 0);
        } else {
            this.versionMap.enforceSafeAccess();
            OpVsLuceneDocStatus opVsLucene = this.compareOpToLuceneDocBasedOnSeqNo(index);
            plan = opVsLucene == OpVsLuceneDocStatus.OP_STALE_OR_EQUAL ? IndexingStrategy.processAsStaleOp(index.version(), 0) : IndexingStrategy.processNormally(opVsLucene == OpVsLuceneDocStatus.LUCENE_DOC_NOT_FOUND, index.version(), 0);
        }
        return plan;
    }

    protected IndexingStrategy indexingStrategyForOperation(Engine.Index index) throws IOException {
        if (index.origin() == Engine.Operation.Origin.PRIMARY) {
            return this.planIndexingAsPrimary(index);
        }
        return this.planIndexingAsNonPrimary(index);
    }

    private IndexingStrategy planIndexingAsPrimary(Engine.Index index) throws IOException {
        IndexingStrategy plan;
        assert (index.origin() == Engine.Operation.Origin.PRIMARY) : "planing as primary but origin isn't. got " + String.valueOf((Object)index.origin());
        int reservingDocs = index.parsedDoc().docs().size();
        boolean canOptimizeAddDocument = this.canOptimizeAddDocument(index);
        if (canOptimizeAddDocument && !this.mayHaveBeenIndexedBefore(index)) {
            Exception reserveError = this.tryAcquireInFlightDocs(index, reservingDocs);
            plan = reserveError != null ? IndexingStrategy.failAsTooManyDocs(reserveError, index.id()) : IndexingStrategy.optimizedAppendOnly(1L, reservingDocs);
        } else {
            boolean currentNotFoundOrDeleted;
            long currentVersion;
            this.versionMap.enforceSafeAccess();
            VersionValue versionValue = this.resolveDocVersion(index, index.getIfSeqNo() != -2L);
            if (versionValue == null) {
                currentVersion = -1L;
                currentNotFoundOrDeleted = true;
            } else {
                currentVersion = versionValue.version;
                currentNotFoundOrDeleted = versionValue.isDelete();
            }
            if (index.getIfSeqNo() != -2L && currentNotFoundOrDeleted) {
                VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, index.id(), index.getIfSeqNo(), index.getIfPrimaryTerm(), -2L, 0L);
                plan = IndexingStrategy.skipDueToVersionConflict(e, true, currentVersion, index.id());
            } else if (index.getIfSeqNo() != -2L && (versionValue.seqNo != index.getIfSeqNo() || versionValue.term != index.getIfPrimaryTerm())) {
                VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, index.id(), index.getIfSeqNo(), index.getIfPrimaryTerm(), versionValue.seqNo, versionValue.term);
                plan = IndexingStrategy.skipDueToVersionConflict(e, currentNotFoundOrDeleted, currentVersion, index.id());
            } else if (index.versionType().isVersionConflictForWrites(currentVersion, index.version(), currentNotFoundOrDeleted)) {
                VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, index.parsedDoc().documentDescription(), index.versionType().explainConflictForWrites(currentVersion, index.version(), true));
                plan = IndexingStrategy.skipDueToVersionConflict(e, currentNotFoundOrDeleted, currentVersion, index.id());
            } else {
                Exception reserveError = this.tryAcquireInFlightDocs(index, reservingDocs);
                plan = reserveError != null ? IndexingStrategy.failAsTooManyDocs(reserveError, index.id()) : IndexingStrategy.processNormally(currentNotFoundOrDeleted, canOptimizeAddDocument ? 1L : index.versionType().updateVersion(currentVersion, index.version()), reservingDocs);
            }
        }
        return plan;
    }

    private Engine.IndexResult indexIntoLucene(Engine.Index index, IndexingStrategy plan) throws IOException {
        assert (index.seqNo() >= 0L) : "ops should have an assigned seq no.; origin: " + String.valueOf((Object)index.origin());
        assert (plan.versionForIndexing >= 0L) : "version must be set. got " + plan.versionForIndexing;
        assert (plan.indexIntoLucene || plan.addStaleOpToLucene);
        index.parsedDoc().updateSeqID(index.seqNo(), index.primaryTerm());
        index.parsedDoc().version().setLongValue(plan.versionForIndexing);
        try {
            if (plan.addStaleOpToLucene) {
                this.addStaleDocs(index.docs(), this.indexWriter);
            } else if (plan.useLuceneUpdateDocument) {
                assert (this.assertMaxSeqNoOfUpdatesIsAdvanced(index.uid(), index.seqNo(), true, true));
                this.updateDocs(index.uid(), index.docs(), this.indexWriter);
            } else {
                assert (this.assertDocDoesNotExist(index, !this.canOptimizeAddDocument(index)));
                this.addDocs(index.docs(), this.indexWriter);
            }
            return new Engine.IndexResult(plan.versionForIndexing, index.primaryTerm(), index.seqNo(), plan.currentNotFoundOrDeleted, index.id());
        }
        catch (Exception ex) {
            if (!(ex instanceof AlreadyClosedException) && this.indexWriter.getTragicException() == null && !InternalEngine.treatDocumentFailureAsTragicError(index)) {
                return new Engine.IndexResult(ex, -3L, index.primaryTerm(), index.seqNo(), index.id());
            }
            throw ex;
        }
    }

    private static boolean treatDocumentFailureAsTragicError(Engine.Index index) {
        return index.origin() == Engine.Operation.Origin.REPLICA || index.origin() == Engine.Operation.Origin.PEER_RECOVERY || index.origin() == Engine.Operation.Origin.LOCAL_RESET;
    }

    private boolean mayHaveBeenIndexedBefore(Engine.Index index) {
        boolean mayHaveBeenIndexBefore;
        assert (this.canOptimizeAddDocument(index));
        if (index.isRetry()) {
            mayHaveBeenIndexBefore = true;
            this.updateAutoIdTimestamp(index.getAutoGeneratedIdTimestamp(), true);
            assert (this.maxUnsafeAutoIdTimestamp.get() >= index.getAutoGeneratedIdTimestamp());
        } else {
            mayHaveBeenIndexBefore = this.maxUnsafeAutoIdTimestamp.get() >= index.getAutoGeneratedIdTimestamp();
            this.updateAutoIdTimestamp(index.getAutoGeneratedIdTimestamp(), false);
        }
        return mayHaveBeenIndexBefore;
    }

    private void addDocs(List<LuceneDocument> docs, IndexWriter indexWriter) throws IOException {
        indexWriter.addDocuments(docs);
        this.numDocAppends.inc(docs.size());
    }

    private void addStaleDocs(List<LuceneDocument> docs, IndexWriter indexWriter) throws IOException {
        for (LuceneDocument doc : docs) {
            doc.add((IndexableField)this.softDeletesField);
        }
        if (docs.size() > 1) {
            indexWriter.addDocuments(docs);
        } else {
            indexWriter.addDocument((Iterable)docs.get(0));
        }
    }

    private boolean assertDocDoesNotExist(Engine.Index index, boolean allowDeleted) throws IOException {
        VersionValue versionValue = this.versionMap.getVersionForAssert(index.uid());
        if (versionValue != null) {
            if (!versionValue.isDelete() || !allowDeleted) {
                throw new AssertionError((Object)("doc [" + index.id() + "] exists in version map (version " + String.valueOf(versionValue) + ")"));
            }
        } else {
            try (Engine.Searcher searcher = this.acquireSearcher("assert doc doesn't exist", Engine.SearcherScope.INTERNAL);){
                searcher.setQueryCache(null);
                long docsWithId = searcher.count((Query)new TermQuery(new Term("_id", index.uid())));
                if (docsWithId > 0L) {
                    throw new AssertionError((Object)("doc [" + index.id() + "] exists [" + docsWithId + "] times in index"));
                }
            }
        }
        return true;
    }

    private void updateDocs(BytesRef uid, List<LuceneDocument> docs, IndexWriter indexWriter) throws IOException {
        Term uidTerm = new Term("_id", uid);
        if (docs.size() > 1) {
            indexWriter.softUpdateDocuments(uidTerm, docs, new Field[]{this.softDeletesField});
        } else {
            indexWriter.softUpdateDocument(uidTerm, (Iterable)docs.get(0), new Field[]{this.softDeletesField});
        }
        this.numDocUpdates.inc(docs.size());
    }

    @Override
    public Engine.DeleteResult delete(Engine.Delete delete) throws IOException {
        Engine.DeleteResult deleteResult;
        this.versionMap.enforceSafeAccess();
        assert (this.assertIncomingSequenceNumber(delete.origin(), delete.seqNo()));
        int reservedDocs = 0;
        try (Releasable ignored = this.acquireEnsureOpenRef();
             Releasable ignored2 = this.versionMap.acquireLock(delete.uid());){
            this.lastWriteNanos = delete.startTime();
            DeletionStrategy plan = this.deletionStrategyForOperation(delete);
            reservedDocs = plan.reservedDocs;
            if (plan.earlyResultOnPreflightError.isPresent()) {
                assert (delete.origin() == Engine.Operation.Origin.PRIMARY) : delete.origin();
                deleteResult = plan.earlyResultOnPreflightError.get();
            } else {
                if (delete.origin() == Engine.Operation.Origin.PRIMARY) {
                    delete = new Engine.Delete(delete.id(), delete.uid(), this.generateSeqNoForOperationOnPrimary(delete), delete.primaryTerm(), delete.version(), delete.versionType(), delete.origin(), delete.startTime(), delete.getIfSeqNo(), delete.getIfPrimaryTerm());
                    this.advanceMaxSeqNoOfDeletesOnPrimary(delete.seqNo());
                } else {
                    this.markSeqNoAsSeen(delete.seqNo());
                }
                assert (delete.seqNo() >= 0L) : "ops should have an assigned seq no.; origin: " + String.valueOf((Object)delete.origin());
                deleteResult = plan.deleteFromLucene || plan.addStaleOpToLucene ? this.deleteInLucene(delete, plan) : new Engine.DeleteResult(plan.versionOfDeletion, delete.primaryTerm(), delete.seqNo(), !plan.currentlyDeleted, delete.id());
                if (plan.deleteFromLucene) {
                    this.numDocDeletes.inc();
                    this.versionMap.putDeleteUnderLock(delete.uid(), new DeleteVersionValue(plan.versionOfDeletion, delete.seqNo(), delete.primaryTerm(), this.engineConfig.getThreadPool().relativeTimeInMillis()));
                }
            }
            if (!delete.origin().isFromTranslog() && deleteResult.getResultType() == Engine.Result.Type.SUCCESS) {
                Translog.Location location = this.translog.add(new Translog.Delete(delete, deleteResult));
                deleteResult.setTranslogLocation(location);
            }
            this.localCheckpointTracker.markSeqNoAsProcessed(deleteResult.getSeqNo());
            if (deleteResult.getTranslogLocation() == null) {
                assert (delete.origin().isFromTranslog() || deleteResult.getSeqNo() == -2L);
                this.localCheckpointTracker.markSeqNoAsPersisted(deleteResult.getSeqNo());
            }
            deleteResult.setTook(System.nanoTime() - delete.startTime());
            deleteResult.freeze();
        }
        catch (IOException | RuntimeException e) {
            try {
                this.maybeFailEngine("delete", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw e;
        }
        finally {
            this.releaseInFlightDocs(reservedDocs);
        }
        this.maybePruneDeletes();
        return deleteResult;
    }

    private Exception tryAcquireInFlightDocs(Engine.Operation operation, int addingDocs) {
        assert (operation.origin() == Engine.Operation.Origin.PRIMARY) : operation;
        assert (operation.seqNo() == -2L) : operation;
        assert (addingDocs > 0) : addingDocs;
        long totalDocs = this.indexWriter.getPendingNumDocs() + this.inFlightDocCount.addAndGet(addingDocs);
        if (totalDocs > (long)this.maxDocs) {
            this.releaseInFlightDocs(addingDocs);
            return new IllegalArgumentException(org.elasticsearch.common.Strings.format("Number of documents in the shard cannot exceed [%d]; for more information, see [%s]", new Object[]{this.maxDocs, ReferenceDocs.LUCENE_MAX_DOCS_LIMIT}));
        }
        return null;
    }

    private void releaseInFlightDocs(int numDocs) {
        assert (numDocs >= 0) : numDocs;
        long newValue = this.inFlightDocCount.addAndGet(-numDocs);
        assert (newValue >= 0L) : "inFlightDocCount must not be negative [" + newValue + "]";
    }

    long getInFlightDocCount() {
        return this.inFlightDocCount.get();
    }

    protected DeletionStrategy deletionStrategyForOperation(Engine.Delete delete) throws IOException {
        if (delete.origin() == Engine.Operation.Origin.PRIMARY) {
            return this.planDeletionAsPrimary(delete);
        }
        return this.planDeletionAsNonPrimary(delete);
    }

    protected final DeletionStrategy planDeletionAsNonPrimary(Engine.Delete delete) throws IOException {
        OpVsLuceneDocStatus opVsLucene;
        assert (this.assertNonPrimaryOrigin(delete));
        DeletionStrategy plan = this.hasBeenProcessedBefore(delete) ? DeletionStrategy.processButSkipLucene(false, delete.version()) : ((opVsLucene = this.compareOpToLuceneDocBasedOnSeqNo(delete)) == OpVsLuceneDocStatus.OP_STALE_OR_EQUAL ? DeletionStrategy.processAsStaleOp(delete.version()) : DeletionStrategy.processNormally(opVsLucene == OpVsLuceneDocStatus.LUCENE_DOC_NOT_FOUND, delete.version(), 0));
        return plan;
    }

    protected boolean assertNonPrimaryOrigin(Engine.Operation operation) {
        assert (operation.origin() != Engine.Operation.Origin.PRIMARY) : "planing as primary but got " + String.valueOf((Object)operation.origin());
        return true;
    }

    private DeletionStrategy planDeletionAsPrimary(Engine.Delete delete) throws IOException {
        DeletionStrategy plan;
        boolean currentlyDeleted;
        long currentVersion;
        assert (delete.origin() == Engine.Operation.Origin.PRIMARY) : "planing as primary but got " + String.valueOf((Object)delete.origin());
        VersionValue versionValue = this.resolveDocVersion(delete, delete.getIfSeqNo() != -2L);
        assert (this.incrementVersionLookup());
        if (versionValue == null) {
            currentVersion = -1L;
            currentlyDeleted = true;
        } else {
            currentVersion = versionValue.version;
            currentlyDeleted = versionValue.isDelete();
        }
        if (delete.getIfSeqNo() != -2L && currentlyDeleted) {
            VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, delete.id(), delete.getIfSeqNo(), delete.getIfPrimaryTerm(), -2L, 0L);
            plan = DeletionStrategy.skipDueToVersionConflict(e, currentVersion, true, delete.id());
        } else if (delete.getIfSeqNo() != -2L && (versionValue.seqNo != delete.getIfSeqNo() || versionValue.term != delete.getIfPrimaryTerm())) {
            VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, delete.id(), delete.getIfSeqNo(), delete.getIfPrimaryTerm(), versionValue.seqNo, versionValue.term);
            plan = DeletionStrategy.skipDueToVersionConflict(e, currentVersion, currentlyDeleted, delete.id());
        } else if (delete.versionType().isVersionConflictForWrites(currentVersion, delete.version(), currentlyDeleted)) {
            VersionConflictEngineException e = new VersionConflictEngineException(this.shardId, "[" + delete.id() + "]", delete.versionType().explainConflictForWrites(currentVersion, delete.version(), true));
            plan = DeletionStrategy.skipDueToVersionConflict(e, currentVersion, currentlyDeleted, delete.id());
        } else {
            Exception reserveError = this.tryAcquireInFlightDocs(delete, 1);
            if (reserveError != null) {
                plan = DeletionStrategy.failAsTooManyDocs(reserveError, delete.id());
            } else {
                long versionOfDeletion = delete.versionType().updateVersion(currentVersion, delete.version());
                plan = DeletionStrategy.processNormally(currentlyDeleted, versionOfDeletion, 1);
            }
        }
        return plan;
    }

    private Engine.DeleteResult deleteInLucene(Engine.Delete delete, DeletionStrategy plan) throws IOException {
        assert (this.assertMaxSeqNoOfUpdatesIsAdvanced(delete.uid(), delete.seqNo(), false, false));
        try {
            ParsedDocument tombstone = ParsedDocument.deleteTombstone(this.engineConfig.getIndexSettings().seqNoIndexOptions(), delete.id());
            assert (tombstone.docs().size() == 1) : "Tombstone doc should have single doc [" + String.valueOf(tombstone) + "]";
            tombstone.updateSeqID(delete.seqNo(), delete.primaryTerm());
            tombstone.version().setLongValue(plan.versionOfDeletion);
            LuceneDocument doc = tombstone.docs().get(0);
            assert (doc.getField("_tombstone") != null) : "Delete tombstone document but _tombstone field is not set [" + String.valueOf(doc) + " ]";
            doc.add((IndexableField)this.softDeletesField);
            if (plan.addStaleOpToLucene || plan.currentlyDeleted) {
                this.indexWriter.addDocument((Iterable)doc);
            } else {
                this.indexWriter.softUpdateDocument(new Term("_id", delete.uid()), (Iterable)doc, new Field[]{this.softDeletesField});
            }
            return new Engine.DeleteResult(plan.versionOfDeletion, delete.primaryTerm(), delete.seqNo(), !plan.currentlyDeleted, delete.id());
        }
        catch (Exception ex) {
            if (!(ex instanceof AlreadyClosedException) && this.indexWriter.getTragicException() == null) {
                String reason = String.format(Locale.ROOT, "delete id[%s] origin [%s] seq#[%d] failed at the document level", new Object[]{delete.id(), delete.origin(), delete.seqNo()});
                this.failEngine(reason, ex);
            }
            throw ex;
        }
    }

    @Override
    public void maybePruneDeletes() {
        if (this.engineConfig.isEnableGcDeletes() && (double)(this.engineConfig.getThreadPool().relativeTimeInMillis() - this.lastDeleteVersionPruneTimeMSec) > (double)this.getGcDeletesInMillis() * 0.25) {
            this.pruneDeletedTombstones();
        }
    }

    @Override
    public Engine.NoOpResult noOp(Engine.NoOp noOp) throws IOException {
        Engine.NoOpResult noOpResult;
        try (Releasable ignored = this.acquireEnsureOpenRef();){
            noOpResult = this.innerNoOp(noOp);
        }
        catch (Exception e) {
            try {
                this.maybeFailEngine("noop", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw e;
        }
        return noOpResult;
    }

    private Engine.NoOpResult innerNoOp(Engine.NoOp noOp) throws IOException {
        assert (!this.isDrainedForClose());
        assert (noOp.seqNo() > -1L);
        long seqNo = noOp.seqNo();
        try {
            Engine.NoOpResult noOpResult;
            block23: {
                Releasable ignored = this.noOpKeyedLock.acquire(seqNo);
                try {
                    Engine.NoOpResult noOpResult2;
                    Optional<Exception> preFlightError = this.preFlightCheckForNoOp(noOp);
                    if (preFlightError.isPresent()) {
                        noOpResult2 = new Engine.NoOpResult(0L, -2L, preFlightError.get());
                    } else {
                        this.markSeqNoAsSeen(noOp.seqNo());
                        if (!this.hasBeenProcessedBefore(noOp)) {
                            try {
                                ParsedDocument tombstone = ParsedDocument.noopTombstone(this.engineConfig.getIndexSettings().seqNoIndexOptions(), noOp.reason());
                                tombstone.updateSeqID(noOp.seqNo(), noOp.primaryTerm());
                                tombstone.version().setLongValue(1L);
                                assert (tombstone.docs().size() == 1) : "Tombstone should have a single doc [" + String.valueOf(tombstone) + "]";
                                LuceneDocument doc = tombstone.docs().get(0);
                                assert (doc.getField("_tombstone") != null) : "Noop tombstone document but _tombstone field is not set [" + String.valueOf(doc) + " ]";
                                doc.add((IndexableField)this.softDeletesField);
                                this.indexWriter.addDocument((Iterable)doc);
                            }
                            catch (Exception ex) {
                                if (!(ex instanceof AlreadyClosedException) && this.indexWriter.getTragicException() == null) {
                                    this.failEngine("no-op origin[" + String.valueOf((Object)noOp.origin()) + "] seq#[" + noOp.seqNo() + "] failed at document level", ex);
                                }
                                throw ex;
                            }
                        }
                        noOpResult2 = new Engine.NoOpResult(noOp.primaryTerm(), noOp.seqNo());
                        if (!noOp.origin().isFromTranslog() && noOpResult2.getResultType() == Engine.Result.Type.SUCCESS) {
                            Translog.Location location = this.translog.add(new Translog.NoOp(noOp.seqNo(), noOp.primaryTerm(), noOp.reason()));
                            noOpResult2.setTranslogLocation(location);
                        }
                    }
                    this.localCheckpointTracker.markSeqNoAsProcessed(noOpResult2.getSeqNo());
                    if (noOpResult2.getTranslogLocation() == null) {
                        assert (noOp.origin().isFromTranslog() || noOpResult2.getSeqNo() == -2L);
                        this.localCheckpointTracker.markSeqNoAsPersisted(noOpResult2.getSeqNo());
                    }
                    noOpResult2.setTook(System.nanoTime() - noOp.startTime());
                    noOpResult2.freeze();
                    noOpResult = noOpResult2;
                    if (ignored == null) break block23;
                }
                catch (Throwable throwable) {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored.close();
            }
            return noOpResult;
        }
        finally {
            assert (!this.isDrainedForClose());
        }
    }

    protected Optional<Exception> preFlightCheckForNoOp(Engine.NoOp noOp) throws IOException {
        return Optional.empty();
    }

    @Override
    public Engine.RefreshResult refresh(String source) throws EngineException {
        return this.refresh(source, Engine.SearcherScope.EXTERNAL, true);
    }

    @Override
    public void maybeRefresh(String source, ActionListener<Engine.RefreshResult> listener) throws EngineException {
        ActionListener.completeWith(listener, () -> this.refresh(source, Engine.SearcherScope.EXTERNAL, false));
    }

    protected Engine.RefreshResult refreshInternalSearcher(String source, boolean block) throws EngineException {
        return this.refresh(source, Engine.SearcherScope.INTERNAL, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Engine.RefreshResult refresh(String source, Engine.SearcherScope scope, boolean block) throws EngineException {
        long segmentGeneration;
        boolean refreshed;
        long localCheckpointBeforeRefresh;
        block20: {
            localCheckpointBeforeRefresh = this.localCheckpointTracker.getProcessedCheckpoint();
            refreshed = false;
            segmentGeneration = -1L;
            try {
                if (this.store.tryIncRef()) {
                    block19: {
                        try {
                            ReferenceManager<ElasticsearchDirectoryReader> referenceManager = this.getReferenceManager(scope);
                            long generationBeforeRefresh = this.lastCommittedSegmentInfos.getGeneration();
                            Lock engineReadLock = this.engineConfig.getEngineResetLock().readLock();
                            if (block) {
                                engineReadLock.lock();
                                try {
                                    referenceManager.maybeRefreshBlocking();
                                    segmentGeneration = this.segmentGenerationAfterRefresh(referenceManager, generationBeforeRefresh);
                                    refreshed = true;
                                    break block19;
                                }
                                finally {
                                    engineReadLock.unlock();
                                }
                            }
                            if (!engineReadLock.tryLock()) break block19;
                            try {
                                refreshed = referenceManager.maybeRefresh();
                                if (refreshed) {
                                    segmentGeneration = this.segmentGenerationAfterRefresh(referenceManager, generationBeforeRefresh);
                                }
                            }
                            finally {
                                engineReadLock.unlock();
                            }
                        }
                        finally {
                            this.store.decRef();
                        }
                    }
                    if (refreshed) {
                        this.lastRefreshedCheckpointListener.updateRefreshedCheckpoint(localCheckpointBeforeRefresh);
                    }
                    break block20;
                }
                refreshed = false;
            }
            catch (AlreadyClosedException e) {
                this.failOnTragicEvent(e);
                throw e;
            }
            catch (Exception e) {
                try {
                    this.failEngine("refresh failed source[" + source + "]", e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                throw new RefreshFailedEngineException(this.shardId, (Throwable)e);
            }
        }
        assert (!refreshed || this.lastRefreshedCheckpoint() >= localCheckpointBeforeRefresh) : "refresh checkpoint was not advanced; local_checkpoint=" + localCheckpointBeforeRefresh + " refresh_checkpoint=" + this.lastRefreshedCheckpoint();
        this.maybePruneDeletes();
        this.mergeScheduler.refreshConfig();
        long primaryTerm = this.config().getPrimaryTermSupplier().getAsLong();
        return new Engine.RefreshResult(refreshed, primaryTerm, segmentGeneration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long segmentGenerationAfterRefresh(ReferenceManager<ElasticsearchDirectoryReader> referenceManager, long generationBeforeRefresh) throws IOException {
        assert (this.store.hasReferences());
        assert (this.engineConfig.getEngineResetLock().isReadLockedByCurrentThread()) : "prevent concurrent engine resets";
        ElasticsearchDirectoryReader current = (ElasticsearchDirectoryReader)((Object)referenceManager.acquire());
        try {
            long l = Math.max(current.getIndexCommit().getGeneration(), generationBeforeRefresh);
            return l;
        }
        finally {
            referenceManager.release((Object)current);
        }
    }

    @Override
    public void writeIndexingBuffer() throws IOException {
        long indexWriterBytesUsed;
        long reclaimableVersionMapBytes = this.versionMap.reclaimableRefreshRamBytes();
        if (reclaimableVersionMapBytes >= (indexWriterBytesUsed = this.indexWriter.ramBytesUsed() - this.indexWriter.getFlushingBytes())) {
            this.reclaimVersionMapMemory();
        } else {
            this.indexWriter.flushNextBuffer();
        }
    }

    protected void reclaimVersionMapMemory() {
        long flushThresholdAgeInNanos;
        long flushThresholdSizeInBytes = Math.max((long)(Translog.DEFAULT_HEADER_SIZE_IN_BYTES + 1), this.config().getIndexSettings().getFlushThresholdSize(this.totalDiskSpace).getBytes() / 2L);
        if (this.shouldPeriodicallyFlush(flushThresholdSizeInBytes, flushThresholdAgeInNanos = this.config().getIndexSettings().getFlushThresholdAge().getNanos() / 2L)) {
            this.flush(false, false, ActionListener.noop());
        } else {
            this.refresh("write indexing buffer", Engine.SearcherScope.INTERNAL, false);
        }
    }

    @Override
    public boolean shouldPeriodicallyFlush() {
        long flushThresholdSizeInBytes = this.config().getIndexSettings().getFlushThresholdSize(this.totalDiskSpace).getBytes();
        long flushThresholdAgeInNanos = this.config().getIndexSettings().getFlushThresholdAge().getNanos();
        return this.shouldPeriodicallyFlush(flushThresholdSizeInBytes, flushThresholdAgeInNanos);
    }

    private boolean shouldPeriodicallyFlush(long flushThresholdSizeInBytes, long flushThresholdAgeInNanos) {
        this.ensureOpen();
        if (this.shouldPeriodicallyFlushAfterBigMerge.get()) {
            return true;
        }
        long localCheckpointOfLastCommit = Long.parseLong((String)this.lastCommittedSegmentInfos.userData.get("local_checkpoint"));
        long translogGenerationOfLastCommit = this.translog.getMinGenerationForSeqNo(localCheckpointOfLastCommit + 1L).translogFileGeneration();
        if (this.translog.sizeInBytesByMinGen(translogGenerationOfLastCommit) < flushThresholdSizeInBytes && this.relativeTimeInNanosSupplier.getAsLong() - this.lastFlushTimestamp < flushThresholdAgeInNanos) {
            return false;
        }
        long translogGenerationOfNewCommit = this.translog.getMinGenerationForSeqNo(this.localCheckpointTracker.getProcessedCheckpoint() + 1L).translogFileGeneration();
        return translogGenerationOfLastCommit < translogGenerationOfNewCommit || this.localCheckpointTracker.getProcessedCheckpoint() == this.localCheckpointTracker.getMaxSeqNo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void flushHoldingLock(boolean force, boolean waitIfOngoing, ActionListener<Engine.FlushResult> listener) throws EngineException {
        long generation;
        this.ensureOpen();
        if (force && !waitIfOngoing) {
            String message = "wait_if_ongoing must be true for a force flush: force=" + force + " wait_if_ongoing=" + waitIfOngoing;
            assert (false) : message;
            throw new IllegalArgumentException(message);
        }
        Lock engineReadLock = this.engineConfig.getEngineResetLock().readLock();
        engineReadLock.lock();
        try {
            long startTime;
            block24: {
                if (!this.flushLock.tryLock()) {
                    if (!waitIfOngoing) {
                        this.logger.trace("detected an in-flight flush, not blocking to wait for it's completion");
                        listener.onResponse(Engine.FlushResult.NO_FLUSH);
                        return;
                    }
                    this.logger.trace("waiting for in-flight flush to finish");
                    this.flushLock.lock();
                    this.logger.trace("acquired flush lock after blocking");
                } else {
                    this.logger.trace("acquired flush lock immediately");
                }
                startTime = System.nanoTime();
                try {
                    boolean hasUncommittedChanges = this.hasUncommittedChanges();
                    if (hasUncommittedChanges || force || this.shouldPeriodicallyFlush() || this.getProcessedLocalCheckpoint() > Long.parseLong((String)this.lastCommittedSegmentInfos.userData.get("local_checkpoint"))) {
                        this.ensureCanFlush();
                        Translog.Location commitLocation = this.getTranslogLastWriteLocation();
                        try {
                            this.translog.rollGeneration();
                            this.logger.trace("starting commit for flush; commitTranslog=true");
                            long lastFlushTimestamp = this.relativeTimeInNanosSupplier.getAsLong();
                            this.preCommitSegmentGeneration.set(this.lastCommittedSegmentInfos.getGeneration() + 1L);
                            this.commitIndexWriter(this.indexWriter, this.translog);
                            this.logger.trace("finished commit for flush");
                            this.refresh("version_table_flush", Engine.SearcherScope.INTERNAL, true);
                            this.translog.trimUnreferencedReaders();
                            Translog.Location writeLocationAfterFlush = this.translog.getLastWriteLocation();
                            if (!writeLocationAfterFlush.equals(commitLocation) && !this.hasUncommittedChanges()) {
                                assert (writeLocationAfterFlush.compareTo(commitLocation) > 0) : String.valueOf(writeLocationAfterFlush) + " <= " + String.valueOf(commitLocation);
                                commitLocation = writeLocationAfterFlush;
                            }
                            this.lastFlushTimestamp = lastFlushTimestamp;
                        }
                        catch (AlreadyClosedException e) {
                            this.failOnTragicEvent(e);
                            throw e;
                        }
                        catch (Exception e) {
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                        this.refreshLastCommittedSegmentInfos();
                        generation = this.lastCommittedSegmentInfos.getGeneration();
                        this.flushListener.afterFlush(generation, commitLocation);
                        break block24;
                    }
                    generation = this.lastCommittedSegmentInfos.getGeneration();
                }
                catch (FlushFailedEngineException ex) {
                    this.maybeFailEngine("flush", ex);
                    listener.onFailure(ex);
                    this.totalFlushTimeExcludingWaitingOnLock.inc(System.nanoTime() - startTime);
                    this.flushLock.unlock();
                    this.logger.trace("released flush lock");
                    engineReadLock.unlock();
                    return;
                }
                catch (Exception e) {
                    listener.onFailure(e);
                    this.totalFlushTimeExcludingWaitingOnLock.inc(System.nanoTime() - startTime);
                    this.flushLock.unlock();
                    {
                        catch (Throwable throwable) {
                            this.totalFlushTimeExcludingWaitingOnLock.inc(System.nanoTime() - startTime);
                            this.flushLock.unlock();
                            this.logger.trace("released flush lock");
                            throw throwable;
                        }
                    }
                    this.logger.trace("released flush lock");
                    engineReadLock.unlock();
                    return;
                }
            }
            this.totalFlushTimeExcludingWaitingOnLock.inc(System.nanoTime() - startTime);
            this.flushLock.unlock();
            this.logger.trace("released flush lock");
        }
        finally {
            engineReadLock.unlock();
        }
        this.afterFlush(generation);
        if (this.engineConfig.isEnableGcDeletes()) {
            this.pruneDeletedTombstones();
        }
        this.waitForCommitDurability(generation, listener.map(v -> new Engine.FlushResult(true, generation)));
    }

    protected final boolean isFlushLockIsHeldByCurrentThread() {
        return this.flushLock.isHeldByCurrentThread();
    }

    protected boolean hasUncommittedChanges() {
        return this.indexWriter.hasUncommittedChanges();
    }

    private void refreshLastCommittedSegmentInfos() {
        this.store.incRef();
        try {
            this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
        }
        catch (Exception e) {
            if (!this.isClosed.get()) {
                this.logger.warn("failed to read latest segment infos on flush", (Throwable)e);
                if (Lucene.isCorruptionException(e)) {
                    throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                }
            }
        }
        finally {
            this.store.decRef();
        }
    }

    protected void afterFlush(long generation) {
    }

    @Override
    public void rollTranslogGeneration() throws EngineException {
        try (Releasable ignored = this.acquireEnsureOpenRef();){
            this.translog.rollGeneration();
            this.translog.trimUnreferencedReaders();
        }
        catch (AlreadyClosedException e) {
            this.failOnTragicEvent(e);
            throw e;
        }
        catch (Exception e) {
            try {
                this.failEngine("translog trimming failed", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new EngineException(this.shardId, "failed to roll translog", e, new Object[0]);
        }
    }

    @Override
    public void trimUnreferencedTranslogFiles() throws EngineException {
        try (Releasable ignored = this.acquireEnsureOpenRef();){
            this.translog.trimUnreferencedReaders();
        }
        catch (AlreadyClosedException e) {
            this.failOnTragicEvent(e);
            throw e;
        }
        catch (Exception e) {
            try {
                this.failEngine("translog trimming failed", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new EngineException(this.shardId, "failed to trim translog", e, new Object[0]);
        }
    }

    @Override
    public boolean shouldRollTranslogGeneration() {
        return this.getTranslog().shouldRollGeneration();
    }

    @Override
    public void trimOperationsFromTranslog(long belowTerm, long aboveSeqNo) throws EngineException {
        try (Releasable ignored = this.acquireEnsureOpenRef();){
            this.translog.trimOperations(belowTerm, aboveSeqNo);
        }
        catch (AlreadyClosedException e) {
            this.failOnTragicEvent(e);
            throw e;
        }
        catch (Exception e) {
            try {
                this.failEngine("translog operations trimming failed", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new EngineException(this.shardId, "failed to trim translog operations", e, new Object[0]);
        }
    }

    private void pruneDeletedTombstones() {
        long timeMSec = this.engineConfig.getThreadPool().relativeTimeInMillis();
        long maxTimestampToPrune = timeMSec - this.engineConfig.getIndexSettings().getGcDeletesInMillis();
        this.versionMap.pruneTombstones(maxTimestampToPrune, this.localCheckpointTracker.getProcessedCheckpoint());
        this.lastDeleteVersionPruneTimeMSec = timeMSec;
    }

    void clearDeletedTombstones() {
        this.versionMap.pruneTombstones(Long.MAX_VALUE, this.localCheckpointTracker.getMaxSeqNo());
    }

    final Map<BytesRef, VersionValue> getVersionMap() {
        return Stream.concat(this.versionMap.getAllCurrent().entrySet().stream(), this.versionMap.getAllTombstones().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceMerge(boolean flush, int maxNumSegments, boolean onlyExpungeDeletes, String forceMergeUUID) throws EngineException, IOException {
        if (onlyExpungeDeletes && maxNumSegments >= 0) {
            throw new IllegalArgumentException("only_expunge_deletes and max_num_segments are mutually exclusive");
        }
        this.optimizeLock.lock();
        try {
            this.ensureOpen();
            this.store.incRef();
            try {
                if (onlyExpungeDeletes) {
                    this.indexWriter.forceMergeDeletes(true);
                } else if (maxNumSegments <= 0) {
                    this.indexWriter.maybeMerge();
                } else {
                    this.indexWriter.forceMerge(maxNumSegments, true);
                    this.forceMergeUUID = forceMergeUUID;
                }
                if (flush) {
                    this.flush(false, true);
                    this.refresh("force-merge");
                }
            }
            finally {
                this.store.decRef();
            }
        }
        catch (AlreadyClosedException ex) {
            this.ensureOpen((Exception)((Object)ex));
            this.failOnTragicEvent(ex);
            throw ex;
        }
        catch (Exception e) {
            try {
                this.maybeFailEngine("force merge", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw e;
        }
        finally {
            this.optimizeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Engine.IndexCommitRef acquireIndexCommitRef(Supplier<IndexCommit> indexCommitSupplier) {
        this.store.incRef();
        boolean success = false;
        try {
            IndexCommit indexCommit = indexCommitSupplier.get();
            Engine.IndexCommitRef commitRef = new Engine.IndexCommitRef(indexCommit, (CheckedRunnable<IOException>)((CheckedRunnable)() -> {
                Closeable[] closeableArray = new Closeable[2];
                closeableArray[0] = () -> this.releaseIndexCommit(indexCommit);
                closeableArray[1] = this.store::decRef;
                IOUtils.close((Closeable[])closeableArray);
            }));
            success = true;
            Engine.IndexCommitRef indexCommitRef = commitRef;
            return indexCommitRef;
        }
        finally {
            if (!success) {
                this.store.decRef();
            }
        }
    }

    @Override
    public Engine.IndexCommitRef acquireLastIndexCommit(boolean flushFirst) throws EngineException {
        if (flushFirst) {
            this.logger.trace("start flush for snapshot");
            PlainActionFuture<Engine.FlushResult> future = new PlainActionFuture<Engine.FlushResult>();
            this.flush(false, true, future);
            future.actionGet();
            this.logger.trace("finish flush for snapshot");
        }
        return this.acquireIndexCommitRef(() -> this.combinedDeletionPolicy.acquireIndexCommit(false));
    }

    @Override
    public Engine.IndexCommitRef acquireSafeIndexCommit() throws EngineException {
        return this.acquireIndexCommitRef(() -> this.combinedDeletionPolicy.acquireIndexCommit(true));
    }

    private void releaseIndexCommit(IndexCommit snapshot) throws IOException {
        if (this.combinedDeletionPolicy.releaseCommit(snapshot)) {
            try {
                this.indexWriter.deleteUnusedFiles();
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
    }

    @Override
    public SafeCommitInfo getSafeCommitInfo() {
        return this.combinedDeletionPolicy.getSafeCommitInfo();
    }

    private boolean failOnTragicEvent(AlreadyClosedException ex) {
        boolean engineFailed;
        if (!this.indexWriter.isOpen() && this.indexWriter.getTragicException() != null) {
            Exception tragicException = this.indexWriter.getTragicException() instanceof Exception ? (Exception)this.indexWriter.getTragicException() : new RuntimeException(this.indexWriter.getTragicException());
            this.failEngine("already closed by tragic event on the index writer", tragicException);
            engineFailed = true;
        } else if (!this.translog.isOpen() && this.translog.getTragicException() != null) {
            this.failEngine("already closed by tragic event on the translog", this.translog.getTragicException());
            engineFailed = true;
        } else {
            if (this.failedEngine.get() == null && !this.isClosing() && !this.isClosed.get()) {
                throw new AssertionError("Unexpected AlreadyClosedException", ex);
            }
            engineFailed = false;
        }
        return engineFailed;
    }

    @Override
    protected boolean maybeFailEngine(String source, Exception e) {
        boolean shouldFail = super.maybeFailEngine(source, e);
        if (shouldFail) {
            return true;
        }
        if (e instanceof AlreadyClosedException) {
            return this.failOnTragicEvent((AlreadyClosedException)((Object)e));
        }
        if (e != null && (!this.indexWriter.isOpen() && this.indexWriter.getTragicException() == e || !this.translog.isOpen() && this.translog.getTragicException() == e)) {
            this.failEngine(source, e);
            return true;
        }
        return false;
    }

    @Override
    public SegmentInfos getLastCommittedSegmentInfos() {
        return this.lastCommittedSegmentInfos;
    }

    @Override
    protected final void writerSegmentStats(SegmentsStats stats) {
        stats.addVersionMapMemoryInBytes(this.versionMap.ramBytesUsed());
        stats.addIndexWriterMemoryInBytes(this.indexWriter.ramBytesUsed());
        stats.updateMaxUnsafeAutoIdTimestamp(this.maxUnsafeAutoIdTimestamp.get());
    }

    @Override
    public long getIndexBufferRAMBytesUsed() {
        return this.indexWriter.ramBytesUsed() + this.versionMap.ramBytesUsedForRefresh();
    }

    @Override
    public List<Segment> segments() {
        return this.segments(false);
    }

    @Override
    public List<Segment> segments(boolean includeVectorFormatsInfo) {
        try (Releasable ignored = this.acquireEnsureOpenRef();){
            Segment[] segmentsArr = this.getSegmentInfo(this.lastCommittedSegmentInfos, includeVectorFormatsInfo);
            Set<OnGoingMerge> onGoingMerges = this.mergeScheduler.onGoingMerges();
            for (OnGoingMerge onGoingMerge : onGoingMerges) {
                block6: for (SegmentCommitInfo segmentInfoPerCommit : onGoingMerge.getMergedSegments()) {
                    for (Segment segment : segmentsArr) {
                        if (!segment.getName().equals(segmentInfoPerCommit.info.name)) continue;
                        segment.mergeId = onGoingMerge.getId();
                        continue block6;
                    }
                }
            }
            List<Segment> list = Arrays.asList(segmentsArr);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void closeNoLock(String reason, CountDownLatch closedLatch) {
        if (this.isClosed.compareAndSet(false, true)) {
            assert (this.isDrainedForClose() || this.failEngineLock.isHeldByCurrentThread()) : "Either all operations must have been drained or the engine must be currently be failing itself";
            try {
                this.versionMap.clear();
                if (this.internalReaderManager != null) {
                    this.internalReaderManager.removeListener(this.versionMap);
                }
                try {
                    IOUtils.close((Closeable[])new Closeable[]{this.flushListener, this.externalReaderManager, this.internalReaderManager});
                }
                catch (Exception e) {
                    this.logger.warn("Failed to close ReaderManager", (Throwable)e);
                }
                try {
                    IOUtils.close((Closeable)this.translog);
                }
                catch (Exception e) {
                    this.logger.warn("Failed to close translog", (Throwable)e);
                }
                this.logger.trace("rollback indexWriter");
                try {
                    assert (ClusterApplierService.assertNotApplyingClusterState());
                    this.indexWriter.rollback();
                }
                catch (AlreadyClosedException ex) {
                    this.failOnTragicEvent(ex);
                    throw ex;
                }
                this.logger.trace("rollback indexWriter done");
            }
            catch (Exception e) {
                this.logger.warn("failed to rollback writer on close", (Throwable)e);
            }
            finally {
                try {
                    this.store.decRef();
                    this.logger.debug("engine closed [{}]", (Object)reason);
                }
                finally {
                    closedLatch.countDown();
                }
            }
        }
    }

    @Override
    protected final ReferenceManager<ElasticsearchDirectoryReader> getReferenceManager(Engine.SearcherScope scope) {
        return switch (scope) {
            default -> throw new MatchException(null, null);
            case Engine.SearcherScope.INTERNAL -> this.internalReaderManager;
            case Engine.SearcherScope.EXTERNAL -> this.externalReaderManager;
        };
    }

    private IndexWriter createWriter() throws IOException {
        try {
            IndexWriterConfig iwc = this.getIndexWriterConfig();
            return this.createWriter(this.store.directory(), iwc);
        }
        catch (LockObtainFailedException ex) {
            this.logger.warn("could not lock IndexWriter", (Throwable)ex);
            throw ex;
        }
    }

    protected IndexWriter createWriter(Directory directory, IndexWriterConfig iwc) throws IOException {
        if (Assertions.ENABLED) {
            return new AssertingIndexWriter(directory, iwc);
        }
        return new IndexWriter(directory, iwc);
    }

    private IndexWriterConfig getIndexWriterConfig() {
        IndexWriterConfig iwc = new IndexWriterConfig(this.engineConfig.getAnalyzer());
        iwc.setCommitOnClose(false);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.APPEND);
        iwc.setIndexDeletionPolicy((IndexDeletionPolicy)this.combinedDeletionPolicy);
        iwc.setInfoStream((InfoStream)(TESTS_VERBOSE ? InfoStream.getDefault() : new LoggerInfoStream(this.logger)));
        iwc.setMergeScheduler(this.mergeScheduler.getMergeScheduler());
        Object mergePolicy = this.config().getMergePolicy();
        iwc.setSoftDeletesField("__soft_deletes");
        mergePolicy = new RecoverySourcePruneMergePolicy(this.engineConfig.getIndexSettings().isRecoverySourceSyntheticEnabled() ? null : "_recovery_source", this.engineConfig.getIndexSettings().isRecoverySourceSyntheticEnabled() ? "_recovery_source_size" : "_recovery_source", this.engineConfig.getIndexSettings().getMode() == IndexMode.TIME_SERIES, () -> this.softDeletesPolicy.getRetentionQuery(this.engineConfig.getIndexSettings().seqNoIndexOptions()), (MergePolicy)new SoftDeletesRetentionMergePolicy("__soft_deletes", () -> this.softDeletesPolicy.getRetentionQuery(this.engineConfig.getIndexSettings().seqNoIndexOptions()), (MergePolicy)new PrunePostingsMergePolicy((MergePolicy)mergePolicy, "_id")));
        if (SHUFFLE_FORCE_MERGE) {
            mergePolicy = new ShuffleForcedMergePolicy((MergePolicy)mergePolicy);
        }
        iwc.setMergePolicy(mergePolicy);
        iwc.setMaxFullFlushMergeWaitMillis(-1L);
        iwc.setSimilarity(this.engineConfig.getSimilarity());
        iwc.setRAMBufferSizeMB(this.engineConfig.getIndexingBufferSize().getMbFrac());
        iwc.setCodec(this.engineConfig.getCodec());
        boolean useCompoundFile = this.engineConfig.getUseCompoundFile();
        iwc.setUseCompoundFile(useCompoundFile);
        if (!useCompoundFile) {
            this.logger.warn("[{}] is set to false, this should only be used in tests and can cause serious problems in production environments", (Object)"index.use_compound_file");
        }
        if (this.config().getIndexSort() != null) {
            iwc.setIndexSort(this.config().getIndexSort());
            if (this.config().getIndexSettings().getIndexVersionCreated().onOrAfter(IndexVersions.INDEX_SORTING_ON_NESTED)) {
                iwc.setParentField("__root_doc_for_nested");
            }
        }
        if (this.engineConfig.getLeafSorter() != null) {
            iwc.setLeafSorter(this.engineConfig.getLeafSorter());
        }
        return iwc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateThrottling() {
        AtomicInteger atomicInteger = this.throttleRequestCount;
        synchronized (atomicInteger) {
            int count = this.throttleRequestCount.incrementAndGet();
            assert (count >= 1) : "invalid post-increment throttleRequestCount=" + count;
            if (count == 1) {
                this.throttle.activate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivateThrottling() {
        AtomicInteger atomicInteger = this.throttleRequestCount;
        synchronized (atomicInteger) {
            int count = this.throttleRequestCount.decrementAndGet();
            assert (count >= 0) : "invalid post-decrement throttleRequestCount=" + count;
            if (count == 0) {
                this.throttle.deactivate();
            }
        }
    }

    @Override
    public boolean isThrottled() {
        return this.throttle.isThrottled();
    }

    boolean throttleLockIsHeldByCurrentThread() {
        return this.throttle.throttleLockIsHeldByCurrentThread();
    }

    @Override
    public long getIndexThrottleTimeInMillis() {
        return this.throttle.getThrottleTimeInMillis();
    }

    long getGcDeletesInMillis() {
        return this.engineConfig.getIndexSettings().getGcDeletesInMillis();
    }

    LiveIndexWriterConfig getCurrentIndexWriterConfig() {
        return this.indexWriter.getConfig();
    }

    private void maybeFlushAfterMerge(OnGoingMerge merge) {
        if (!this.indexWriter.hasPendingMerges() && System.nanoTime() - this.lastWriteNanos >= this.engineConfig.getFlushMergesAfter().nanos()) {
            this.engineConfig.getThreadPool().executor("flush").execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    if (!InternalEngine.this.isClosed.get()) {
                        InternalEngine.this.logger.warn("failed to flush after merge has finished", (Throwable)e);
                    } else {
                        InternalEngine.this.logger.info("failed to flush after merge has finished during shard close");
                    }
                }

                @Override
                protected void doRun() {
                    InternalEngine.this.flush();
                }
            });
        } else if (merge.getTotalBytesSize() >= this.engineConfig.getIndexSettings().getFlushAfterMergeThresholdSize().getBytes()) {
            this.shouldPeriodicallyFlushAfterBigMerge.set(true);
        }
    }

    protected ElasticsearchMergeScheduler createMergeScheduler(ShardId shardId, IndexSettings indexSettings, @Nullable ThreadPoolMergeExecutorService threadPoolMergeExecutorService, MergeMetrics mergeMetrics) {
        if (threadPoolMergeExecutorService != null) {
            return new EngineThreadPoolMergeScheduler(shardId, indexSettings, threadPoolMergeExecutorService, mergeMetrics);
        }
        return new EngineConcurrentMergeScheduler(shardId, indexSettings);
    }

    protected void mergeException(final Throwable exc) {
        this.engineConfig.getThreadPool().generic().execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                InternalEngine.this.logger.debug("merge failure action rejected", (Throwable)e);
            }

            @Override
            protected void doRun() throws Exception {
                InternalEngine.this.failEngine("merge failed", (Exception)new MergePolicy.MergeException(exc));
            }
        });
    }

    protected void commitIndexWriter(IndexWriter writer, Translog translog) throws IOException {
        assert (this.isFlushLockIsHeldByCurrentThread());
        this.ensureCanFlush();
        try {
            long localCheckpoint = this.localCheckpointTracker.getProcessedCheckpoint();
            writer.setLiveCommitData(() -> {
                Map<String, String> extraCommitUserData = this.getCommitExtraUserData(localCheckpoint);
                Map<String, String> commitData = Maps.newMapWithExpectedSize(8 + extraCommitUserData.size());
                commitData.putAll(extraCommitUserData);
                commitData.put("translog_uuid", translog.getTranslogUUID());
                commitData.put("local_checkpoint", Long.toString(localCheckpoint));
                commitData.put("max_seq_no", Long.toString(this.localCheckpointTracker.getMaxSeqNo()));
                commitData.put("max_unsafe_auto_id_timestamp", Long.toString(this.maxUnsafeAutoIdTimestamp.get()));
                commitData.put("history_uuid", this.historyUUID);
                String currentForceMergeUUID = this.forceMergeUUID;
                if (currentForceMergeUUID != null) {
                    commitData.put("force_merge_uuid", currentForceMergeUUID);
                }
                commitData.put("min_retained_seq_no", Long.toString(this.softDeletesPolicy.getMinRetainedSeqNo()));
                commitData.put("es_version", IndexVersion.current().toString());
                this.logger.trace("committing writer with commit data [{}]", commitData);
                return commitData.entrySet().iterator();
            });
            this.shouldPeriodicallyFlushAfterBigMerge.set(false);
            writer.commit();
        }
        catch (Exception ex) {
            try {
                this.failEngine("lucene commit failed", ex);
            }
            catch (Exception inner) {
                ex.addSuppressed(inner);
            }
            throw ex;
        }
        catch (AssertionError e) {
            if (ExceptionsHelper.stackTrace((Throwable)((Object)e)).contains("org.apache.lucene.index.IndexWriter.filesExist")) {
                EngineException engineException = new EngineException(this.shardId, "failed to commit engine", (Throwable)((Object)e), new Object[0]);
                try {
                    this.failEngine("lucene commit failed", engineException);
                }
                catch (Exception inner) {
                    engineException.addSuppressed(inner);
                }
                throw engineException;
            }
            throw e;
        }
    }

    protected Map<String, String> getCommitExtraUserData(long localCheckpoint) {
        return Collections.emptyMap();
    }

    final void ensureCanFlush() {
        if (this.pendingTranslogRecovery.get()) {
            throw new IllegalStateException(this.shardId.toString() + " flushes are disabled - pending translog recovery");
        }
    }

    @Override
    public void onSettingsChanged() {
        this.mergeScheduler.refreshConfig();
        this.maybePruneDeletes();
        this.softDeletesPolicy.setRetentionOperations(this.config().getIndexSettings().getSoftDeleteRetentionOperations());
    }

    @Override
    public MergeStats getMergeStats() {
        return this.mergeScheduler.stats();
    }

    protected LocalCheckpointTracker getLocalCheckpointTracker() {
        return this.localCheckpointTracker;
    }

    @Override
    public long getLastSyncedGlobalCheckpoint() {
        return this.getTranslog().getLastSyncedGlobalCheckpoint();
    }

    @Override
    public long getMaxSeqNo() {
        return this.localCheckpointTracker.getMaxSeqNo();
    }

    @Override
    public long getProcessedLocalCheckpoint() {
        return this.localCheckpointTracker.getProcessedCheckpoint();
    }

    @Override
    public long getPersistedLocalCheckpoint() {
        return this.localCheckpointTracker.getPersistedCheckpoint();
    }

    protected final void markSeqNoAsSeen(long seqNo) {
        this.localCheckpointTracker.advanceMaxSeqNo(seqNo);
    }

    protected final boolean hasBeenProcessedBefore(Engine.Operation op) {
        if (Assertions.ENABLED) {
            assert (op.seqNo() != -2L) : "operation is not assigned seq_no";
            if (op.operationType() == Engine.Operation.TYPE.NO_OP ? !$assertionsDisabled && !this.noOpKeyedLock.isHeldByCurrentThread(op.seqNo()) : !$assertionsDisabled && !this.versionMap.assertKeyedLockHeldByCurrentThread(op.uid())) {
                throw new AssertionError();
            }
        }
        return this.localCheckpointTracker.hasProcessed(op.seqNo());
    }

    @Override
    public SeqNoStats getSeqNoStats(long globalCheckpoint) {
        return this.localCheckpointTracker.getStats(globalCheckpoint);
    }

    long getNumIndexVersionsLookups() {
        return this.numIndexVersionsLookups.count();
    }

    long getNumVersionLookups() {
        return this.numVersionLookups.count();
    }

    private boolean incrementVersionLookup() {
        this.numVersionLookups.inc();
        return true;
    }

    private boolean incrementIndexVersionLookup() {
        this.numIndexVersionsLookups.inc();
        return true;
    }

    boolean isSafeAccessRequired() {
        return this.versionMap.isSafeAccessRequired();
    }

    long getNumDocDeletes() {
        return this.numDocDeletes.count();
    }

    long getNumDocAppends() {
        return this.numDocAppends.count();
    }

    long getNumDocUpdates() {
        return this.numDocUpdates.count();
    }

    @Override
    public long getTotalFlushTimeExcludingWaitingOnLockInMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.totalFlushTimeExcludingWaitingOnLock.sum());
    }

    @Override
    public int countChanges(String source, long fromSeqNo, long toSeqNo) throws IOException {
        this.ensureOpen();
        this.refreshIfNeeded(source, toSeqNo);
        Engine.Searcher searcher = this.acquireSearcher(source, Engine.SearcherScope.INTERNAL);
        try {
            int n = LuceneChangesSnapshot.countOperations(searcher, this.engineConfig.getIndexSettings(), fromSeqNo, toSeqNo);
            if (searcher != null) {
                searcher.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (searcher != null) {
                    try {
                        searcher.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                try {
                    this.maybeFailEngine("count changes", e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                throw e;
            }
        }
    }

    @Override
    public Translog.Snapshot newChangesSnapshot(String source, long fromSeqNo, long toSeqNo, boolean requiredFullRange, boolean singleConsumer, boolean accessStats, long maxChunkSize) throws IOException {
        if (!this.enableRecoverySource) {
            throw new IllegalStateException("Changes snapshot are unavailable when the " + RecoverySettings.INDICES_RECOVERY_SOURCE_ENABLED_SETTING.getKey() + " setting is disabled.");
        }
        this.ensureOpen();
        this.refreshIfNeeded(source, toSeqNo);
        Engine.Searcher searcher = this.acquireSearcher(source, Engine.SearcherScope.INTERNAL);
        try {
            SearchBasedChangesSnapshot snapshot = this.engineConfig.getIndexSettings().isRecoverySourceSyntheticEnabled() ? new LuceneSyntheticSourceChangesSnapshot(this.engineConfig.getMapperService(), searcher, 1024, maxChunkSize, fromSeqNo, toSeqNo, requiredFullRange, accessStats, this.config().getIndexSettings().getIndexVersionCreated()) : new LuceneChangesSnapshot(this.engineConfig.getMapperService(), searcher, 1024, fromSeqNo, toSeqNo, requiredFullRange, singleConsumer, accessStats, this.config().getIndexSettings().getIndexVersionCreated());
            searcher = null;
            SearchBasedChangesSnapshot searchBasedChangesSnapshot = snapshot;
            return searchBasedChangesSnapshot;
        }
        catch (Exception e) {
            try {
                this.maybeFailEngine("acquire changes snapshot", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw e;
        }
        finally {
            IOUtils.close((Closeable)((Object)searcher));
        }
    }

    @Override
    public boolean hasCompleteOperationHistory(String reason, long startingSeqNo) {
        return this.getMinRetainedSeqNo() <= startingSeqNo;
    }

    @Override
    public final long getMinRetainedSeqNo() {
        return this.softDeletesPolicy.getMinRetainedSeqNo();
    }

    @Override
    public Closeable acquireHistoryRetentionLock() {
        return this.softDeletesPolicy.acquireRetentionLock();
    }

    private static Map<String, String> commitDataAsMap(IndexWriter indexWriter) {
        Map<String, String> commitData = Maps.newMapWithExpectedSize(8);
        for (Map.Entry entry : indexWriter.getLiveCommitData()) {
            commitData.put((String)entry.getKey(), (String)entry.getValue());
        }
        return commitData;
    }

    final long lastRefreshedCheckpoint() {
        return this.lastRefreshedCheckpointListener.refreshedCheckpoint.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void refreshIfNeeded(String source, long requestingSeqNo) {
        if (this.lastRefreshedCheckpoint() < requestingSeqNo) {
            Object object = this.refreshIfNeededMutex;
            synchronized (object) {
                if (this.lastRefreshedCheckpoint() < requestingSeqNo) {
                    this.refreshInternalSearcher(source, true);
                }
            }
        }
    }

    @Override
    public final long getMaxSeenAutoIdTimestamp() {
        return this.maxSeenAutoIdTimestamp.get();
    }

    @Override
    public final void updateMaxUnsafeAutoIdTimestamp(long newTimestamp) {
        this.updateAutoIdTimestamp(newTimestamp, true);
    }

    private void updateAutoIdTimestamp(long newTimestamp, boolean unsafe) {
        assert (newTimestamp >= -1L) : "invalid timestamp [" + newTimestamp + "]";
        this.maxSeenAutoIdTimestamp.accumulateAndGet(newTimestamp, Math::max);
        if (unsafe) {
            this.maxUnsafeAutoIdTimestamp.accumulateAndGet(newTimestamp, Math::max);
        }
        assert (this.maxUnsafeAutoIdTimestamp.get() <= this.maxSeenAutoIdTimestamp.get());
    }

    @Override
    public long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.maxSeqNoOfUpdatesOrDeletes.get();
    }

    @Override
    public void advanceMaxSeqNoOfUpdatesOrDeletes(long maxSeqNoOfUpdatesOnPrimary) {
        if (maxSeqNoOfUpdatesOnPrimary == -2L) {
            assert (false) : "max_seq_no_of_updates on primary is unassigned";
            throw new IllegalArgumentException("max_seq_no_of_updates on primary is unassigned");
        }
        this.maxSeqNoOfUpdatesOrDeletes.accumulateAndGet(maxSeqNoOfUpdatesOnPrimary, Math::max);
    }

    private boolean assertMaxSeqNoOfUpdatesIsAdvanced(BytesRef id, long seqNo, boolean allowDeleted, boolean relaxIfGapInSeqNo) {
        VersionValue versionValue;
        long maxSeqNoOfUpdates = this.getMaxSeqNoOfUpdatesOrDeletes();
        if (allowDeleted && (versionValue = this.versionMap.getVersionForAssert(id)) != null && versionValue.isDelete()) {
            return true;
        }
        if (relaxIfGapInSeqNo && this.localCheckpointTracker.getProcessedCheckpoint() < maxSeqNoOfUpdates) {
            return true;
        }
        assert (seqNo <= maxSeqNoOfUpdates) : "id=" + String.valueOf(id) + " seq_no=" + seqNo + " msu=" + maxSeqNoOfUpdates;
        return true;
    }

    private void restoreVersionMapAndCheckpointTracker(DirectoryReader directoryReader, IndexVersion indexVersionCreated) throws IOException {
        IndexSearcher searcher = new IndexSearcher((IndexReader)directoryReader);
        searcher.setQueryCache(null);
        BooleanQuery query = new BooleanQuery.Builder().add(SeqNoFieldMapper.rangeQueryForSeqNo(this.engineConfig.getIndexSettings().seqNoIndexOptions(), this.getPersistedLocalCheckpoint() + 1L, Long.MAX_VALUE), BooleanClause.Occur.MUST).add(Queries.newNonNestedFilter(indexVersionCreated), BooleanClause.Occur.MUST).build();
        Weight weight = searcher.createWeight(searcher.rewrite((Query)query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        for (LeafReaderContext leaf : directoryReader.leaves()) {
            int docId;
            Scorer scorer = weight.scorer(leaf);
            if (scorer == null) continue;
            CombinedDocValues dv = new CombinedDocValues(leaf.reader());
            IdStoredFieldLoader idFieldLoader = new IdStoredFieldLoader(leaf.reader());
            DocIdSetIterator iterator = scorer.iterator();
            while ((docId = iterator.nextDoc()) != Integer.MAX_VALUE) {
                long primaryTerm = dv.docPrimaryTerm(docId);
                long seqNo = dv.docSeqNo(docId);
                this.localCheckpointTracker.markSeqNoAsProcessed(seqNo);
                this.localCheckpointTracker.markSeqNoAsPersisted(seqNo);
                String id = idFieldLoader.id(docId);
                if (id == null) {
                    assert (dv.isTombstone(docId));
                    continue;
                }
                BytesRef uid = Uid.encodeId(id);
                Releasable ignored = this.versionMap.acquireLock(uid);
                try {
                    VersionValue curr = this.versionMap.getUnderLock(uid);
                    if (curr != null && InternalEngine.compareOpToVersionMapOnSeqNo(id, seqNo, primaryTerm, curr) != OpVsLuceneDocStatus.OP_NEWER) continue;
                    if (dv.isTombstone(docId)) {
                        long startTime = 0L;
                        this.versionMap.putDeleteUnderLock(uid, new DeleteVersionValue(dv.docVersion(docId), seqNo, primaryTerm, 0L));
                        continue;
                    }
                    this.versionMap.putIndexUnderLock(uid, new IndexVersionValue(null, dv.docVersion(docId), seqNo, primaryTerm));
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
        }
        this.refresh("restore_version_map_and_checkpoint_tracker", Engine.SearcherScope.INTERNAL, true);
    }

    @Override
    public ShardLongFieldRange getRawFieldRange(String field) {
        return ShardLongFieldRange.UNKNOWN;
    }

    @Override
    public void addFlushListener(Translog.Location location, final ActionListener<Long> listener) {
        this.flushListener.addOrNotify(location, new ActionListener<Long>(){

            @Override
            public void onResponse(Long generation) {
                InternalEngine.this.checkGenerationFlushed(generation, listener.map(v -> generation));
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private void checkGenerationFlushed(long generation, ActionListener<Void> listener) {
        try {
            this.ensureOpen();
        }
        catch (AlreadyClosedException e) {
            listener.onFailure((Exception)((Object)e));
            return;
        }
        if (this.lastCommittedSegmentInfos.getGeneration() < generation) {
            listener.onFailure(new IllegalStateException("Cannot wait on generation which has not been committed"));
        } else {
            listener.onResponse(null);
        }
    }

    protected void waitForCommitDurability(long generation, ActionListener<Void> listener) {
        this.checkGenerationFlushed(generation, listener);
    }

    @Override
    public long getLastUnsafeSegmentGenerationForGets() {
        return this.lastUnsafeSegmentGenerationForGets.get();
    }

    protected LiveVersionMapArchive createLiveVersionMapArchive() {
        return LiveVersionMapArchive.NOOP_ARCHIVE;
    }

    protected LiveVersionMapArchive getLiveVersionMapArchive() {
        return this.liveVersionMapArchive;
    }

    public LiveVersionMap getLiveVersionMap() {
        return this.versionMap;
    }

    protected long getPreCommitSegmentGeneration() {
        return this.preCommitSegmentGeneration.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T performActionWithDirectoryReader(Engine.SearcherScope scope, CheckedFunction<DirectoryReader, T, IOException> action) throws EngineException {
        assert (scope == Engine.SearcherScope.INTERNAL) : "performActionWithDirectoryReader(...) isn't prepared for external usage";
        if (!this.store.tryIncRef()) {
            throw new AlreadyClosedException(String.valueOf(this.shardId) + " store is closed", (Throwable)this.failedEngine.get());
        }
        try {
            Object object;
            ReferenceManager<ElasticsearchDirectoryReader> referenceManager = this.getReferenceManager(scope);
            ElasticsearchDirectoryReader acquire = (ElasticsearchDirectoryReader)((Object)referenceManager.acquire());
            try {
                object = action.apply((Object)acquire);
            }
            catch (Throwable throwable) {
                try {
                    referenceManager.release((Object)acquire);
                    throw throwable;
                }
                catch (AlreadyClosedException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    this.maybeFailEngine("perform_action_directory_reader", ex);
                    this.ensureOpen(ex);
                    this.logger.error("failed to perform action with directory reader", (Throwable)ex);
                    throw new EngineException(this.shardId, "failed to perform action with directory reader", ex, new Object[0]);
                }
            }
            referenceManager.release((Object)acquire);
            return (T)object;
        }
        finally {
            this.store.decRef();
        }
    }

    protected long estimateMergeBytes(MergePolicy.OneMerge merge) {
        Engine.Searcher searcher = this.acquireSearcher("merge_memory_estimation", Engine.SearcherScope.INTERNAL);
        try {
            long l = MergeMemoryEstimator.estimateMergeMemory(merge, searcher.getIndexReader());
            if (searcher != null) {
                searcher.close();
            }
            return l;
        }
        catch (Throwable throwable) {
            try {
                if (searcher != null) {
                    try {
                        searcher.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (AlreadyClosedException e) {
                return 0L;
            }
        }
    }

    protected void deleteByQuery(ShardSplittingQuery query) throws Exception {
        this.indexWriter.deleteDocuments(new Query[]{query});
    }

    private static /* synthetic */ void lambda$index$8() {
    }

    static final class RefreshWarmerListener
    implements BiConsumer<ElasticsearchDirectoryReader, ElasticsearchDirectoryReader> {
        private final Engine.Warmer warmer;
        private final Logger logger;
        private final AtomicBoolean isEngineClosed;

        RefreshWarmerListener(Logger logger, AtomicBoolean isEngineClosed, EngineConfig engineConfig) {
            this.warmer = engineConfig.getWarmer();
            this.logger = logger;
            this.isEngineClosed = isEngineClosed;
        }

        @Override
        public void accept(ElasticsearchDirectoryReader reader, ElasticsearchDirectoryReader previousReader) {
            block3: {
                if (this.warmer != null) {
                    try {
                        this.warmer.warm(reader);
                    }
                    catch (Exception e) {
                        if (this.isEngineClosed.get()) break block3;
                        this.logger.warn("failed to prepare/warm", (Throwable)e);
                    }
                }
            }
        }
    }

    @SuppressForbidden(reason="reference counting is required here")
    private static final class ExternalReaderManager
    extends ReferenceManager<ElasticsearchDirectoryReader> {
        private final BiConsumer<ElasticsearchDirectoryReader, ElasticsearchDirectoryReader> refreshListener;
        private final ElasticsearchReaderManager internalReaderManager;
        private boolean isWarmedUp;

        ExternalReaderManager(ElasticsearchReaderManager internalReaderManager, BiConsumer<ElasticsearchDirectoryReader, ElasticsearchDirectoryReader> refreshListener) throws IOException {
            this.refreshListener = refreshListener;
            this.internalReaderManager = internalReaderManager;
            this.current = internalReaderManager.acquire();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ElasticsearchDirectoryReader refreshIfNeeded(ElasticsearchDirectoryReader referenceToRefresh) throws IOException {
            this.internalReaderManager.maybeRefreshBlocking();
            ElasticsearchDirectoryReader newReader = (ElasticsearchDirectoryReader)((Object)this.internalReaderManager.acquire());
            if (!this.isWarmedUp || newReader != referenceToRefresh) {
                boolean success = false;
                try {
                    this.refreshListener.accept(newReader, this.isWarmedUp ? referenceToRefresh : null);
                    this.isWarmedUp = true;
                    success = true;
                }
                finally {
                    if (!success) {
                        this.internalReaderManager.release((Object)newReader);
                    }
                }
            }
            if (referenceToRefresh == newReader) {
                this.internalReaderManager.release((Object)newReader);
                return null;
            }
            return newReader;
        }

        protected boolean tryIncRef(ElasticsearchDirectoryReader reference) {
            return reference.tryIncRef();
        }

        protected int getRefCount(ElasticsearchDirectoryReader reference) {
            return reference.getRefCount();
        }

        protected void decRef(ElasticsearchDirectoryReader reference) throws IOException {
            reference.decRef();
        }
    }

    private final class LastRefreshedCheckpointListener
    implements ReferenceManager.RefreshListener {
        final AtomicLong refreshedCheckpoint;
        private long pendingCheckpoint;

        LastRefreshedCheckpointListener(long initialLocalCheckpoint) {
            this.refreshedCheckpoint = new AtomicLong(initialLocalCheckpoint);
        }

        public void beforeRefresh() {
            this.pendingCheckpoint = InternalEngine.this.localCheckpointTracker.getProcessedCheckpoint();
        }

        public void afterRefresh(boolean didRefresh) {
            if (didRefresh) {
                this.updateRefreshedCheckpoint(this.pendingCheckpoint);
            }
        }

        void updateRefreshedCheckpoint(long checkpoint) {
            this.refreshedCheckpoint.accumulateAndGet(checkpoint, Math::max);
            assert (this.refreshedCheckpoint.get() >= checkpoint) : this.refreshedCheckpoint.get() + " < " + checkpoint;
        }
    }

    static enum OpVsLuceneDocStatus {
        OP_NEWER,
        OP_STALE_OR_EQUAL,
        LUCENE_DOC_NOT_FOUND;

    }

    protected static final class IndexingStrategy {
        final boolean currentNotFoundOrDeleted;
        final boolean useLuceneUpdateDocument;
        final long versionForIndexing;
        final boolean indexIntoLucene;
        final boolean addStaleOpToLucene;
        final int reservedDocs;
        final Optional<Engine.IndexResult> earlyResultOnPreFlightError;

        private IndexingStrategy(boolean currentNotFoundOrDeleted, boolean useLuceneUpdateDocument, boolean indexIntoLucene, boolean addStaleOpToLucene, long versionForIndexing, int reservedDocs, Engine.IndexResult earlyResultOnPreFlightError) {
            assert (!useLuceneUpdateDocument || indexIntoLucene) : "use lucene update is set to true, but we're not indexing into lucene";
            assert (!(indexIntoLucene && earlyResultOnPreFlightError != null)) : "can only index into lucene or have a preflight result but not both.indexIntoLucene: " + indexIntoLucene + "  earlyResultOnPreFlightError:" + String.valueOf(earlyResultOnPreFlightError);
            assert (reservedDocs == 0 || indexIntoLucene || addStaleOpToLucene) : reservedDocs;
            this.currentNotFoundOrDeleted = currentNotFoundOrDeleted;
            this.useLuceneUpdateDocument = useLuceneUpdateDocument;
            this.versionForIndexing = versionForIndexing;
            this.indexIntoLucene = indexIntoLucene;
            this.addStaleOpToLucene = addStaleOpToLucene;
            this.reservedDocs = reservedDocs;
            this.earlyResultOnPreFlightError = earlyResultOnPreFlightError == null ? Optional.empty() : Optional.of(earlyResultOnPreFlightError);
        }

        static IndexingStrategy optimizedAppendOnly(long versionForIndexing, int reservedDocs) {
            return new IndexingStrategy(true, false, true, false, versionForIndexing, reservedDocs, null);
        }

        public static IndexingStrategy skipDueToVersionConflict(VersionConflictEngineException e, boolean currentNotFoundOrDeleted, long currentVersion, String id) {
            Engine.IndexResult result = new Engine.IndexResult(e, currentVersion, id);
            return new IndexingStrategy(currentNotFoundOrDeleted, false, false, false, -1L, 0, result);
        }

        static IndexingStrategy processNormally(boolean currentNotFoundOrDeleted, long versionForIndexing, int reservedDocs) {
            return new IndexingStrategy(currentNotFoundOrDeleted, !currentNotFoundOrDeleted, true, false, versionForIndexing, reservedDocs, null);
        }

        public static IndexingStrategy processButSkipLucene(boolean currentNotFoundOrDeleted, long versionForIndexing) {
            return new IndexingStrategy(currentNotFoundOrDeleted, false, false, false, versionForIndexing, 0, null);
        }

        static IndexingStrategy processAsStaleOp(long versionForIndexing, int reservedDocs) {
            return new IndexingStrategy(false, false, false, true, versionForIndexing, reservedDocs, null);
        }

        static IndexingStrategy failAsTooManyDocs(Exception e, String id) {
            Engine.IndexResult result = new Engine.IndexResult(e, -1L, id);
            return new IndexingStrategy(false, false, false, false, -1L, 0, result);
        }
    }

    protected static final class DeletionStrategy {
        final boolean deleteFromLucene;
        final boolean addStaleOpToLucene;
        final boolean currentlyDeleted;
        final long versionOfDeletion;
        final Optional<Engine.DeleteResult> earlyResultOnPreflightError;
        final int reservedDocs;

        private DeletionStrategy(boolean deleteFromLucene, boolean addStaleOpToLucene, boolean currentlyDeleted, long versionOfDeletion, int reservedDocs, Engine.DeleteResult earlyResultOnPreflightError) {
            assert (!(deleteFromLucene && earlyResultOnPreflightError != null)) : "can only delete from lucene or have a preflight result but not both.deleteFromLucene: " + deleteFromLucene + "  earlyResultOnPreFlightError:" + String.valueOf(earlyResultOnPreflightError);
            this.deleteFromLucene = deleteFromLucene;
            this.addStaleOpToLucene = addStaleOpToLucene;
            this.currentlyDeleted = currentlyDeleted;
            this.versionOfDeletion = versionOfDeletion;
            this.reservedDocs = reservedDocs;
            assert (reservedDocs == 0 || deleteFromLucene || addStaleOpToLucene) : reservedDocs;
            this.earlyResultOnPreflightError = earlyResultOnPreflightError == null ? Optional.empty() : Optional.of(earlyResultOnPreflightError);
        }

        public static DeletionStrategy skipDueToVersionConflict(VersionConflictEngineException e, long currentVersion, boolean currentlyDeleted, String id) {
            Engine.DeleteResult deleteResult = new Engine.DeleteResult(e, currentVersion, 0L, -2L, !currentlyDeleted, id);
            return new DeletionStrategy(false, false, currentlyDeleted, -1L, 0, deleteResult);
        }

        static DeletionStrategy processNormally(boolean currentlyDeleted, long versionOfDeletion, int reservedDocs) {
            return new DeletionStrategy(true, false, currentlyDeleted, versionOfDeletion, reservedDocs, null);
        }

        public static DeletionStrategy processButSkipLucene(boolean currentlyDeleted, long versionOfDeletion) {
            return new DeletionStrategy(false, false, currentlyDeleted, versionOfDeletion, 0, null);
        }

        static DeletionStrategy processAsStaleOp(long versionOfDeletion) {
            return new DeletionStrategy(false, true, false, versionOfDeletion, 0, null);
        }

        static DeletionStrategy failAsTooManyDocs(Exception e, String id) {
            Engine.DeleteResult deleteResult = new Engine.DeleteResult(e, -1L, 0L, -2L, false, id);
            return new DeletionStrategy(false, false, false, -1L, 0, deleteResult);
        }
    }

    private static class AssertingIndexWriter
    extends IndexWriter {
        AssertingIndexWriter(Directory d, IndexWriterConfig conf) throws IOException {
            super(d, conf);
        }

        public long deleteDocuments(Term ... terms) {
            throw new AssertionError((Object)"must not hard delete documents");
        }

        public long tryDeleteDocument(IndexReader readerIn, int docID) {
            throw new AssertionError((Object)"tryDeleteDocument is not supported. See Lucene#DirectoryReaderWithAllLiveDocs");
        }
    }

    private final class EngineThreadPoolMergeScheduler
    extends ThreadPoolMergeScheduler {
        EngineThreadPoolMergeScheduler(ShardId shardId, IndexSettings indexSettings, ThreadPoolMergeExecutorService threadPoolMergeExecutorService, MergeMetrics mergeMetrics) {
            super(shardId, indexSettings, threadPoolMergeExecutorService, InternalEngine.this::estimateMergeBytes, mergeMetrics);
        }

        @Override
        protected synchronized void enableIndexingThrottling(int numRunningMerges, int numQueuedMerges, int configuredMaxMergeCount) {
            this.logger.info("now throttling indexing: numRunningMerges={}, numQueuedMerges={}, maxNumMergesConfigured={}", (Object)numRunningMerges, (Object)numQueuedMerges, (Object)configuredMaxMergeCount);
            InternalEngine.this.activateThrottling();
        }

        @Override
        protected synchronized void disableIndexingThrottling(int numRunningMerges, int numQueuedMerges, int configuredMaxMergeCount) {
            this.logger.info("stop throttling indexing: numRunningMerges={}, numQueuedMerges={}, maxNumMergesConfigured={}", (Object)numRunningMerges, (Object)numQueuedMerges, (Object)configuredMaxMergeCount);
            InternalEngine.this.deactivateThrottling();
        }

        @Override
        public synchronized void afterMerge(OnGoingMerge merge) {
            InternalEngine.this.maybeFlushAfterMerge(merge);
        }

        @Override
        protected void handleMergeException(Throwable exc) {
            InternalEngine.this.mergeException(exc);
        }
    }

    private final class EngineConcurrentMergeScheduler
    extends ElasticsearchConcurrentMergeScheduler {
        private final AtomicInteger numMergesInFlight;
        private final AtomicBoolean isThrottling;

        EngineConcurrentMergeScheduler(ShardId shardId, IndexSettings indexSettings) {
            super(shardId, indexSettings);
            this.numMergesInFlight = new AtomicInteger(0);
            this.isThrottling = new AtomicBoolean();
        }

        @Override
        public synchronized void beforeMerge(OnGoingMerge merge) {
            int maxNumMerges = this.getMaxMergeCount();
            if (this.numMergesInFlight.incrementAndGet() > maxNumMerges && !this.isThrottling.getAndSet(true)) {
                this.logger.info("now throttling indexing: numMergesInFlight={}, maxNumMerges={}", (Object)this.numMergesInFlight, (Object)maxNumMerges);
                InternalEngine.this.activateThrottling();
            }
        }

        @Override
        public synchronized void afterMerge(OnGoingMerge merge) {
            int maxNumMerges = this.getMaxMergeCount();
            if (this.numMergesInFlight.decrementAndGet() <= maxNumMerges && this.isThrottling.getAndSet(false)) {
                this.logger.info("stop throttling indexing: numMergesInFlight={}, maxNumMerges={}", (Object)this.numMergesInFlight, (Object)maxNumMerges);
                InternalEngine.this.deactivateThrottling();
            }
            InternalEngine.this.maybeFlushAfterMerge(merge);
        }

        protected void handleMergeException(Throwable exc) {
            InternalEngine.this.mergeException(exc);
        }
    }
}

