/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.MemorySizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.codec.CodecProvider;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.MergeMetrics;
import org.elasticsearch.index.engine.ThreadPoolMergeExecutorService;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.shard.EngineResetLock;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.indices.IndexingMemoryController;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.threadpool.ThreadPool;

public final class EngineConfig {
    private final ShardId shardId;
    private final IndexSettings indexSettings;
    private final ByteSizeValue indexingBufferSize;
    private volatile boolean enableGcDeletes = true;
    private final TimeValue flushMergesAfter;
    private final String codecName;
    private final MapperService mapperService;
    private final IndexStorePlugin.SnapshotCommitSupplier snapshotCommitSupplier;
    private final ThreadPool threadPool;
    @Nullable
    private final ThreadPoolMergeExecutorService threadPoolMergeExecutorService;
    private final Engine.Warmer warmer;
    private final Store store;
    private final MergePolicy mergePolicy;
    private final Analyzer analyzer;
    private final Similarity similarity;
    private final CodecProvider codecProvider;
    private final Engine.EventListener eventListener;
    private final QueryCache queryCache;
    private final QueryCachingPolicy queryCachingPolicy;
    @Nullable
    private final List<ReferenceManager.RefreshListener> externalRefreshListener;
    @Nullable
    private final List<ReferenceManager.RefreshListener> internalRefreshListener;
    @Nullable
    private final Sort indexSort;
    @Nullable
    private final CircuitBreakerService circuitBreakerService;
    private final LongSupplier globalCheckpointSupplier;
    private final Supplier<RetentionLeases> retentionLeasesSupplier;
    private final Comparator<LeafReader> leafSorter;
    private final boolean useCompoundFile;
    private final LongSupplier primaryTermSupplier;
    public static final Setting<String> INDEX_CODEC_SETTING = new Setting<String>("index.codec", settings -> {
        IndexMode indexMode = IndexSettings.MODE.get((Settings)settings);
        return indexMode.getDefaultCodec();
    }, s -> {
        switch (s) {
            case "default": 
            case "legacy_default": 
            case "best_compression": 
            case "legacy_best_compression": 
            case "lucene_default": {
                return s;
            }
        }
        if (!Codec.availableCodecs().contains(s)) {
            throw new IllegalArgumentException("unknown value for [index.codec] must be one of [default, best_compression] but was: " + s);
        }
        return s;
    }, Setting.Property.IndexScope, Setting.Property.NodeScope, Setting.Property.ServerlessPublic);
    public static final String USE_COMPOUND_FILE = "index.use_compound_file";
    @Deprecated
    public static final Setting<Boolean> INDEX_OPTIMIZE_AUTO_GENERATED_IDS = Setting.boolSetting("index.optimize_auto_generated_id", true, Setting.Property.IndexScope, Setting.Property.Dynamic, Setting.Property.IndexSettingDeprecatedInV7AndRemovedInV8);
    private final TranslogConfig translogConfig;
    private final LongSupplier relativeTimeInNanosSupplier;
    @Nullable
    private final Engine.IndexCommitListener indexCommitListener;
    private final boolean promotableToPrimary;
    private final EngineResetLock engineResetLock;
    private final MergeMetrics mergeMetrics;

    public Supplier<RetentionLeases> retentionLeasesSupplier() {
        return this.retentionLeasesSupplier;
    }

    public EngineConfig(ShardId shardId, ThreadPool threadPool, ThreadPoolMergeExecutorService threadPoolMergeExecutorService, IndexSettings indexSettings, Engine.Warmer warmer, Store store, MergePolicy mergePolicy, Analyzer analyzer, Similarity similarity, CodecProvider codecProvider, Engine.EventListener eventListener, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, TranslogConfig translogConfig, TimeValue flushMergesAfter, List<ReferenceManager.RefreshListener> externalRefreshListener, List<ReferenceManager.RefreshListener> internalRefreshListener, Sort indexSort, CircuitBreakerService circuitBreakerService, LongSupplier globalCheckpointSupplier, Supplier<RetentionLeases> retentionLeasesSupplier, LongSupplier primaryTermSupplier, IndexStorePlugin.SnapshotCommitSupplier snapshotCommitSupplier, Comparator<LeafReader> leafSorter, LongSupplier relativeTimeInNanosSupplier, Engine.IndexCommitListener indexCommitListener, boolean promotableToPrimary, MapperService mapperService, EngineResetLock engineResetLock, MergeMetrics mergeMetrics) {
        this.shardId = shardId;
        this.indexSettings = indexSettings;
        this.threadPool = threadPool;
        this.threadPoolMergeExecutorService = threadPoolMergeExecutorService;
        this.warmer = warmer == null ? a -> {} : warmer;
        this.store = store;
        this.mergePolicy = mergePolicy;
        this.analyzer = analyzer;
        this.similarity = similarity;
        this.codecProvider = codecProvider;
        this.eventListener = eventListener;
        this.codecName = indexSettings.getValue(INDEX_CODEC_SETTING);
        this.mapperService = mapperService;
        String escapeHatchProperty = "es.index.memory.max_index_buffer_size";
        String maxBufferSize = System.getProperty("es.index.memory.max_index_buffer_size");
        this.indexingBufferSize = maxBufferSize != null ? MemorySizeValue.parseBytesSizeValueOrHeapRatio(maxBufferSize, "es.index.memory.max_index_buffer_size") : IndexingMemoryController.INDEX_BUFFER_SIZE_SETTING.get(indexSettings.getNodeSettings());
        this.queryCache = queryCache;
        this.queryCachingPolicy = queryCachingPolicy;
        this.translogConfig = translogConfig;
        this.flushMergesAfter = flushMergesAfter;
        this.externalRefreshListener = externalRefreshListener;
        this.internalRefreshListener = internalRefreshListener;
        this.indexSort = indexSort;
        this.circuitBreakerService = circuitBreakerService;
        this.globalCheckpointSupplier = globalCheckpointSupplier;
        this.retentionLeasesSupplier = Objects.requireNonNull(retentionLeasesSupplier);
        this.primaryTermSupplier = primaryTermSupplier;
        this.snapshotCommitSupplier = snapshotCommitSupplier;
        this.leafSorter = leafSorter;
        this.relativeTimeInNanosSupplier = relativeTimeInNanosSupplier;
        this.indexCommitListener = indexCommitListener;
        this.promotableToPrimary = promotableToPrimary;
        this.useCompoundFile = indexSettings.getSettings().getAsBoolean(USE_COMPOUND_FILE, true);
        this.engineResetLock = engineResetLock;
        this.mergeMetrics = mergeMetrics;
    }

    public void setEnableGcDeletes(boolean enableGcDeletes) {
        this.enableGcDeletes = enableGcDeletes;
    }

    public ByteSizeValue getIndexingBufferSize() {
        return this.indexingBufferSize;
    }

    public boolean isEnableGcDeletes() {
        return this.enableGcDeletes;
    }

    public Codec getCodec() {
        return this.codecProvider.codec(this.codecName);
    }

    public CodecProvider getCodecProvider() {
        return this.codecProvider;
    }

    @Deprecated
    public CodecProvider getCodecService() {
        return this.codecProvider;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    @Nullable
    public ThreadPoolMergeExecutorService getThreadPoolMergeExecutorService() {
        return this.threadPoolMergeExecutorService;
    }

    public Engine.Warmer getWarmer() {
        return this.warmer;
    }

    public Store getStore() {
        return this.store;
    }

    public LongSupplier getGlobalCheckpointSupplier() {
        return this.globalCheckpointSupplier;
    }

    public MergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    public Engine.EventListener getEventListener() {
        return this.eventListener;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    public QueryCachingPolicy getQueryCachingPolicy() {
        return this.queryCachingPolicy;
    }

    public TranslogConfig getTranslogConfig() {
        return this.translogConfig;
    }

    public TimeValue getFlushMergesAfter() {
        return this.flushMergesAfter;
    }

    public List<ReferenceManager.RefreshListener> getExternalRefreshListener() {
        return this.externalRefreshListener;
    }

    public List<ReferenceManager.RefreshListener> getInternalRefreshListener() {
        return this.internalRefreshListener;
    }

    public Sort getIndexSort() {
        return this.indexSort;
    }

    @Nullable
    public CircuitBreakerService getCircuitBreakerService() {
        return this.circuitBreakerService;
    }

    public LongSupplier getPrimaryTermSupplier() {
        return this.primaryTermSupplier;
    }

    public IndexStorePlugin.SnapshotCommitSupplier getSnapshotCommitSupplier() {
        return this.snapshotCommitSupplier;
    }

    @Nullable
    public Comparator<LeafReader> getLeafSorter() {
        return this.leafSorter;
    }

    public LongSupplier getRelativeTimeInNanosSupplier() {
        return this.relativeTimeInNanosSupplier;
    }

    @Nullable
    public Engine.IndexCommitListener getIndexCommitListener() {
        return this.indexCommitListener;
    }

    public boolean isPromotableToPrimary() {
        return this.promotableToPrimary;
    }

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public MapperService getMapperService() {
        return this.mapperService;
    }

    public EngineResetLock getEngineResetLock() {
        return this.engineResetLock;
    }

    public MergeMetrics getMergeMetrics() {
        return this.mergeMetrics;
    }
}

