/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.perfield.PerFieldKnnVectorsFormat;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.UnsafePlainActionFuture;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.lucene.uid.VersionsAndSeqNoResolver;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Assertions;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.codec.FieldInfosWithUsages;
import org.elasticsearch.index.codec.vectors.reflect.OffHeapByteSizeUtils;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.SafeCommitInfo;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.mapper.DocumentParser;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.mapper.vectors.SparseVectorFieldMapper;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.DenseVectorStats;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.EngineResetLock;
import org.elasticsearch.index.shard.ShardFieldStats;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardLongFieldRange;
import org.elasticsearch.index.shard.SparseVectorStats;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.indices.IndexingMemoryController;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.transport.Transports;

public abstract class Engine
implements Closeable {
    public static final String HISTORY_UUID_KEY = "history_uuid";
    public static final String FORCE_MERGE_UUID_KEY = "force_merge_uuid";
    public static final String MIN_RETAINED_SEQNO = "min_retained_seq_no";
    public static final String MAX_UNSAFE_AUTO_ID_TIMESTAMP_COMMIT_ID = "max_unsafe_auto_id_timestamp";
    public static final String ES_VERSION = "es_version";
    public static final String SEARCH_SOURCE = "search";
    public static final String CAN_MATCH_SEARCH_SOURCE = "can_match";
    protected static final String DOC_STATS_SOURCE = "doc_stats";
    protected static final String SEGMENTS_STATS_SOURCE = "segments_stats";
    public static final long UNKNOWN_PRIMARY_TERM = -1L;
    public static final String ROOT_DOC_FIELD_NAME = "__root_doc_for_nested";
    protected final ShardId shardId;
    protected final Logger logger;
    protected final EngineConfig engineConfig;
    protected final Store store;
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final CountDownLatch closedLatch = new CountDownLatch(1);
    protected final EventListener eventListener;
    protected final ReentrantLock failEngineLock = new ReentrantLock();
    protected final SetOnce<Exception> failedEngine = new SetOnce();
    protected final boolean enableRecoverySource;
    protected final boolean pauseIndexingOnThrottle;
    private final AtomicBoolean isClosing = new AtomicBoolean();
    private final SubscribableListener<Void> drainOnCloseListener = new SubscribableListener();
    private final RefCounted ensureOpenRefs = AbstractRefCounted.of(() -> this.drainOnCloseListener.onResponse(null));
    private final Releasable releaseEnsureOpenRef = () -> ((RefCounted)this.ensureOpenRefs).decRef();
    protected volatile long lastWriteNanos = System.nanoTime();

    protected Engine(EngineConfig engineConfig) {
        Objects.requireNonNull(engineConfig.getStore(), "Store must be provided to the engine");
        this.engineConfig = engineConfig;
        this.shardId = engineConfig.getShardId();
        this.store = engineConfig.getStore();
        this.logger = Loggers.getLogger(Engine.class, engineConfig.getShardId(), new String[0]);
        this.eventListener = engineConfig.getEventListener();
        this.enableRecoverySource = RecoverySettings.INDICES_RECOVERY_SOURCE_ENABLED_SETTING.get(engineConfig.getIndexSettings().getSettings());
        this.pauseIndexingOnThrottle = IndexingMemoryController.PAUSE_INDEXING_ON_THROTTLE.get(engineConfig.getIndexSettings().getSettings());
    }

    public static IndexVersion readIndexVersion(String esVersion) {
        if (esVersion.contains(".")) {
            Version v = Version.fromString(esVersion);
            assert (v.onOrBefore(Version.V_8_11_0));
            return IndexVersion.fromId(v.id);
        }
        return IndexVersion.fromId(Integer.parseInt(esVersion));
    }

    public final EngineConfig config() {
        return this.engineConfig;
    }

    public abstract SegmentInfos getLastCommittedSegmentInfos();

    public MergeStats getMergeStats() {
        return new MergeStats();
    }

    public abstract String getHistoryUUID();

    public abstract long getWritingBytes();

    public abstract CompletionStats completionStats(String ... var1);

    public DocsStats docStats() {
        try (Searcher searcher = this.acquireSearcher(DOC_STATS_SOURCE, SearcherScope.INTERNAL);){
            DocsStats docsStats = this.docsStats(searcher.getIndexReader());
            return docsStats;
        }
    }

    protected final DocsStats docsStats(IndexReader indexReader) {
        long numDocs = 0L;
        long numDeletedDocs = 0L;
        long sizeInBytes = 0L;
        for (LeafReaderContext readerContext : indexReader.leaves()) {
            SegmentReader segmentReader = Lucene.segmentReader(readerContext.reader());
            SegmentCommitInfo info = segmentReader.getSegmentInfo();
            numDocs += (long)readerContext.reader().numDocs();
            numDeletedDocs += (long)readerContext.reader().numDeletedDocs();
            try {
                sizeInBytes += info.sizeInBytes();
            }
            catch (IOException e) {
                this.logger.trace(() -> "failed to get size for [" + info.info.name + "]", (Throwable)e);
            }
        }
        return new DocsStats(numDocs, numDeletedDocs, sizeInBytes);
    }

    public ShardFieldStats shardFieldStats() {
        try (Searcher searcher = this.acquireSearcher("shard_field_stats", SearcherScope.INTERNAL);){
            ShardFieldStats shardFieldStats = Engine.shardFieldStats(searcher.getLeafContexts());
            return shardFieldStats;
        }
    }

    public FieldInfos shardFieldInfos() {
        try (Searcher searcher = this.acquireSearcher("field_has_value");){
            FieldInfos fieldInfos = FieldInfos.getMergedFieldInfos((IndexReader)searcher.getIndexReader());
            return fieldInfos;
        }
    }

    protected static ShardFieldStats shardFieldStats(List<LeafReaderContext> leaves) {
        int numSegments = 0;
        int totalFields = 0;
        long usages = 0L;
        for (LeafReaderContext leaf : leaves) {
            ++numSegments;
            FieldInfos fieldInfos = leaf.reader().getFieldInfos();
            totalFields += fieldInfos.size();
            if (fieldInfos instanceof FieldInfosWithUsages) {
                FieldInfosWithUsages ft = (FieldInfosWithUsages)fieldInfos;
                if (usages == -1L) continue;
                usages += (long)ft.getTotalUsages();
                continue;
            }
            usages = -1L;
        }
        return new ShardFieldStats(numSegments, totalFields, usages);
    }

    public DenseVectorStats denseVectorStats(MappingLookup mappingLookup) {
        if (mappingLookup == null) {
            return new DenseVectorStats();
        }
        ArrayList<DenseVectorFieldMapper> fields = new ArrayList<DenseVectorFieldMapper>();
        for (Mapper mapper : mappingLookup.fieldMappers()) {
            if (!(mapper instanceof DenseVectorFieldMapper)) continue;
            DenseVectorFieldMapper denseVectorFieldMapper = (DenseVectorFieldMapper)mapper;
            fields.add(denseVectorFieldMapper);
        }
        if (fields.isEmpty()) {
            return new DenseVectorStats(0L);
        }
        try (Searcher searcher = this.acquireSearcher(DOC_STATS_SOURCE, SearcherScope.INTERNAL);){
            DenseVectorStats denseVectorStats = this.denseVectorStats(searcher.getIndexReader(), fields);
            return denseVectorStats;
        }
    }

    protected final DenseVectorStats denseVectorStats(IndexReader indexReader, List<DenseVectorFieldMapper> fields) {
        DenseVectorStats stats = new DenseVectorStats();
        for (LeafReaderContext readerContext : indexReader.leaves()) {
            try {
                stats.add(this.getDenseVectorStats(readerContext.reader(), fields));
            }
            catch (IOException e) {
                this.logger.trace(() -> "failed to get dense vector stats for [" + String.valueOf(readerContext) + "]", (Throwable)e);
            }
        }
        return stats;
    }

    private DenseVectorStats getDenseVectorStats(LeafReader atomicReader, List<DenseVectorFieldMapper> fieldMappers) throws IOException {
        long count = 0L;
        HashMap<String, Map<String, Long>> offHeapStats = new HashMap<String, Map<String, Long>>();
        for (DenseVectorFieldMapper fieldMapper : fieldMappers) {
            FieldInfo info = atomicReader.getFieldInfos().fieldInfo(fieldMapper.fullPath());
            if (info == null || info.getVectorDimension() <= 0) continue;
            switch (info.getVectorEncoding()) {
                case FLOAT32: {
                    FloatVectorValues values = atomicReader.getFloatVectorValues(info.name);
                    count += values != null ? (long)values.size() : 0L;
                    break;
                }
                case BYTE: {
                    FloatVectorValues values = atomicReader.getByteVectorValues(info.name);
                    count += values != null ? (long)values.size() : 0L;
                }
            }
            SegmentReader reader = Lucene.segmentReader(atomicReader);
            KnnVectorsReader vectorsReader = reader.getVectorReader();
            if (vectorsReader instanceof PerFieldKnnVectorsFormat.FieldsReader) {
                PerFieldKnnVectorsFormat.FieldsReader fieldsReader = (PerFieldKnnVectorsFormat.FieldsReader)vectorsReader;
                vectorsReader = fieldsReader.getFieldReader(info.name);
            }
            Map<String, Long> offHeap = OffHeapByteSizeUtils.getOffHeapByteSize(vectorsReader, info);
            offHeapStats.put(info.name, offHeap);
        }
        return new DenseVectorStats(count, Collections.unmodifiableMap(offHeapStats));
    }

    public SparseVectorStats sparseVectorStats(MappingLookup mappingLookup) {
        if (mappingLookup == null) {
            return new SparseVectorStats(0L);
        }
        ArrayList<BytesRef> fields = new ArrayList<BytesRef>();
        for (Mapper mapper : mappingLookup.fieldMappers()) {
            if (!(mapper instanceof SparseVectorFieldMapper)) continue;
            fields.add(new BytesRef((CharSequence)mapper.fullPath()));
        }
        if (fields.isEmpty()) {
            return new SparseVectorStats(0L);
        }
        Collections.sort(fields);
        try (Searcher searcher = this.acquireSearcher(DOC_STATS_SOURCE, SearcherScope.INTERNAL);){
            SparseVectorStats sparseVectorStats = this.sparseVectorStats(searcher.getIndexReader(), fields);
            return sparseVectorStats;
        }
    }

    protected final SparseVectorStats sparseVectorStats(IndexReader indexReader, List<BytesRef> fields) {
        long valueCount = 0L;
        for (LeafReaderContext readerContext : indexReader.leaves()) {
            try {
                valueCount += this.getSparseVectorValueCount(readerContext.reader(), fields);
            }
            catch (IOException e) {
                this.logger.trace(() -> "failed to get sparse vector stats for [" + String.valueOf(readerContext) + "]", (Throwable)e);
            }
        }
        return new SparseVectorStats(valueCount);
    }

    private long getSparseVectorValueCount(LeafReader atomicReader, List<BytesRef> fields) throws IOException {
        long count = 0L;
        for (BytesRef fieldNameBR : fields) {
            Terms terms;
            String fieldName = fieldNameBR.utf8ToString();
            FieldInfo fi = atomicReader.getFieldInfos().fieldInfo(fieldName);
            if (fi == null || (terms = atomicReader.terms(fieldName)) == null) continue;
            count += (long)terms.getDocCount();
        }
        return count;
    }

    public void verifyEngineBeforeIndexClosing() throws IllegalStateException {
        long maxSeqNo;
        long globalCheckpoint = this.engineConfig.getGlobalCheckpointSupplier().getAsLong();
        if (globalCheckpoint != (maxSeqNo = this.getSeqNoStats(globalCheckpoint).getMaxSeqNo())) {
            throw new IllegalStateException("Global checkpoint [" + globalCheckpoint + "] mismatches maximum sequence number [" + maxSeqNo + "] on index shard " + String.valueOf(this.shardId));
        }
    }

    public abstract long getIndexThrottleTimeInMillis();

    public abstract boolean isThrottled();

    public abstract void trimOperationsFromTranslog(long var1, long var3) throws EngineException;

    public long getTotalFlushTimeExcludingWaitingOnLockInMillis() {
        return 0L;
    }

    public abstract IndexResult index(Index var1) throws IOException;

    public abstract DeleteResult delete(Delete var1) throws IOException;

    public abstract NoOpResult noOp(NoOp var1) throws IOException;

    protected final GetResult getFromSearcher(Get get, Searcher searcher, boolean uncachedLookup) throws EngineException {
        VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion;
        try {
            docIdAndVersion = uncachedLookup ? VersionsAndSeqNoResolver.loadDocIdAndVersionUncached(searcher.getIndexReader(), get.uid(), true) : VersionsAndSeqNoResolver.timeSeriesLoadDocIdAndVersion(searcher.getIndexReader(), get.uid(), true);
        }
        catch (Exception e) {
            Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{searcher});
            throw new EngineException(this.shardId, "Couldn't resolve version", e, new Object[0]);
        }
        if (docIdAndVersion != null) {
            if (get.versionType().isVersionConflictForReads(docIdAndVersion.version, get.version())) {
                Releasables.close((Releasable)searcher);
                throw new VersionConflictEngineException(this.shardId, "[" + get.id() + "]", get.versionType().explainConflictForReads(docIdAndVersion.version, get.version()));
            }
            if (get.getIfSeqNo() != -2L && (get.getIfSeqNo() != docIdAndVersion.seqNo || get.getIfPrimaryTerm() != docIdAndVersion.primaryTerm)) {
                Releasables.close((Releasable)searcher);
                throw new VersionConflictEngineException(this.shardId, get.id(), get.getIfSeqNo(), get.getIfPrimaryTerm(), docIdAndVersion.seqNo, docIdAndVersion.primaryTerm);
            }
        }
        if (docIdAndVersion != null) {
            return new GetResult(searcher, docIdAndVersion);
        }
        Releasables.close((Releasable)searcher);
        return GetResult.NOT_EXISTS;
    }

    public abstract GetResult get(Get var1, MappingLookup var2, DocumentParser var3, Function<Searcher, Searcher> var4);

    public GetResult getFromTranslog(Get get, MappingLookup mappingLookup, DocumentParser documentParser, Function<Searcher, Searcher> searcherWrapper) {
        throw new UnsupportedOperationException();
    }

    public final SearcherSupplier acquireSearcherSupplier(Function<Searcher, Searcher> wrapper) throws EngineException {
        return this.acquireSearcherSupplier(wrapper, SearcherScope.EXTERNAL);
    }

    public SearcherSupplier acquireSearcherSupplier(Function<Searcher, Searcher> wrapper, final SearcherScope scope) throws EngineException {
        if (!this.store.tryIncRef()) {
            throw new AlreadyClosedException(String.valueOf(this.shardId) + " store is closed", (Throwable)this.failedEngine.get());
        }
        Releasable releasable = this.store::decRef;
        try {
            final ReferenceManager<ElasticsearchDirectoryReader> referenceManager = this.getReferenceManager(scope);
            final ElasticsearchDirectoryReader acquire = (ElasticsearchDirectoryReader)((Object)referenceManager.acquire());
            SearcherSupplier reader = new SearcherSupplier(wrapper){

                @Override
                public Searcher acquireSearcherInternal(String source) {
                    assert (Engine.this.assertSearcherIsWarmedUp(source, scope));
                    return new Searcher(source, (IndexReader)acquire, Engine.this.engineConfig.getSimilarity(), Engine.this.engineConfig.getQueryCache(), Engine.this.engineConfig.getQueryCachingPolicy(), () -> {});
                }

                @Override
                protected void doClose() {
                    try {
                        referenceManager.release((Object)acquire);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("failed to close", e);
                    }
                    catch (AlreadyClosedException e) {
                        throw new AssertionError((Object)e);
                    }
                    finally {
                        Engine.this.store.decRef();
                    }
                }
            };
            releasable = null;
            SearcherSupplier searcherSupplier = reader;
            return searcherSupplier;
        }
        catch (AlreadyClosedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.maybeFailEngine("acquire_reader", ex);
            this.ensureOpen(ex);
            this.logger.error("failed to acquire reader", (Throwable)ex);
            throw new EngineException(this.shardId, "failed to acquire reader", ex, new Object[0]);
        }
        finally {
            Releasables.close((Releasable)releasable);
        }
    }

    public final Searcher acquireSearcher(String source) throws EngineException {
        return this.acquireSearcher(source, SearcherScope.EXTERNAL);
    }

    public Searcher acquireSearcher(String source, SearcherScope scope) throws EngineException {
        return this.acquireSearcher(source, scope, Function.identity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Searcher acquireSearcher(String source, SearcherScope scope, Function<Searcher, Searcher> wrapper) throws EngineException {
        Searcher searcher;
        SearcherSupplier releasable = null;
        try {
            SearcherSupplier reader = releasable = this.acquireSearcherSupplier(wrapper, scope);
            Searcher searcher2 = reader.acquireSearcher(source);
            releasable = null;
            searcher = new Searcher(source, (IndexReader)searcher2.getDirectoryReader(), searcher2.getSimilarity(), searcher2.getQueryCache(), searcher2.getQueryCachingPolicy(), () -> Releasables.close((Releasable[])new Releasable[]{searcher2, reader}));
        }
        catch (Throwable throwable) {
            Releasables.close(releasable);
            throw throwable;
        }
        Releasables.close((Releasable)releasable);
        return searcher;
    }

    protected abstract ReferenceManager<ElasticsearchDirectoryReader> getReferenceManager(SearcherScope var1);

    boolean assertSearcherIsWarmedUp(String source, SearcherScope scope) {
        return true;
    }

    public abstract boolean isTranslogSyncNeeded();

    public boolean allowSearchIdleOptimization() {
        return true;
    }

    public abstract void asyncEnsureTranslogSynced(Translog.Location var1, Consumer<Exception> var2);

    public abstract void asyncEnsureGlobalCheckpointSynced(long var1, Consumer<Exception> var3);

    public abstract void syncTranslog() throws IOException;

    public abstract Closeable acquireHistoryRetentionLock();

    public abstract int countChanges(String var1, long var2, long var4) throws IOException;

    public abstract Translog.Snapshot newChangesSnapshot(String var1, long var2, long var4, boolean var6, boolean var7, boolean var8, long var9) throws IOException;

    public abstract boolean hasCompleteOperationHistory(String var1, long var2);

    public abstract long getMinRetainedSeqNo();

    public abstract TranslogStats getTranslogStats();

    public abstract Translog.Location getTranslogLastWriteLocation();

    protected final void ensureOpen(Exception suppressed) {
        if (this.isClosed.get()) {
            AlreadyClosedException ace = new AlreadyClosedException(String.valueOf(this.shardId) + " engine is closed", (Throwable)this.failedEngine.get());
            if (suppressed != null) {
                ace.addSuppressed((Throwable)suppressed);
            }
            throw ace;
        }
    }

    protected final void ensureOpen() {
        this.ensureOpen(null);
    }

    public final CommitStats commitStats() {
        return new CommitStats(this.getLastCommittedSegmentInfos());
    }

    public abstract long getMaxSeqNo();

    public abstract long getProcessedLocalCheckpoint();

    public abstract long getPersistedLocalCheckpoint();

    public abstract SeqNoStats getSeqNoStats(long var1);

    public abstract long getLastSyncedGlobalCheckpoint();

    public SegmentsStats segmentsStats(boolean includeSegmentFileSizes, boolean includeUnloadedSegments) {
        SegmentReader segmentReader;
        this.ensureOpen();
        HashSet<String> segmentName = new HashSet<String>();
        SegmentsStats stats = new SegmentsStats();
        try (Searcher searcher = this.acquireSearcher(SEGMENTS_STATS_SOURCE, SearcherScope.INTERNAL);){
            for (LeafReaderContext ctx : searcher.getIndexReader().getContext().leaves()) {
                segmentReader = Lucene.segmentReader(ctx.reader());
                this.fillSegmentStats(segmentReader, includeSegmentFileSizes, stats);
                segmentName.add(segmentReader.getSegmentName());
            }
        }
        searcher = this.acquireSearcher(SEGMENTS_STATS_SOURCE, SearcherScope.EXTERNAL);
        try {
            for (LeafReaderContext ctx : searcher.getIndexReader().getContext().leaves()) {
                segmentReader = Lucene.segmentReader(ctx.reader());
                if (segmentName.contains(segmentReader.getSegmentName())) continue;
                this.fillSegmentStats(segmentReader, includeSegmentFileSizes, stats);
            }
        }
        finally {
            if (searcher != null) {
                searcher.close();
            }
        }
        this.writerSegmentStats(stats);
        return stats;
    }

    protected void fillSegmentStats(SegmentReader segmentReader, boolean includeSegmentFileSizes, SegmentsStats stats) {
        stats.add(1L);
        if (includeSegmentFileSizes) {
            stats.addFiles(this.getSegmentFileSizes(segmentReader));
        }
    }

    private Map<String, SegmentsStats.FileStats> getSegmentFileSizes(SegmentReader segmentReader) {
        try {
            HashMap<String, SegmentsStats.FileStats> files = new HashMap<String, SegmentsStats.FileStats>();
            SegmentCommitInfo segmentCommitInfo = segmentReader.getSegmentInfo();
            for (String fileName : segmentCommitInfo.files()) {
                String fileExtension = IndexFileNames.getExtension((String)fileName);
                if (fileExtension == null) continue;
                try {
                    long fileLength = segmentReader.directory().fileLength(fileName);
                    files.put(fileExtension, new SegmentsStats.FileStats(fileExtension, fileLength, 1L, fileLength, fileLength));
                }
                catch (IOException ioe) {
                    this.logger.warn(() -> "Error when retrieving file length for [" + fileName + "]", (Throwable)ioe);
                }
                catch (AlreadyClosedException ace) {
                    this.logger.warn(() -> "Error when retrieving file length for [" + fileName + "], directory is closed", (Throwable)ace);
                    return Map.of();
                }
            }
            return Collections.unmodifiableMap(files);
        }
        catch (IOException e) {
            this.logger.warn(() -> Strings.format((String)"Error when listing files for segment reader [%s] and segment info [%s]", (Object[])new Object[]{segmentReader, segmentReader.getSegmentInfo()}), (Throwable)e);
            return Map.of();
        }
    }

    protected void writerSegmentStats(SegmentsStats stats) {
        stats.addVersionMapMemoryInBytes(0L);
        stats.addIndexWriterMemoryInBytes(0L);
    }

    public abstract long getIndexBufferRAMBytesUsed();

    final Segment[] getSegmentInfo(SegmentInfos lastCommittedSegmentInfos) {
        return this.getSegmentInfo(lastCommittedSegmentInfos, false);
    }

    final Segment[] getSegmentInfo(SegmentInfos lastCommittedSegmentInfos, boolean includeVectorFormatsInfo) {
        this.ensureOpen();
        HashMap<String, Segment> segments = new HashMap<String, Segment>();
        try (Object searcher = this.acquireSearcher("segments", SearcherScope.EXTERNAL);){
            for (LeafReaderContext ctx : searcher.getIndexReader().getContext().leaves()) {
                this.fillSegmentInfo(Lucene.segmentReader(ctx.reader()), true, segments, includeVectorFormatsInfo);
            }
        }
        searcher = this.acquireSearcher("segments", SearcherScope.INTERNAL);
        try {
            for (LeafReaderContext ctx : searcher.getIndexReader().getContext().leaves()) {
                SegmentReader segmentReader = Lucene.segmentReader(ctx.reader());
                if (segments.containsKey(segmentReader.getSegmentName())) continue;
                this.fillSegmentInfo(segmentReader, false, segments, includeVectorFormatsInfo);
            }
        }
        finally {
            if (searcher != null) {
                ((Searcher)((Object)searcher)).close();
            }
        }
        if (lastCommittedSegmentInfos != null) {
            for (SegmentCommitInfo info : lastCommittedSegmentInfos) {
                Segment segment = (Segment)segments.get(info.info.name);
                if (segment == null) {
                    segment = new Segment(info.info.name);
                    segment.search = false;
                    segment.committed = true;
                    segment.delDocCount = info.getDelCount() + info.getSoftDelCount();
                    segment.docCount = info.info.maxDoc() - segment.delDocCount;
                    segment.version = info.info.getVersion();
                    segment.compound = info.info.getUseCompoundFile();
                    try {
                        segment.sizeInBytes = info.sizeInBytes();
                    }
                    catch (IOException e) {
                        this.logger.trace(() -> "failed to get size for [" + info.info.name + "]", (Throwable)e);
                    }
                    segment.segmentSort = info.info.getIndexSort();
                    segment.attributes = info.info.getAttributes();
                    segments.put(info.info.name, segment);
                    continue;
                }
                segment.committed = true;
            }
        }
        Segment[] segmentsArr = segments.values().toArray(new Segment[segments.values().size()]);
        Arrays.sort(segmentsArr, Comparator.comparingLong(Segment::getGeneration));
        return segmentsArr;
    }

    private void fillSegmentInfo(SegmentReader segmentReader, boolean search, Map<String, Segment> segments, boolean includeVectorFormatsInfo) {
        SegmentCommitInfo info = segmentReader.getSegmentInfo();
        assert (!segments.containsKey(info.info.name));
        Segment segment = new Segment(info.info.name);
        segment.search = search;
        segment.docCount = segmentReader.numDocs();
        segment.delDocCount = segmentReader.numDeletedDocs();
        segment.version = info.info.getVersion();
        segment.compound = info.info.getUseCompoundFile();
        try {
            segment.sizeInBytes = info.sizeInBytes();
        }
        catch (IOException e) {
            this.logger.trace(() -> "failed to get size for [" + info.info.name + "]", (Throwable)e);
        }
        segment.segmentSort = info.info.getIndexSort();
        segment.attributes = new HashMap<String, String>();
        segment.attributes.putAll(info.info.getAttributes());
        HashMap<String, List> knnFormats = null;
        if (includeVectorFormatsInfo) {
            try {
                FieldInfos fieldInfos = segmentReader.getFieldInfos();
                if (fieldInfos.hasVectorValues()) {
                    for (FieldInfo fieldInfo : fieldInfos) {
                        String name = fieldInfo.getName();
                        if (!fieldInfo.hasVectorValues()) continue;
                        if (knnFormats == null) {
                            knnFormats = new HashMap<String, List>();
                        }
                        String key = fieldInfo.getAttribute(PerFieldKnnVectorsFormat.PER_FIELD_FORMAT_KEY);
                        knnFormats.compute(key, (s, a) -> {
                            if (a == null) {
                                a = new ArrayList<String>();
                            }
                            a.add(name);
                            return a;
                        });
                    }
                }
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
        if (knnFormats != null) {
            for (Map.Entry entry : knnFormats.entrySet()) {
                segment.attributes.put((String)entry.getKey(), ((List)entry.getValue()).toString());
            }
        }
        segments.put(info.info.name, segment);
    }

    public abstract List<Segment> segments();

    public abstract List<Segment> segments(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshNeeded() {
        if (!this.store.tryIncRef()) {
            return false;
        }
        try {
            boolean bl;
            ReferenceManager<ElasticsearchDirectoryReader> refManager = this.getReferenceManager(SearcherScope.EXTERNAL);
            ElasticsearchDirectoryReader reader = (ElasticsearchDirectoryReader)((Object)refManager.acquire());
            try {
                bl = !reader.isCurrent();
            }
            catch (Throwable throwable) {
                try {
                    refManager.release((Object)reader);
                    throw throwable;
                }
                catch (IOException e) {
                    this.logger.error("failed to access directory reader", (Throwable)e);
                    this.failEngine("failed to access directory reader", e);
                    throw new EngineException(this.shardId, "failed to access directory reader", e, new Object[0]);
                }
            }
            refManager.release((Object)reader);
            return bl;
        }
        finally {
            this.store.decRef();
        }
    }

    @Nullable
    public abstract RefreshResult refresh(String var1) throws EngineException;

    public void externalRefresh(String source, ActionListener<RefreshResult> listener) {
        ActionListener.completeWith(listener, () -> {
            this.logger.trace("external refresh with source [{}]", (Object)source);
            return this.refresh(source);
        });
    }

    @Nullable
    public abstract void maybeRefresh(String var1, ActionListener<RefreshResult> var2) throws EngineException;

    public abstract void writeIndexingBuffer() throws IOException;

    public abstract boolean shouldPeriodicallyFlush();

    public void flush(boolean force, boolean waitIfOngoing) throws EngineException {
        PlainActionFuture<FlushResult> future = new PlainActionFuture<FlushResult>();
        this.flush(force, waitIfOngoing, future);
        future.actionGet();
    }

    public final void flush(boolean force, boolean waitIfOngoing, ActionListener<FlushResult> listener) throws EngineException {
        try (Releasable ignored = this.acquireEnsureOpenRef();){
            this.flushHoldingLock(force, waitIfOngoing, listener);
        }
    }

    protected abstract void flushHoldingLock(boolean var1, boolean var2, ActionListener<FlushResult> var3) throws EngineException;

    public final void flush() throws EngineException {
        PlainActionFuture<FlushResult> future = new PlainActionFuture<FlushResult>();
        this.flush(false, false, future);
        future.actionGet();
    }

    public abstract void trimUnreferencedTranslogFiles() throws EngineException;

    public abstract boolean shouldRollTranslogGeneration();

    public abstract void rollTranslogGeneration() throws EngineException;

    public abstract void forceMerge(boolean var1, int var2, boolean var3, String var4) throws EngineException, IOException;

    public abstract IndexCommitRef acquireLastIndexCommit(boolean var1) throws EngineException;

    public abstract IndexCommitRef acquireSafeIndexCommit() throws EngineException;

    public final IndexCommitRef acquireIndexCommitForSnapshot() throws EngineException {
        return this.engineConfig.getSnapshotCommitSupplier().acquireIndexCommitForSnapshot(this);
    }

    public abstract SafeCommitInfo getSafeCommitInfo();

    private void maybeDie(String maybeMessage, Throwable maybeFatal) {
        ExceptionsHelper.maybeError(maybeFatal).ifPresent(error -> {
            try {
                this.logger.error(maybeMessage, (Throwable)error);
            }
            finally {
                throw error;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failEngine(String reason, @Nullable Exception failure) {
        assert (Transports.assertNotTransportThread("failEngine can block on IO"));
        if (failure != null) {
            this.maybeDie(reason, failure);
        }
        if (this.failEngineLock.tryLock()) {
            try {
                if (this.failedEngine.get() != null) {
                    this.logger.warn(() -> "tried to fail engine but engine is already failed. ignoring. [" + reason + "]", (Throwable)failure);
                    return;
                }
                this.failedEngine.set((Object)(failure != null ? failure : new IllegalStateException(reason)));
                try {
                    this.closeNoLock("engine failed on: [" + reason + "]", this.closedLatch);
                }
                finally {
                    this.logger.warn(() -> "failed engine [" + reason + "]", (Throwable)failure);
                    if (Lucene.isCorruptionException(failure)) {
                        if (this.store.tryIncRef()) {
                            try {
                                this.store.markStoreCorrupted(new IOException("failed engine (reason: [" + reason + "])", ExceptionsHelper.unwrapCorruption(failure)));
                            }
                            catch (IOException e) {
                                this.logger.warn("Couldn't mark store corrupted", (Throwable)e);
                            }
                            finally {
                                this.store.decRef();
                            }
                        } else {
                            this.logger.warn(() -> Strings.format((String)"tried to mark store as corrupted but store is already closed. [%s]", (Object[])new Object[]{reason}), (Throwable)failure);
                        }
                    }
                    this.eventListener.onFailedEngine(reason, failure);
                }
            }
            catch (Exception inner) {
                if (failure != null) {
                    inner.addSuppressed(failure);
                }
                this.logger.warn("failEngine threw exception", (Throwable)inner);
            }
        } else {
            this.logger.debug(() -> Strings.format((String)"tried to fail engine but could not acquire lock - engine should be failed by now [%s]", (Object[])new Object[]{reason}), (Throwable)failure);
        }
    }

    protected boolean maybeFailEngine(String source, Exception e) {
        if (Lucene.isCorruptionException(e)) {
            this.failEngine("corrupt file (source: [" + source + "])", e);
            return true;
        }
        return false;
    }

    protected abstract void closeNoLock(String var1, CountDownLatch var2);

    protected final boolean isDrainedForClose() {
        return !this.ensureOpenRefs.hasReferences();
    }

    protected final boolean isClosing() {
        return this.isClosing.get();
    }

    protected final Releasable acquireEnsureOpenRef() {
        if (this.isClosing() || !this.ensureOpenRefs.tryIncRef()) {
            this.ensureOpen();
            throw new AlreadyClosedException(String.valueOf(this.shardId) + " engine is closing", (Throwable)this.failedEngine.get());
        }
        return Releasables.assertOnce((Releasable)this.releaseEnsureOpenRef);
    }

    private boolean drainForClose() {
        if (!this.isClosing.compareAndSet(false, true)) {
            this.logger.trace("drainForClose(): already closing");
            return false;
        }
        this.logger.debug("drainForClose(): draining ops");
        this.releaseEnsureOpenRef.close();
        UnsafePlainActionFuture<Void> future = new UnsafePlainActionFuture<Void>(this, new String[]{"generic"}){

            @Override
            protected boolean blockingAllowed() {
                return Thread.currentThread().getName().contains("clusterApplierService#updateTask") || super.blockingAllowed();
            }
        };
        this.drainOnCloseListener.addListener((ActionListener<Void>)future);
        try {
            future.get();
            return true;
        }
        catch (ExecutionException e) {
            this.logger.error("failure while draining operations on close", (Throwable)e);
            assert (false) : e;
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.error("interrupted while draining operations on close");
            throw new IllegalStateException(e);
        }
    }

    public void flushAndClose() throws IOException {
        this.logger.trace("flushAndClose() maybe draining ops");
        if (!this.isClosed.get() && this.drainForClose()) {
            this.logger.trace("flushAndClose drained ops");
            try {
                this.logger.debug("flushing shard on close - this might take some time to sync files to disk");
                try {
                    this.flushHoldingLock(false, false, ActionListener.noop());
                }
                catch (AlreadyClosedException ex) {
                    this.logger.debug("engine already closed - skipping flushAndClose");
                }
            }
            finally {
                this.closeNoLock("flushAndClose", this.closedLatch);
            }
        }
        this.awaitPendingClose();
    }

    @Override
    public void close() throws IOException {
        this.logger.debug("close() maybe draining ops");
        if (!this.isClosed.get() && this.drainForClose()) {
            this.logger.debug("close drained ops");
            this.closeNoLock("api", this.closedLatch);
        }
        this.awaitPendingClose();
    }

    protected final void awaitPendingClose() {
        try {
            this.closedLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void onSettingsChanged() {
    }

    public long getLastWriteNanos() {
        return this.lastWriteNanos;
    }

    public abstract void activateThrottling();

    public abstract void deactivateThrottling();

    public abstract int restoreLocalHistoryFromTranslog(TranslogRecoveryRunner var1) throws IOException;

    public abstract int fillSeqNoGaps(long var1) throws IOException;

    public final void recoverFromTranslog(TranslogRecoveryRunner translogRecoveryRunner, long recoverUpToSeqNo) throws IOException {
        PlainActionFuture<Void> future = new PlainActionFuture<Void>();
        this.recoverFromTranslog(translogRecoveryRunner, recoverUpToSeqNo, future);
        try {
            future.get();
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IOException) {
                IOException ioException = (IOException)throwable;
                throw ioException;
            }
            throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)throwable;
                throw runtimeException;
            }
            this.logger.error("checked non-IOException unexpectedly thrown", (Throwable)e);
            assert (false) : e;
            throw new UncategorizedExecutionException("recoverFromTranslog", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public abstract void recoverFromTranslog(TranslogRecoveryRunner var1, long var2, ActionListener<Void> var4);

    public abstract void skipTranslogRecovery();

    public abstract void maybePruneDeletes();

    public long getMaxSeenAutoIdTimestamp() {
        return -1L;
    }

    public abstract void updateMaxUnsafeAutoIdTimestamp(long var1);

    public abstract long getMaxSeqNoOfUpdatesOrDeletes();

    public abstract void advanceMaxSeqNoOfUpdatesOrDeletes(long var1);

    public abstract ShardLongFieldRange getRawFieldRange(String var1) throws IOException;

    public final EngineConfig getEngineConfig() {
        return this.engineConfig;
    }

    public static SeqNoStats buildSeqNoStats(EngineConfig config, SegmentInfos infos) {
        SequenceNumbers.CommitInfo seqNoStats = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(infos.userData.entrySet());
        long maxSeqNo = seqNoStats.maxSeqNo();
        long localCheckpoint = seqNoStats.localCheckpoint();
        return new SeqNoStats(maxSeqNo, localCheckpoint, config.getGlobalCheckpointSupplier().getAsLong());
    }

    @Deprecated
    public void addSegmentGenerationListener(long minGeneration, ActionListener<Long> listener) {
        this.addPrimaryTermAndGenerationListener(-1L, minGeneration, listener);
    }

    public void addPrimaryTermAndGenerationListener(long minPrimaryTerm, long minGeneration, ActionListener<Long> listener) {
        throw new UnsupportedOperationException();
    }

    public void addFlushListener(Translog.Location location, ActionListener<Long> listener) {
        listener.onFailure(new UnsupportedOperationException("Engine type " + String.valueOf(this.getClass()) + " does not support flush listeners."));
    }

    public void prepareForEngineReset() throws IOException {
        throw new UnsupportedOperationException("does not support engine reset");
    }

    public long getLastUnsafeSegmentGenerationForGets() {
        throw new UnsupportedOperationException("Doesn't support getting the latest segment generation");
    }

    protected static <R extends ReferenceManager<ElasticsearchDirectoryReader>> R wrapForAssertions(R referenceManager, EngineConfig engineConfig) {
        if (Assertions.ENABLED) {
            referenceManager.addListener((ReferenceManager.RefreshListener)new AssertRefreshListenerHoldsEngineReadLock(engineConfig.getEngineResetLock()));
        }
        return referenceManager;
    }

    public static interface EventListener {
        default public void onFailedEngine(String reason, @Nullable Exception e) {
        }
    }

    public static enum SearcherScope {
        EXTERNAL,
        INTERNAL;

    }

    public static final class Searcher
    extends IndexSearcher
    implements Releasable {
        private final String source;
        private final Closeable onClose;

        public Searcher(String source, IndexReader reader, Similarity similarity, QueryCache queryCache, QueryCachingPolicy queryCachingPolicy, Closeable onClose) {
            super(reader);
            this.setSimilarity(similarity);
            this.setQueryCache(queryCache);
            this.setQueryCachingPolicy(queryCachingPolicy);
            this.source = source;
            this.onClose = onClose;
        }

        public String source() {
            return this.source;
        }

        public DirectoryReader getDirectoryReader() {
            if (this.getIndexReader() instanceof DirectoryReader) {
                return (DirectoryReader)this.getIndexReader();
            }
            throw new IllegalStateException("Can't use " + String.valueOf(this.getIndexReader().getClass()) + " as a directory reader");
        }

        public void close() {
            try {
                this.onClose.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("failed to close", e);
            }
            catch (AlreadyClosedException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    public static class Get {
        private final boolean realtime;
        private final BytesRef uid;
        private final String id;
        private final boolean readFromTranslog;
        private long version = -3L;
        private VersionType versionType = VersionType.INTERNAL;
        private long ifSeqNo = -2L;
        private long ifPrimaryTerm = 0L;

        public Get(boolean realtime, boolean readFromTranslog, String id) {
            this.realtime = realtime;
            this.id = id;
            this.uid = Uid.encodeId(id);
            this.readFromTranslog = readFromTranslog;
        }

        public boolean realtime() {
            return this.realtime;
        }

        public String id() {
            return this.id;
        }

        public BytesRef uid() {
            return this.uid;
        }

        public long version() {
            return this.version;
        }

        public Get version(long version) {
            this.version = version;
            return this;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public Get versionType(VersionType versionType) {
            this.versionType = versionType;
            return this;
        }

        public boolean isReadFromTranslog() {
            return this.readFromTranslog;
        }

        public Get setIfSeqNo(long seqNo) {
            this.ifSeqNo = seqNo;
            return this;
        }

        public long getIfSeqNo() {
            return this.ifSeqNo;
        }

        public Get setIfPrimaryTerm(long primaryTerm) {
            this.ifPrimaryTerm = primaryTerm;
            return this;
        }

        public long getIfPrimaryTerm() {
            return this.ifPrimaryTerm;
        }
    }

    public static class GetResult
    implements Releasable {
        private final boolean exists;
        private final long version;
        private final VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion;
        private final Searcher searcher;
        public static final GetResult NOT_EXISTS = new GetResult(false, -1L, null, null);

        private GetResult(boolean exists, long version, VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion, Searcher searcher) {
            this.exists = exists;
            this.version = version;
            this.docIdAndVersion = docIdAndVersion;
            this.searcher = searcher;
        }

        public GetResult(Searcher searcher, VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion) {
            this(true, docIdAndVersion.version, docIdAndVersion, searcher);
        }

        public boolean exists() {
            return this.exists;
        }

        public long version() {
            return this.version;
        }

        public Searcher searcher() {
            return this.searcher;
        }

        public VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion() {
            return this.docIdAndVersion;
        }

        public void close() {
            Releasables.close((Releasable)this.searcher);
        }
    }

    public static abstract class SearcherSupplier
    implements Releasable {
        private final Function<Searcher, Searcher> wrapper;
        private final AtomicBoolean released = new AtomicBoolean(false);

        public SearcherSupplier(Function<Searcher, Searcher> wrapper) {
            this.wrapper = wrapper;
        }

        public final Searcher acquireSearcher(String source) {
            if (this.released.get()) {
                throw new AlreadyClosedException("SearcherSupplier was closed");
            }
            Searcher searcher = this.acquireSearcherInternal(source);
            return this.wrapper.apply(searcher);
        }

        public final void close() {
            if (this.released.compareAndSet(false, true)) {
                this.doClose();
            } else assert (false) : "SearchSupplier was released twice";
        }

        protected abstract void doClose();

        protected abstract Searcher acquireSearcherInternal(String var1);

        @Nullable
        public String getSearcherId() {
            return null;
        }
    }

    public static class IndexCommitRef
    implements Closeable {
        private final AtomicBoolean closed = new AtomicBoolean();
        private final CheckedRunnable<IOException> onClose;
        private final IndexCommit indexCommit;

        public IndexCommitRef(IndexCommit indexCommit, CheckedRunnable<IOException> onClose) {
            this.indexCommit = indexCommit;
            this.onClose = onClose;
        }

        @Override
        public void close() throws IOException {
            if (this.closed.compareAndSet(false, true)) {
                this.onClose.run();
            }
        }

        public IndexCommit getIndexCommit() {
            return this.indexCommit;
        }
    }

    @FunctionalInterface
    public static interface TranslogRecoveryRunner {
        public int run(Engine var1, Translog.Snapshot var2) throws IOException;
    }

    private static class AssertRefreshListenerHoldsEngineReadLock
    implements ReferenceManager.RefreshListener {
        private final EngineResetLock engineLock;

        private AssertRefreshListenerHoldsEngineReadLock(EngineResetLock engineLock) {
            this.engineLock = Objects.requireNonNull(engineLock);
        }

        public void beforeRefresh() throws IOException {
            assert (this.engineLock.isReadLockedByCurrentThread()) : Thread.currentThread();
        }

        public void afterRefresh(boolean didRefresh) throws IOException {
            assert (this.engineLock.isReadLockedByCurrentThread()) : Thread.currentThread();
        }
    }

    public record RefreshResult(boolean refreshed, long primaryTerm, long generation) {
        public static final long UNKNOWN_GENERATION = -1L;
        public static final RefreshResult NO_REFRESH = new RefreshResult(false);

        public RefreshResult(boolean refreshed) {
            this(refreshed, -1L, -1L);
        }
    }

    public record FlushResult(boolean flushPerformed, long generation) {
        public static final long UNKNOWN_GENERATION = -1L;
        public static final FlushResult NO_FLUSH = new FlushResult(false, -1L);
    }

    public static interface Warmer {
        public void warm(ElasticsearchDirectoryReader var1);
    }

    public static class NoOp
    extends Operation {
        private final String reason;

        public String reason() {
            return this.reason;
        }

        public NoOp(long seqNo, long primaryTerm, Operation.Origin origin, long startTime, String reason) {
            super(null, seqNo, primaryTerm, -1L, null, origin, startTime);
            this.reason = reason;
        }

        @Override
        public BytesRef uid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long version() {
            throw new UnsupportedOperationException();
        }

        @Override
        public VersionType versionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Operation.TYPE operationType() {
            return Operation.TYPE.NO_OP;
        }

        @Override
        public int estimatedSizeInBytes() {
            return 2 * this.reason.length() + 16;
        }
    }

    public static class Delete
    extends Operation {
        private final String id;
        private final long ifSeqNo;
        private final long ifPrimaryTerm;

        public Delete(String id, BytesRef uid, long seqNo, long primaryTerm, long version, VersionType versionType, Operation.Origin origin, long startTime, long ifSeqNo, long ifPrimaryTerm) {
            super(uid, seqNo, primaryTerm, version, versionType, origin, startTime);
            assert (origin == Operation.Origin.PRIMARY == (versionType != null)) : "invalid version_type=" + String.valueOf(versionType) + " for origin=" + String.valueOf((Object)origin);
            assert (ifPrimaryTerm >= 0L) : "ifPrimaryTerm [" + ifPrimaryTerm + "] must be non negative";
            assert (ifSeqNo == -2L || ifSeqNo >= 0L) : "ifSeqNo [" + ifSeqNo + "] must be non negative or unset";
            assert (origin == Operation.Origin.PRIMARY || ifSeqNo == -2L && ifPrimaryTerm == 0L) : "cas operations are only allowed if origin is primary. get [" + String.valueOf((Object)origin) + "]";
            this.id = Objects.requireNonNull(id);
            this.ifSeqNo = ifSeqNo;
            this.ifPrimaryTerm = ifPrimaryTerm;
        }

        public Delete(String id, BytesRef uid, long primaryTerm) {
            this(id, uid, -2L, primaryTerm, -3L, VersionType.INTERNAL, Operation.Origin.PRIMARY, System.nanoTime(), -2L, 0L);
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public Operation.TYPE operationType() {
            return Operation.TYPE.DELETE;
        }

        @Override
        public int estimatedSizeInBytes() {
            return this.uid().length * 2 + 20;
        }

        public long getIfSeqNo() {
            return this.ifSeqNo;
        }

        public long getIfPrimaryTerm() {
            return this.ifPrimaryTerm;
        }
    }

    public static class Index
    extends Operation {
        private final ParsedDocument doc;
        private final long autoGeneratedIdTimestamp;
        private final boolean isRetry;
        private final long ifSeqNo;
        private final long ifPrimaryTerm;

        public Index(BytesRef uid, ParsedDocument doc, long seqNo, long primaryTerm, long version, VersionType versionType, Operation.Origin origin, long startTime, long autoGeneratedIdTimestamp, boolean isRetry, long ifSeqNo, long ifPrimaryTerm) {
            super(uid, seqNo, primaryTerm, version, versionType, origin, startTime);
            assert (origin == Operation.Origin.PRIMARY == (versionType != null)) : "invalid version_type=" + String.valueOf(versionType) + " for origin=" + String.valueOf((Object)origin);
            assert (ifPrimaryTerm >= 0L) : "ifPrimaryTerm [" + ifPrimaryTerm + "] must be non negative";
            assert (ifSeqNo == -2L || ifSeqNo >= 0L) : "ifSeqNo [" + ifSeqNo + "] must be non negative or unset";
            assert (origin == Operation.Origin.PRIMARY || ifSeqNo == -2L && ifPrimaryTerm == 0L) : "cas operations are only allowed if origin is primary. get [" + String.valueOf((Object)origin) + "]";
            this.doc = doc;
            this.isRetry = isRetry;
            this.autoGeneratedIdTimestamp = autoGeneratedIdTimestamp;
            this.ifSeqNo = ifSeqNo;
            this.ifPrimaryTerm = ifPrimaryTerm;
        }

        public Index(BytesRef uid, long primaryTerm, ParsedDocument doc) {
            this(uid, primaryTerm, doc, -3L);
        }

        Index(BytesRef uid, long primaryTerm, ParsedDocument doc, long version) {
            this(uid, doc, -2L, primaryTerm, version, VersionType.INTERNAL, Operation.Origin.PRIMARY, System.nanoTime(), -1L, false, -2L, 0L);
        }

        public ParsedDocument parsedDoc() {
            return this.doc;
        }

        @Override
        public String id() {
            return this.doc.id();
        }

        @Override
        public Operation.TYPE operationType() {
            return Operation.TYPE.INDEX;
        }

        public String routing() {
            return this.doc.routing();
        }

        public List<LuceneDocument> docs() {
            return this.doc.docs();
        }

        public BytesReference source() {
            return this.doc.source();
        }

        @Override
        public int estimatedSizeInBytes() {
            return this.id().length() * 2 + this.source().length() + 12;
        }

        public long getAutoGeneratedIdTimestamp() {
            return this.autoGeneratedIdTimestamp;
        }

        public boolean isRetry() {
            return this.isRetry;
        }

        public long getIfSeqNo() {
            return this.ifSeqNo;
        }

        public long getIfPrimaryTerm() {
            return this.ifPrimaryTerm;
        }
    }

    public static abstract class Operation {
        private final BytesRef uid;
        private final long version;
        private final long seqNo;
        private final long primaryTerm;
        private final VersionType versionType;
        private final Origin origin;
        private final long startTime;

        public Operation(BytesRef uid, long seqNo, long primaryTerm, long version, VersionType versionType, Origin origin, long startTime) {
            this.uid = uid;
            this.seqNo = seqNo;
            this.primaryTerm = primaryTerm;
            this.version = version;
            this.versionType = versionType;
            this.origin = origin;
            this.startTime = startTime;
        }

        public Origin origin() {
            return this.origin;
        }

        public BytesRef uid() {
            return this.uid;
        }

        public long version() {
            return this.version;
        }

        public long seqNo() {
            return this.seqNo;
        }

        public long primaryTerm() {
            return this.primaryTerm;
        }

        public abstract int estimatedSizeInBytes();

        public VersionType versionType() {
            return this.versionType;
        }

        public long startTime() {
            return this.startTime;
        }

        abstract String id();

        public abstract TYPE operationType();

        public static enum Origin {
            PRIMARY,
            REPLICA,
            PEER_RECOVERY,
            LOCAL_TRANSLOG_RECOVERY,
            LOCAL_RESET;


            public boolean isRecovery() {
                return this == PEER_RECOVERY || this == LOCAL_TRANSLOG_RECOVERY;
            }

            boolean isFromTranslog() {
                return this == LOCAL_TRANSLOG_RECOVERY || this == LOCAL_RESET;
            }
        }

        public static enum TYPE {
            INDEX,
            DELETE,
            NO_OP;

            private final String lowercase = this.toString().toLowerCase(Locale.ROOT);

            public String getLowercase() {
                return this.lowercase;
            }
        }
    }

    public static class NoOpResult
    extends Result {
        public NoOpResult(long term, long seqNo) {
            super(Operation.TYPE.NO_OP, 0L, term, seqNo, null);
        }

        NoOpResult(long term, long seqNo, Exception failure) {
            super(Operation.TYPE.NO_OP, failure, 0L, term, seqNo, null);
        }
    }

    public static class DeleteResult
    extends Result {
        private final boolean found;

        public DeleteResult(long version, long term, long seqNo, boolean found, String id) {
            super(Operation.TYPE.DELETE, version, term, seqNo, id);
            this.found = found;
        }

        public DeleteResult(Exception failure, long version, long term, String id) {
            this(failure, version, term, -2L, false, id);
        }

        public DeleteResult(Exception failure, long version, long term, long seqNo, boolean found, String id) {
            super(Operation.TYPE.DELETE, failure, version, term, seqNo, id);
            this.found = found;
        }

        public boolean isFound() {
            return this.found;
        }
    }

    public static class IndexResult
    extends Result {
        private final boolean created;

        public IndexResult(long version, long term, long seqNo, boolean created, String id) {
            super(Operation.TYPE.INDEX, version, term, seqNo, id);
            this.created = created;
        }

        public IndexResult(Exception failure, long version, String id) {
            this(failure, version, 0L, -2L, id);
        }

        public IndexResult(Exception failure, long version, long term, long seqNo, String id) {
            super(Operation.TYPE.INDEX, failure, version, term, seqNo, id);
            this.created = false;
        }

        public IndexResult(Mapping requiredMappingUpdate, String id) {
            super(Operation.TYPE.INDEX, requiredMappingUpdate, id);
            this.created = false;
        }

        public boolean isCreated() {
            return this.created;
        }
    }

    public static abstract class Result {
        private final Operation.TYPE operationType;
        private final Type resultType;
        private final long version;
        private final long term;
        private final long seqNo;
        private final Exception failure;
        private final SetOnce<Boolean> freeze = new SetOnce();
        private final Mapping requiredMappingUpdate;
        private final String id;
        private Translog.Location translogLocation;
        private long took;

        protected Result(Operation.TYPE operationType, Exception failure, long version, long term, long seqNo, String id) {
            this.operationType = operationType;
            this.failure = Objects.requireNonNull(failure);
            this.version = version;
            this.term = term;
            this.seqNo = seqNo;
            this.requiredMappingUpdate = null;
            this.resultType = Type.FAILURE;
            this.id = id;
        }

        protected Result(Operation.TYPE operationType, long version, long term, long seqNo, String id) {
            this.operationType = operationType;
            this.version = version;
            this.seqNo = seqNo;
            this.term = term;
            this.failure = null;
            this.requiredMappingUpdate = null;
            this.resultType = Type.SUCCESS;
            this.id = id;
        }

        protected Result(Operation.TYPE operationType, Mapping requiredMappingUpdate, String id) {
            this.operationType = operationType;
            this.version = -1L;
            this.seqNo = -2L;
            this.term = 0L;
            this.failure = null;
            this.requiredMappingUpdate = requiredMappingUpdate;
            this.resultType = Type.MAPPING_UPDATE_REQUIRED;
            this.id = id;
        }

        public Type getResultType() {
            return this.resultType;
        }

        public long getVersion() {
            return this.version;
        }

        public long getSeqNo() {
            return this.seqNo;
        }

        public long getTerm() {
            return this.term;
        }

        public Mapping getRequiredMappingUpdate() {
            return this.requiredMappingUpdate;
        }

        public Translog.Location getTranslogLocation() {
            return this.translogLocation;
        }

        public Exception getFailure() {
            return this.failure;
        }

        public long getTook() {
            return this.took;
        }

        public Operation.TYPE getOperationType() {
            return this.operationType;
        }

        public String getId() {
            return this.id;
        }

        void setTranslogLocation(Translog.Location translogLocation) {
            if (this.freeze.get() != null) {
                throw new IllegalStateException("result is already frozen");
            }
            this.translogLocation = translogLocation;
        }

        void setTook(long took) {
            if (this.freeze.get() != null) {
                throw new IllegalStateException("result is already frozen");
            }
            this.took = took;
        }

        void freeze() {
            this.freeze.set((Object)true);
        }

        public static enum Type {
            SUCCESS,
            FAILURE,
            MAPPING_UPDATE_REQUIRED;

        }
    }

    protected static final class NoOpLock
    implements Lock {
        protected NoOpLock() {
        }

        @Override
        public void lock() {
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
        }

        @Override
        public boolean tryLock() {
            return true;
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public void unlock() {
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("NoOpLock can't provide a condition");
        }
    }

    protected static final class IndexThrottle {
        private static final Logger logger = LogManager.getLogger(IndexThrottle.class);
        private final CounterMetric throttleTimeMillisMetric = new CounterMetric();
        private volatile long startOfThrottleNS;
        private static final ReleasableLock NOOP_LOCK = new ReleasableLock(new NoOpLock());
        private final ReleasableLock lockReference = new ReleasableLock(new ReentrantLock());
        private final Lock pauseIndexingLock = new ReentrantLock();
        private final Condition pauseCondition = this.pauseIndexingLock.newCondition();
        private final ReleasableLock pauseLockReference = new ReleasableLock(this.pauseIndexingLock);
        private volatile AtomicBoolean suspendThrottling = new AtomicBoolean();
        private final boolean pauseWhenThrottled;
        private volatile ReleasableLock lock = NOOP_LOCK;

        public IndexThrottle(boolean pause) {
            this.pauseWhenThrottled = pause;
        }

        public Releasable acquireThrottle() {
            ReleasableLock lockCopy = this.lock;
            if (lockCopy == this.pauseLockReference) {
                try (ReleasableLock ignored = this.pauseLockReference.acquire();){
                    while (this.lock == this.pauseLockReference && !this.suspendThrottling.getAcquire()) {
                        logger.trace("Waiting on pause indexing lock");
                        this.pauseCondition.await();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                finally {
                    logger.trace("Acquired pause indexing lock");
                }
                return () -> {};
            }
            return lockCopy.acquire();
        }

        public void activate() {
            assert (this.lock == NOOP_LOCK) : "throttling activated while already active";
            this.startOfThrottleNS = System.nanoTime();
            if (this.pauseWhenThrottled) {
                this.lock = this.pauseLockReference;
                logger.trace("Activated index throttling pause");
            } else {
                this.lock = this.lockReference;
            }
        }

        public void deactivate() {
            assert (this.lock != NOOP_LOCK) : "throttling deactivated but not active";
            this.lock = NOOP_LOCK;
            if (this.pauseWhenThrottled) {
                try (ReleasableLock releasableLock = this.pauseLockReference.acquire();){
                    this.pauseCondition.signalAll();
                }
                logger.trace("Deactivated index throttling pause");
            }
            assert (this.startOfThrottleNS > 0L) : "Bad state of startOfThrottleNS";
            long throttleTimeNS = System.nanoTime() - this.startOfThrottleNS;
            if (throttleTimeNS >= 0L) {
                this.throttleTimeMillisMetric.inc(TimeValue.nsecToMSec((long)throttleTimeNS));
            }
        }

        long getThrottleTimeInMillis() {
            long currentThrottleNS = 0L;
            if (this.isThrottled() && this.startOfThrottleNS != 0L && (currentThrottleNS += System.nanoTime() - this.startOfThrottleNS) < 0L) {
                currentThrottleNS = 0L;
            }
            return this.throttleTimeMillisMetric.count() + TimeValue.nsecToMSec((long)currentThrottleNS);
        }

        boolean isThrottled() {
            return this.lock != NOOP_LOCK;
        }

        public void suspendThrottle() {
            if (this.pauseWhenThrottled) {
                try (ReleasableLock releasableLock = this.pauseLockReference.acquire();){
                    this.suspendThrottling.setRelease(true);
                    this.pauseCondition.signalAll();
                }
            }
        }

        public void resumeThrottle() {
            if (this.pauseWhenThrottled) {
                try (ReleasableLock releasableLock = this.pauseLockReference.acquire();){
                    this.suspendThrottling.setRelease(false);
                    this.pauseCondition.signalAll();
                }
            }
        }

        boolean throttleLockIsHeldByCurrentThread() {
            if (this.isThrottled()) {
                return this.lock.isHeldByCurrentThread();
            }
            return false;
        }
    }

    public static interface IndexCommitListener {
        public void onNewCommit(ShardId var1, Store var2, long var3, IndexCommitRef var5, Set<String> var6);

        public void onIndexCommitDelete(ShardId var1, IndexCommit var2);
    }
}

