/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.util.Map;
import org.apache.lucene.backward_codecs.lucene90.Lucene90HnswVectorsReader;
import org.apache.lucene.backward_codecs.lucene91.Lucene91HnswVectorsReader;
import org.apache.lucene.backward_codecs.lucene92.Lucene92HnswVectorsReader;
import org.apache.lucene.backward_codecs.lucene94.Lucene94HnswVectorsReader;
import org.apache.lucene.backward_codecs.lucene95.Lucene95HnswVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.VectorEncoding;
import org.elasticsearch.core.SuppressForbidden;

public class OffHeapReflectionUtils {
    static final String FLAT_VECTOR_DATA_EXTENSION = "vec";
    static final String SQ_VECTOR_INDEX_EXTENSION = "veq";
    static final String HNSW_VECTOR_INDEX_EXTENSION = "vex";
    private static final MethodHandle GET_FIELD_ENTRY_HNDL_SQ;
    private static final MethodHandle GET_VECTOR_DATA_LENGTH_HANDLE_SQ;
    private static final VarHandle RAW_VECTORS_READER_HNDL_SQ;
    private static final MethodHandle GET_FIELD_ENTRY_HANDLE_L99FLT;
    private static final MethodHandle VECTOR_DATA_LENGTH_HANDLE_L99FLT;
    private static final MethodHandle GET_FIELD_ENTRY_HANDLE_L99HNSW;
    private static final MethodHandle GET_VECTOR_INDEX_LENGTH_HANDLE_L99HNSW;
    private static final VarHandle FLAT_VECTORS_READER_HNDL_L99HNSW;
    static final Class<?> L99_SQ_VR_CLS;
    static final Class<?> L99_FLT_VR_CLS;
    static final Class<?> L99_HNSW_VR_CLS;
    private static final MethodHandle GET_FIELD_ENTRY_HANDLE_L90HNSW;
    private static final MethodHandle GET_VECTOR_INDEX_LENGTH_HANDLE_L90HNSW;
    private static final MethodHandle GET_VECTOR_DATA_LENGTH_HANDLE_L90HNSW;
    private static final MethodHandle GET_FIELD_ENTRY_HANDLE_L91HNSW;
    private static final MethodHandle GET_VECTOR_INDEX_LENGTH_HANDLE_L91HNSW;
    private static final MethodHandle GET_VECTOR_DATA_LENGTH_HANDLE_L91HNSW;
    private static final MethodHandle GET_FIELD_ENTRY_HANDLE_L92HNSW;
    private static final MethodHandle GET_VECTOR_INDEX_LENGTH_HANDLE_L92HNSW;
    private static final MethodHandle GET_VECTOR_DATA_LENGTH_HANDLE_L92HNSW;
    private static final MethodHandle GET_FIELD_ENTRY_HANDLE_L94HNSW;
    private static final MethodHandle GET_VECTOR_INDEX_LENGTH_HANDLE_L94HNSW;
    private static final MethodHandle GET_VECTOR_DATA_LENGTH_HANDLE_L94HNSW;
    private static final MethodHandle GET_FIELD_ENTRY_HANDLE_L95HNSW;
    private static final MethodHandle GET_VECTOR_INDEX_LENGTH_HANDLE_L95HNSW;
    private static final MethodHandle GET_VECTOR_DATA_LENGTH_HANDLE_L95HNSW;
    static final Class<?> L90_HNSW_VR_CLS;
    static final Class<?> L91_HNSW_VR_CLS;
    static final Class<?> L92_HNSW_VR_CLS;
    static final Class<?> L94_HNSW_VR_CLS;
    static final Class<?> L95_HNSW_VR_CLS;

    private OffHeapReflectionUtils() {
    }

    @SuppressForbidden(reason="static type is not accessible")
    static Map<String, Long> getOffHeapByteSizeSQ(Lucene99ScalarQuantizedVectorsReader reader, FieldInfo fieldInfo) {
        try {
            Object entry = GET_FIELD_ENTRY_HNDL_SQ.invoke(reader, fieldInfo.name);
            long len = GET_VECTOR_DATA_LENGTH_HANDLE_SQ.invoke(entry);
            return Map.of(SQ_VECTOR_INDEX_EXTENSION, len);
        }
        catch (Throwable t) {
            OffHeapReflectionUtils.handleThrowable(t);
            throw new AssertionError((Object)"should not reach here");
        }
    }

    static FlatVectorsReader getFlatVectorsReaderSQ(Lucene99ScalarQuantizedVectorsReader reader) {
        return RAW_VECTORS_READER_HNDL_SQ.get(reader);
    }

    @SuppressForbidden(reason="static type is not accessible")
    static Map<String, Long> getOffHeapByteSizeF99FLT(Lucene99FlatVectorsReader reader, FieldInfo fieldInfo) {
        try {
            Object entry = GET_FIELD_ENTRY_HANDLE_L99FLT.invoke(reader, fieldInfo.name, fieldInfo.getVectorEncoding());
            long len = VECTOR_DATA_LENGTH_HANDLE_L99FLT.invoke(entry);
            return Map.of(FLAT_VECTOR_DATA_EXTENSION, len);
        }
        catch (Throwable t) {
            OffHeapReflectionUtils.handleThrowable(t);
            throw new AssertionError((Object)"should not reach here");
        }
    }

    @SuppressForbidden(reason="static type is not accessible")
    static Map<String, Long> getOffHeapByteSizeL99HNSW(Lucene99HnswVectorsReader reader, FieldInfo fieldInfo) {
        try {
            Object entry = GET_FIELD_ENTRY_HANDLE_L99HNSW.invoke(reader, fieldInfo.name, fieldInfo.getVectorEncoding());
            long len = GET_VECTOR_INDEX_LENGTH_HANDLE_L99HNSW.invoke(entry);
            return Map.of(HNSW_VECTOR_INDEX_EXTENSION, len);
        }
        catch (Throwable t) {
            OffHeapReflectionUtils.handleThrowable(t);
            throw new AssertionError((Object)"should not reach here");
        }
    }

    static FlatVectorsReader getFlatVectorsReaderL99HNSW(Lucene99HnswVectorsReader reader) {
        return FLAT_VECTORS_READER_HNDL_L99HNSW.get(reader);
    }

    @SuppressForbidden(reason="static type is not accessible")
    static Map<String, Long> getOffHeapByteSizeL90HNSW(Lucene90HnswVectorsReader reader, FieldInfo fieldInfo) {
        try {
            Object entry = GET_FIELD_ENTRY_HANDLE_L90HNSW.invoke(reader, fieldInfo.name);
            long graph = GET_VECTOR_INDEX_LENGTH_HANDLE_L90HNSW.invoke(entry);
            long raw = GET_VECTOR_DATA_LENGTH_HANDLE_L90HNSW.invoke(entry);
            return Map.of(HNSW_VECTOR_INDEX_EXTENSION, graph, FLAT_VECTOR_DATA_EXTENSION, raw);
        }
        catch (Throwable t) {
            OffHeapReflectionUtils.handleThrowable(t);
            throw new AssertionError((Object)"should not reach here");
        }
    }

    @SuppressForbidden(reason="static type is not accessible")
    static Map<String, Long> getOffHeapByteSizeL91HNSW(Lucene91HnswVectorsReader reader, FieldInfo fieldInfo) {
        try {
            Object entry = GET_FIELD_ENTRY_HANDLE_L91HNSW.invoke(reader, fieldInfo.name);
            long graph = GET_VECTOR_INDEX_LENGTH_HANDLE_L91HNSW.invoke(entry);
            long raw = GET_VECTOR_DATA_LENGTH_HANDLE_L91HNSW.invoke(entry);
            return Map.of(HNSW_VECTOR_INDEX_EXTENSION, graph, FLAT_VECTOR_DATA_EXTENSION, raw);
        }
        catch (Throwable t) {
            OffHeapReflectionUtils.handleThrowable(t);
            throw new AssertionError((Object)"should not reach here");
        }
    }

    @SuppressForbidden(reason="static type is not accessible")
    static Map<String, Long> getOffHeapByteSizeL92HNSW(Lucene92HnswVectorsReader reader, FieldInfo fieldInfo) {
        try {
            Object entry = GET_FIELD_ENTRY_HANDLE_L92HNSW.invoke(reader, fieldInfo.name);
            long graph = GET_VECTOR_INDEX_LENGTH_HANDLE_L92HNSW.invoke(entry);
            long raw = GET_VECTOR_DATA_LENGTH_HANDLE_L92HNSW.invoke(entry);
            return Map.of(HNSW_VECTOR_INDEX_EXTENSION, graph, FLAT_VECTOR_DATA_EXTENSION, raw);
        }
        catch (Throwable t) {
            OffHeapReflectionUtils.handleThrowable(t);
            throw new AssertionError((Object)"should not reach here");
        }
    }

    @SuppressForbidden(reason="static type is not accessible")
    static Map<String, Long> getOffHeapByteSizeL94HNSW(Lucene94HnswVectorsReader reader, FieldInfo fieldInfo) {
        try {
            Object entry = GET_FIELD_ENTRY_HANDLE_L94HNSW.invoke(reader, fieldInfo.name, fieldInfo.getVectorEncoding());
            long graph = GET_VECTOR_INDEX_LENGTH_HANDLE_L94HNSW.invoke(entry);
            long raw = GET_VECTOR_DATA_LENGTH_HANDLE_L94HNSW.invoke(entry);
            return Map.of(HNSW_VECTOR_INDEX_EXTENSION, graph, FLAT_VECTOR_DATA_EXTENSION, raw);
        }
        catch (Throwable t) {
            OffHeapReflectionUtils.handleThrowable(t);
            throw new AssertionError((Object)"should not reach here");
        }
    }

    @SuppressForbidden(reason="static type is not accessible")
    static Map<String, Long> getOffHeapByteSizeL95HNSW(Lucene95HnswVectorsReader reader, FieldInfo fieldInfo) {
        try {
            Object entry = GET_FIELD_ENTRY_HANDLE_L95HNSW.invoke(reader, fieldInfo.name, fieldInfo.getVectorEncoding());
            long graph = GET_VECTOR_INDEX_LENGTH_HANDLE_L95HNSW.invoke(entry);
            long raw = GET_VECTOR_DATA_LENGTH_HANDLE_L95HNSW.invoke(entry);
            return Map.of(HNSW_VECTOR_INDEX_EXTENSION, graph, FLAT_VECTOR_DATA_EXTENSION, raw);
        }
        catch (Throwable t) {
            OffHeapReflectionUtils.handleThrowable(t);
            throw new AssertionError((Object)"should not reach here");
        }
    }

    private static void handleThrowable(Throwable t) {
        if (t instanceof Error) {
            Error error = (Error)t;
            throw error;
        }
        if (t instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)t;
            throw runtimeException;
        }
        throw new AssertionError((Object)t);
    }

    static {
        L99_SQ_VR_CLS = Lucene99ScalarQuantizedVectorsReader.class;
        L99_FLT_VR_CLS = Lucene99FlatVectorsReader.class;
        L99_HNSW_VR_CLS = Lucene99HnswVectorsReader.class;
        L90_HNSW_VR_CLS = Lucene90HnswVectorsReader.class;
        L91_HNSW_VR_CLS = Lucene91HnswVectorsReader.class;
        L92_HNSW_VR_CLS = Lucene92HnswVectorsReader.class;
        L94_HNSW_VR_CLS = Lucene94HnswVectorsReader.class;
        L95_HNSW_VR_CLS = Lucene95HnswVectorsReader.class;
        try {
            Class<?> cls = Class.forName("org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsReader$FieldEntry");
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(L99_SQ_VR_CLS, MethodHandles.lookup());
            MethodType mt = MethodType.methodType(cls, String.class);
            GET_FIELD_ENTRY_HNDL_SQ = lookup.findVirtual(L99_SQ_VR_CLS, "getFieldEntry", mt);
            GET_VECTOR_DATA_LENGTH_HANDLE_SQ = lookup.findVirtual(cls, "vectorDataLength", MethodType.methodType(Long.TYPE));
            RAW_VECTORS_READER_HNDL_SQ = lookup.findVarHandle(L99_SQ_VR_CLS, "rawVectorsReader", FlatVectorsReader.class);
            cls = Class.forName("org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsReader$FieldEntry");
            lookup = MethodHandles.privateLookupIn(L99_FLT_VR_CLS, MethodHandles.lookup());
            mt = MethodType.methodType(cls, String.class, VectorEncoding.class);
            GET_FIELD_ENTRY_HANDLE_L99FLT = lookup.findVirtual(L99_FLT_VR_CLS, "getFieldEntry", mt);
            VECTOR_DATA_LENGTH_HANDLE_L99FLT = lookup.findVirtual(cls, "vectorDataLength", MethodType.methodType(Long.TYPE));
            cls = Class.forName("org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsReader$FieldEntry");
            lookup = MethodHandles.privateLookupIn(L99_HNSW_VR_CLS, MethodHandles.lookup());
            mt = MethodType.methodType(cls, String.class, VectorEncoding.class);
            GET_FIELD_ENTRY_HANDLE_L99HNSW = lookup.findVirtual(L99_HNSW_VR_CLS, "getFieldEntry", mt);
            GET_VECTOR_INDEX_LENGTH_HANDLE_L99HNSW = lookup.findVirtual(cls, "vectorIndexLength", MethodType.methodType(Long.TYPE));
            lookup = MethodHandles.privateLookupIn(L99_HNSW_VR_CLS, MethodHandles.lookup());
            FLAT_VECTORS_READER_HNDL_L99HNSW = lookup.findVarHandle(L99_HNSW_VR_CLS, "flatVectorsReader", FlatVectorsReader.class);
            cls = Class.forName("org.apache.lucene.backward_codecs.lucene90.Lucene90HnswVectorsReader$FieldEntry");
            lookup = MethodHandles.privateLookupIn(L90_HNSW_VR_CLS, MethodHandles.lookup());
            mt = MethodType.methodType(cls, String.class);
            GET_FIELD_ENTRY_HANDLE_L90HNSW = lookup.findVirtual(L90_HNSW_VR_CLS, "getFieldEntry", mt);
            GET_VECTOR_INDEX_LENGTH_HANDLE_L90HNSW = lookup.findVirtual(cls, "indexDataLength", MethodType.methodType(Long.TYPE));
            GET_VECTOR_DATA_LENGTH_HANDLE_L90HNSW = lookup.findVirtual(cls, "vectorDataLength", MethodType.methodType(Long.TYPE));
            cls = Class.forName("org.apache.lucene.backward_codecs.lucene91.Lucene91HnswVectorsReader$FieldEntry");
            lookup = MethodHandles.privateLookupIn(L91_HNSW_VR_CLS, MethodHandles.lookup());
            mt = MethodType.methodType(cls, String.class);
            GET_FIELD_ENTRY_HANDLE_L91HNSW = lookup.findVirtual(L91_HNSW_VR_CLS, "getFieldEntry", mt);
            GET_VECTOR_INDEX_LENGTH_HANDLE_L91HNSW = lookup.findVirtual(cls, "vectorIndexLength", MethodType.methodType(Long.TYPE));
            GET_VECTOR_DATA_LENGTH_HANDLE_L91HNSW = lookup.findVirtual(cls, "vectorDataLength", MethodType.methodType(Long.TYPE));
            cls = Class.forName("org.apache.lucene.backward_codecs.lucene92.Lucene92HnswVectorsReader$FieldEntry");
            lookup = MethodHandles.privateLookupIn(L92_HNSW_VR_CLS, MethodHandles.lookup());
            mt = MethodType.methodType(cls, String.class);
            GET_FIELD_ENTRY_HANDLE_L92HNSW = lookup.findVirtual(L92_HNSW_VR_CLS, "getFieldEntry", mt);
            GET_VECTOR_INDEX_LENGTH_HANDLE_L92HNSW = lookup.findVirtual(cls, "vectorIndexLength", MethodType.methodType(Long.TYPE));
            GET_VECTOR_DATA_LENGTH_HANDLE_L92HNSW = lookup.findVirtual(cls, "vectorDataLength", MethodType.methodType(Long.TYPE));
            cls = Class.forName("org.apache.lucene.backward_codecs.lucene94.Lucene94HnswVectorsReader$FieldEntry");
            lookup = MethodHandles.privateLookupIn(L94_HNSW_VR_CLS, MethodHandles.lookup());
            mt = MethodType.methodType(cls, String.class, VectorEncoding.class);
            GET_FIELD_ENTRY_HANDLE_L94HNSW = lookup.findVirtual(L94_HNSW_VR_CLS, "getFieldEntry", mt);
            GET_VECTOR_INDEX_LENGTH_HANDLE_L94HNSW = lookup.findVirtual(cls, "vectorIndexLength", MethodType.methodType(Long.TYPE));
            GET_VECTOR_DATA_LENGTH_HANDLE_L94HNSW = lookup.findVirtual(cls, "vectorDataLength", MethodType.methodType(Long.TYPE));
            cls = Class.forName("org.apache.lucene.backward_codecs.lucene95.Lucene95HnswVectorsReader$FieldEntry");
            lookup = MethodHandles.privateLookupIn(L95_HNSW_VR_CLS, MethodHandles.lookup());
            mt = MethodType.methodType(cls, String.class, VectorEncoding.class);
            GET_FIELD_ENTRY_HANDLE_L95HNSW = lookup.findVirtual(L95_HNSW_VR_CLS, "getFieldEntry", mt);
            GET_VECTOR_INDEX_LENGTH_HANDLE_L95HNSW = lookup.findVirtual(cls, "vectorIndexLength", MethodType.methodType(Long.TYPE));
            GET_VECTOR_DATA_LENGTH_HANDLE_L95HNSW = lookup.findVirtual(cls, "vectorDataLength", MethodType.methodType(Long.TYPE));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

