/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es818;

import java.io.IOException;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsReader;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.elasticsearch.index.codec.vectors.es818.DirectIOIndexInputSupplier;
import org.elasticsearch.index.codec.vectors.es818.DirectIOLucene99FlatVectorsReader;
import org.elasticsearch.index.codec.vectors.es818.ES818BinaryQuantizedVectorsFormat;
import org.elasticsearch.index.codec.vectors.es818.MergeReaderWrapper;
import org.elasticsearch.index.store.FsDirectoryFactory;

public class DirectIOLucene99FlatVectorsFormat
extends FlatVectorsFormat {
    static final String NAME = "Lucene99FlatVectorsFormat";
    static final String META_CODEC_NAME = "Lucene99FlatVectorsFormatMeta";
    static final String VECTOR_DATA_CODEC_NAME = "Lucene99FlatVectorsFormatData";
    static final String META_EXTENSION = "vemf";
    static final String VECTOR_DATA_EXTENSION = "vec";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;
    static final int DIRECT_MONOTONIC_BLOCK_SHIFT = 16;
    private final FlatVectorsScorer vectorsScorer;

    public DirectIOLucene99FlatVectorsFormat(FlatVectorsScorer vectorsScorer) {
        super(NAME);
        this.vectorsScorer = vectorsScorer;
    }

    public FlatVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new Lucene99FlatVectorsWriter(state, this.vectorsScorer);
    }

    static boolean shouldUseDirectIO(SegmentReadState state) {
        assert (ES818BinaryQuantizedVectorsFormat.USE_DIRECT_IO);
        return FsDirectoryFactory.isHybridFs(state.directory) && FilterDirectory.unwrap((Directory)state.directory) instanceof DirectIOIndexInputSupplier;
    }

    public FlatVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        if (DirectIOLucene99FlatVectorsFormat.shouldUseDirectIO(state) && state.context.context() == IOContext.Context.DEFAULT) {
            return new MergeReaderWrapper(new DirectIOLucene99FlatVectorsReader(state, this.vectorsScorer), (FlatVectorsReader)new Lucene99FlatVectorsReader(state, this.vectorsScorer));
        }
        return new Lucene99FlatVectorsReader(state, this.vectorsScorer);
    }

    public String toString() {
        return "ES818FlatVectorsFormat(vectorsScorer=" + String.valueOf(this.vectorsScorer) + ")";
    }
}

