/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.IOException;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.hnsw.FlatVectorScorerUtil;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsFormat;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.elasticsearch.index.codec.vectors.DefaultIVFVectorsReader;
import org.elasticsearch.index.codec.vectors.DefaultIVFVectorsWriter;

public class IVFVectorsFormat
extends KnnVectorsFormat {
    public static final String NAME = "IVFVectorsFormat";
    public static final String CENTROID_EXTENSION = "cenivf";
    public static final String CLUSTER_EXTENSION = "clivf";
    static final String IVF_META_EXTENSION = "mivf";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;
    private static final FlatVectorsFormat rawVectorFormat = new Lucene99FlatVectorsFormat(FlatVectorScorerUtil.getLucene99FlatVectorsScorer());
    public static final int DYNAMIC_NPROBE = -1;
    public static final int DEFAULT_VECTORS_PER_CLUSTER = 384;
    public static final int MIN_VECTORS_PER_CLUSTER = 64;
    public static final int MAX_VECTORS_PER_CLUSTER = 65536;
    private final int vectorPerCluster;

    public IVFVectorsFormat(int vectorPerCluster) {
        super(NAME);
        if (vectorPerCluster < 64 || vectorPerCluster > 65536) {
            throw new IllegalArgumentException("vectorsPerCluster must be between 64 and 65536, got: " + vectorPerCluster);
        }
        this.vectorPerCluster = vectorPerCluster;
    }

    public IVFVectorsFormat() {
        this(384);
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new DefaultIVFVectorsWriter(state, rawVectorFormat.fieldsWriter(state), this.vectorPerCluster);
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new DefaultIVFVectorsReader(state, rawVectorFormat.fieldsReader(state));
    }

    public int getMaxDimensions(String fieldName) {
        return 4096;
    }

    public String toString() {
        return "IVFVectorsFormat(vectorPerCluster=" + this.vectorPerCluster + ")";
    }
}

