/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.ModifyDataStreamsAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedBatchedClusterStateUpdateTask;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.SimpleBatchedAckListenerTaskExecutor;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAction;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetentionSettings;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.DataStreamOptions;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataCreateDataStreamService;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.MetadataMigrateToDataStreamService;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.snapshots.SnapshotInProgressException;
import org.elasticsearch.snapshots.SnapshotsService;

public class MetadataDataStreamsService {
    private static final Logger LOGGER = LogManager.getLogger(MetadataDataStreamsService.class);
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final DataStreamGlobalRetentionSettings globalRetentionSettings;
    private final MasterServiceTaskQueue<UpdateLifecycleTask> updateLifecycleTaskQueue;
    private final MasterServiceTaskQueue<SetRolloverOnWriteTask> setRolloverOnWriteTaskQueue;
    private final MasterServiceTaskQueue<UpdateOptionsTask> updateOptionsTaskQueue;
    private final MasterServiceTaskQueue<UpdateSettingsTask> updateSettingsTaskQueue;

    public MetadataDataStreamsService(ClusterService clusterService, IndicesService indicesService, DataStreamGlobalRetentionSettings globalRetentionSettings) {
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.globalRetentionSettings = globalRetentionSettings;
        SimpleBatchedAckListenerTaskExecutor<UpdateLifecycleTask> updateLifecycleExecutor = new SimpleBatchedAckListenerTaskExecutor<UpdateLifecycleTask>(){

            @Override
            public Tuple<ClusterState, ClusterStateAckListener> executeTask(UpdateLifecycleTask modifyLifecycleTask, ClusterState clusterState) {
                return new Tuple((Object)ClusterState.builder(clusterState).putProjectMetadata(MetadataDataStreamsService.this.updateDataLifecycle(clusterState.metadata().getProject(modifyLifecycleTask.getProjectId()), modifyLifecycleTask.getDataStreamNames(), modifyLifecycleTask.getDataLifecycle())).build(), (Object)modifyLifecycleTask);
            }
        };
        this.updateLifecycleTaskQueue = clusterService.createTaskQueue("modify-lifecycle", Priority.HIGH, updateLifecycleExecutor);
        SimpleBatchedAckListenerTaskExecutor<SetRolloverOnWriteTask> rolloverOnWriteExecutor = new SimpleBatchedAckListenerTaskExecutor<SetRolloverOnWriteTask>(this){

            @Override
            public Tuple<ClusterState, ClusterStateAckListener> executeTask(SetRolloverOnWriteTask setRolloverOnWriteTask, ClusterState clusterState) {
                return new Tuple((Object)MetadataDataStreamsService.setRolloverOnWrite(clusterState.projectState(setRolloverOnWriteTask.projectId()), setRolloverOnWriteTask.getDataStreamName(), setRolloverOnWriteTask.rolloverOnWrite(), setRolloverOnWriteTask.targetFailureStore()), (Object)setRolloverOnWriteTask);
            }
        };
        this.setRolloverOnWriteTaskQueue = clusterService.createTaskQueue("data-stream-rollover-on-write", Priority.NORMAL, rolloverOnWriteExecutor);
        SimpleBatchedAckListenerTaskExecutor<UpdateOptionsTask> updateOptionsExecutor = new SimpleBatchedAckListenerTaskExecutor<UpdateOptionsTask>(){

            @Override
            public Tuple<ClusterState, ClusterStateAckListener> executeTask(UpdateOptionsTask modifyOptionsTask, ClusterState clusterState) {
                return new Tuple((Object)ClusterState.builder(clusterState).putProjectMetadata(MetadataDataStreamsService.this.updateDataStreamOptions(clusterState.projectState(modifyOptionsTask.projectId).metadata(), modifyOptionsTask.getDataStreamNames(), modifyOptionsTask.getOptions())).build(), (Object)modifyOptionsTask);
            }
        };
        this.updateOptionsTaskQueue = clusterService.createTaskQueue("modify-data-stream-options", Priority.NORMAL, updateOptionsExecutor);
        SimpleBatchedAckListenerTaskExecutor<UpdateSettingsTask> updateSettingsExecutor = new SimpleBatchedAckListenerTaskExecutor<UpdateSettingsTask>(){

            @Override
            public Tuple<ClusterState, ClusterStateAckListener> executeTask(UpdateSettingsTask updateSettingsTask, ClusterState clusterState) throws Exception {
                DataStream dataStream = MetadataDataStreamsService.this.createDataStreamForUpdatedDataStreamSettings(updateSettingsTask.projectId, updateSettingsTask.dataStreamName, updateSettingsTask.settingsOverrides, clusterState);
                ProjectMetadata projectMetadata = clusterState.metadata().getProject(updateSettingsTask.projectId);
                ProjectMetadata.Builder projectMetadataBuilder = ProjectMetadata.builder(projectMetadata);
                projectMetadataBuilder.removeDataStream(updateSettingsTask.dataStreamName);
                projectMetadataBuilder.put(dataStream);
                ClusterState updatedClusterState = ClusterState.builder(clusterState).putProjectMetadata(projectMetadataBuilder).build();
                return new Tuple((Object)updatedClusterState, (Object)updateSettingsTask);
            }
        };
        this.updateSettingsTaskQueue = clusterService.createTaskQueue("update-data-stream-settings", Priority.NORMAL, updateSettingsExecutor);
    }

    public void modifyDataStream(final ProjectId projectId, final ModifyDataStreamsAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        if (request.getActions().size() == 0) {
            listener.onResponse(AcknowledgedResponse.TRUE);
        } else {
            this.submitUnbatchedTask("update-backing-indices", new AckedClusterStateUpdateTask(Priority.URGENT, request, listener){

                @Override
                public ClusterState execute(ClusterState currentState) {
                    ProjectMetadata project = MetadataDataStreamsService.modifyDataStream(currentState.metadata().getProject(projectId), request.getActions(), indexMetadata -> {
                        try {
                            return MetadataDataStreamsService.this.indicesService.createIndexMapperServiceForValidation((IndexMetadata)indexMetadata);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }, MetadataDataStreamsService.this.clusterService.getSettings());
                    return ClusterState.builder(currentState).putProjectMetadata(project).build();
                }
            });
        }
    }

    public void setLifecycle(ProjectId projectId, List<String> dataStreamNames, DataStreamLifecycle lifecycle, TimeValue ackTimeout, TimeValue masterTimeout, ActionListener<AcknowledgedResponse> listener) {
        this.updateLifecycleTaskQueue.submitTask("set-lifecycle", new UpdateLifecycleTask(projectId, dataStreamNames, lifecycle, ackTimeout, listener), masterTimeout);
    }

    public void removeLifecycle(ProjectId projectId, List<String> dataStreamNames, TimeValue ackTimeout, TimeValue masterTimeout, ActionListener<AcknowledgedResponse> listener) {
        this.updateLifecycleTaskQueue.submitTask("delete-lifecycle", new UpdateLifecycleTask(projectId, dataStreamNames, null, ackTimeout, listener), masterTimeout);
    }

    public void setDataStreamOptions(ProjectId projectId, List<String> dataStreamNames, DataStreamOptions options, TimeValue ackTimeout, TimeValue masterTimeout, ActionListener<AcknowledgedResponse> listener) {
        this.updateOptionsTaskQueue.submitTask("set-data-stream-options", new UpdateOptionsTask(projectId, dataStreamNames, options, ackTimeout, listener), masterTimeout);
    }

    public void removeDataStreamOptions(ProjectId projectId, List<String> dataStreamNames, TimeValue ackTimeout, TimeValue masterTimeout, ActionListener<AcknowledgedResponse> listener) {
        this.updateOptionsTaskQueue.submitTask("delete-data-stream-options", new UpdateOptionsTask(projectId, dataStreamNames, null, ackTimeout, listener), masterTimeout);
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    public void setRolloverOnWrite(ProjectId projectId, String dataStreamName, boolean rolloverOnWrite, boolean targetFailureStore, TimeValue ackTimeout, TimeValue masterTimeout, ActionListener<AcknowledgedResponse> listener) {
        this.setRolloverOnWriteTaskQueue.submitTask("set-rollover-on-write", new SetRolloverOnWriteTask(projectId, dataStreamName, rolloverOnWrite, targetFailureStore, ackTimeout, listener), masterTimeout);
    }

    static ProjectMetadata modifyDataStream(ProjectMetadata currentProject, Iterable<DataStreamAction> actions, Function<IndexMetadata, MapperService> mapperSupplier, Settings nodeSettings) {
        ProjectMetadata updatedProject = currentProject;
        for (DataStreamAction action : actions) {
            ProjectMetadata.Builder builder = ProjectMetadata.builder(updatedProject);
            if (action.getType() == DataStreamAction.Type.ADD_BACKING_INDEX) {
                MetadataDataStreamsService.addBackingIndex(updatedProject, builder, mapperSupplier, action.getDataStream(), action.getIndex(), action.isFailureStore(), nodeSettings);
            } else if (action.getType() == DataStreamAction.Type.REMOVE_BACKING_INDEX) {
                MetadataDataStreamsService.removeBackingIndex(updatedProject, builder, action.getDataStream(), action.getIndex(), action.isFailureStore());
            } else {
                throw new IllegalStateException("unsupported data stream action type [" + action.getClass().getName() + "]");
            }
            updatedProject = builder.build();
        }
        return updatedProject;
    }

    ProjectMetadata updateDataLifecycle(ProjectMetadata project, List<String> dataStreamNames, @Nullable DataStreamLifecycle lifecycle) {
        ProjectMetadata.Builder builder = ProjectMetadata.builder(project);
        boolean onlyInternalDataStreams = true;
        for (String dataStreamName : dataStreamNames) {
            DataStream dataStream = MetadataDataStreamsService.validateDataStream(project, dataStreamName);
            builder.put(dataStream.copy().setLifecycle(lifecycle).build());
            onlyInternalDataStreams = onlyInternalDataStreams && dataStream.isInternal();
        }
        if (lifecycle != null) {
            lifecycle.addWarningHeaderIfDataRetentionNotEffective(this.globalRetentionSettings.get(false), onlyInternalDataStreams);
        }
        return builder.build();
    }

    ProjectMetadata updateDataStreamOptions(ProjectMetadata project, List<String> dataStreamNames, @Nullable DataStreamOptions dataStreamOptions) {
        ProjectMetadata.Builder builder = ProjectMetadata.builder(project);
        boolean onlyInternalDataStreams = true;
        for (String dataStreamName : dataStreamNames) {
            DataStream dataStream = MetadataDataStreamsService.validateDataStream(project, dataStreamName);
            builder.put(dataStream.copy().setDataStreamOptions(dataStreamOptions).build());
            onlyInternalDataStreams = onlyInternalDataStreams && dataStream.isInternal();
        }
        if (dataStreamOptions != null && dataStreamOptions.failureStore() != null && dataStreamOptions.failureStore().lifecycle() != null) {
            dataStreamOptions.failureStore().lifecycle().addWarningHeaderIfDataRetentionNotEffective(this.globalRetentionSettings.get(true), onlyInternalDataStreams);
        }
        return builder.build();
    }

    public static ClusterState setRolloverOnWrite(ProjectState currentState, String dataStreamName, boolean rolloverOnWrite, boolean targetFailureStore) {
        ProjectMetadata metadata = currentState.metadata();
        DataStream dataStream = MetadataDataStreamsService.validateDataStream(metadata, dataStreamName);
        DataStream.DataStreamIndices indices = dataStream.getDataStreamIndices(targetFailureStore);
        if (indices.isRolloverOnWrite() == rolloverOnWrite) {
            return currentState.cluster();
        }
        return currentState.updatedState(builder -> builder.put(dataStream.copy().setDataStreamIndices(targetFailureStore, indices.copy().setRolloverOnWrite(rolloverOnWrite).build()).build()));
    }

    public void updateSettings(ProjectId projectId, TimeValue masterNodeTimeout, TimeValue ackTimeout, String dataStreamName, Settings settingsOverrides, boolean dryRun, ActionListener<DataStream> listener) {
        if (dryRun) {
            try {
                DataStream updatedDataStream = this.createDataStreamForUpdatedDataStreamSettings(projectId, dataStreamName, settingsOverrides, this.clusterService.state());
                listener.onResponse(updatedDataStream);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        } else {
            UpdateSettingsTask updateSettingsTask = new UpdateSettingsTask(projectId, dataStreamName, settingsOverrides, this.clusterService, ackTimeout, listener);
            this.updateSettingsTaskQueue.submitTask("updating settings on data stream", updateSettingsTask, masterNodeTimeout);
        }
    }

    private DataStream createDataStreamForUpdatedDataStreamSettings(ProjectId projectId, String dataStreamName, Settings settingsOverrides, ClusterState clusterState) throws Exception {
        ProjectMetadata projectMetadata = clusterState.metadata().getProject(projectId);
        Map<String, DataStream> dataStreamMap = projectMetadata.dataStreams();
        DataStream dataStream = dataStreamMap.get(dataStreamName);
        Settings existingDataStreamSettings = dataStream.getSettings();
        Settings.Builder mergedSettingsBuilder = Settings.builder().put(existingDataStreamSettings).put(settingsOverrides);
        settingsOverrides.keySet().forEach(key -> {
            if (mergedSettingsBuilder.get((String)key) == null) {
                mergedSettingsBuilder.remove((String)key);
            }
        });
        Settings mergedDataStreamSettings = mergedSettingsBuilder.build();
        ComposableIndexTemplate template = MetadataCreateDataStreamService.lookupTemplateForDataStream(dataStreamName, projectMetadata);
        Settings templateSettings = MetadataIndexTemplateService.resolveSettings(template, projectMetadata.componentTemplates());
        Settings mergedEffectiveSettings = templateSettings.merge(mergedDataStreamSettings);
        MetadataIndexTemplateService.validateTemplate(mergedEffectiveSettings, ComposableIndexTemplate.EMPTY_MAPPINGS, this.indicesService);
        return dataStream.copy().setSettings(mergedDataStreamSettings).build();
    }

    private static void addBackingIndex(ProjectMetadata project, ProjectMetadata.Builder builder, Function<IndexMetadata, MapperService> mapperSupplier, String dataStreamName, String indexName, boolean failureStore, Settings nodeSettings) {
        DataStream dataStream = MetadataDataStreamsService.validateDataStream(project, dataStreamName);
        IndexAbstraction index = MetadataDataStreamsService.validateIndex(project, indexName);
        try {
            MetadataMigrateToDataStreamService.prepareBackingIndex(builder, project.index(index.getWriteIndex()), dataStreamName, mapperSupplier, false, failureStore, dataStream.isSystem(), nodeSettings);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to prepare backing index", e);
        }
        if (failureStore) {
            builder.put(dataStream.addFailureStoreIndex(project, index.getWriteIndex()));
        } else {
            builder.put(dataStream.addBackingIndex(project, index.getWriteIndex()));
        }
    }

    private static void removeBackingIndex(ProjectMetadata project, ProjectMetadata.Builder builder, String dataStreamName, String indexName, boolean failureStore) {
        boolean indexNotRemoved = true;
        DataStream dataStream = MetadataDataStreamsService.validateDataStream(project, dataStreamName);
        List<Index> targetIndices = failureStore ? dataStream.getFailureIndices() : dataStream.getIndices();
        for (Index backingIndex : targetIndices) {
            if (!backingIndex.getName().equals(indexName)) continue;
            if (failureStore) {
                builder.put(dataStream.removeFailureStoreIndex(backingIndex));
            } else {
                builder.put(dataStream.removeBackingIndex(backingIndex));
            }
            indexNotRemoved = false;
            break;
        }
        if (indexNotRemoved) {
            throw new IllegalArgumentException("index [" + indexName + "] not found");
        }
        IndexMetadata indexMetadata = builder.get(indexName);
        if (indexMetadata != null) {
            builder.put(IndexMetadata.builder(indexMetadata).settings(Settings.builder().put(indexMetadata.getSettings()).put("index.hidden", "false").build()).settingsVersion(indexMetadata.getSettingsVersion() + 1L));
        }
    }

    private static DataStream validateDataStream(ProjectMetadata project, String dataStreamName) {
        IndexAbstraction dataStream = (IndexAbstraction)project.getIndicesLookup().get(dataStreamName);
        if (dataStream == null || dataStream.getType() != IndexAbstraction.Type.DATA_STREAM) {
            throw new IllegalArgumentException("data stream [" + dataStreamName + "] not found");
        }
        return (DataStream)dataStream;
    }

    private static IndexAbstraction validateIndex(ProjectMetadata project, String indexName) {
        IndexAbstraction index = (IndexAbstraction)project.getIndicesLookup().get(indexName);
        if (index == null || index.getType() != IndexAbstraction.Type.CONCRETE_INDEX) {
            throw new IllegalArgumentException("index [" + indexName + "] not found");
        }
        return index;
    }

    public static ClusterState deleteDataStreams(ProjectState projectState, Set<DataStream> dataStreams, Settings settings) {
        if (dataStreams.isEmpty()) {
            return projectState.cluster();
        }
        Set<String> dataStreamNames = dataStreams.stream().map(DataStream::getName).collect(Collectors.toSet());
        Set<String> snapshottingDataStreams = SnapshotsService.snapshottingDataStreams(projectState, dataStreamNames);
        if (!snapshottingDataStreams.isEmpty()) {
            throw new SnapshotInProgressException("Cannot delete data streams that are being snapshotted: [" + String.join((CharSequence)", ", snapshottingDataStreams) + "]. Try again after snapshot finishes or cancel the currently running snapshot.");
        }
        HashSet<Index> backingIndicesToRemove = new HashSet<Index>();
        for (DataStream dataStream : dataStreams) {
            assert (dataStream != null);
            if (projectState.metadata().dataStreams().get(dataStream.getName()) == null) {
                throw new ResourceNotFoundException("data stream [" + dataStream.getName() + "] not found", new Object[0]);
            }
            backingIndicesToRemove.addAll(dataStream.getIndices());
            backingIndicesToRemove.addAll(dataStream.getFailureIndices());
        }
        ClusterState newState = projectState.updatedState(builder -> {
            for (DataStream ds : dataStreams) {
                LOGGER.info("removing data stream [{}]", new Object[]{ds.getName()});
                builder.removeDataStream(ds.getName());
            }
        });
        return MetadataDeleteIndexService.deleteIndices(newState.projectState(projectState.projectId()), backingIndicesToRemove, settings);
    }

    static class UpdateLifecycleTask
    extends AckedBatchedClusterStateUpdateTask {
        private final ProjectId projectId;
        private final List<String> dataStreamNames;
        private final DataStreamLifecycle lifecycle;

        UpdateLifecycleTask(ProjectId projectId, List<String> dataStreamNames, @Nullable DataStreamLifecycle lifecycle, TimeValue ackTimeout, ActionListener<AcknowledgedResponse> listener) {
            super(ackTimeout, listener);
            this.projectId = projectId;
            this.dataStreamNames = dataStreamNames;
            this.lifecycle = lifecycle;
        }

        public ProjectId getProjectId() {
            return this.projectId;
        }

        public List<String> getDataStreamNames() {
            return this.dataStreamNames;
        }

        public DataStreamLifecycle getDataLifecycle() {
            return this.lifecycle;
        }
    }

    static class UpdateOptionsTask
    extends AckedBatchedClusterStateUpdateTask {
        ProjectId projectId;
        private final List<String> dataStreamNames;
        private final DataStreamOptions options;

        UpdateOptionsTask(ProjectId projectId, List<String> dataStreamNames, @Nullable DataStreamOptions options, TimeValue ackTimeout, ActionListener<AcknowledgedResponse> listener) {
            super(ackTimeout, listener);
            this.projectId = projectId;
            this.dataStreamNames = dataStreamNames;
            this.options = options;
        }

        public ProjectId getProjectId() {
            return this.projectId;
        }

        public List<String> getDataStreamNames() {
            return this.dataStreamNames;
        }

        public DataStreamOptions getOptions() {
            return this.options;
        }
    }

    static class SetRolloverOnWriteTask
    extends AckedBatchedClusterStateUpdateTask {
        private final ProjectId projectId;
        private final String dataStreamName;
        private final boolean rolloverOnWrite;
        private final boolean targetFailureStore;

        SetRolloverOnWriteTask(ProjectId projectId, String dataStreamName, boolean rolloverOnWrite, boolean targetFailureStore, TimeValue ackTimeout, ActionListener<AcknowledgedResponse> listener) {
            super(ackTimeout, listener);
            this.projectId = projectId;
            this.dataStreamName = dataStreamName;
            this.rolloverOnWrite = rolloverOnWrite;
            this.targetFailureStore = targetFailureStore;
        }

        public ProjectId projectId() {
            return this.projectId;
        }

        public String getDataStreamName() {
            return this.dataStreamName;
        }

        public boolean rolloverOnWrite() {
            return this.rolloverOnWrite;
        }

        public boolean targetFailureStore() {
            return this.targetFailureStore;
        }
    }

    static class UpdateSettingsTask
    extends AckedBatchedClusterStateUpdateTask {
        final ProjectId projectId;
        private final String dataStreamName;
        private final Settings settingsOverrides;

        UpdateSettingsTask(ProjectId projectId, String dataStreamName, Settings settingsOverrides, ClusterService clusterService, TimeValue ackTimeout, ActionListener<DataStream> listener) {
            super(ackTimeout, listener.safeMap(response -> {
                if (response.isAcknowledged()) {
                    return clusterService.state().projectState(projectId).metadata().dataStreams().get(dataStreamName);
                }
                throw new ElasticsearchException("Updating settings not accepted for unknown reasons", new Object[0]);
            }));
            this.projectId = projectId;
            this.dataStreamName = dataStreamName;
            this.settingsOverrides = settingsOverrides;
        }
    }
}

