/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiffable;
import org.elasticsearch.cluster.NamedDiffableValueSerializer;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.DataStreamMetadata;
import org.elasticsearch.cluster.metadata.DiffableStringMap;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.persistent.ClusterPersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.NamedObjectNotFoundException;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public class Metadata
implements Diffable<Metadata>,
ChunkedToXContent {
    private static final Logger logger = LogManager.getLogger(Metadata.class);
    public static final Runnable ON_NEXT_INDEX_FIND_MAPPINGS_NOOP = () -> {};
    public static final String ALL = "_all";
    public static final String UNKNOWN_CLUSTER_UUID = "_na_";
    public static final ProjectId DEFAULT_PROJECT_ID = ProjectId.DEFAULT;
    public static final EnumSet<XContentContext> API_ONLY = EnumSet.of(XContentContext.API);
    public static final EnumSet<XContentContext> API_AND_GATEWAY = EnumSet.of(XContentContext.API, XContentContext.GATEWAY);
    public static final EnumSet<XContentContext> API_AND_SNAPSHOT = EnumSet.of(XContentContext.API, XContentContext.SNAPSHOT);
    public static final EnumSet<XContentContext> ALL_CONTEXTS = EnumSet.allOf(XContentContext.class);
    public static final Setting<Boolean> SETTING_READ_ONLY_SETTING = Setting.boolSetting("cluster.blocks.read_only", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ClusterBlock CLUSTER_READ_ONLY_BLOCK = new ClusterBlock(6, "cluster read-only (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final Setting<Boolean> SETTING_READ_ONLY_ALLOW_DELETE_SETTING = Setting.boolSetting("cluster.blocks.read_only_allow_delete", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ClusterBlock CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK = new ClusterBlock(13, "cluster read-only / allow delete (api)", false, false, true, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final Metadata EMPTY_METADATA = Metadata.builder().build();
    public static final String CONTEXT_MODE_PARAM = "context_mode";
    public static final String CONTEXT_MODE_SNAPSHOT = XContentContext.SNAPSHOT.toString();
    public static final String CONTEXT_MODE_GATEWAY = XContentContext.GATEWAY.toString();
    public static final String CONTEXT_MODE_API = XContentContext.API.toString();
    public static final String DEDUPLICATED_MAPPINGS_PARAM = "deduplicated_mappings";
    public static final String GLOBAL_STATE_FILE_PREFIX = "global-";
    private static final NamedDiffableValueSerializer<ClusterCustom> CLUSTER_CUSTOM_VALUE_SERIALIZER = new NamedDiffableValueSerializer<ClusterCustom>(ClusterCustom.class);
    private static final NamedDiffableValueSerializer<ProjectCustom> PROJECT_CUSTOM_VALUE_SERIALIZER = new NamedDiffableValueSerializer<ProjectCustom>(ProjectCustom.class);
    private static final NamedDiffableValueSerializer BWC_CUSTOM_VALUE_SERIALIZER = new NamedDiffableValueSerializer(MetadataCustom.class){

        @Override
        public MetadataCustom read(StreamInput in, String key) throws IOException {
            Set<String> clusterScopedNames = in.namedWriteableRegistry().getReaders(ClusterCustom.class).keySet();
            Set<String> projectScopedNames = in.namedWriteableRegistry().getReaders(ProjectCustom.class).keySet();
            if (clusterScopedNames.contains(key)) {
                return in.readNamedWriteable(ClusterCustom.class, key);
            }
            if (projectScopedNames.contains(key)) {
                return in.readNamedWriteable(ProjectCustom.class, key);
            }
            throw new IllegalArgumentException("Unknown custom name [" + key + "]");
        }
    };
    private final String clusterUUID;
    private final boolean clusterUUIDCommitted;
    private final long version;
    private final CoordinationMetadata coordinationMetadata;
    private final Map<ProjectId, ProjectMetadata> projectMetadata;
    private final Settings transientSettings;
    private final Settings persistentSettings;
    private final Settings settings;
    private final DiffableStringMap hashesOfConsistentSettings;
    private final ImmutableOpenMap<String, ClusterCustom> customs;
    private final ImmutableOpenMap<String, ReservedStateMetadata> reservedStateMetadata;
    private static final DiffableUtils.KeySerializer<ProjectId> PROJECT_ID_SERIALIZER = DiffableUtils.getWriteableKeySerializer(ProjectId.READER);
    private volatile ProjectLookup projectLookup = null;

    private Metadata(String clusterUUID, boolean clusterUUIDCommitted, long version, CoordinationMetadata coordinationMetadata, Map<ProjectId, ProjectMetadata> projectMetadata, Settings transientSettings, Settings persistentSettings, Settings settings, DiffableStringMap hashesOfConsistentSettings, ImmutableOpenMap<String, ClusterCustom> customs, ImmutableOpenMap<String, ReservedStateMetadata> reservedStateMetadata) {
        this.clusterUUID = clusterUUID;
        this.clusterUUIDCommitted = clusterUUIDCommitted;
        this.version = version;
        this.coordinationMetadata = coordinationMetadata;
        this.projectMetadata = projectMetadata;
        this.transientSettings = transientSettings;
        this.persistentSettings = persistentSettings;
        this.settings = settings;
        this.hashesOfConsistentSettings = hashesOfConsistentSettings;
        this.customs = customs;
        this.reservedStateMetadata = reservedStateMetadata;
    }

    private boolean isSingleProject() {
        return this.projectMetadata.size() == 1 && this.projectMetadata.containsKey(DEFAULT_PROJECT_ID);
    }

    private ProjectMetadata getSingleProject() {
        if (this.projectMetadata.isEmpty()) {
            throw new UnsupportedOperationException("There are no projects");
        }
        if (this.projectMetadata.size() != 1) {
            throw new MultiProjectPendingException("There are multiple projects " + String.valueOf(this.projectMetadata.keySet()));
        }
        ProjectMetadata defaultProject = this.projectMetadata.get(DEFAULT_PROJECT_ID);
        if (defaultProject == null) {
            throw new UnsupportedOperationException("There is 1 project, but it has id " + String.valueOf(this.projectMetadata.keySet()) + " rather than " + String.valueOf(DEFAULT_PROJECT_ID));
        }
        return defaultProject;
    }

    public Metadata withIncrementedVersion() {
        return new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version + 1L, this.coordinationMetadata, this.projectMetadata, this.transientSettings, this.persistentSettings, this.settings, this.hashesOfConsistentSettings, this.customs, this.reservedStateMetadata);
    }

    public Metadata withLifecycleState(Index index, LifecycleExecutionState lifecycleState) {
        return this.updateSingleProject(project -> project.withLifecycleState(index, lifecycleState));
    }

    public Metadata withCoordinationMetadata(CoordinationMetadata coordinationMetadata) {
        return new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version, coordinationMetadata, this.projectMetadata, this.transientSettings, this.persistentSettings, this.settings, this.hashesOfConsistentSettings, this.customs, this.reservedStateMetadata);
    }

    public Metadata withLastCommittedValues(boolean clusterUUIDCommitted, CoordinationMetadata.VotingConfiguration lastCommittedConfiguration) {
        if (clusterUUIDCommitted == this.clusterUUIDCommitted && lastCommittedConfiguration.equals(this.coordinationMetadata.getLastCommittedConfiguration())) {
            return this;
        }
        return new Metadata(this.clusterUUID, clusterUUIDCommitted, this.version, CoordinationMetadata.builder(this.coordinationMetadata).lastCommittedConfiguration(lastCommittedConfiguration).build(), this.projectMetadata, this.transientSettings, this.persistentSettings, this.settings, this.hashesOfConsistentSettings, this.customs, this.reservedStateMetadata);
    }

    public Metadata withAddedIndex(IndexMetadata index) {
        return this.updateSingleProject(project -> project.withAddedIndex(index));
    }

    private Metadata updateSingleProject(Function<ProjectMetadata, ProjectMetadata> update) {
        if (this.projectMetadata.size() == 1) {
            Map.Entry<ProjectId, ProjectMetadata> entry = this.projectMetadata.entrySet().iterator().next();
            ProjectMetadata newProject = update.apply(entry.getValue());
            return newProject == entry.getValue() ? this : new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version, this.coordinationMetadata, Map.of(entry.getKey(), newProject), this.transientSettings, this.persistentSettings, this.settings, this.hashesOfConsistentSettings, this.customs, this.reservedStateMetadata);
        }
        throw new MultiProjectPendingException("There are multiple projects " + String.valueOf(this.projectMetadata.keySet()));
    }

    public Metadata withUpdatedProject(ProjectMetadata updatedProject) {
        Map<ProjectId, ProjectMetadata> updatedMap;
        ProjectMetadata existingProject = this.projectMetadata.get(updatedProject.id());
        if (existingProject == null) {
            throw new IllegalArgumentException("Can only update existing project, cannot add a new project [" + String.valueOf(updatedProject.id()) + "]. Use the builder instead");
        }
        if (updatedProject == existingProject) {
            return this;
        }
        if (this.projects().size() == 1) {
            updatedMap = Map.of(updatedProject.id(), updatedProject);
        } else {
            HashMap<ProjectId, ProjectMetadata> hashMap = new HashMap<ProjectId, ProjectMetadata>(this.projectMetadata);
            hashMap.put(updatedProject.id(), updatedProject);
            updatedMap = Collections.unmodifiableMap(hashMap);
        }
        return new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version, this.coordinationMetadata, updatedMap, this.transientSettings, this.persistentSettings, this.settings, this.hashesOfConsistentSettings, this.customs, this.reservedStateMetadata);
    }

    public long version() {
        return this.version;
    }

    public String clusterUUID() {
        return this.clusterUUID;
    }

    public boolean clusterUUIDCommitted() {
        return this.clusterUUIDCommitted;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings transientSettings() {
        return this.transientSettings;
    }

    public Settings persistentSettings() {
        return this.persistentSettings;
    }

    public Map<String, String> hashesOfConsistentSettings() {
        return this.hashesOfConsistentSettings;
    }

    public CoordinationMetadata coordinationMetadata() {
        return this.coordinationMetadata;
    }

    public Map<ProjectId, ProjectMetadata> projects() {
        return this.projectMetadata;
    }

    public Iterable<IndexMetadata> indicesAllProjects() {
        return () -> Iterators.flatMap(this.projectMetadata.values().iterator(), ProjectMetadata::iterator);
    }

    @Deprecated(forRemoval=true)
    public ProjectMetadata getProject() {
        return this.getSingleProject();
    }

    @Deprecated(forRemoval=true)
    public ProjectMetadata getDefaultProject() {
        return this.getProject(DEFAULT_PROJECT_ID);
    }

    public boolean hasProject(ProjectId projectId) {
        return this.projectMetadata.containsKey(projectId);
    }

    public ProjectMetadata getProject(ProjectId projectId) {
        ProjectMetadata metadata = this.projectMetadata.get(projectId);
        if (metadata == null) {
            throw new IllegalArgumentException("project [" + String.valueOf(projectId) + "] not found in metadata version [" + this.version() + "]");
        }
        return metadata;
    }

    public int getTotalOpenIndexShards() {
        int shards = 0;
        for (ProjectMetadata project : this.projects().values()) {
            shards += project.getTotalOpenIndexShards();
        }
        return shards;
    }

    @Nullable
    public <T extends ProjectCustom> T getSingleProjectCustom(String type) {
        ProjectMetadata project = this.getSingleProjectWithCustom(type);
        return project == null ? null : (T)project.custom(type);
    }

    @Nullable
    public ProjectMetadata getSingleProjectWithCustom(String type) {
        ProjectMetadata resultingProject = null;
        for (ProjectMetadata project : this.projects().values()) {
            Object projectCustom = project.custom(type);
            if (projectCustom == null) continue;
            if (resultingProject != null) {
                throw new UnsupportedOperationException("Multiple custom projects found for type [" + type + "]");
            }
            resultingProject = project;
        }
        return resultingProject;
    }

    public int getTotalNumberOfShards() {
        int shards = 0;
        for (ProjectMetadata project : this.projects().values()) {
            shards += project.getTotalNumberOfShards();
        }
        return shards;
    }

    public int getTotalNumberOfIndices() {
        int indexCount = 0;
        for (ProjectMetadata project : this.projects().values()) {
            indexCount += project.indices().size();
        }
        return indexCount;
    }

    public boolean hasAnyIndices() {
        for (ProjectMetadata project : this.projects().values()) {
            if (project.indices().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public IndexVersion oldestIndexVersionAllProjects() {
        IndexVersion oldest = IndexVersion.current();
        for (ProjectMetadata projectMetadata : this.projectMetadata.values()) {
            if (oldest.compareTo(projectMetadata.oldestIndexVersion()) <= 0) continue;
            oldest = projectMetadata.oldestIndexVersion();
        }
        return oldest;
    }

    public NodesShutdownMetadata nodeShutdowns() {
        return this.custom("node_shutdown", NodesShutdownMetadata.EMPTY);
    }

    public ImmutableOpenMap<String, ClusterCustom> customs() {
        return this.customs;
    }

    public Map<String, ReservedStateMetadata> reservedStateMetadata() {
        return this.reservedStateMetadata;
    }

    public <T extends ClusterCustom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public <T extends ClusterCustom> T custom(String type, T defaultValue) {
        return (T)this.customs.getOrDefault((Object)type, defaultValue);
    }

    public static boolean isGlobalStateEquals(Metadata metadata1, Metadata metadata2) {
        if (!metadata1.coordinationMetadata.equals(metadata2.coordinationMetadata)) {
            return false;
        }
        if (!metadata1.persistentSettings.equals(metadata2.persistentSettings)) {
            return false;
        }
        if (!metadata1.hashesOfConsistentSettings.equals(metadata2.hashesOfConsistentSettings)) {
            return false;
        }
        if (!metadata1.clusterUUID.equals(metadata2.clusterUUID)) {
            return false;
        }
        if (metadata1.clusterUUIDCommitted != metadata2.clusterUUIDCommitted) {
            return false;
        }
        if (!Metadata.customsEqual(metadata1.customs, metadata2.customs)) {
            return false;
        }
        if (!Objects.equals(metadata1.reservedStateMetadata, metadata2.reservedStateMetadata)) {
            return false;
        }
        return Metadata.projectMetadataEqual(metadata1.projectMetadata, metadata2.projectMetadata);
    }

    static <C extends MetadataCustom<C>> boolean customsEqual(Map<String, C> customs1, Map<String, C> customs2) {
        int customCount1 = 0;
        for (Map.Entry<String, C> cursor : customs1.entrySet()) {
            if (!((MetadataCustom)cursor.getValue()).context().contains((Object)XContentContext.GATEWAY)) continue;
            if (!((MetadataCustom)cursor.getValue()).equals(customs2.get(cursor.getKey()))) {
                return false;
            }
            ++customCount1;
        }
        int customCount2 = 0;
        for (MetadataCustom custom : customs2.values()) {
            if (!custom.context().contains((Object)XContentContext.GATEWAY)) continue;
            ++customCount2;
        }
        return customCount1 == customCount2;
    }

    private static boolean projectMetadataEqual(Map<ProjectId, ProjectMetadata> projectMetadata1, Map<ProjectId, ProjectMetadata> projectMetadata2) {
        if (projectMetadata1.size() != projectMetadata2.size()) {
            return false;
        }
        for (ProjectMetadata project1 : projectMetadata1.values()) {
            ProjectMetadata project2 = projectMetadata2.get(project1.id());
            if (project2 == null) {
                return false;
            }
            if (ProjectMetadata.isStateEquals(project1, project2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Diff<Metadata> diff(Metadata previousState) {
        return new MetadataDiff(previousState, this);
    }

    public static Diff<Metadata> readDiffFrom(StreamInput in) throws IOException {
        return in.readBoolean() ? SimpleDiffable.empty() : new MetadataDiff(in);
    }

    public static Metadata fromXContent(XContentParser parser) throws IOException {
        return Builder.fromXContent(parser);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params p) {
        XContentContext context = XContentContext.from(p);
        Iterator<ToXContent> start = context == XContentContext.API ? ChunkedToXContentHelper.startObject("metadata") : Iterators.single((builder, params) -> builder.startObject("meta-data").field("version", this.version()));
        Iterator<ToXContent> clusterCoordination = Iterators.single((builder, params) -> {
            builder.field("cluster_uuid", this.clusterUUID);
            builder.field("cluster_uuid_committed", this.clusterUUIDCommitted);
            builder.startObject("cluster_coordination");
            this.coordinationMetadata().toXContent(builder, params);
            return builder.endObject();
        });
        Iterator persistentSettings = context != XContentContext.API && !this.persistentSettings().isEmpty() ? Iterators.single((builder, params) -> {
            builder.startObject("settings");
            this.persistentSettings().toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
            return builder.endObject();
        }) : Collections.emptyIterator();
        boolean multiProject = p.paramAsBoolean("multi-project", false);
        if (multiProject) {
            return this.toXContentChunkedWithMultiProjectFormat(p, context, start, clusterCoordination, persistentSettings);
        }
        return this.toXContentChunkedWithSingleProjectFormat(p, context, start, clusterCoordination, persistentSettings);
    }

    private Iterator<? extends ToXContent> toXContentChunkedWithMultiProjectFormat(ToXContent.Params p, XContentContext context, Iterator<? extends ToXContent> start, Iterator<? extends ToXContent> clusterCoordination, Iterator<? extends ToXContent> persistentSettings) {
        return Iterators.concat(start, clusterCoordination, persistentSettings, ChunkedToXContentHelper.array("projects", Iterators.flatMap(this.projectMetadata.entrySet().iterator(), e -> Iterators.concat(ChunkedToXContentHelper.startObject(), Iterators.single((builder, params) -> builder.field("id", (ToXContent)e.getKey())), ((ProjectMetadata)e.getValue()).toXContentChunked(p), ChunkedToXContentHelper.endObject()))), Iterators.flatMap(this.customs.entrySet().iterator(), entry -> ((ClusterCustom)entry.getValue()).context().contains((Object)context) ? ChunkedToXContentHelper.object((String)entry.getKey(), ((ClusterCustom)entry.getValue()).toXContentChunked(p)) : Collections.emptyIterator()), ChunkedToXContentHelper.object("reserved_state", this.reservedStateMetadata().values().iterator()), ChunkedToXContentHelper.endObject());
    }

    private Iterator<? extends ToXContent> toXContentChunkedWithSingleProjectFormat(ToXContent.Params p, XContentContext context, Iterator<? extends ToXContent> start, Iterator<? extends ToXContent> clusterCoordination, Iterator<? extends ToXContent> persistentSettings) {
        if (this.projectMetadata.size() != 1) {
            throw new MultiProjectPendingException("There are multiple projects " + String.valueOf(this.projectMetadata.keySet()));
        }
        ProjectMetadata project = this.projectMetadata.values().iterator().next();
        TreeMap<String, ReservedStateMetadata> clusterReservedState = new TreeMap<String, ReservedStateMetadata>(this.reservedStateMetadata);
        clusterReservedState.putAll(project.reservedStateMetadata());
        Iterator<Object> customs = Iterators.flatMap(this.customs().entrySet().iterator(), entry -> {
            if (((ClusterCustom)entry.getValue()).context().contains((Object)context) && !"cluster_persistent_tasks".equals(entry.getKey())) {
                return ChunkedToXContentHelper.object((String)entry.getKey(), ((ClusterCustom)entry.getValue()).toXContentChunked(p));
            }
            return Collections.emptyIterator();
        });
        PersistentTasksCustomMetadata combinedTasks = PersistentTasksCustomMetadata.combine(ClusterPersistentTasksCustomMetadata.get(this), PersistentTasksCustomMetadata.get(project));
        if (combinedTasks != null) {
            customs = Iterators.concat(customs, ChunkedToXContentHelper.object("persistent_tasks", combinedTasks.toXContentChunked(p)));
        }
        return Iterators.concat(start, clusterCoordination, persistentSettings, project.toXContentChunked(p), customs, ChunkedToXContentHelper.object("reserved_state", clusterReservedState.values().iterator()), ChunkedToXContentHelper.endObject());
    }

    public static Metadata readFrom(StreamInput in) throws IOException {
        Builder builder = new Builder();
        builder.version(in.readLong());
        builder.clusterUUID(in.readString());
        builder.clusterUUIDCommitted(in.readBoolean());
        builder.coordinationMetadata(new CoordinationMetadata(in));
        builder.transientSettings(Settings.readSettingsFromStream(in));
        builder.persistentSettings(Settings.readSettingsFromStream(in));
        builder.hashesOfConsistentSettings(DiffableStringMap.readFrom(in));
        if (in.getTransportVersion().before(TransportVersions.MULTI_PROJECT)) {
            int i;
            ProjectMetadata.Builder projectBuilder = ProjectMetadata.builder(ProjectId.DEFAULT);
            builder.put(projectBuilder);
            Map<String, MappingMetadata> mappingMetadataMap = in.readMapValues(MappingMetadata::new, MappingMetadata::getSha256);
            Function<String, MappingMetadata> mappingLookup = !mappingMetadataMap.isEmpty() ? mappingMetadataMap::get : null;
            int size = in.readVInt();
            for (i = 0; i < size; ++i) {
                projectBuilder.put(IndexMetadata.readFrom(in, mappingLookup), false);
            }
            size = in.readVInt();
            for (i = 0; i < size; ++i) {
                projectBuilder.put(IndexTemplateMetadata.readFrom(in));
            }
            Metadata.readBwcCustoms(in, builder);
            int reservedStateSize = in.readVInt();
            for (int i2 = 0; i2 < reservedStateSize; ++i2) {
                builder.put(ReservedStateMetadata.readFrom(in));
            }
        } else {
            Metadata.readClusterCustoms(in, builder);
            int reservedStateSize = in.readVInt();
            for (int i = 0; i < reservedStateSize; ++i) {
                builder.put(ReservedStateMetadata.readFrom(in));
            }
            builder.projectMetadata(in.readMap(ProjectId::readFrom, ProjectMetadata::readFrom));
        }
        return builder.build();
    }

    private static void readBwcCustoms(StreamInput in, Builder builder) throws IOException {
        Set<String> clusterScopedNames = in.namedWriteableRegistry().getReaders(ClusterCustom.class).keySet();
        Set<String> projectScopedNames = in.namedWriteableRegistry().getReaders(ProjectCustom.class).keySet();
        int count = in.readVInt();
        for (int i = 0; i < count; ++i) {
            MetadataCustom<ClusterCustom> custom;
            String name = in.readString();
            if (clusterScopedNames.contains(name)) {
                custom = in.readNamedWriteable(ClusterCustom.class, name);
                builder.putCustom(custom.getWriteableName(), (ClusterCustom)custom);
                continue;
            }
            if (projectScopedNames.contains(name)) {
                custom = in.readNamedWriteable(ProjectCustom.class, name);
                if (custom instanceof PersistentTasksCustomMetadata) {
                    PersistentTasksCustomMetadata persistentTasksCustomMetadata = (PersistentTasksCustomMetadata)custom;
                    Tuple<ClusterPersistentTasksCustomMetadata, PersistentTasksCustomMetadata> tuple = persistentTasksCustomMetadata.split();
                    builder.putCustom(((ClusterPersistentTasksCustomMetadata)tuple.v1()).getWriteableName(), (ClusterCustom)tuple.v1());
                    builder.putProjectCustom(((PersistentTasksCustomMetadata)tuple.v2()).getWriteableName(), (ProjectCustom)tuple.v2());
                    continue;
                }
                builder.putProjectCustom(custom.getWriteableName(), (ProjectCustom)custom);
                continue;
            }
            throw new IllegalArgumentException("Unknown custom name [" + name + "]");
        }
    }

    private static void readClusterCustoms(StreamInput in, Builder builder) throws IOException {
        Set<String> clusterScopedNames = in.namedWriteableRegistry().getReaders(ClusterCustom.class).keySet();
        int count = in.readVInt();
        for (int i = 0; i < count; ++i) {
            String name = in.readString();
            if (!clusterScopedNames.contains(name)) {
                throw new IllegalArgumentException("Unknown cluster custom name [" + name + "]");
            }
            ClusterCustom custom = in.readNamedWriteable(ClusterCustom.class, name);
            builder.putCustom(custom.getWriteableName(), custom);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        out.writeString(this.clusterUUID);
        out.writeBoolean(this.clusterUUIDCommitted);
        this.coordinationMetadata.writeTo(out);
        this.transientSettings.writeTo(out);
        this.persistentSettings.writeTo(out);
        this.hashesOfConsistentSettings.writeTo(out);
        if (out.getTransportVersion().before(TransportVersions.MULTI_PROJECT)) {
            ProjectMetadata singleProject = this.getSingleProject();
            out.writeMapValues(singleProject.getMappingsByHash());
            out.writeVInt(singleProject.size());
            for (IndexMetadata indexMetadata : singleProject) {
                indexMetadata.writeTo(out, true);
            }
            out.writeCollection(singleProject.templates().values());
            ArrayList<MetadataCustom<ProjectCustom>> combinedCustoms = new ArrayList<MetadataCustom<ProjectCustom>>(this.customs.size() + singleProject.customs().size());
            PersistentTasksCustomMetadata persistentTasksCustomMetadata = PersistentTasksCustomMetadata.combine(ClusterPersistentTasksCustomMetadata.get(this), PersistentTasksCustomMetadata.get(singleProject));
            if (persistentTasksCustomMetadata != null) {
                combinedCustoms.add(persistentTasksCustomMetadata);
            }
            combinedCustoms.addAll(this.customs.values().stream().filter(c -> !(c instanceof ClusterPersistentTasksCustomMetadata)).toList());
            combinedCustoms.addAll(singleProject.customs().values().stream().filter(c -> !(c instanceof PersistentTasksCustomMetadata)).toList());
            VersionedNamedWriteable.writeVersionedWriteables(out, combinedCustoms);
            ArrayList<ReservedStateMetadata> combinedMetadata = new ArrayList<ReservedStateMetadata>(this.reservedStateMetadata.size() + singleProject.reservedStateMetadata().size());
            combinedMetadata.addAll(this.reservedStateMetadata.values());
            combinedMetadata.addAll(singleProject.reservedStateMetadata().values());
            out.writeCollection(combinedMetadata);
        } else {
            VersionedNamedWriteable.writeVersionedWriteables(out, this.customs.values());
            out.writeCollection(this.reservedStateMetadata.values());
            out.writeMap(this.projectMetadata, StreamOutput::writeWriteable, StreamOutput::writeWriteable);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Metadata metadata) {
        return new Builder(metadata);
    }

    public Metadata copyAndUpdate(Consumer<Builder> updater) {
        Builder builder = Metadata.builder(this);
        updater.accept(builder);
        return builder.build();
    }

    public Metadata copyAndUpdateProject(ProjectId projectId, Consumer<ProjectMetadata.Builder> updater) {
        ProjectMetadata existingProject = this.projectMetadata.get(projectId);
        if (existingProject == null) {
            throw new IllegalArgumentException("Can only update existing project, cannot add a new project [" + String.valueOf(projectId) + "]. Use the builder instead");
        }
        ProjectMetadata.Builder builder = ProjectMetadata.builder(existingProject);
        updater.accept(builder);
        return this.withUpdatedProject(builder.build());
    }

    public Optional<ProjectMetadata> lookupProject(Index index) {
        return this.getProjectLookup().project(index);
    }

    public ProjectMetadata projectFor(Index index) {
        return this.lookupProject(index).orElseThrow(() -> new IndexNotFoundException("index [" + String.valueOf(index) + "] does not exist in any project", index));
    }

    public IndexMetadata indexMetadata(Index index) {
        return this.projectFor(index).getIndexSafe(index);
    }

    public Optional<IndexMetadata> findIndex(Index index) {
        return this.lookupProject(index).map(projectMetadata -> projectMetadata.index(index));
    }

    ProjectLookup getProjectLookup() {
        if (this.projectLookup == null) {
            this.projectLookup = this.isSingleProject() ? new SingleProjectLookup(this.getSingleProject()) : new MultiProjectLookup(this);
        }
        return this.projectLookup;
    }

    static interface ProjectLookup {
        public Optional<ProjectMetadata> project(Index var1);
    }

    public static class MultiProjectPendingException
    extends UnsupportedOperationException {
        public MultiProjectPendingException(String message) {
            super(message);
        }
    }

    public static interface ProjectCustom
    extends MetadataCustom<ProjectCustom> {
    }

    public static interface ClusterCustom
    extends MetadataCustom<ClusterCustom> {
    }

    public static interface MetadataCustom<T>
    extends NamedDiffable<T>,
    ChunkedToXContent {
        public EnumSet<XContentContext> context();

        default public boolean isRestorable() {
            return this.context().contains((Object)XContentContext.SNAPSHOT);
        }
    }

    public static enum XContentContext {
        API,
        GATEWAY,
        SNAPSHOT;


        public static XContentContext from(ToXContent.Params params) {
            return XContentContext.valueOf(params.param(Metadata.CONTEXT_MODE_PARAM, CONTEXT_MODE_API));
        }
    }

    private static class MetadataDiff
    implements Diff<Metadata> {
        private final long version;
        private final String clusterUUID;
        private final boolean clusterUUIDCommitted;
        private final CoordinationMetadata coordinationMetadata;
        private final Settings transientSettings;
        private final Settings persistentSettings;
        private final Diff<DiffableStringMap> hashesOfConsistentSettings;
        private final ProjectMetadata.ProjectMetadataDiff singleProject;
        private final DiffableUtils.MapDiff<ProjectId, ProjectMetadata, Map<ProjectId, ProjectMetadata>> multiProject;
        private final DiffableUtils.MapDiff<String, ClusterCustom, ImmutableOpenMap<String, ClusterCustom>> clusterCustoms;
        private final DiffableUtils.MapDiff<String, ReservedStateMetadata, ImmutableOpenMap<String, ReservedStateMetadata>> reservedStateMetadata;
        private final boolean empty;
        private final boolean fromNodeBeforeMultiProjectsSupport;
        private final DiffableUtils.MapDiff<String, ProjectCustom, ImmutableOpenMap<String, ProjectCustom>> combinedTasksDiff;
        private static final DiffableUtils.DiffableValueReader<String, IndexMetadata> INDEX_METADATA_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(IndexMetadata::readFrom, IndexMetadata::readDiffFrom);
        private static final DiffableUtils.DiffableValueReader<String, IndexTemplateMetadata> TEMPLATES_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(IndexTemplateMetadata::readFrom, IndexTemplateMetadata::readDiffFrom);
        private static final DiffableUtils.DiffableValueReader<String, ReservedStateMetadata> RESERVED_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(ReservedStateMetadata::readFrom, ReservedStateMetadata::readDiffFrom);

        MetadataDiff(Metadata before, Metadata after) {
            this.empty = before == after;
            this.fromNodeBeforeMultiProjectsSupport = false;
            this.clusterUUID = after.clusterUUID;
            this.clusterUUIDCommitted = after.clusterUUIDCommitted;
            this.version = after.version;
            this.coordinationMetadata = after.coordinationMetadata;
            this.transientSettings = after.transientSettings;
            this.persistentSettings = after.persistentSettings;
            if (before.isSingleProject() && after.isSingleProject()) {
                this.singleProject = after.getSingleProject().diff(before.getSingleProject());
                this.multiProject = null;
            } else {
                this.singleProject = null;
                this.multiProject = DiffableUtils.diff(before.projectMetadata, after.projectMetadata, PROJECT_ID_SERIALIZER);
            }
            if (this.empty) {
                this.hashesOfConsistentSettings = DiffableStringMap.DiffableStringMapDiff.EMPTY;
                this.clusterCustoms = DiffableUtils.emptyDiff();
                this.reservedStateMetadata = DiffableUtils.emptyDiff();
                this.combinedTasksDiff = null;
            } else {
                if (this.singleProject != null) {
                    PersistentTasksCustomMetadata beforeTasks = PersistentTasksCustomMetadata.combine((ClusterPersistentTasksCustomMetadata)before.custom("cluster_persistent_tasks"), (PersistentTasksCustomMetadata)before.getSingleProject().custom("persistent_tasks"));
                    PersistentTasksCustomMetadata afterTasks = PersistentTasksCustomMetadata.combine((ClusterPersistentTasksCustomMetadata)after.custom("cluster_persistent_tasks"), (PersistentTasksCustomMetadata)after.getSingleProject().custom("persistent_tasks"));
                    this.combinedTasksDiff = beforeTasks == null && afterTasks == null ? null : (beforeTasks == null ? DiffableUtils.singleUpsertDiff("persistent_tasks", afterTasks, DiffableUtils.getStringKeySerializer()) : (afterTasks == null ? DiffableUtils.singleDeleteDiff("persistent_tasks", DiffableUtils.getStringKeySerializer()) : DiffableUtils.singleEntryDiff("persistent_tasks", afterTasks.diff(beforeTasks), DiffableUtils.getStringKeySerializer())));
                } else {
                    this.combinedTasksDiff = null;
                }
                this.hashesOfConsistentSettings = after.hashesOfConsistentSettings.diff(before.hashesOfConsistentSettings);
                this.clusterCustoms = DiffableUtils.diff(before.customs, after.customs, DiffableUtils.getStringKeySerializer(), CLUSTER_CUSTOM_VALUE_SERIALIZER);
                this.reservedStateMetadata = DiffableUtils.diff(before.reservedStateMetadata, after.reservedStateMetadata, DiffableUtils.getStringKeySerializer());
            }
        }

        private MetadataDiff(StreamInput in) throws IOException {
            this.empty = false;
            this.clusterUUID = in.readString();
            this.clusterUUIDCommitted = in.readBoolean();
            this.version = in.readLong();
            this.coordinationMetadata = new CoordinationMetadata(in);
            this.transientSettings = Settings.readSettingsFromStream(in);
            this.persistentSettings = Settings.readSettingsFromStream(in);
            this.hashesOfConsistentSettings = DiffableStringMap.readDiffFrom(in);
            this.combinedTasksDiff = null;
            if (in.getTransportVersion().before(TransportVersions.MULTI_PROJECT)) {
                this.fromNodeBeforeMultiProjectsSupport = true;
                DiffableUtils.MapDiff<String, IndexMetadata, ImmutableOpenMap<String, IndexMetadata>> indices = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), INDEX_METADATA_DIFF_VALUE_READER);
                DiffableUtils.MapDiff<String, IndexTemplateMetadata, ImmutableOpenMap<String, IndexTemplateMetadata>> templates = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), TEMPLATES_DIFF_VALUE_READER);
                Tuple<DiffableUtils.MapDiff<String, ClusterCustom, ImmutableOpenMap<String, ClusterCustom>>, DiffableUtils.MapDiff<String, ProjectCustom, ImmutableOpenMap<String, ProjectCustom>>> bwcCustoms = MetadataDiff.readBwcCustoms(in);
                this.clusterCustoms = (DiffableUtils.MapDiff)bwcCustoms.v1();
                DiffableUtils.MapDiff projectCustoms = (DiffableUtils.MapDiff)bwcCustoms.v2();
                this.reservedStateMetadata = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), RESERVED_DIFF_VALUE_READER);
                this.singleProject = new ProjectMetadata.ProjectMetadataDiff(indices, templates, projectCustoms, DiffableUtils.emptyDiff());
                this.multiProject = null;
            } else {
                this.fromNodeBeforeMultiProjectsSupport = false;
                this.clusterCustoms = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), CLUSTER_CUSTOM_VALUE_SERIALIZER);
                this.reservedStateMetadata = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), RESERVED_DIFF_VALUE_READER);
                this.singleProject = null;
                this.multiProject = DiffableUtils.readJdkMapDiff(in, PROJECT_ID_SERIALIZER, ProjectMetadata::readFrom, ProjectMetadata.ProjectMetadataDiff::new);
            }
        }

        private static Tuple<DiffableUtils.MapDiff<String, ClusterCustom, ImmutableOpenMap<String, ClusterCustom>>, DiffableUtils.MapDiff<String, ProjectCustom, ImmutableOpenMap<String, ProjectCustom>>> readBwcCustoms(StreamInput in) throws IOException {
            DiffableUtils.MapDiff customs = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), BWC_CUSTOM_VALUE_SERIALIZER);
            return DiffableUtils.split(customs, in.namedWriteableRegistry().getReaders(ClusterCustom.class).keySet()::contains, CLUSTER_CUSTOM_VALUE_SERIALIZER, in.namedWriteableRegistry().getReaders(ProjectCustom.class).keySet()::contains, PROJECT_CUSTOM_VALUE_SERIALIZER);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.empty);
            if (this.empty) {
                return;
            }
            out.writeString(this.clusterUUID);
            out.writeBoolean(this.clusterUUIDCommitted);
            out.writeLong(this.version);
            this.coordinationMetadata.writeTo(out);
            this.transientSettings.writeTo(out);
            this.persistentSettings.writeTo(out);
            this.hashesOfConsistentSettings.writeTo(out);
            if (out.getTransportVersion().before(TransportVersions.MULTI_PROJECT)) {
                if (this.multiProject != null) {
                    throw new UnsupportedOperationException("Trying to serialize a multi-project diff with a single-project serialization version");
                }
                this.singleProject.indices().writeTo(out);
                this.singleProject.templates().writeTo(out);
                this.buildUnifiedCustomDiff().writeTo(out);
                this.buildUnifiedReservedStateMetadataDiff().writeTo(out);
            } else {
                this.clusterCustoms.writeTo(out);
                this.reservedStateMetadata.writeTo(out);
                if (this.multiProject != null) {
                    this.multiProject.writeTo(out);
                } else {
                    DiffableUtils.singleEntryDiff(DEFAULT_PROJECT_ID, this.singleProject, PROJECT_ID_SERIALIZER).writeTo(out);
                }
            }
        }

        private Diff<ImmutableOpenMap<String, ?>> buildUnifiedCustomDiff() {
            assert (this.multiProject == null) : "should only be used for single project metadata";
            DiffableUtils.MapDiff mergedClusterAndProjectCustomDiff = DiffableUtils.merge(this.clusterCustoms, this.singleProject.customs(), DiffableUtils.getStringKeySerializer(), BWC_CUSTOM_VALUE_SERIALIZER);
            if (this.combinedTasksDiff == null) {
                assert (!DiffableUtils.hasKey(mergedClusterAndProjectCustomDiff, "cluster_persistent_tasks"));
                assert (this.fromNodeBeforeMultiProjectsSupport || !DiffableUtils.hasKey(mergedClusterAndProjectCustomDiff, "persistent_tasks"));
                return mergedClusterAndProjectCustomDiff;
            }
            return DiffableUtils.merge(DiffableUtils.removeKeys(mergedClusterAndProjectCustomDiff, Set.of("persistent_tasks", "cluster_persistent_tasks")), this.combinedTasksDiff, DiffableUtils.getStringKeySerializer(), BWC_CUSTOM_VALUE_SERIALIZER);
        }

        private Diff<Map<String, ReservedStateMetadata>> buildUnifiedReservedStateMetadataDiff() {
            return DiffableUtils.merge(this.reservedStateMetadata, this.singleProject.reservedStateMetadata(), DiffableUtils.getStringKeySerializer(), RESERVED_DIFF_VALUE_READER);
        }

        @Override
        public Metadata apply(Metadata part) {
            if (this.empty) {
                return part;
            }
            Builder builder = new Builder();
            builder.clusterUUID(this.clusterUUID);
            builder.clusterUUIDCommitted(this.clusterUUIDCommitted);
            builder.version(this.version);
            builder.coordinationMetadata(this.coordinationMetadata);
            builder.transientSettings(this.transientSettings);
            builder.persistentSettings(this.persistentSettings);
            builder.hashesOfConsistentSettings(this.hashesOfConsistentSettings.apply(part.hashesOfConsistentSettings));
            if (this.singleProject != null) {
                if (!part.isSingleProject()) {
                    throw new UnsupportedOperationException("Trying to apply a single-project diff to a multi-project metadata");
                }
                if (this.fromNodeBeforeMultiProjectsSupport) {
                    PersistentTasksCustomMetadata combinedTasksBefore = PersistentTasksCustomMetadata.combine((ClusterPersistentTasksCustomMetadata)part.custom("cluster_persistent_tasks"), (PersistentTasksCustomMetadata)part.getSingleProject().custom("persistent_tasks"));
                    ProjectMetadata projectWithCombinedTasks = combinedTasksBefore == null ? this.singleProject.apply(part.getSingleProject()) : this.singleProject.apply(ProjectMetadata.builder(part.getSingleProject()).putCustom("persistent_tasks", combinedTasksBefore).build());
                    PersistentTasksCustomMetadata combinedTasksAfter = (PersistentTasksCustomMetadata)projectWithCombinedTasks.custom("persistent_tasks");
                    if (combinedTasksAfter == null) {
                        builder.projectMetadata(Map.of(DEFAULT_PROJECT_ID, projectWithCombinedTasks));
                        builder.customs(this.clusterCustoms.apply(part.customs));
                    } else {
                        Tuple<ClusterPersistentTasksCustomMetadata, PersistentTasksCustomMetadata> tuple = combinedTasksAfter.split();
                        builder.projectMetadata(Map.of(DEFAULT_PROJECT_ID, ProjectMetadata.builder(projectWithCombinedTasks).putCustom("persistent_tasks", (ProjectCustom)tuple.v2()).build()));
                        ImmutableOpenMap.Builder<String, ClusterCustom> clusterCustomsBuilder = ImmutableOpenMap.builder(this.clusterCustoms.apply(part.customs));
                        clusterCustomsBuilder.put("cluster_persistent_tasks", (ClusterCustom)tuple.v1());
                        builder.customs(clusterCustomsBuilder.build());
                    }
                } else {
                    builder.customs(this.clusterCustoms.apply(part.customs));
                    builder.projectMetadata(Map.of(DEFAULT_PROJECT_ID, this.singleProject.apply(part.getSingleProject())));
                }
            } else {
                assert (!this.fromNodeBeforeMultiProjectsSupport);
                builder.customs(this.clusterCustoms.apply(part.customs));
                builder.projectMetadata(this.multiProject.apply(part.projectMetadata));
            }
            builder.put(this.reservedStateMetadata.apply(part.reservedStateMetadata));
            return builder.build(true);
        }
    }

    public static class Builder {
        private String clusterUUID;
        private boolean clusterUUIDCommitted;
        private long version;
        private CoordinationMetadata coordinationMetadata = CoordinationMetadata.EMPTY_METADATA;
        private Settings transientSettings = Settings.EMPTY;
        private Settings persistentSettings = Settings.EMPTY;
        private DiffableStringMap hashesOfConsistentSettings = DiffableStringMap.EMPTY;
        private final ImmutableOpenMap.Builder<String, ClusterCustom> customs;
        private final Map<ProjectId, ProjectMetadata.Builder> projectMetadata;
        private final ImmutableOpenMap.Builder<String, ReservedStateMetadata> reservedStateMetadata;
        private static final Set<String> MOVED_PROJECT_CUSTOMS = Set.of("index-graveyard", "data_stream", "index_template", "component_template");

        public Builder() {
            this.clusterUUID = Metadata.UNKNOWN_CLUSTER_UUID;
            this.customs = ImmutableOpenMap.builder();
            this.projectMetadata = new HashMap<ProjectId, ProjectMetadata.Builder>();
            this.reservedStateMetadata = ImmutableOpenMap.builder();
        }

        Builder(Metadata metadata) {
            this.clusterUUID = metadata.clusterUUID;
            this.clusterUUIDCommitted = metadata.clusterUUIDCommitted;
            this.coordinationMetadata = metadata.coordinationMetadata;
            this.transientSettings = metadata.transientSettings;
            this.persistentSettings = metadata.persistentSettings;
            this.hashesOfConsistentSettings = metadata.hashesOfConsistentSettings;
            this.version = metadata.version;
            this.customs = ImmutableOpenMap.builder(metadata.customs);
            this.projectMetadata = Maps.transformValues(metadata.projectMetadata, ProjectMetadata::builder);
            this.reservedStateMetadata = ImmutableOpenMap.builder(metadata.reservedStateMetadata);
        }

        private ProjectMetadata.Builder getSingleProject() {
            if (this.projectMetadata.isEmpty()) {
                this.createDefaultProject();
            } else if (this.projectMetadata.size() != 1) {
                throw new MultiProjectPendingException("There are multiple projects " + String.valueOf(this.projectMetadata.keySet()));
            }
            return this.projectMetadata.values().iterator().next();
        }

        public Builder projectMetadata(Map<ProjectId, ProjectMetadata> projectMetadata) {
            assert (projectMetadata.entrySet().stream().allMatch(e -> ((ProjectMetadata)e.getValue()).id().equals(e.getKey()))) : "Project metadata map is inconsistent";
            this.projectMetadata.clear();
            projectMetadata.forEach((k, v) -> this.projectMetadata.put((ProjectId)k, ProjectMetadata.builder(v)));
            return this;
        }

        public Builder put(ProjectMetadata projectMetadata) {
            return this.put(ProjectMetadata.builder(projectMetadata));
        }

        public Builder put(ProjectMetadata.Builder projectMetadata) {
            this.projectMetadata.put(projectMetadata.getId(), projectMetadata);
            return this;
        }

        public Builder removeProject(ProjectId projectId) {
            this.projectMetadata.remove(projectId);
            return this;
        }

        public ProjectMetadata.Builder getProject(ProjectId projectId) {
            return this.projectMetadata.get(projectId);
        }

        public Builder forEachProject(UnaryOperator<ProjectMetadata.Builder> modifier) {
            this.projectMetadata.replaceAll((p, b) -> (ProjectMetadata.Builder)modifier.apply((ProjectMetadata.Builder)b));
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder put(IndexMetadata.Builder indexMetadataBuilder) {
            this.getSingleProject().put(indexMetadataBuilder);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder put(IndexMetadata indexMetadata, boolean incrementVersion) {
            this.getSingleProject().put(indexMetadata, incrementVersion);
            return this;
        }

        @Deprecated(forRemoval=true)
        public IndexMetadata get(String index) {
            return this.getSingleProject().get(index);
        }

        @Deprecated(forRemoval=true)
        public IndexMetadata getSafe(Index index) {
            return this.getSingleProject().getSafe(index);
        }

        @Deprecated(forRemoval=true)
        public Builder remove(String index) {
            this.getSingleProject().remove(index);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder removeAllIndices() {
            this.getSingleProject().removeAllIndices();
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder indices(Map<String, IndexMetadata> indices) {
            this.getSingleProject().indices(indices);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder put(IndexTemplateMetadata.Builder template) {
            this.getSingleProject().put(template);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder put(IndexTemplateMetadata template) {
            this.getSingleProject().put(template);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder removeTemplate(String templateName) {
            this.getSingleProject().removeTemplate(templateName);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder templates(Map<String, IndexTemplateMetadata> templates) {
            this.getSingleProject().templates(templates);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder put(String name, ComponentTemplate componentTemplate) {
            this.getSingleProject().put(name, componentTemplate);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder removeComponentTemplate(String name) {
            this.getSingleProject().removeComponentTemplate(name);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder componentTemplates(Map<String, ComponentTemplate> componentTemplates) {
            this.getSingleProject().componentTemplates(componentTemplates);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder indexTemplates(Map<String, ComposableIndexTemplate> indexTemplates) {
            this.getSingleProject().indexTemplates(indexTemplates);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder put(String name, ComposableIndexTemplate indexTemplate) {
            this.getSingleProject().put(name, indexTemplate);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder removeIndexTemplate(String name) {
            this.getSingleProject().removeIndexTemplate(name);
            return this;
        }

        @Deprecated(forRemoval=true)
        public DataStream dataStream(String dataStreamName) {
            return this.getSingleProject().dataStream(dataStreamName);
        }

        @Deprecated(forRemoval=true)
        public Builder dataStreams(Map<String, DataStream> dataStreams, Map<String, DataStreamAlias> dataStreamAliases) {
            this.getSingleProject().dataStreams(dataStreams, dataStreamAliases);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder put(DataStream dataStream) {
            this.getSingleProject().put(dataStream);
            return this;
        }

        @Deprecated(forRemoval=true)
        public DataStreamMetadata dataStreamMetadata() {
            return this.getSingleProject().dataStreamMetadata();
        }

        @Deprecated(forRemoval=true)
        public boolean put(String aliasName, String dataStream, Boolean isWriteDataStream, String filter) {
            return this.getSingleProject().put(aliasName, dataStream, isWriteDataStream, filter);
        }

        @Deprecated(forRemoval=true)
        public Builder removeDataStream(String name) {
            this.getSingleProject().removeDataStream(name);
            return this;
        }

        @Deprecated(forRemoval=true)
        public boolean removeDataStreamAlias(String aliasName, String dataStreamName, boolean mustExist) {
            return this.getSingleProject().removeDataStreamAlias(aliasName, dataStreamName, mustExist);
        }

        public Builder putCustom(String type, ClusterCustom custom) {
            this.customs.put(type, Objects.requireNonNull(custom, type));
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder putCustom(String type, ProjectCustom custom) {
            return this.putProjectCustom(type, custom);
        }

        public ClusterCustom getCustom(String type) {
            return this.customs.get(type);
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Builder removeCustomIf(BiPredicate<String, ? super ClusterCustom> p) {
            this.customs.removeAll(p);
            return this;
        }

        public Builder customs(Map<String, ClusterCustom> clusterCustoms) {
            clusterCustoms.forEach((key, value) -> Objects.requireNonNull(value, key));
            this.customs.putAllFromMap(clusterCustoms);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder putProjectCustom(String type, ProjectCustom custom) {
            this.getSingleProject().putCustom(type, Objects.requireNonNull(custom, type));
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder projectCustoms(Map<String, ProjectCustom> projectCustoms) {
            projectCustoms.forEach((key, value) -> Objects.requireNonNull(value, key));
            this.getSingleProject().customs(projectCustoms);
            return this;
        }

        public Builder put(Map<String, ReservedStateMetadata> reservedStateMetadata) {
            this.reservedStateMetadata.putAllFromMap(reservedStateMetadata);
            return this;
        }

        public Builder put(ReservedStateMetadata metadata) {
            this.reservedStateMetadata.put(metadata.namespace(), metadata);
            return this;
        }

        public Builder removeReservedState(ReservedStateMetadata metadata) {
            this.reservedStateMetadata.remove(metadata.namespace());
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder updateSettings(Settings settings, String ... indices) {
            this.getSingleProject().updateSettings(settings, indices);
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder updateNumberOfReplicas(int numberOfReplicas, String[] indices) {
            this.getSingleProject().updateNumberOfReplicas(numberOfReplicas, indices);
            return this;
        }

        public Builder coordinationMetadata(CoordinationMetadata coordinationMetadata) {
            this.coordinationMetadata = coordinationMetadata;
            return this;
        }

        public Settings transientSettings() {
            return this.transientSettings;
        }

        public Builder transientSettings(Settings settings) {
            this.transientSettings = settings;
            return this;
        }

        public Settings persistentSettings() {
            return this.persistentSettings;
        }

        public Builder persistentSettings(Settings settings) {
            this.persistentSettings = settings;
            return this;
        }

        public Builder hashesOfConsistentSettings(DiffableStringMap hashesOfConsistentSettings) {
            this.hashesOfConsistentSettings = hashesOfConsistentSettings;
            return this;
        }

        public Builder hashesOfConsistentSettings(Map<String, String> hashesOfConsistentSettings) {
            this.hashesOfConsistentSettings = new DiffableStringMap(hashesOfConsistentSettings);
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder clusterUUID(String clusterUUID) {
            this.clusterUUID = clusterUUID;
            return this;
        }

        public Builder clusterUUIDCommitted(boolean clusterUUIDCommitted) {
            this.clusterUUIDCommitted = clusterUUIDCommitted;
            return this;
        }

        public Builder generateClusterUuidIfNeeded() {
            if (this.clusterUUID.equals(Metadata.UNKNOWN_CLUSTER_UUID)) {
                this.clusterUUID(UUIDs.randomBase64UUID());
            }
            return this;
        }

        public Metadata build() {
            return this.build(false);
        }

        public Metadata build(boolean skipNameCollisionChecks) {
            return new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version, this.coordinationMetadata, this.buildProjectMetadata(skipNameCollisionChecks), this.transientSettings, this.persistentSettings, Settings.builder().put(this.persistentSettings).put(this.transientSettings).build(), this.hashesOfConsistentSettings, this.customs.build(), this.reservedStateMetadata.build());
        }

        private Map<ProjectId, ProjectMetadata> buildProjectMetadata(boolean skipNameCollisionChecks) {
            if (this.projectMetadata.isEmpty()) {
                this.createDefaultProject();
            }
            assert (this.assertProjectIdAndProjectMetadataConsistency());
            if (this.projectMetadata.size() == 1) {
                Map.Entry<ProjectId, ProjectMetadata.Builder> entry = this.projectMetadata.entrySet().iterator().next();
                return Map.of(entry.getKey(), entry.getValue().build(skipNameCollisionChecks));
            }
            return Collections.unmodifiableMap(Maps.transformValues(this.projectMetadata, m -> m.build(skipNameCollisionChecks)));
        }

        private ProjectMetadata.Builder createDefaultProject() {
            return this.projectMetadata.put(DEFAULT_PROJECT_ID, new ProjectMetadata.Builder(Map.of(), 0).id(DEFAULT_PROJECT_ID));
        }

        private boolean assertProjectIdAndProjectMetadataConsistency() {
            this.projectMetadata.forEach((id, project) -> {
                assert (project.getId().equals(id)) : "project id mismatch key=[" + String.valueOf(id) + "] builder=[" + String.valueOf(project.getId()) + "]";
            });
            return true;
        }

        public static Metadata fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder();
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (!"meta-data".equals(currentFieldName)) {
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.nextToken(), parser);
                    token = parser.nextToken();
                }
                currentFieldName = parser.currentName();
            }
            if (!"meta-data".equals(currentFieldName)) {
                throw new IllegalArgumentException("Expected [meta-data] as a field name but got " + currentFieldName);
            }
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
            Supplier<ProjectMetadata.Builder> projectBuilderForBwc = () -> {
                ProjectMetadata.Builder pmb = builder.getProject(ProjectId.DEFAULT);
                if (pmb == null) {
                    pmb = ProjectMetadata.builder(ProjectId.DEFAULT);
                    builder.put(pmb);
                }
                return pmb;
            };
            block33: while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    switch (currentFieldName) {
                        case "projects": {
                            assert (builder.projectMetadata.isEmpty()) : "expect empty projectMetadata, but got " + String.valueOf(builder.projectMetadata);
                            Builder.readProjects(parser, builder);
                            continue block33;
                        }
                    }
                    throw new IllegalArgumentException("Unexpected field [" + currentFieldName + "]");
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    switch (currentFieldName) {
                        case "cluster_coordination": {
                            builder.coordinationMetadata(CoordinationMetadata.fromXContent(parser));
                            continue block33;
                        }
                        case "settings": {
                            builder.persistentSettings(Settings.fromXContent(parser));
                            continue block33;
                        }
                        case "hashes_of_consistent_settings": {
                            builder.hashesOfConsistentSettings(parser.mapStrings());
                            continue block33;
                        }
                        case "reserved_state": {
                            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                builder.put(ReservedStateMetadata.fromXContent(parser));
                            }
                            continue block33;
                        }
                        case "indices": {
                            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                projectBuilderForBwc.get().put(IndexMetadata.Builder.fromXContent(parser), false);
                            }
                            continue block33;
                        }
                        case "templates": {
                            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                projectBuilderForBwc.get().put(IndexTemplateMetadata.Builder.fromXContent(parser, parser.currentName()));
                            }
                            continue block33;
                        }
                    }
                    NamedXContentRegistry registry = parser.getXContentRegistry();
                    if (registry.hasParser(ClusterCustom.class, currentFieldName, parser.getRestApiVersion()) && !MOVED_PROJECT_CUSTOMS.contains(currentFieldName)) {
                        Builder.parseCustomObject(parser, currentFieldName, ClusterCustom.class, builder::putCustom);
                        continue;
                    }
                    if (registry.hasParser(ProjectCustom.class, currentFieldName, parser.getRestApiVersion())) {
                        Builder.parseCustomObject(parser, currentFieldName, ProjectCustom.class, (name, projectCustom) -> {
                            if (projectCustom instanceof PersistentTasksCustomMetadata) {
                                PersistentTasksCustomMetadata persistentTasksCustomMetadata = (PersistentTasksCustomMetadata)projectCustom;
                                assert ("persistent_tasks".equals(name)) : name + " != persistent_tasks";
                                Tuple<ClusterPersistentTasksCustomMetadata, PersistentTasksCustomMetadata> tuple = persistentTasksCustomMetadata.split();
                                ((ProjectMetadata.Builder)projectBuilderForBwc.get()).putCustom("persistent_tasks", (ProjectCustom)tuple.v2());
                                builder.putCustom("cluster_persistent_tasks", (ClusterCustom)tuple.v1());
                            } else {
                                ((ProjectMetadata.Builder)projectBuilderForBwc.get()).putCustom((String)name, (ProjectCustom)projectCustom);
                            }
                        });
                        continue;
                    }
                    logger.warn("Skipping unknown custom object with type {}", (Object)currentFieldName);
                    parser.skipChildren();
                    continue;
                }
                if (token.isValue()) {
                    switch (currentFieldName) {
                        case "version": {
                            builder.version(parser.longValue());
                            continue block33;
                        }
                        case "cluster_uuid": 
                        case "uuid": {
                            builder.clusterUUID(parser.text());
                            continue block33;
                        }
                        case "cluster_uuid_committed": {
                            builder.clusterUUIDCommitted(parser.booleanValue());
                            continue block33;
                        }
                    }
                    throw new IllegalArgumentException("Unexpected field [" + currentFieldName + "]");
                }
                throw new IllegalArgumentException("Unexpected token " + String.valueOf(token));
            }
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser);
            return builder.build();
        }

        private static void readProjects(XContentParser parser, Builder builder) throws IOException {
            XContentParser.Token token;
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.currentToken(), parser);
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                builder.put(ProjectMetadata.Builder.fromXContent(parser));
            }
        }

        static <C extends MetadataCustom<C>> void parseCustomObject(XContentParser parser, String name, Class<C> categoryClass, BiConsumer<String, C> consumer) throws IOException {
            try {
                MetadataCustom custom = (MetadataCustom)parser.namedObject(categoryClass, name, null);
                consumer.accept(custom.getWriteableName(), custom);
            }
            catch (NamedObjectNotFoundException _ex) {
                logger.warn("Skipping unknown custom [{}] object with type {}", (Object)categoryClass.getSimpleName(), (Object)name);
                parser.skipChildren();
            }
        }
    }

    static class SingleProjectLookup
    implements ProjectLookup {
        private final ProjectMetadata project;

        SingleProjectLookup(ProjectMetadata project) {
            this.project = project;
        }

        @Override
        public Optional<ProjectMetadata> project(Index index) {
            if (this.project.hasIndex(index)) {
                return Optional.of(this.project);
            }
            return Optional.empty();
        }
    }

    class MultiProjectLookup
    implements ProjectLookup {
        private final Map<String, ProjectMetadata> lookup;

        private MultiProjectLookup(Metadata this$0) {
            this.lookup = Maps.newMapWithExpectedSize(this$0.getTotalNumberOfIndices());
            for (ProjectMetadata project : this$0.projectMetadata.values()) {
                for (IndexMetadata indexMetadata : project) {
                    String uuid = indexMetadata.getIndex().getUUID();
                    ProjectMetadata previousProject = this.lookup.put(uuid, project);
                    if (previousProject == null || previousProject == project) continue;
                    throw new IllegalStateException("Index UUID [" + uuid + "] exists in project [" + String.valueOf(project.id()) + "] and [" + String.valueOf(previousProject.id()) + "]");
                }
            }
        }

        @Override
        public Optional<ProjectMetadata> project(Index index) {
            ProjectMetadata project = this.lookup.get(index.getUUID());
            if (project != null && project.hasIndex(index)) {
                return Optional.of(project);
            }
            return Optional.empty();
        }
    }
}

