/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.DocValuesSkipIndexType;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PointValues;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.admin.indices.rollover.RolloverInfo;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStreamAutoShardingEvent;
import org.elasticsearch.cluster.metadata.DataStreamFailureStoreSettings;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.DataStreamOptions;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateDataStreamService;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public final class DataStream
implements SimpleDiffable<DataStream>,
ToXContentObject,
IndexAbstraction {
    private static final Logger LOGGER = LogManager.getLogger(DataStream.class);
    public static final NodeFeature DATA_STREAM_FAILURE_STORE_FEATURE = new NodeFeature("data_stream.failure_store");
    public static final boolean LOGS_STREAM_FEATURE_FLAG = new FeatureFlag("logs_stream").isEnabled();
    public static final TransportVersion ADDED_FAILURE_STORE_TRANSPORT_VERSION = TransportVersions.V_8_12_0;
    public static final TransportVersion ADDED_AUTO_SHARDING_EVENT_VERSION = TransportVersions.V_8_14_0;
    public static final TransportVersion ADD_DATA_STREAM_OPTIONS_VERSION = TransportVersions.V_8_16_0;
    public static final String BACKING_INDEX_PREFIX = ".ds-";
    public static final String FAILURE_STORE_PREFIX = ".fs-";
    public static final DateFormatter DATE_FORMATTER = DateFormatter.forPattern("uuuu.MM.dd");
    public static final String TIMESTAMP_FIELD_NAME = "@timestamp";
    public static final Comparator<LeafReader> TIMESERIES_LEAF_READERS_SORTER = Comparator.comparingLong(r -> {
        try {
            FieldInfo info = r.getFieldInfos().fieldInfo(TIMESTAMP_FIELD_NAME);
            if (info != null && info.docValuesSkipIndexType() == DocValuesSkipIndexType.RANGE) {
                DocValuesSkipper skipper = r.getDocValuesSkipper(TIMESTAMP_FIELD_NAME);
                return skipper.maxValue();
            }
            PointValues points = r.getPointValues(TIMESTAMP_FIELD_NAME);
            if (points != null) {
                byte[] sortValue = points.getMaxPackedValue();
                return LongPoint.decodeDimension((byte[])sortValue, (int)0);
            }
            return Long.MIN_VALUE;
        }
        catch (IOException e) {
            throw new ElasticsearchException("Can't access [@timestamp] field for the index!", (Throwable)e, new Object[0]);
        }
    }).reversed();
    private final LongSupplier timeProvider;
    private final String name;
    private final long generation;
    @Nullable
    private final Map<String, Object> metadata;
    private final Settings settings;
    private final CompressedXContent mappings;
    private final boolean hidden;
    private final boolean replicated;
    private final boolean system;
    private final boolean allowCustomRouting;
    @Nullable
    private final IndexMode indexMode;
    @Nullable
    private final DataStreamLifecycle lifecycle;
    private final DataStreamOptions dataStreamOptions;
    private final DataStreamIndices backingIndices;
    private final DataStreamIndices failureIndices;
    public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    public static final ParseField TIMESTAMP_FIELD_FIELD = new ParseField("timestamp_field", new String[0]);
    public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    public static final ParseField GENERATION_FIELD = new ParseField("generation", new String[0]);
    public static final ParseField METADATA_FIELD = new ParseField("_meta", new String[0]);
    public static final ParseField HIDDEN_FIELD = new ParseField("hidden", new String[0]);
    public static final ParseField REPLICATED_FIELD = new ParseField("replicated", new String[0]);
    public static final ParseField SYSTEM_FIELD = new ParseField("system", new String[0]);
    public static final ParseField ALLOW_CUSTOM_ROUTING = new ParseField("allow_custom_routing", new String[0]);
    public static final ParseField INDEX_MODE = new ParseField("index_mode", new String[0]);
    public static final ParseField LIFECYCLE = new ParseField("lifecycle", new String[0]);
    public static final ParseField FAILURE_STORE_FIELD = new ParseField("failure_store", new String[0]);
    public static final ParseField FAILURE_INDICES_FIELD = new ParseField("failure_indices", new String[0]);
    public static final ParseField ROLLOVER_ON_WRITE_FIELD = new ParseField("rollover_on_write", new String[0]);
    public static final ParseField AUTO_SHARDING_FIELD = new ParseField("auto_sharding", new String[0]);
    public static final ParseField FAILURE_ROLLOVER_ON_WRITE_FIELD = new ParseField("failure_rollover_on_write", new String[0]);
    public static final ParseField FAILURE_AUTO_SHARDING_FIELD = new ParseField("failure_auto_sharding", new String[0]);
    public static final ParseField DATA_STREAM_OPTIONS_FIELD = new ParseField("options", new String[0]);
    public static final ParseField SETTINGS_FIELD = new ParseField("settings", new String[0]);
    public static final ParseField MAPPINGS_FIELD = new ParseField("mappings", new String[0]);
    private static final ConstructingObjectParser<DataStream, Void> PARSER = new ConstructingObjectParser("data_stream", args -> new DataStream((String)args[0], (Long)args[2], (Map)args[3], args[17] == null ? Settings.EMPTY : (Settings)args[17], args[18] == null ? ComposableIndexTemplate.EMPTY_MAPPINGS : (CompressedXContent)args[18], args[4] != null && (Boolean)args[4] != false, args[5] != null && (Boolean)args[5] != false, args[6] != null && (Boolean)args[6] != false, System::currentTimeMillis, args[7] != null && (Boolean)args[7] != false, args[8] != null ? IndexMode.fromString((String)args[8]) : null, (DataStreamLifecycle)args[9], args[16] != null ? (DataStreamOptions)args[16] : DataStreamOptions.EMPTY, new DataStreamIndices(BACKING_INDEX_PREFIX, (List)args[1], args[10] != null && (Boolean)args[10] != false, (DataStreamAutoShardingEvent)args[11]), new DataStreamIndices(FAILURE_STORE_PREFIX, args[13] != null ? (List)args[13] : List.of(), args[14] != null && (Boolean)args[14] != false, (DataStreamAutoShardingEvent)args[15])));
    public static final XContentParserConfiguration TS_EXTRACT_CONFIG;
    private static final DateFormatter TIMESTAMP_FORMATTER;

    public DataStream(String name, List<Index> indices, long generation, Map<String, Object> metadata, boolean hidden, boolean replicated, boolean system, boolean allowCustomRouting, IndexMode indexMode, DataStreamLifecycle lifecycle, @Nullable DataStreamOptions dataStreamOptions, List<Index> failureIndices, boolean rolloverOnWrite, @Nullable DataStreamAutoShardingEvent autoShardingEvent) {
        this(name, indices, generation, metadata, Settings.EMPTY, ComposableIndexTemplate.EMPTY_MAPPINGS, hidden, replicated, system, allowCustomRouting, indexMode, lifecycle, dataStreamOptions, failureIndices, rolloverOnWrite, autoShardingEvent);
    }

    public DataStream(String name, List<Index> indices, long generation, Map<String, Object> metadata, Settings settings, CompressedXContent mappings, boolean hidden, boolean replicated, boolean system, boolean allowCustomRouting, IndexMode indexMode, DataStreamLifecycle lifecycle, @Nullable DataStreamOptions dataStreamOptions, List<Index> failureIndices, boolean rolloverOnWrite, @Nullable DataStreamAutoShardingEvent autoShardingEvent) {
        this(name, generation, metadata, settings, mappings, hidden, replicated, system, System::currentTimeMillis, allowCustomRouting, indexMode, lifecycle, dataStreamOptions, new DataStreamIndices(BACKING_INDEX_PREFIX, List.copyOf(indices), rolloverOnWrite, autoShardingEvent), new DataStreamIndices(FAILURE_STORE_PREFIX, List.copyOf(failureIndices), false, null));
    }

    DataStream(String name, long generation, Map<String, Object> metadata, Settings settings, CompressedXContent mappings, boolean hidden, boolean replicated, boolean system, LongSupplier timeProvider, boolean allowCustomRouting, IndexMode indexMode, DataStreamLifecycle lifecycle, DataStreamOptions dataStreamOptions, DataStreamIndices backingIndices, DataStreamIndices failureIndices) {
        this.name = name;
        this.generation = generation;
        this.metadata = metadata;
        this.settings = Objects.requireNonNull(settings);
        this.mappings = Objects.requireNonNull(mappings);
        assert (!system || hidden);
        this.hidden = hidden;
        this.replicated = replicated;
        this.timeProvider = timeProvider;
        this.system = system;
        this.allowCustomRouting = allowCustomRouting;
        this.indexMode = indexMode;
        assert (lifecycle == null || !lifecycle.targetsFailureStore()) : "Invalid lifecycle type for data lifecycle";
        this.lifecycle = lifecycle;
        DataStreamOptions dataStreamOptions2 = this.dataStreamOptions = dataStreamOptions == null ? DataStreamOptions.EMPTY : dataStreamOptions;
        assert (!backingIndices.indices.isEmpty());
        assert (!replicated || !backingIndices.rolloverOnWrite && !failureIndices.rolloverOnWrite) : "replicated data streams cannot be marked for lazy rollover";
        this.backingIndices = backingIndices;
        this.failureIndices = failureIndices;
    }

    public static DataStream read(StreamInput in) throws IOException {
        String name = DataStream.readName(in);
        DataStreamIndices.Builder backingIndicesBuilder = DataStreamIndices.backingIndicesBuilder(DataStream.readIndices(in));
        long generation = in.readVLong();
        Map<String, Object> metadata = in.readGenericMap();
        boolean hidden = in.readBoolean();
        boolean replicated = in.readBoolean();
        boolean system = in.readBoolean();
        boolean allowCustomRouting = in.getTransportVersion().onOrAfter(TransportVersions.V_8_0_0) ? in.readBoolean() : false;
        IndexMode indexMode = in.getTransportVersion().onOrAfter(TransportVersions.V_8_1_0) ? in.readOptionalEnum(IndexMode.class) : null;
        DataStreamLifecycle lifecycle = in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X) ? in.readOptionalWriteable(DataStreamLifecycle::new) : null;
        boolean failureStoreEnabled = in.getTransportVersion().between(ADDED_FAILURE_STORE_TRANSPORT_VERSION, TransportVersions.V_8_16_0) ? in.readBoolean() : false;
        List<Index> failureIndices = in.getTransportVersion().onOrAfter(ADDED_FAILURE_STORE_TRANSPORT_VERSION) ? DataStream.readIndices(in) : List.of();
        DataStreamIndices.Builder failureIndicesBuilder = DataStreamIndices.failureIndicesBuilder(failureIndices);
        backingIndicesBuilder.setRolloverOnWrite(in.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0) ? in.readBoolean() : false);
        if (in.getTransportVersion().onOrAfter(ADDED_AUTO_SHARDING_EVENT_VERSION)) {
            backingIndicesBuilder.setAutoShardingEvent(in.readOptionalWriteable(DataStreamAutoShardingEvent::new));
        }
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0)) {
            failureIndicesBuilder.setRolloverOnWrite(in.readBoolean()).setAutoShardingEvent(in.readOptionalWriteable(DataStreamAutoShardingEvent::new));
        }
        DataStreamOptions dataStreamOptions = in.getTransportVersion().onOrAfter(TransportVersions.V_8_16_0) ? in.readOptionalWriteable(DataStreamOptions::read) : (failureStoreEnabled ? DataStreamOptions.FAILURE_STORE_ENABLED : null);
        Settings settings = in.getTransportVersion().onOrAfter(TransportVersions.SETTINGS_IN_DATA_STREAMS) || in.getTransportVersion().isPatchFrom(TransportVersions.SETTINGS_IN_DATA_STREAMS_8_19) ? Settings.readSettingsFromStream(in) : Settings.EMPTY;
        CompressedXContent mappings = in.getTransportVersion().onOrAfter(TransportVersions.MAPPINGS_IN_DATA_STREAMS) ? CompressedXContent.readCompressedString(in) : ComposableIndexTemplate.EMPTY_MAPPINGS;
        return new DataStream(name, generation, metadata, settings, mappings, hidden, replicated, system, System::currentTimeMillis, allowCustomRouting, indexMode, lifecycle, dataStreamOptions, backingIndicesBuilder.build(), failureIndicesBuilder.build());
    }

    @Override
    public IndexAbstraction.Type getType() {
        return IndexAbstraction.Type.DATA_STREAM;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDataStreamRelated() {
        return true;
    }

    @Override
    public List<Index> getIndices() {
        return this.backingIndices.indices;
    }

    @Override
    public List<Index> getFailureIndices(ProjectMetadata ignored) {
        return this.failureIndices.indices;
    }

    public List<Index> getFailureIndices() {
        return this.failureIndices.indices;
    }

    public long getGeneration() {
        return this.generation;
    }

    @Override
    public Index getWriteIndex() {
        return this.backingIndices.getWriteIndex();
    }

    @Override
    public Index getWriteFailureIndex(ProjectMetadata metadata) {
        return this.getWriteFailureIndex();
    }

    @Nullable
    public Index getWriteFailureIndex() {
        return this.failureIndices.indices.isEmpty() ? null : this.failureIndices.getWriteIndex();
    }

    public boolean isFailureStoreIndex(String indexName) {
        return this.failureIndices.containsIndex(indexName);
    }

    public boolean containsIndex(String indexName) {
        return this.backingIndices.containsIndex(indexName) || this.failureIndices.containsIndex(indexName);
    }

    public DataStreamOptions getDataStreamOptions() {
        return this.dataStreamOptions;
    }

    public boolean rolloverOnWrite() {
        return this.backingIndices.rolloverOnWrite;
    }

    public ComposableIndexTemplate getEffectiveIndexTemplate(ProjectMetadata projectMetadata) throws IOException {
        return this.getMatchingIndexTemplate(projectMetadata).mergeSettings(this.settings).mergeMappings(this.mappings);
    }

    public Settings getEffectiveSettings(ProjectMetadata projectMetadata) {
        ComposableIndexTemplate template = this.getMatchingIndexTemplate(projectMetadata);
        Settings templateSettings = MetadataIndexTemplateService.resolveSettings(template, projectMetadata.componentTemplates());
        return templateSettings.merge(this.settings);
    }

    public CompressedXContent getEffectiveMappings(ProjectMetadata projectMetadata) throws IOException {
        return this.getMatchingIndexTemplate(projectMetadata).mergeMappings(this.mappings).template().mappings();
    }

    private ComposableIndexTemplate getMatchingIndexTemplate(ProjectMetadata projectMetadata) {
        return MetadataCreateDataStreamService.lookupTemplateForDataStream(this.name, projectMetadata);
    }

    public boolean isInternal() {
        return this.isSystem() || DataStream.isDotPrefixName(this.name);
    }

    private static boolean isInternalName(String name, SystemIndices systemIndices) {
        return DataStream.isDotPrefixName(name) || systemIndices.isSystemDataStream(name);
    }

    private static boolean isDotPrefixName(String name) {
        return name.charAt(0) == '.';
    }

    public Index selectTimeSeriesWriteIndex(Instant timestamp, ProjectMetadata project) {
        for (int i = this.backingIndices.indices.size() - 1; i >= 0; --i) {
            Index index = this.backingIndices.indices.get(i);
            IndexMetadata im = project.index(index);
            if (im.getIndexMode() != IndexMode.TIME_SERIES) continue;
            Instant start = im.getTimeSeriesStart();
            Instant end = im.getTimeSeriesEnd();
            if (timestamp.compareTo(start) < 0 || timestamp.compareTo(end) >= 0) continue;
            return index;
        }
        return null;
    }

    public void validate(Function<String, IndexMetadata> imSupplier) {
        if (this.indexMode == IndexMode.TIME_SERIES) {
            List<Tuple> startAndEndTimes = this.backingIndices.indices.stream().map(index -> {
                IndexMetadata im = (IndexMetadata)imSupplier.apply(index.getName());
                if (im == null) {
                    throw new IllegalStateException("index [" + index.getName() + "] is not found in the index metadata supplier");
                }
                return im;
            }).filter(im -> im.getTimeSeriesStart() != null && im.getTimeSeriesEnd() != null).map(im -> {
                Instant start = im.getTimeSeriesStart();
                Instant end = im.getTimeSeriesEnd();
                assert (end.isAfter(start));
                return new Tuple((Object)im.getIndex().getName(), (Object)new Tuple((Object)start, (Object)end));
            }).sorted(Comparator.comparing(entry -> (Instant)((Tuple)entry.v2()).v1())).toList();
            Tuple previous = null;
            DateFormatter formatter = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER;
            for (Tuple current : startAndEndTimes) {
                if (previous == null) {
                    previous = current;
                    continue;
                }
                if (((Instant)((Tuple)previous.v2()).v2()).compareTo((Instant)((Tuple)current.v2()).v1()) <= 0) continue;
                String range1 = formatter.format((TemporalAccessor)((Tuple)previous.v2()).v1()) + " TO " + formatter.format((TemporalAccessor)((Tuple)previous.v2()).v2());
                String range2 = formatter.format((TemporalAccessor)((Tuple)current.v2()).v1()) + " TO " + formatter.format((TemporalAccessor)((Tuple)current.v2()).v2());
                throw new IllegalArgumentException("backing index [" + (String)previous.v1() + "] with range [" + range1 + "] is overlapping with backing index [" + (String)current.v1() + "] with range [" + range2 + "]");
            }
        }
    }

    @Nullable
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public CompressedXContent getMappings() {
        return this.mappings;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    @Override
    public boolean isSystem() {
        return this.system;
    }

    public boolean isAllowCustomRouting() {
        return this.allowCustomRouting;
    }

    public boolean isFailureStoreExplicitlyEnabled() {
        return this.dataStreamOptions.failureStore() != null && Boolean.TRUE.equals(this.dataStreamOptions.failureStore().enabled());
    }

    public boolean isFailureStoreEffectivelyEnabled(DataStreamFailureStoreSettings dataStreamFailureStoreSettings) {
        return DataStream.isFailureStoreEffectivelyEnabled(this.dataStreamOptions, dataStreamFailureStoreSettings, this.name, this.isInternal());
    }

    public static boolean isFailureStoreEffectivelyEnabled(@Nullable DataStreamOptions options, DataStreamFailureStoreSettings dataStreamFailureStoreSettings, String name, SystemIndices systemIndices) {
        return DataStream.isFailureStoreEffectivelyEnabled(options, dataStreamFailureStoreSettings, name, DataStream.isInternalName(name, systemIndices));
    }

    private static boolean isFailureStoreEffectivelyEnabled(DataStreamOptions options, DataStreamFailureStoreSettings dataStreamFailureStoreSettings, String name, boolean isInternal) {
        if (options != null && options.failureStore() != null && options.failureStore().enabled() != null) {
            return options.failureStore().enabled();
        }
        return !isInternal && dataStreamFailureStoreSettings.failureStoreEnabledForDataStreamName(name);
    }

    @Nullable
    public IndexMode getIndexMode() {
        return this.indexMode;
    }

    @Nullable
    public DataStreamLifecycle getDataLifecycle() {
        return this.lifecycle;
    }

    @Nullable
    public DataStreamLifecycle getFailuresLifecycle() {
        return this.getFailuresLifecycle(this.dataStreamOptions != null && this.dataStreamOptions.failureStore() != null ? this.dataStreamOptions.failureStore().enabled() : null);
    }

    @Nullable
    public DataStreamLifecycle getFailuresLifecycle(Boolean effectivelyEnabledFailureStore) {
        if (this.dataStreamOptions.failureStore() != null && this.dataStreamOptions.failureStore().lifecycle() != null) {
            return this.dataStreamOptions.failureStore().lifecycle();
        }
        return Boolean.TRUE.equals(effectivelyEnabledFailureStore) || !this.getFailureIndices().isEmpty() ? DataStreamLifecycle.DEFAULT_FAILURE_LIFECYCLE : null;
    }

    @Nullable
    public DataStreamLifecycle getDataLifecycleForIndex(Index index) {
        if (this.backingIndices.containsIndex(index.getName())) {
            return this.getDataLifecycle();
        }
        if (this.failureIndices.containsIndex(index.getName())) {
            return this.getFailuresLifecycle();
        }
        return null;
    }

    public DataStreamAutoShardingEvent getAutoShardingEvent() {
        return this.backingIndices.autoShardingEvent;
    }

    public DataStreamIndices getDataComponent() {
        return this.backingIndices;
    }

    public DataStreamIndices getFailureComponent() {
        return this.failureIndices;
    }

    public DataStreamIndices getDataStreamIndices(boolean failureStore) {
        return failureStore ? this.failureIndices : this.backingIndices;
    }

    public DataStream rollover(Index writeIndex, long generation, IndexMode indexModeFromTemplate, @Nullable DataStreamAutoShardingEvent autoShardingEvent) {
        this.ensureNotReplicated();
        return this.unsafeRollover(writeIndex, generation, indexModeFromTemplate, autoShardingEvent);
    }

    public DataStream unsafeRollover(Index writeIndex, long generation, IndexMode indexModeFromTemplate, DataStreamAutoShardingEvent autoShardingEvent) {
        IndexMode dsIndexMode = this.indexMode;
        if ((dsIndexMode == null || dsIndexMode == IndexMode.STANDARD) && indexModeFromTemplate == IndexMode.TIME_SERIES) {
            dsIndexMode = IndexMode.TIME_SERIES;
        } else if (dsIndexMode == IndexMode.TIME_SERIES && (indexModeFromTemplate == null || indexModeFromTemplate == IndexMode.STANDARD)) {
            dsIndexMode = null;
        } else if ((dsIndexMode == null || dsIndexMode == IndexMode.STANDARD) && indexModeFromTemplate == IndexMode.LOGSDB) {
            dsIndexMode = IndexMode.LOGSDB;
        } else if (dsIndexMode == IndexMode.LOGSDB && (indexModeFromTemplate == null || indexModeFromTemplate == IndexMode.STANDARD)) {
            dsIndexMode = null;
        } else if (dsIndexMode == IndexMode.TIME_SERIES && indexModeFromTemplate == IndexMode.LOGSDB) {
            dsIndexMode = IndexMode.LOGSDB;
            LOGGER.warn("Changing [{}] index mode from [{}] to [{}]", (Object)this.name, (Object)indexModeFromTemplate, (Object)dsIndexMode);
        } else if (dsIndexMode == IndexMode.LOGSDB && indexModeFromTemplate == IndexMode.TIME_SERIES) {
            dsIndexMode = IndexMode.TIME_SERIES;
            LOGGER.warn("Changing [{}] index mode from [{}] to [{}]", (Object)this.name, (Object)indexModeFromTemplate, (Object)dsIndexMode);
        }
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.backingIndices.indices);
        backingIndices.add(writeIndex);
        return this.copy().setBackingIndices(this.backingIndices.copy().setIndices(backingIndices).setAutoShardingEvent(autoShardingEvent).setRolloverOnWrite(false).build()).setGeneration(generation).setIndexMode(dsIndexMode).build();
    }

    public DataStream rolloverFailureStore(Index writeIndex, long generation) {
        this.ensureNotReplicated();
        return this.unsafeRolloverFailureStore(writeIndex, generation);
    }

    public DataStream unsafeRolloverFailureStore(Index writeIndex, long generation) {
        ArrayList<Index> failureIndices = new ArrayList<Index>(this.failureIndices.indices);
        failureIndices.add(writeIndex);
        return this.copy().setGeneration(generation).setFailureIndices(this.failureIndices.copy().setIndices(failureIndices).build()).build();
    }

    public Tuple<String, Long> nextWriteIndexAndGeneration(ProjectMetadata project, DataStreamIndices dataStreamIndices) {
        this.ensureNotReplicated();
        return this.unsafeNextWriteIndexAndGeneration(project, dataStreamIndices);
    }

    public Tuple<String, Long> unsafeNextWriteIndexAndGeneration(ProjectMetadata project, DataStreamIndices dataStreamIndices) {
        String newWriteIndexName;
        long generation = this.generation;
        long currentTimeMillis = this.timeProvider.getAsLong();
        while (project.hasIndexAbstraction(newWriteIndexName = dataStreamIndices.generateName(this.name, ++generation, currentTimeMillis))) {
        }
        return Tuple.tuple((Object)newWriteIndexName, (Object)generation);
    }

    private void ensureNotReplicated() {
        if (this.replicated) {
            throw new IllegalArgumentException("data stream [" + this.name + "] cannot be rolled over, because it is a replicated data stream");
        }
    }

    public DataStream removeBackingIndex(Index index) {
        int backingIndexPosition = this.backingIndices.indices.indexOf(index);
        if (backingIndexPosition == -1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "index [%s] is not part of data stream [%s]", index.getName(), this.name));
        }
        if (this.backingIndices.indices.size() == backingIndexPosition + 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot remove backing index [%s] of data stream [%s] because it is the write index", index.getName(), this.name));
        }
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.backingIndices.indices);
        backingIndices.remove(index);
        assert (backingIndices.size() == this.backingIndices.indices.size() - 1);
        return this.copy().setBackingIndices(this.backingIndices.copy().setIndices(backingIndices).build()).setGeneration(this.generation + 1L).build();
    }

    public DataStream removeFailureStoreIndex(Index index) {
        int failureIndexPosition = this.failureIndices.indices.indexOf(index);
        if (failureIndexPosition == -1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "index [%s] is not part of data stream [%s] failure store", index.getName(), this.name));
        }
        boolean rolloverOnWrite = this.failureIndices.indices.size() == failureIndexPosition + 1;
        ArrayList<Index> updatedFailureIndices = new ArrayList<Index>(this.failureIndices.indices);
        updatedFailureIndices.remove(index);
        assert (updatedFailureIndices.size() == this.failureIndices.indices.size() - 1);
        return this.copy().setFailureIndices(this.failureIndices.copy().setIndices(updatedFailureIndices).setRolloverOnWrite(rolloverOnWrite).build()).setGeneration(this.generation + 1L).build();
    }

    public DataStream replaceBackingIndex(Index existingBackingIndex, Index newBackingIndex) {
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.backingIndices.indices);
        int backingIndexPosition = backingIndices.indexOf(existingBackingIndex);
        if (backingIndexPosition == -1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "index [%s] is not part of data stream [%s]", existingBackingIndex.getName(), this.name));
        }
        if (this.backingIndices.indices.size() == backingIndexPosition + 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot replace backing index [%s] of data stream [%s] because it is the write index", existingBackingIndex.getName(), this.name));
        }
        backingIndices.set(backingIndexPosition, newBackingIndex);
        return this.copy().setBackingIndices(this.backingIndices.copy().setIndices(backingIndices).build()).setGeneration(this.generation + 1L).build();
    }

    public DataStream replaceFailureStoreIndex(Index existingFailureIndex, Index newFailureIndex) {
        ArrayList<Index> currentFailureIndices = new ArrayList<Index>(this.failureIndices.indices);
        int failureIndexPosition = currentFailureIndices.indexOf(existingFailureIndex);
        if (failureIndexPosition == -1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "index [%s] is not part of data stream [%s] failure store", existingFailureIndex.getName(), this.name));
        }
        if (this.failureIndices.indices.size() == failureIndexPosition + 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot replace failure index [%s] of data stream [%s] because it is the failure store write index", existingFailureIndex.getName(), this.name));
        }
        currentFailureIndices.set(failureIndexPosition, newFailureIndex);
        return this.copy().setFailureIndices(this.failureIndices.copy().setIndices(currentFailureIndices).build()).setGeneration(this.generation + 1L).build();
    }

    public DataStream addBackingIndex(ProjectMetadata project, Index index) {
        DataStream parentDataStream = ((IndexAbstraction)project.getIndicesLookup().get(index.getName())).getParentDataStream();
        if (parentDataStream != null) {
            this.validateDataStreamAlreadyContainsIndex(index, parentDataStream, false);
            return this;
        }
        this.ensureNoAliasesOnIndex(project, index);
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.backingIndices.indices.size() + 1);
        backingIndices.add(index);
        backingIndices.addAll(this.backingIndices.indices);
        assert (backingIndices.size() == this.backingIndices.indices.size() + 1);
        return this.copy().setBackingIndices(this.backingIndices.copy().setIndices(backingIndices).build()).setGeneration(this.generation + 1L).build();
    }

    public DataStream addFailureStoreIndex(ProjectMetadata project, Index index) {
        DataStream parentDataStream = ((IndexAbstraction)project.getIndicesLookup().get(index.getName())).getParentDataStream();
        if (parentDataStream != null) {
            this.validateDataStreamAlreadyContainsIndex(index, parentDataStream, true);
            return this;
        }
        this.ensureNoAliasesOnIndex(project, index);
        ArrayList<Index> updatedFailureIndices = new ArrayList<Index>(this.failureIndices.indices.size() + 1);
        updatedFailureIndices.add(index);
        updatedFailureIndices.addAll(this.failureIndices.indices);
        assert (updatedFailureIndices.size() == this.failureIndices.indices.size() + 1);
        return this.copy().setFailureIndices(this.failureIndices.copy().setIndices(updatedFailureIndices).build()).setGeneration(this.generation + 1L).build();
    }

    private void validateDataStreamAlreadyContainsIndex(Index index, DataStream parentDataStream, boolean targetFailureStore) {
        if (!parentDataStream.equals(this) || parentDataStream.isFailureStoreIndex(index.getName()) != targetFailureStore) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot add index [%s] to data stream [%s] because it is already a %s index on data stream [%s]", index.getName(), this.getName(), parentDataStream.isFailureStoreIndex(index.getName()) ? "failure store" : "backing", parentDataStream.getName()));
        }
    }

    private void ensureNoAliasesOnIndex(ProjectMetadata project, Index index) {
        IndexMetadata im = project.index(((IndexAbstraction)project.getIndicesLookup().get(index.getName())).getWriteIndex());
        if (im.getAliases().size() > 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot add index [%s] to data stream [%s] until its %s [%s] %s removed", index.getName(), this.getName(), im.getAliases().size() > 1 ? "aliases" : "alias", Strings.collectionToCommaDelimitedString(im.getAliases().keySet().stream().sorted().toList()), im.getAliases().size() > 1 ? "are" : "is"));
        }
    }

    public DataStream promoteDataStream() {
        return this.copy().setReplicated(false).build();
    }

    @Nullable
    @Deprecated
    public DataStream snapshot(Set<String> indicesInSnapshot, Metadata.Builder snapshotMetadataBuilder) {
        ProjectId projectId = ProjectId.DEFAULT;
        ProjectMetadata.Builder project = snapshotMetadataBuilder.getProject(projectId);
        if (project == null) {
            project = ProjectMetadata.builder(projectId);
            snapshotMetadataBuilder.put(project);
        }
        return this.snapshot(indicesInSnapshot, project);
    }

    public DataStream snapshot(Set<String> indicesInSnapshot, ProjectMetadata.Builder snapshotMetadataBuilder) {
        boolean backingIndicesChanged = false;
        boolean failureIndicesChanged = false;
        List<Index> reconciledBackingIndices = this.backingIndices.indices;
        if (DataStream.isAnyIndexMissing(this.backingIndices.getIndices(), snapshotMetadataBuilder, indicesInSnapshot)) {
            reconciledBackingIndices = new ArrayList<Index>(this.backingIndices.indices);
            backingIndicesChanged = reconciledBackingIndices.removeIf(x -> !indicesInSnapshot.contains(x.getName()));
            if (reconciledBackingIndices.isEmpty()) {
                return null;
            }
        }
        List<Index> reconciledFailureIndices = this.failureIndices.indices;
        if (DataStream.isAnyIndexMissing(this.failureIndices.indices, snapshotMetadataBuilder, indicesInSnapshot)) {
            reconciledFailureIndices = new ArrayList<Index>(this.failureIndices.indices);
            failureIndicesChanged = reconciledFailureIndices.removeIf(x -> !indicesInSnapshot.contains(x.getName()));
        }
        if (!backingIndicesChanged && !failureIndicesChanged) {
            return this;
        }
        Builder builder = this.copy();
        if (backingIndicesChanged) {
            builder.setBackingIndices(this.backingIndices.copy().setIndices(reconciledBackingIndices).build());
        }
        if (failureIndicesChanged) {
            builder.setFailureIndices(this.failureIndices.copy().setIndices(reconciledFailureIndices).build());
        }
        return builder.setMetadata((Map<String, Object>)(this.metadata == null ? null : new HashMap<String, Object>(this.metadata))).build();
    }

    private static boolean isAnyIndexMissing(List<Index> indices, ProjectMetadata.Builder builder, Set<String> indicesInSnapshot) {
        for (Index index : indices) {
            String indexName = index.getName();
            if (builder.get(indexName) != null && indicesInSnapshot.contains(indexName)) continue;
            return true;
        }
        return false;
    }

    public List<Index> getIndicesPastRetention(Function<String, IndexMetadata> indexMetadataSupplier, LongSupplier nowSupplier, TimeValue effectiveRetention, boolean failureStore) {
        if (effectiveRetention == null) {
            return List.of();
        }
        List<Index> indicesPastRetention = this.getNonWriteIndicesOlderThan(this.getDataStreamIndices(failureStore).getIndices(), effectiveRetention, indexMetadataSupplier, this::isIndexManagedByDataStreamLifecycle, nowSupplier);
        return indicesPastRetention;
    }

    public List<DataStreamLifecycle.DownsamplingRound> getDownsamplingRoundsFor(Index index, Function<String, IndexMetadata> indexMetadataSupplier, LongSupplier nowSupplier) {
        assert (this.backingIndices.indices.contains(index)) : "the provided index must be a backing index for this datastream";
        if (this.lifecycle == null || this.lifecycle.downsampling() == null) {
            return List.of();
        }
        IndexMetadata indexMetadata = indexMetadataSupplier.apply(index.getName());
        if (indexMetadata == null || IndexSettings.MODE.get(indexMetadata.getSettings()) != IndexMode.TIME_SERIES) {
            return List.of();
        }
        TimeValue indexGenerationTime = this.getGenerationLifecycleDate(indexMetadata);
        if (indexGenerationTime != null) {
            long nowMillis = nowSupplier.getAsLong();
            long indexGenerationTimeMillis = indexGenerationTime.millis();
            ArrayList<DataStreamLifecycle.DownsamplingRound> orderedRoundsForIndex = new ArrayList<DataStreamLifecycle.DownsamplingRound>(this.lifecycle.downsampling().size());
            for (DataStreamLifecycle.DownsamplingRound round : this.lifecycle.downsampling()) {
                if (nowMillis < indexGenerationTimeMillis + round.after().getMillis()) continue;
                orderedRoundsForIndex.add(round);
            }
            return orderedRoundsForIndex;
        }
        return List.of();
    }

    private List<Index> getNonWriteIndicesOlderThan(List<Index> indices, TimeValue retentionPeriod, Function<String, IndexMetadata> indexMetadataSupplier, @Nullable Predicate<IndexMetadata> indicesPredicate, LongSupplier nowSupplier) {
        if (indices.isEmpty()) {
            return List.of();
        }
        ArrayList<Index> olderIndices = new ArrayList<Index>();
        for (Index index : indices) {
            if (!this.isIndexOlderThan(index, retentionPeriod.getMillis(), nowSupplier.getAsLong(), indicesPredicate, indexMetadataSupplier)) continue;
            olderIndices.add(index);
        }
        return olderIndices;
    }

    private boolean isIndexOlderThan(Index index, long retentionPeriod, long now, Predicate<IndexMetadata> indicesPredicate, Function<String, IndexMetadata> indexMetadataSupplier) {
        IndexMetadata indexMetadata = indexMetadataSupplier.apply(index.getName());
        if (indexMetadata == null) {
            return false;
        }
        TimeValue indexLifecycleDate = this.getGenerationLifecycleDate(indexMetadata);
        return indexLifecycleDate != null && now >= indexLifecycleDate.getMillis() + retentionPeriod && (indicesPredicate == null || indicesPredicate.test(indexMetadata));
    }

    public boolean isIndexManagedByDataStreamLifecycle(Index index, Function<String, IndexMetadata> indexMetadataSupplier) {
        if (!this.containsIndex(index.getName())) {
            return false;
        }
        IndexMetadata indexMetadata = indexMetadataSupplier.apply(index.getName());
        if (indexMetadata == null) {
            return false;
        }
        return this.isIndexManagedByDataStreamLifecycle(indexMetadata);
    }

    private boolean isIndexManagedByDataStreamLifecycle(IndexMetadata indexMetadata) {
        DataStreamLifecycle lifecycle = this.getDataLifecycleForIndex(indexMetadata.getIndex());
        if (indexMetadata.getLifecyclePolicyName() != null && lifecycle != null && lifecycle.enabled()) {
            return IndexSettings.PREFER_ILM_SETTING.get(indexMetadata.getSettings()) == false;
        }
        return lifecycle != null && lifecycle.enabled();
    }

    @Nullable
    public TimeValue getGenerationLifecycleDate(IndexMetadata indexMetadata) {
        if (indexMetadata.getIndex().equals(this.getWriteIndex()) || indexMetadata.getIndex().equals(this.getWriteFailureIndex())) {
            return null;
        }
        Long originationDate = indexMetadata.getSettings().getAsLong("index.lifecycle.origination_date", null);
        RolloverInfo rolloverInfo = indexMetadata.getRolloverInfos().get(this.getName());
        if (rolloverInfo != null) {
            return TimeValue.timeValueMillis((long)Objects.requireNonNullElseGet(originationDate, rolloverInfo::getTime));
        }
        return TimeValue.timeValueMillis((long)Objects.requireNonNullElseGet(originationDate, indexMetadata::getCreationDate));
    }

    public static String getDefaultBackingIndexName(String dataStreamName, long generation) {
        return DataStream.getDefaultBackingIndexName(dataStreamName, generation, System.currentTimeMillis());
    }

    public static String getDefaultBackingIndexName(String dataStreamName, long generation, long epochMillis) {
        return DataStream.getDefaultIndexName(BACKING_INDEX_PREFIX, dataStreamName, generation, epochMillis);
    }

    public static String getDefaultFailureStoreName(String dataStreamName, long generation, long epochMillis) {
        return DataStream.getDefaultIndexName(FAILURE_STORE_PREFIX, dataStreamName, generation, epochMillis);
    }

    private static String getDefaultIndexName(String prefix, String dataStreamName, long generation, long epochMillis) {
        return String.format(Locale.ROOT, prefix + "%s-%s-%06d", dataStreamName, DATE_FORMATTER.formatMillis(epochMillis), generation);
    }

    static String readName(StreamInput in) throws IOException {
        String name = in.readString();
        in.readString();
        return name;
    }

    static List<Index> readIndices(StreamInput in) throws IOException {
        return in.readCollectionAsImmutableList(Index::new);
    }

    public static Diff<DataStream> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(DataStream::read, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(TIMESTAMP_FIELD_NAME);
        out.writeCollection(this.backingIndices.indices);
        out.writeVLong(this.generation);
        out.writeGenericMap(this.metadata);
        out.writeBoolean(this.hidden);
        out.writeBoolean(this.replicated);
        out.writeBoolean(this.system);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_0_0)) {
            out.writeBoolean(this.allowCustomRouting);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_1_0)) {
            out.writeOptionalEnum(this.indexMode);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            out.writeOptionalWriteable(this.lifecycle);
        }
        if (out.getTransportVersion().between(ADDED_FAILURE_STORE_TRANSPORT_VERSION, ADD_DATA_STREAM_OPTIONS_VERSION)) {
            out.writeBoolean(this.isFailureStoreExplicitlyEnabled());
        }
        if (out.getTransportVersion().onOrAfter(ADDED_FAILURE_STORE_TRANSPORT_VERSION)) {
            out.writeCollection(this.failureIndices.indices);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0)) {
            out.writeBoolean(this.backingIndices.rolloverOnWrite);
        }
        if (out.getTransportVersion().onOrAfter(ADDED_AUTO_SHARDING_EVENT_VERSION)) {
            out.writeOptionalWriteable(this.backingIndices.autoShardingEvent);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_15_0)) {
            out.writeBoolean(this.failureIndices.rolloverOnWrite);
            out.writeOptionalWriteable(this.failureIndices.autoShardingEvent);
        }
        if (out.getTransportVersion().onOrAfter(ADD_DATA_STREAM_OPTIONS_VERSION)) {
            out.writeOptionalWriteable(this.dataStreamOptions.isEmpty() ? null : this.dataStreamOptions);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.SETTINGS_IN_DATA_STREAMS) || out.getTransportVersion().isPatchFrom(TransportVersions.SETTINGS_IN_DATA_STREAMS_8_19)) {
            this.settings.writeTo(out);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.MAPPINGS_IN_DATA_STREAMS)) {
            this.mappings.writeTo(out);
        }
    }

    public static DataStream fromXContent(XContentParser parser) throws IOException {
        return (DataStream)PARSER.parse(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, null, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration, @Nullable DataStreamGlobalRetention globalRetention) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD.getPreferredName(), this.name);
        builder.field(TIMESTAMP_FIELD_FIELD.getPreferredName()).startObject().field(NAME_FIELD.getPreferredName(), TIMESTAMP_FIELD_NAME).endObject();
        builder.xContentList(INDICES_FIELD.getPreferredName(), this.backingIndices.indices);
        builder.field(GENERATION_FIELD.getPreferredName(), this.generation);
        if (this.metadata != null) {
            builder.field(METADATA_FIELD.getPreferredName(), this.metadata);
        }
        builder.field(HIDDEN_FIELD.getPreferredName(), this.hidden);
        builder.field(REPLICATED_FIELD.getPreferredName(), this.replicated);
        builder.field(SYSTEM_FIELD.getPreferredName(), this.system);
        builder.field(ALLOW_CUSTOM_ROUTING.getPreferredName(), this.allowCustomRouting);
        if (!this.failureIndices.indices.isEmpty()) {
            builder.xContentList(FAILURE_INDICES_FIELD.getPreferredName(), this.failureIndices.indices);
        }
        builder.field(FAILURE_ROLLOVER_ON_WRITE_FIELD.getPreferredName(), this.failureIndices.rolloverOnWrite);
        if (this.failureIndices.autoShardingEvent != null) {
            builder.startObject(FAILURE_AUTO_SHARDING_FIELD.getPreferredName());
            this.failureIndices.autoShardingEvent.toXContent(builder, params);
            builder.endObject();
        }
        if (!this.dataStreamOptions.isEmpty()) {
            builder.field(DATA_STREAM_OPTIONS_FIELD.getPreferredName());
            this.dataStreamOptions.toXContent(builder, params);
        }
        if (this.indexMode != null) {
            builder.field(INDEX_MODE.getPreferredName(), (Enum)this.indexMode);
        }
        if (this.lifecycle != null) {
            builder.field(LIFECYCLE.getPreferredName());
            this.lifecycle.toXContent(builder, params, rolloverConfiguration, globalRetention, this.isInternal());
        }
        builder.field(ROLLOVER_ON_WRITE_FIELD.getPreferredName(), this.backingIndices.rolloverOnWrite);
        if (this.backingIndices.autoShardingEvent != null) {
            builder.startObject(AUTO_SHARDING_FIELD.getPreferredName());
            this.backingIndices.autoShardingEvent.toXContent(builder, params);
            builder.endObject();
        }
        builder.startObject(SETTINGS_FIELD.getPreferredName());
        this.settings.toXContent(builder, params);
        builder.endObject();
        String context = params.param("context_mode", Metadata.CONTEXT_MODE_API);
        boolean binary = params.paramAsBoolean("binary", false);
        if (Metadata.CONTEXT_MODE_API.equals(context) || !binary) {
            Map uncompressedMapping = (Map)XContentHelper.convertToMap(this.mappings.uncompressed(), true, XContentType.JSON).v2();
            if (!uncompressedMapping.isEmpty()) {
                builder.field(MAPPINGS_FIELD.getPreferredName());
                builder.map(uncompressedMapping);
            }
        } else {
            builder.field(MAPPINGS_FIELD.getPreferredName(), this.mappings.compressed());
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStream that = (DataStream)o;
        return this.name.equals(that.name) && this.generation == that.generation && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.settings, that.settings) && this.hidden == that.hidden && this.system == that.system && this.replicated == that.replicated && this.allowCustomRouting == that.allowCustomRouting && this.indexMode == that.indexMode && Objects.equals(this.lifecycle, that.lifecycle) && Objects.equals(this.dataStreamOptions, that.dataStreamOptions) && Objects.equals(this.backingIndices, that.backingIndices) && Objects.equals(this.failureIndices, that.failureIndices);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.generation, this.metadata, this.settings, this.hidden, this.system, this.replicated, this.allowCustomRouting, this.indexMode, this.lifecycle, this.dataStreamOptions, this.backingIndices, this.failureIndices});
    }

    @Override
    public Index getWriteIndex(IndexRequest request, ProjectMetadata project) {
        if (request.opType() != DocWriteRequest.OpType.CREATE) {
            return this.getWriteIndex();
        }
        if (this.getIndexMode() != IndexMode.TIME_SERIES) {
            return this.getWriteIndex();
        }
        Object rawTimestamp = request.getRawTimestamp();
        Instant timestamp = rawTimestamp != null ? DataStream.getTimeStampFromRaw(rawTimestamp) : DataStream.getTimestampFromParser(request.source(), request.getContentType());
        Index result = this.selectTimeSeriesWriteIndex(timestamp = DataStream.getCanonicalTimestampBound(timestamp), project);
        if (result == null) {
            String timestampAsString = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.format(timestamp);
            String writeableIndicesString = this.getIndices().stream().map(project::index).map(IndexMetadata::getSettings).map(settings -> "[" + settings.get(IndexSettings.TIME_SERIES_START_TIME.getKey()) + "," + settings.get(IndexSettings.TIME_SERIES_END_TIME.getKey()) + "]").collect(Collectors.joining());
            throw new TimestampError("the document timestamp [" + timestampAsString + "] is outside of ranges of currently writable indices [" + writeableIndicesString + "]");
        }
        return result;
    }

    @Override
    public DataStream getParentDataStream() {
        return null;
    }

    public static List<Index> getIndicesWithinMaxAgeRange(DataStream dataStream, Function<Index, IndexMetadata> indexProvider, TimeValue maxIndexAge, LongSupplier nowSupplier) {
        List<Index> dataStreamIndices = dataStream.getIndices();
        long currentTimeMillis = nowSupplier.getAsLong();
        int firstIndexWithinAgeRange = Math.max(dataStreamIndices.size() - 2, 0);
        for (int i = 0; i < dataStreamIndices.size(); ++i) {
            Index index = dataStreamIndices.get(i);
            IndexMetadata indexMetadata = indexProvider.apply(index);
            long indexAge = currentTimeMillis - indexMetadata.getCreationDate();
            if (indexAge >= maxIndexAge.getMillis()) continue;
            firstIndexWithinAgeRange = i == 0 ? 0 : i - 1;
            break;
        }
        return dataStreamIndices.subList(firstIndexWithinAgeRange, dataStreamIndices.size());
    }

    private static Instant getTimeStampFromRaw(Object rawTimestamp) {
        try {
            if (rawTimestamp instanceof Long) {
                Long lTimestamp = (Long)rawTimestamp;
                return Instant.ofEpochMilli(lTimestamp);
            }
            if (rawTimestamp instanceof String) {
                String sTimestamp = (String)rawTimestamp;
                return DateFormatters.from(TIMESTAMP_FORMATTER.parse(sTimestamp), TIMESTAMP_FORMATTER.locale()).toInstant();
            }
            throw new TimestampError("timestamp [" + String.valueOf(rawTimestamp) + "] type [" + String.valueOf(rawTimestamp.getClass()) + "] error");
        }
        catch (Exception e) {
            throw new TimestampError("Error get data stream timestamp field: " + e.getMessage(), e);
        }
    }

    private static Instant getTimestampFromParser(BytesReference source, XContentType xContentType) {
        Instant instant;
        block12: {
            XContentParser parser = XContentHelper.createParserNotCompressed(TS_EXTRACT_CONFIG, source, xContentType);
            try {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.nextToken(), parser);
                instant = switch (parser.nextToken()) {
                    case XContentParser.Token.VALUE_STRING -> DateFormatters.from(TIMESTAMP_FORMATTER.parse(parser.text()), TIMESTAMP_FORMATTER.locale()).toInstant();
                    case XContentParser.Token.VALUE_NUMBER -> Instant.ofEpochMilli(parser.longValue());
                    default -> throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "Failed to parse object: expecting token of type [%s] or [%s] but found [%s]", XContentParser.Token.VALUE_STRING, XContentParser.Token.VALUE_NUMBER, parser.currentToken()), new Object[0]);
                };
                if (parser == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new TimestampError("Error extracting data stream timestamp field: " + e.getMessage(), e);
                }
            }
            parser.close();
        }
        return instant;
    }

    public static DataStream resolveDataStream(IndexAbstraction indexAbstraction, ProjectMetadata project) {
        if (indexAbstraction == null || !indexAbstraction.isDataStreamRelated()) {
            return null;
        }
        Index writeIndex = indexAbstraction.getWriteIndex();
        if (writeIndex == null) {
            return null;
        }
        IndexAbstraction writeAbstraction = (IndexAbstraction)project.getIndicesLookup().get(writeIndex.getName());
        return writeAbstraction.getParentDataStream();
    }

    public static Instant getCanonicalTimestampBound(Instant time) {
        return time.truncatedTo(ChronoUnit.SECONDS);
    }

    public static Builder builder(String name, List<Index> indices) {
        return new Builder(name, indices);
    }

    public static Builder builder(String name, DataStreamIndices backingIndices) {
        return new Builder(name, backingIndices);
    }

    public Builder copy() {
        return new Builder(this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        ConstructingObjectParser tsFieldParser = new ConstructingObjectParser("timestamp_field", args -> {
            if (!TIMESTAMP_FIELD_NAME.equals(args[0])) {
                throw new IllegalArgumentException("unexpected timestamp field [" + String.valueOf(args[0]) + "]");
            }
            return TIMESTAMP_FIELD_NAME;
        });
        tsFieldParser.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        PARSER.declareObject((f, v) -> {
            assert (v == TIMESTAMP_FIELD_NAME);
        }, (ContextParser)tsFieldParser, TIMESTAMP_FIELD_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> Index.fromXContent(p), INDICES_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), GENERATION_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), METADATA_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), HIDDEN_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), REPLICATED_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), SYSTEM_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ALLOW_CUSTOM_ROUTING);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEX_MODE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DataStreamLifecycle.dataLifecycleFromXContent(p), LIFECYCLE);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ROLLOVER_ON_WRITE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DataStreamAutoShardingEvent.fromXContent(p), AUTO_SHARDING_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), FAILURE_STORE_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Index.fromXContent(p), FAILURE_INDICES_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), FAILURE_ROLLOVER_ON_WRITE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DataStreamAutoShardingEvent.fromXContent(p), FAILURE_AUTO_SHARDING_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DataStreamOptions.fromXContent(p), DATA_STREAM_OPTIONS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Settings.fromXContent(p), SETTINGS_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            XContentParser.Token token = p.currentToken();
            if (token == XContentParser.Token.VALUE_STRING) {
                return new CompressedXContent(Base64.getDecoder().decode(p.text()));
            }
            if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                return new CompressedXContent(p.binaryValue());
            }
            if (token == XContentParser.Token.START_OBJECT) {
                return new CompressedXContent(Strings.toString(XContentFactory.jsonBuilder().map(p.mapOrdered())));
            }
            throw new IllegalArgumentException("Unexpected token: " + String.valueOf(token));
        }, MAPPINGS_FIELD, ObjectParser.ValueType.VALUE_OBJECT_ARRAY);
        TS_EXTRACT_CONFIG = XContentParserConfiguration.EMPTY.withFiltering(null, Set.of(TIMESTAMP_FIELD_NAME), null, false);
        TIMESTAMP_FORMATTER = DateFormatter.forPattern("strict_date_optional_time_nanos||strict_date_optional_time||epoch_millis");
    }

    public static class DataStreamIndices {
        private final String namePrefix;
        private final List<Index> indices;
        private final boolean rolloverOnWrite;
        @Nullable
        private final DataStreamAutoShardingEvent autoShardingEvent;
        private Set<String> lookup;

        protected DataStreamIndices(String namePrefix, List<Index> indices, boolean rolloverOnWrite, DataStreamAutoShardingEvent autoShardingEvent) {
            this.namePrefix = namePrefix;
            this.indices = indices;
            this.rolloverOnWrite = rolloverOnWrite;
            this.autoShardingEvent = autoShardingEvent;
            assert (this.getLookup().size() == indices.size()) : "found duplicate index entries in " + String.valueOf(indices);
        }

        private Set<String> getLookup() {
            if (this.lookup == null) {
                this.lookup = this.indices.stream().map(Index::getName).collect(Collectors.toSet());
            }
            return this.lookup;
        }

        public Index getWriteIndex() {
            return this.indices.get(this.indices.size() - 1);
        }

        public boolean containsIndex(String index) {
            return this.getLookup().contains(index);
        }

        private String generateName(String dataStreamName, long generation, long epochMillis) {
            return DataStream.getDefaultIndexName(this.namePrefix, dataStreamName, generation, epochMillis);
        }

        public static Builder backingIndicesBuilder(List<Index> indices) {
            return new Builder(DataStream.BACKING_INDEX_PREFIX, indices);
        }

        public static Builder failureIndicesBuilder(List<Index> indices) {
            return new Builder(DataStream.FAILURE_STORE_PREFIX, indices);
        }

        public Builder copy() {
            return new Builder(this);
        }

        public List<Index> getIndices() {
            return this.indices;
        }

        public boolean isRolloverOnWrite() {
            return this.rolloverOnWrite;
        }

        public DataStreamAutoShardingEvent getAutoShardingEvent() {
            return this.autoShardingEvent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataStreamIndices that = (DataStreamIndices)o;
            return this.rolloverOnWrite == that.rolloverOnWrite && Objects.equals(this.namePrefix, that.namePrefix) && Objects.equals(this.indices, that.indices) && Objects.equals(this.autoShardingEvent, that.autoShardingEvent);
        }

        public int hashCode() {
            return Objects.hash(this.namePrefix, this.indices, this.rolloverOnWrite, this.autoShardingEvent);
        }

        public static class Builder {
            private final String namePrefix;
            private List<Index> indices;
            private boolean rolloverOnWrite = false;
            @Nullable
            private DataStreamAutoShardingEvent autoShardingEvent = null;

            private Builder(String namePrefix, List<Index> indices) {
                this.namePrefix = namePrefix;
                this.indices = indices;
            }

            private Builder(DataStreamIndices dataStreamIndices) {
                this.namePrefix = dataStreamIndices.namePrefix;
                this.indices = dataStreamIndices.indices;
                this.rolloverOnWrite = dataStreamIndices.rolloverOnWrite;
                this.autoShardingEvent = dataStreamIndices.autoShardingEvent;
            }

            public Builder setIndices(List<Index> indices) {
                this.indices = List.copyOf(indices);
                return this;
            }

            public Builder setRolloverOnWrite(boolean rolloverOnWrite) {
                this.rolloverOnWrite = rolloverOnWrite;
                return this;
            }

            public Builder setAutoShardingEvent(DataStreamAutoShardingEvent autoShardingEvent) {
                this.autoShardingEvent = autoShardingEvent;
                return this;
            }

            public DataStreamIndices build() {
                return new DataStreamIndices(this.namePrefix, this.indices, this.rolloverOnWrite, this.autoShardingEvent);
            }
        }
    }

    public static class Builder {
        private LongSupplier timeProvider = System::currentTimeMillis;
        private String name;
        private long generation = 1L;
        @Nullable
        private Map<String, Object> metadata = null;
        private Settings settings = Settings.EMPTY;
        private CompressedXContent mappings = ComposableIndexTemplate.EMPTY_MAPPINGS;
        private boolean hidden = false;
        private boolean replicated = false;
        private boolean system = false;
        private boolean allowCustomRouting = false;
        @Nullable
        private IndexMode indexMode = null;
        @Nullable
        private DataStreamLifecycle lifecycle = null;
        private DataStreamOptions dataStreamOptions = DataStreamOptions.EMPTY;
        private DataStreamIndices backingIndices;
        private DataStreamIndices failureIndices = DataStreamIndices.failureIndicesBuilder(List.of()).build();

        private Builder(String name, List<Index> indices) {
            this(name, DataStreamIndices.backingIndicesBuilder(indices).build());
        }

        private Builder(String name, DataStreamIndices backingIndices) {
            this.name = name;
            assert (!backingIndices.indices.isEmpty()) : "Cannot create data stream with empty backing indices";
            this.backingIndices = backingIndices;
        }

        private Builder(DataStream dataStream) {
            this.timeProvider = dataStream.timeProvider;
            this.name = dataStream.name;
            this.generation = dataStream.generation;
            this.metadata = dataStream.metadata;
            this.settings = dataStream.settings;
            this.mappings = dataStream.mappings;
            this.hidden = dataStream.hidden;
            this.replicated = dataStream.replicated;
            this.system = dataStream.system;
            this.allowCustomRouting = dataStream.allowCustomRouting;
            this.indexMode = dataStream.indexMode;
            this.lifecycle = dataStream.lifecycle;
            this.dataStreamOptions = dataStream.dataStreamOptions;
            this.backingIndices = dataStream.backingIndices;
            this.failureIndices = dataStream.failureIndices;
        }

        public Builder setTimeProvider(LongSupplier timeProvider) {
            this.timeProvider = timeProvider;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setGeneration(long generation) {
            this.generation = generation;
            return this;
        }

        public Builder setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setSettings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder setMappings(CompressedXContent mappings) {
            this.mappings = mappings;
            return this;
        }

        public Builder setHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Builder setReplicated(boolean replicated) {
            this.replicated = replicated;
            return this;
        }

        public Builder setSystem(boolean system) {
            this.system = system;
            return this;
        }

        public Builder setAllowCustomRouting(boolean allowCustomRouting) {
            this.allowCustomRouting = allowCustomRouting;
            return this;
        }

        public Builder setIndexMode(IndexMode indexMode) {
            this.indexMode = indexMode;
            return this;
        }

        public Builder setLifecycle(DataStreamLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public Builder setDataStreamOptions(DataStreamOptions dataStreamOptions) {
            this.dataStreamOptions = dataStreamOptions;
            return this;
        }

        public Builder setBackingIndices(DataStreamIndices backingIndices) {
            assert (!backingIndices.indices.isEmpty()) : "Cannot create data stream with empty backing indices";
            this.backingIndices = backingIndices;
            return this;
        }

        public Builder setFailureIndices(DataStreamIndices failureIndices) {
            this.failureIndices = failureIndices;
            return this;
        }

        public Builder setDataStreamIndices(boolean targetFailureStore, DataStreamIndices indices) {
            if (targetFailureStore) {
                this.setFailureIndices(indices);
            } else {
                this.setBackingIndices(indices);
            }
            return this;
        }

        public DataStream build() {
            return new DataStream(this.name, this.generation, this.metadata, this.settings, this.mappings, this.hidden, this.replicated, this.system, this.timeProvider, this.allowCustomRouting, this.indexMode, this.lifecycle, this.dataStreamOptions, this.backingIndices, this.failureIndices);
        }
    }

    public static class TimestampError
    extends IllegalArgumentException {
        public TimestampError(String message, Exception cause) {
            super(message, cause);
        }

        public TimestampError(String message) {
            super(message);
        }
    }
}

