/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.repositories.RepositoryOperation;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.xcontent.ToXContent;

public class SnapshotDeletionsInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final SnapshotDeletionsInProgress EMPTY = new SnapshotDeletionsInProgress(List.of());
    public static final String TYPE = "snapshot_deletions";
    private final List<Entry> entries;

    private SnapshotDeletionsInProgress(List<Entry> entries) {
        this.entries = entries;
        assert ((long)entries.size() == entries.stream().map(Entry::uuid).distinct().count()) : "Found duplicate UUIDs in entries " + String.valueOf(entries);
        assert (SnapshotDeletionsInProgress.assertNoConcurrentDeletionsForSameRepository(entries));
    }

    public static SnapshotDeletionsInProgress of(List<Entry> entries) {
        if (entries.isEmpty()) {
            return EMPTY;
        }
        return new SnapshotDeletionsInProgress(Collections.unmodifiableList(entries));
    }

    public SnapshotDeletionsInProgress(StreamInput in) throws IOException {
        this(in.readCollectionAsImmutableList(Entry::readFrom));
    }

    private static boolean assertNoConcurrentDeletionsForSameRepository(List<Entry> entries) {
        HashSet<String> activeRepositories = new HashSet<String>();
        for (Entry entry : entries) {
            if (entry.state() != State.STARTED) continue;
            boolean added = activeRepositories.add(entry.repository());
            assert (added) : "Found multiple running deletes for a single repository in " + String.valueOf(entries);
        }
        return true;
    }

    public static SnapshotDeletionsInProgress get(ClusterState state) {
        return state.custom(TYPE, EMPTY);
    }

    public SnapshotDeletionsInProgress withAddedEntry(Entry entry) {
        return SnapshotDeletionsInProgress.of(CollectionUtils.appendToCopy(this.getEntries(), entry));
    }

    public SnapshotDeletionsInProgress withRemovedEntry(String deleteUUID) {
        ArrayList<Entry> updatedEntries = new ArrayList<Entry>(this.entries.size() - 1);
        boolean removed = false;
        for (Entry entry : this.entries) {
            if (entry.uuid().equals(deleteUUID)) {
                removed = true;
                continue;
            }
            updatedEntries.add(entry);
        }
        return removed ? SnapshotDeletionsInProgress.of(updatedEntries) : this;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public boolean hasExecutingDeletion(String repository) {
        for (Entry entry : this.entries) {
            if (entry.state() != State.STARTED || !entry.repository().equals(repository)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeletionsInProgress() {
        return !this.entries.isEmpty();
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotDeletionsInProgress that = (SnapshotDeletionsInProgress)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return 31 + this.entries.hashCode();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.entries);
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return SnapshotDeletionsInProgress.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.MINIMUM_COMPATIBLE;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.concat(Iterators.single((builder, params) -> builder.startArray(TYPE)), Iterators.map(this.entries.iterator(), entry -> (builder, params) -> {
            builder.startObject();
            builder.field("project_id", (ToXContent)entry.projectId);
            builder.field("repository", entry.repository());
            builder.startArray("snapshots");
            for (SnapshotId snapshot : entry.snapshots) {
                builder.value(snapshot.getName());
            }
            builder.endArray();
            builder.timestampFieldsFromUnixEpochMillis("start_time_millis", "start_time", entry.startTime);
            builder.field("repository_state_id", entry.repositoryStateId);
            builder.field("state", (Enum)entry.state);
            builder.endObject();
            return builder;
        }), Iterators.single((builder, params) -> builder.endArray()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SnapshotDeletionsInProgress[");
        for (int i = 0; i < this.entries.size(); ++i) {
            builder.append(this.entries.get(i).snapshots());
            if (i + 1 >= this.entries.size()) continue;
            builder.append(",");
        }
        return builder.append("]").toString();
    }

    public record Entry(ProjectId projectId, String repoName, List<SnapshotId> snapshots, long startTime, long repositoryStateId, State state, String uuid) implements Writeable,
    RepositoryOperation
    {
        @SuppressForbidden(reason="using a private constructor within the same file")
        public Entry(ProjectId projectId, String repoName, List<SnapshotId> snapshots, long startTime, long repositoryStateId, State state) {
            this(projectId, repoName, snapshots, startTime, repositoryStateId, state, UUIDs.randomBase64UUID());
        }

        public Entry {
            assert (snapshots.size() == new HashSet<SnapshotId>(snapshots).size()) : "Duplicate snapshot ids in " + String.valueOf(snapshots);
        }

        @SuppressForbidden(reason="using a private constructor within the same file")
        public static Entry readFrom(StreamInput in) throws IOException {
            ProjectId projectId = in.getTransportVersion().onOrAfter(TransportVersions.PROJECT_ID_IN_SNAPSHOTS_DELETIONS_AND_REPO_CLEANUP) ? ProjectId.readFrom(in) : ProjectId.DEFAULT;
            return new Entry(projectId, in.readString(), in.readCollectionAsImmutableList(SnapshotId::new), in.readVLong(), in.readLong(), State.readFrom(in), in.readString());
        }

        @SuppressForbidden(reason="using a private constructor within the same file")
        public Entry started() {
            assert (this.state == State.WAITING);
            return new Entry(this.projectId(), this.repository(), this.snapshots, this.startTime, this.repositoryStateId, State.STARTED, this.uuid);
        }

        @SuppressForbidden(reason="using a private constructor within the same file")
        public Entry withAddedSnapshots(Collection<SnapshotId> newSnapshots) {
            assert (this.state == State.WAITING);
            HashSet<SnapshotId> updatedSnapshots = new HashSet<SnapshotId>(this.snapshots);
            if (!updatedSnapshots.addAll(newSnapshots)) {
                return this;
            }
            return new Entry(this.projectId(), this.repository(), List.copyOf(updatedSnapshots), this.startTime, this.repositoryStateId, State.WAITING, this.uuid);
        }

        @SuppressForbidden(reason="using a private constructor within the same file")
        public Entry withSnapshots(Collection<SnapshotId> snapshots) {
            return new Entry(this.projectId(), this.repository(), List.copyOf(snapshots), this.startTime, this.repositoryStateId, this.state, this.uuid);
        }

        @SuppressForbidden(reason="using a private constructor within the same file")
        public Entry withRepoGen(long repoGen) {
            return new Entry(this.projectId(), this.repository(), this.snapshots, this.startTime, repoGen, this.state, this.uuid);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter(TransportVersions.PROJECT_ID_IN_SNAPSHOTS_DELETIONS_AND_REPO_CLEANUP)) {
                this.projectId.writeTo(out);
            } else if (!ProjectId.DEFAULT.equals(this.projectId)) {
                String message = "Cannot write snapshot deletion entry with non-default project id " + String.valueOf(this.projectId) + " to version before " + String.valueOf(TransportVersions.PROJECT_ID_IN_SNAPSHOTS_DELETIONS_AND_REPO_CLEANUP);
                assert (false) : message;
                throw new IllegalStateException(message);
            }
            out.writeString(this.repoName);
            out.writeCollection(this.snapshots);
            out.writeVLong(this.startTime);
            out.writeLong(this.repositoryStateId);
            this.state.writeTo(out);
            out.writeString(this.uuid);
        }

        @Override
        public String repository() {
            return this.repoName;
        }
    }

    public static enum State implements Writeable
    {
        WAITING(0),
        STARTED(1);

        private final byte value;

        private State(byte value) {
            this.value = value;
        }

        public static State readFrom(StreamInput in) throws IOException {
            byte value = in.readByte();
            return switch (value) {
                case 0 -> WAITING;
                case 1 -> STARTED;
                default -> throw new IllegalArgumentException("No snapshot delete state for value [" + value + "]");
            };
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.value);
        }
    }
}

