/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.SystemDataStreamDescriptor;

public class CreateIndexClusterStateUpdateRequest {
    private final String cause;
    private final ProjectId projectId;
    private final String index;
    private String dataStreamName;
    private final String providedName;
    private long nameResolvedAt;
    private Index recoverFrom;
    private ResizeType resizeType;
    private boolean copySettings;
    private SystemDataStreamDescriptor systemDataStreamDescriptor;
    private boolean isFailureIndex = false;
    private Settings settings = Settings.EMPTY;
    private String mappings = "{}";
    private final Set<Alias> aliases = new HashSet<Alias>();
    private ActiveShardCount waitForActiveShards = ActiveShardCount.DEFAULT;
    private boolean performReroute = true;
    private ComposableIndexTemplate matchingTemplate;

    @Deprecated(forRemoval=true)
    public CreateIndexClusterStateUpdateRequest(String cause, String index, String providedName) {
        this(cause, Metadata.DEFAULT_PROJECT_ID, index, providedName);
    }

    public CreateIndexClusterStateUpdateRequest(String cause, ProjectId projectId, String index, String providedName) {
        this.cause = cause;
        this.projectId = projectId;
        this.index = index;
        this.providedName = providedName;
    }

    public CreateIndexClusterStateUpdateRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public CreateIndexClusterStateUpdateRequest mappings(String mappings) {
        this.mappings = mappings;
        return this;
    }

    public CreateIndexClusterStateUpdateRequest aliases(Set<Alias> aliases) {
        this.aliases.addAll(aliases);
        return this;
    }

    public CreateIndexClusterStateUpdateRequest recoverFrom(Index recoverFrom) {
        this.recoverFrom = recoverFrom;
        return this;
    }

    public CreateIndexClusterStateUpdateRequest waitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return this;
    }

    public CreateIndexClusterStateUpdateRequest resizeType(ResizeType resizeType) {
        this.resizeType = resizeType;
        return this;
    }

    public CreateIndexClusterStateUpdateRequest copySettings(boolean copySettings) {
        this.copySettings = copySettings;
        return this;
    }

    public CreateIndexClusterStateUpdateRequest nameResolvedInstant(long nameResolvedAt) {
        this.nameResolvedAt = nameResolvedAt;
        return this;
    }

    public CreateIndexClusterStateUpdateRequest systemDataStreamDescriptor(SystemDataStreamDescriptor systemDataStreamDescriptor) {
        this.systemDataStreamDescriptor = systemDataStreamDescriptor;
        return this;
    }

    public CreateIndexClusterStateUpdateRequest isFailureIndex(boolean isFailureIndex) {
        this.isFailureIndex = isFailureIndex;
        return this;
    }

    public String cause() {
        return this.cause;
    }

    public String index() {
        return this.index;
    }

    public ProjectId projectId() {
        return this.projectId;
    }

    public Settings settings() {
        return this.settings;
    }

    public String mappings() {
        return this.mappings;
    }

    public Set<Alias> aliases() {
        return this.aliases;
    }

    public Index recoverFrom() {
        return this.recoverFrom;
    }

    public SystemDataStreamDescriptor systemDataStreamDescriptor() {
        return this.systemDataStreamDescriptor;
    }

    public String getProvidedName() {
        return this.providedName;
    }

    public long getNameResolvedAt() {
        return this.nameResolvedAt;
    }

    public ActiveShardCount waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public ResizeType resizeType() {
        return this.resizeType;
    }

    public boolean copySettings() {
        return this.copySettings;
    }

    public String dataStreamName() {
        return this.dataStreamName;
    }

    public boolean isFailureIndex() {
        return this.isFailureIndex;
    }

    public CreateIndexClusterStateUpdateRequest dataStreamName(String dataStreamName) {
        this.dataStreamName = dataStreamName;
        return this;
    }

    public boolean performReroute() {
        return this.performReroute;
    }

    public CreateIndexClusterStateUpdateRequest performReroute(boolean performReroute) {
        this.performReroute = performReroute;
        return this;
    }

    public ComposableIndexTemplate matchingTemplate() {
        return this.matchingTemplate;
    }

    public CreateIndexClusterStateUpdateRequest setMatchingTemplate(ComposableIndexTemplate matchingTemplate) {
        this.matchingTemplate = matchingTemplate;
        return this;
    }

    public String toString() {
        return "CreateIndexClusterStateUpdateRequest{cause='" + this.cause + "', projectId='" + String.valueOf(this.projectId) + "', index='" + this.index + "', dataStreamName='" + this.dataStreamName + "', providedName='" + this.providedName + "', recoverFrom=" + String.valueOf(this.recoverFrom) + ", resizeType=" + String.valueOf((Object)this.resizeType) + ", copySettings=" + this.copySettings + ", settings=" + String.valueOf(this.settings) + ", aliases=" + String.valueOf(this.aliases) + ", waitForActiveShards=" + String.valueOf(this.waitForActiveShards) + ", systemDataStreamDescriptor=" + String.valueOf(this.systemDataStreamDescriptor) + ", matchingTemplate=" + String.valueOf(this.matchingTemplate) + ", isFailureIndex=" + this.isFailureIndex + "}";
    }
}

