/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.storedscripts;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.script.StoredScriptSource;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class PutStoredScriptRequest
extends AcknowledgedRequest<PutStoredScriptRequest>
implements ToXContentFragment {
    @Nullable
    private final String id;
    @Nullable
    private final String context;
    private final int contentLength;
    private final StoredScriptSource source;

    public PutStoredScriptRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readOptionalString();
        if (in.getTransportVersion().isPatchFrom(TransportVersions.V_9_0_0) || in.getTransportVersion().onOrAfter(TransportVersions.STORED_SCRIPT_CONTENT_LENGTH)) {
            this.contentLength = in.readVInt();
        } else {
            BytesReference content = in.readBytesReference();
            this.contentLength = content.length();
            in.readEnum(XContentType.class);
        }
        this.context = in.readOptionalString();
        this.source = new StoredScriptSource(in);
    }

    public PutStoredScriptRequest(TimeValue masterNodeTimeout, TimeValue ackTimeout, @Nullable String id, @Nullable String context, int contentLength, StoredScriptSource source) {
        super(masterNodeTimeout, ackTimeout);
        this.id = id;
        this.context = context;
        this.contentLength = contentLength;
        this.source = Objects.requireNonNull(source);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null || this.id.isEmpty()) {
            validationException = ValidateActions.addValidationError("must specify id for stored script", validationException);
        } else if (this.id.contains("#")) {
            validationException = ValidateActions.addValidationError("id cannot contain '#' for stored script", validationException);
        }
        return validationException;
    }

    public String id() {
        return this.id;
    }

    public String context() {
        return this.context;
    }

    public int contentLength() {
        return this.contentLength;
    }

    public StoredScriptSource source() {
        return this.source;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.id);
        if (out.getTransportVersion().isPatchFrom(TransportVersions.V_9_0_0) || out.getTransportVersion().onOrAfter(TransportVersions.STORED_SCRIPT_CONTENT_LENGTH)) {
            out.writeVInt(this.contentLength);
        } else {
            out.writeBytesReference(new BytesArray(new byte[this.contentLength]));
            XContentHelper.writeTo(out, XContentType.JSON);
        }
        out.writeOptionalString(this.context);
        this.source.writeTo(out);
    }

    @Override
    public String toString() {
        return Strings.format("put stored script {id [%s]%s, content [%s]}", this.id, this.context != null ? ", context [" + this.context + "]" : "", this.source);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field("script", (ToXContent)this.source, params);
    }
}

