/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.restore;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreClusterStateListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportRestoreSnapshotAction
extends TransportMasterNodeAction<RestoreSnapshotRequest, RestoreSnapshotResponse> {
    public static final ActionType<RestoreSnapshotResponse> TYPE = new ActionType("cluster:admin/snapshot/restore");
    private final RestoreService restoreService;

    @Inject
    public TransportRestoreSnapshotAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, RestoreService restoreService, ActionFilters actionFilters) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, RestoreSnapshotRequest::new, RestoreSnapshotResponse::new, threadPool.executor("snapshot_meta"));
        this.restoreService = restoreService;
    }

    @Override
    protected ClusterBlockException checkBlock(RestoreSnapshotRequest request, ClusterState state) {
        ClusterBlockException blockException = state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        if (blockException != null) {
            return blockException;
        }
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    @Override
    protected void masterOperation(Task task, RestoreSnapshotRequest request, ClusterState state, ActionListener<RestoreSnapshotResponse> listener) {
        this.restoreService.restoreSnapshot(request, listener.delegateFailure((delegatedListener, restoreCompletionResponse) -> {
            if (restoreCompletionResponse.restoreInfo() == null && request.waitForCompletion()) {
                RestoreClusterStateListener.createAndRegisterListener(this.clusterService, restoreCompletionResponse, delegatedListener, this.threadPool.getThreadContext());
            } else {
                delegatedListener.onResponse(new RestoreSnapshotResponse(restoreCompletionResponse.restoreInfo()));
            }
        }));
    }
}

