/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.nodes.BaseNodesXContentResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.xcontent.ToXContent;

public class NodesStatsResponse
extends BaseNodesXContentResponse<NodeStats> {
    public NodesStatsResponse(ClusterName clusterName, List<NodeStats> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    @Override
    protected List<NodeStats> readNodesFrom(StreamInput in) throws IOException {
        return (List)TransportAction.localOnly();
    }

    @Override
    protected void writeNodesTo(StreamOutput out, List<NodeStats> nodes) throws IOException {
        TransportAction.localOnly();
    }

    @Override
    protected Iterator<? extends ToXContent> xContentChunks(ToXContent.Params outerParams) {
        if (outerParams.param("include_off_heap") == null) {
            outerParams = new ToXContent.DelegatingMapParams(Map.of("include_off_heap", "true"), outerParams);
        }
        ToXContent.DelegatingMapParams finalOuterParams = new ToXContent.DelegatingMapParams(Map.of("include_off_heap", "true"), outerParams);
        return ChunkedToXContentHelper.object("nodes", Iterators.flatMap(this.getNodes().iterator(), nodeStats -> Iterators.concat(Iterators.single((builder, params) -> {
            builder.startObject(nodeStats.getNode().getId());
            builder.field("timestamp", nodeStats.getTimestamp());
            return builder;
        }), nodeStats.toXContentChunked((ToXContent.Params)finalOuterParams), ChunkedToXContentHelper.endObject())));
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }
}

