/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.elasticsearch.ReleaseVersions;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.Version;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.internal.VersionExtension;
import org.elasticsearch.plugins.ExtensionLoader;

public record TransportVersion(String name, int id, TransportVersion nextPatchVersion) implements VersionId<TransportVersion>
{
    public TransportVersion(int id) {
        this(null, id, null);
    }

    public static TransportVersion fromInputStream(String path, boolean nameInFile, InputStream stream, Integer latest) {
        TransportVersion transportVersion;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        try {
            int i;
            String check;
            String line = reader.readLine();
            String[] parts = line.replaceAll("\\s+", "").split(",");
            while ((check = reader.readLine()) != null) {
                if (check.replaceAll("\\s+", "").isEmpty()) continue;
                throw new IllegalArgumentException("invalid transport version file format [" + path + "]");
            }
            if (parts.length < (nameInFile ? 2 : 1)) {
                throw new IllegalStateException("invalid transport version file format [" + path + "]");
            }
            String name = nameInFile ? parts[0] : path.substring(path.lastIndexOf(47) + 1, path.length() - 4);
            ArrayList<Integer> ids = new ArrayList<Integer>();
            int n = i = nameInFile ? 1 : 0;
            while (i < parts.length) {
                try {
                    ids.add(Integer.parseInt(parts[i]));
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalStateException("invalid transport version file format [" + path + "]", nfe);
                }
                ++i;
            }
            ids.sort(Integer::compareTo);
            TransportVersion transportVersion2 = null;
            for (int idIndex = 0; idIndex < ids.size() && (Integer)ids.get(idIndex) <= latest; ++idIndex) {
                transportVersion2 = new TransportVersion(name, (Integer)ids.get(idIndex), transportVersion2);
            }
            transportVersion = transportVersion2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new UncheckedIOException("cannot parse transport version [" + path + "]", ioe);
            }
        }
        reader.close();
        return transportVersion;
    }

    public static TransportVersion readVersion(StreamInput in) throws IOException {
        return TransportVersion.fromId(in.readVInt());
    }

    public static TransportVersion fromId(int id) {
        TransportVersion known = VersionsHolder.ALL_VERSIONS_BY_ID.get(id);
        if (known != null) {
            return known;
        }
        return new TransportVersion(id);
    }

    public static TransportVersion fromName(String name) {
        TransportVersion known = VersionsHolder.ALL_VERSIONS_BY_NAME.get(name);
        if (known == null) {
            throw new IllegalStateException("unknown transport version [" + name + "]");
        }
        return known;
    }

    public static void writeVersion(TransportVersion version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    public static TransportVersion min(TransportVersion version1, TransportVersion version2) {
        return version1.id < version2.id ? version1 : version2;
    }

    public static TransportVersion max(TransportVersion version1, TransportVersion version2) {
        return version1.id > version2.id ? version1 : version2;
    }

    public static boolean isCompatible(TransportVersion version) {
        return version.onOrAfter(TransportVersions.MINIMUM_COMPATIBLE);
    }

    public static TransportVersion current() {
        return VersionsHolder.CURRENT;
    }

    public static List<TransportVersion> getAllVersions() {
        return VersionsHolder.ALL_VERSIONS;
    }

    public boolean isKnown() {
        return VersionsHolder.ALL_VERSIONS_BY_ID.containsKey(this.id);
    }

    public TransportVersion bestKnownVersion() {
        if (this.isKnown()) {
            return this;
        }
        TransportVersion bestSoFar = TransportVersions.ZERO;
        for (TransportVersion knownVersion : VersionsHolder.ALL_VERSIONS_BY_ID.values()) {
            if (!knownVersion.after(bestSoFar) || !knownVersion.before(this)) continue;
            bestSoFar = knownVersion;
        }
        return bestSoFar;
    }

    public static TransportVersion fromString(String str) {
        return TransportVersion.fromId(Integer.parseInt(str));
    }

    public boolean isPatchFrom(TransportVersion version) {
        return this.onOrAfter(version) && this.id < version.id + 100 - version.id % 100;
    }

    public boolean supports(TransportVersion version) {
        if (this.onOrAfter(version)) {
            return true;
        }
        TransportVersion nextPatchVersion = version.nextPatchVersion;
        while (nextPatchVersion != null) {
            if (this.isPatchFrom(nextPatchVersion)) {
                return true;
            }
            nextPatchVersion = nextPatchVersion.nextPatchVersion;
        }
        return false;
    }

    public String toReleaseVersion() {
        return VersionsHolder.VERSION_LOOKUP_BY_RELEASE.apply(this.id);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportVersion that = (TransportVersion)o;
        return this.id == that.id;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Override
    public String toString() {
        return Integer.toString(this.id);
    }

    private static class VersionsHolder {
        private static final List<TransportVersion> ALL_VERSIONS;
        private static final Map<Integer, TransportVersion> ALL_VERSIONS_BY_ID;
        private static final Map<String, TransportVersion> ALL_VERSIONS_BY_NAME;
        private static final IntFunction<String> VERSION_LOOKUP_BY_RELEASE;
        private static final TransportVersion CURRENT;

        private VersionsHolder() {
        }

        private static Map<String, TransportVersion> loadTransportVersionsByName() {
            HashMap<String, TransportVersion> transportVersions = new HashMap<String, TransportVersion>();
            String latestLocation = "/transport/latest/" + Version.CURRENT.major + "." + Version.CURRENT.minor + ".csv";
            int latestId = -1;
            try (InputStream inputStream = TransportVersion.class.getResourceAsStream(latestLocation);){
                if (inputStream != null) {
                    TransportVersion latest = TransportVersion.fromInputStream(latestLocation, true, inputStream, Integer.MAX_VALUE);
                    if (latest == null) {
                        throw new IllegalStateException("invalid latest transport version for minor version [" + Version.CURRENT.major + "." + Version.CURRENT.minor + "]");
                    }
                    latestId = latest.id();
                }
            }
            catch (IOException ioe) {
                throw new UncheckedIOException("latest transport version file not found at [" + latestLocation + "]", ioe);
            }
            String manifestLocation = "/transport/defined/manifest.txt";
            List<String> versionFileNames = null;
            if (latestId > -1) {
                try (InputStream inputStream = TransportVersion.class.getResourceAsStream(manifestLocation);){
                    if (inputStream != null) {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                        versionFileNames = reader.lines().filter(line -> !line.isBlank()).toList();
                    }
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException("transport version manifest file not found at [" + manifestLocation + "]", ioe);
                }
            }
            if (versionFileNames != null) {
                for (String name : versionFileNames) {
                    String versionLocation = "/transport/defined/" + name;
                    try {
                        InputStream inputStream = TransportVersion.class.getResourceAsStream(versionLocation);
                        try {
                            if (inputStream == null) {
                                throw new IllegalStateException("transport version file not found at [" + versionLocation + "]");
                            }
                            TransportVersion transportVersion = TransportVersion.fromInputStream(versionLocation, false, inputStream, latestId);
                            if (transportVersion == null) continue;
                            transportVersions.put(transportVersion.name(), transportVersion);
                        }
                        finally {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                    }
                    catch (IOException ioe) {
                        throw new UncheckedIOException("transport version file not found at [ " + versionLocation + "]", ioe);
                    }
                }
            }
            return transportVersions;
        }

        private static List<TransportVersion> addTransportVersions(Collection<TransportVersion> addFrom, List<TransportVersion> addTo) {
            for (TransportVersion transportVersion : addFrom) {
                addTo.add(transportVersion);
                for (TransportVersion patchVersion = transportVersion.nextPatchVersion(); patchVersion != null; patchVersion = patchVersion.nextPatchVersion()) {
                    addTo.add(patchVersion);
                }
            }
            return addTo;
        }

        static {
            ArrayList<TransportVersion> allVersions = new ArrayList<TransportVersion>(TransportVersions.DEFINED_VERSIONS);
            Map<String, TransportVersion> allVersionsByName = VersionsHolder.loadTransportVersionsByName();
            VersionsHolder.addTransportVersions(allVersionsByName.values(), allVersions).sort(VersionId::compareTo);
            VERSION_LOOKUP_BY_RELEASE = ReleaseVersions.generateVersionsLookup(TransportVersions.class, ((TransportVersion)allVersions.get(allVersions.size() - 1)).id());
            Collection extendedVersions = ExtensionLoader.loadSingleton(ServiceLoader.load(VersionExtension.class)).map(VersionExtension::getTransportVersions).orElse(Collections.emptyList());
            VersionsHolder.addTransportVersions(extendedVersions, allVersions).sort(VersionId::compareTo);
            for (TransportVersion version : extendedVersions) {
                if (version.name() == null) continue;
                allVersionsByName.put(version.name(), version);
            }
            ALL_VERSIONS = Collections.unmodifiableList(allVersions);
            ALL_VERSIONS_BY_ID = ALL_VERSIONS.stream().collect(Collectors.toUnmodifiableMap(TransportVersion::id, Function.identity()));
            ALL_VERSIONS_BY_NAME = Collections.unmodifiableMap(allVersionsByName);
            CURRENT = ALL_VERSIONS.getLast();
        }
    }
}

