/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.runtime.policy;

import java.lang.invoke.LambdaMetafactory;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.entitlement.bridge.Util;
import org.elasticsearch.entitlement.runtime.policy.FileAccessTree;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;
import org.elasticsearch.entitlement.runtime.policy.Policy;
import org.elasticsearch.entitlement.runtime.policy.Scope;
import org.elasticsearch.entitlement.runtime.policy.entitlements.Entitlement;
import org.elasticsearch.entitlement.runtime.policy.entitlements.FilesEntitlement;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class PolicyManager {
    public static final String ALL_UNNAMED = "ALL-UNNAMED";
    static final Logger generalLogger = LogManager.getLogger(PolicyManager.class);
    static final Set<String> MODULES_EXCLUDED_FROM_SYSTEM_MODULES = Set.of("java.desktop");
    final Map<Module, ModuleEntitlements> moduleEntitlementsMap = new ConcurrentHashMap<Module, ModuleEntitlements>();
    private final Map<String, List<Entitlement>> serverEntitlements;
    private final List<Entitlement> apmAgentEntitlements;
    private final Map<String, Map<String, List<Entitlement>>> pluginsEntitlements;
    private final Function<Class<?>, PolicyScope> scopeResolver;
    private final PathLookup pathLookup;
    private static final Set<Module> SYSTEM_LAYER_MODULES = PolicyManager.findSystemLayerModules();
    public static final Set<Module> SERVER_LAYER_MODULES = ModuleLayer.boot().modules().stream().filter(m -> !SYSTEM_LAYER_MODULES.contains(m)).collect(Collectors.toUnmodifiableSet());
    private final Function<String, Collection<Path>> pluginSourcePathsResolver;
    private final List<FileAccessTree.ExclusivePath> exclusivePaths;

    private FileAccessTree getDefaultFileAccess(Collection<Path> componentPaths) {
        return FileAccessTree.withoutExclusivePaths(FilesEntitlement.EMPTY, this.pathLookup, componentPaths);
    }

    ModuleEntitlements defaultEntitlements(String componentName, Collection<Path> componentPaths, String moduleName) {
        return new ModuleEntitlements(componentName, moduleName, Map.of(), this.getDefaultFileAccess(componentPaths));
    }

    ModuleEntitlements policyEntitlements(String componentName, Collection<Path> componentPaths, String moduleName, List<Entitlement> entitlements) {
        FilesEntitlement filesEntitlement = FilesEntitlement.EMPTY;
        for (Entitlement entitlement : entitlements) {
            if (!(entitlement instanceof FilesEntitlement)) continue;
            filesEntitlement = (FilesEntitlement)entitlement;
        }
        return new ModuleEntitlements(componentName, moduleName, entitlements.stream().collect(Collectors.groupingBy((Function<Entitlement, Class>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getClass(), (Lorg/elasticsearch/entitlement/runtime/policy/entitlements/Entitlement;)Ljava/lang/Class;)())), FileAccessTree.of(componentName, moduleName, filesEntitlement, this.pathLookup, componentPaths, this.exclusivePaths));
    }

    private static Set<Module> findSystemLayerModules() {
        Set systemModulesDescriptors = ModuleFinder.ofSystem().findAll().stream().map(ModuleReference::descriptor).collect(Collectors.toUnmodifiableSet());
        return Stream.concat(Stream.of(PolicyManager.class.getModule()), ModuleLayer.boot().modules().stream().filter(m -> systemModulesDescriptors.contains(m.getDescriptor()) && !MODULES_EXCLUDED_FROM_SYSTEM_MODULES.contains(m.getName()))).collect(Collectors.toUnmodifiableSet());
    }

    public PolicyManager(Policy serverPolicy, List<Entitlement> apmAgentEntitlements, Map<String, Policy> pluginPolicies, Function<Class<?>, PolicyScope> scopeResolver, Function<String, Collection<Path>> pluginSourcePathsResolver, PathLookup pathLookup) {
        this.serverEntitlements = PolicyManager.buildScopeEntitlementsMap(Objects.requireNonNull(serverPolicy));
        this.apmAgentEntitlements = apmAgentEntitlements;
        this.pluginsEntitlements = Objects.requireNonNull(pluginPolicies).entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> PolicyManager.buildScopeEntitlementsMap((Policy)e.getValue())));
        this.scopeResolver = scopeResolver;
        this.pluginSourcePathsResolver = pluginSourcePathsResolver;
        this.pathLookup = Objects.requireNonNull(pathLookup);
        ArrayList<FileAccessTree.ExclusiveFileEntitlement> exclusiveFileEntitlements = new ArrayList<FileAccessTree.ExclusiveFileEntitlement>();
        for (Map.Entry<String, List<Entitlement>> entry : this.serverEntitlements.entrySet()) {
            PolicyManager.validateEntitlementsPerModule(ComponentKind.SERVER.componentName, entry.getKey(), entry.getValue(), exclusiveFileEntitlements);
        }
        PolicyManager.validateEntitlementsPerModule(ComponentKind.APM_AGENT.componentName, ALL_UNNAMED, apmAgentEntitlements, exclusiveFileEntitlements);
        for (Map.Entry<String, Object> entry : this.pluginsEntitlements.entrySet()) {
            for (Map.Entry m : ((Map)entry.getValue()).entrySet()) {
                PolicyManager.validateEntitlementsPerModule(entry.getKey(), (String)m.getKey(), (List)m.getValue(), exclusiveFileEntitlements);
            }
        }
        List<FileAccessTree.ExclusivePath> exclusivePaths = FileAccessTree.buildExclusivePathList(exclusiveFileEntitlements, pathLookup, FileAccessTree.DEFAULT_COMPARISON);
        FileAccessTree.validateExclusivePaths(exclusivePaths, FileAccessTree.DEFAULT_COMPARISON);
        this.exclusivePaths = exclusivePaths;
    }

    private static Map<String, List<Entitlement>> buildScopeEntitlementsMap(Policy policy) {
        return policy.scopes().stream().collect(Collectors.toUnmodifiableMap(Scope::moduleName, Scope::entitlements));
    }

    private static void validateEntitlementsPerModule(String componentName, String moduleName, List<Entitlement> entitlements, List<FileAccessTree.ExclusiveFileEntitlement> exclusiveFileEntitlements) {
        HashSet found = new HashSet();
        for (Entitlement e : entitlements) {
            if (found.contains(e.getClass())) {
                throw new IllegalArgumentException("[" + componentName + "] using module [" + moduleName + "] found duplicate entitlement [" + e.getClass().getName() + "]");
            }
            found.add(e.getClass());
            if (!(e instanceof FilesEntitlement)) continue;
            FilesEntitlement fe = (FilesEntitlement)e;
            exclusiveFileEntitlements.add(new FileAccessTree.ExclusiveFileEntitlement(componentName, moduleName, fe));
        }
    }

    protected ModuleEntitlements getEntitlements(Class<?> requestingClass) {
        return this.moduleEntitlementsMap.computeIfAbsent(requestingClass.getModule(), m -> this.computeEntitlements(requestingClass));
    }

    protected final ModuleEntitlements computeEntitlements(Class<?> requestingClass) {
        PolicyScope policyScope = this.scopeResolver.apply(requestingClass);
        String componentName = policyScope.componentName();
        String moduleName = policyScope.moduleName();
        switch (policyScope.kind().ordinal()) {
            case 1: {
                return this.getModuleScopeEntitlements(this.serverEntitlements, moduleName, ComponentKind.SERVER.componentName, this.getComponentPathsFromClass(requestingClass));
            }
            case 2: {
                return this.policyEntitlements(ComponentKind.APM_AGENT.componentName, this.getComponentPathsFromClass(requestingClass), ALL_UNNAMED, this.apmAgentEntitlements);
            }
            case 0: {
                return this.defaultEntitlements(ComponentKind.UNKNOWN.componentName, List.of(), moduleName);
            }
        }
        assert (policyScope.kind() == ComponentKind.PLUGIN);
        Map<String, List<Entitlement>> pluginEntitlements = this.pluginsEntitlements.get(componentName);
        Collection componentPaths = Objects.requireNonNullElse(this.pluginSourcePathsResolver.apply(componentName), Collections.emptyList());
        if (pluginEntitlements == null) {
            return this.defaultEntitlements(componentName, componentPaths, moduleName);
        }
        return this.getModuleScopeEntitlements(pluginEntitlements, moduleName, componentName, componentPaths);
    }

    protected Collection<Path> getComponentPathsFromClass(Class<?> requestingClass) {
        CodeSource codeSource = requestingClass.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return List.of();
        }
        try {
            return List.of(Paths.get(codeSource.getLocation().toURI()));
        }
        catch (Exception e) {
            generalLogger.info("Cannot get component path for [{}]: [{}] cannot be converted to a valid Path", new Object[]{requestingClass.getName(), codeSource.getLocation().toString()});
            return List.of();
        }
    }

    private ModuleEntitlements getModuleScopeEntitlements(Map<String, List<Entitlement>> scopeEntitlements, String scopeName, String componentName, Collection<Path> componentPaths) {
        List<Entitlement> entitlements = scopeEntitlements.get(scopeName);
        if (entitlements == null) {
            return this.defaultEntitlements(componentName, componentPaths, scopeName);
        }
        return this.policyEntitlements(componentName, componentPaths, scopeName, entitlements);
    }

    boolean isTriviallyAllowed(Class<?> requestingClass) {
        if (requestingClass == null) {
            generalLogger.debug("Entitlement trivially allowed: no caller frames outside the entitlement library");
            return true;
        }
        if (requestingClass == Util.NO_CLASS) {
            generalLogger.debug("Entitlement trivially allowed from outermost frame");
            return true;
        }
        if (this.isTrustedSystemClass(requestingClass)) {
            generalLogger.debug("Entitlement trivially allowed from system module [{}]", new Object[]{requestingClass.getModule().getName()});
            return true;
        }
        generalLogger.trace("Entitlement not trivially allowed");
        return false;
    }

    protected boolean isTrustedSystemClass(Class<?> requestingClass) {
        return SYSTEM_LAYER_MODULES.contains(requestingClass.getModule());
    }

    public String toString() {
        return "PolicyManager{serverEntitlements=" + String.valueOf(this.serverEntitlements) + ", pluginsEntitlements=" + String.valueOf(this.pluginsEntitlements) + "}";
    }

    protected record ModuleEntitlements(String componentName, String moduleName, Map<Class<? extends Entitlement>, List<Entitlement>> entitlementsByType, FileAccessTree fileAccess) {
        public ModuleEntitlements {
            entitlementsByType = Map.copyOf(entitlementsByType);
        }

        public boolean hasEntitlement(Class<? extends Entitlement> entitlementClass) {
            return this.entitlementsByType.containsKey(entitlementClass);
        }

        public <E extends Entitlement> Stream<E> getEntitlements(Class<E> entitlementClass) {
            List<Entitlement> entitlements = this.entitlementsByType.get(entitlementClass);
            if (entitlements == null) {
                return Stream.empty();
            }
            return entitlements.stream().map(entitlementClass::cast);
        }

        Logger logger(Class<?> requestingClass) {
            String packageName = requestingClass.getPackageName();
            String loggerSuffix = "." + this.componentName + "." + (this.moduleName == null ? PolicyManager.ALL_UNNAMED : this.moduleName) + "." + packageName;
            return LogManager.getLogger((String)(PolicyManager.class.getName() + loggerSuffix));
        }
    }

    public static enum ComponentKind {
        UNKNOWN("(unknown)"),
        SERVER("(server)"),
        APM_AGENT("(APM agent)"),
        PLUGIN(null);

        final String componentName;

        private ComponentKind(String componentName) {
            this.componentName = componentName;
        }
    }

    public record PolicyScope(ComponentKind kind, String componentName, String moduleName) {
        public PolicyScope {
            Objects.requireNonNull(kind);
            Objects.requireNonNull(componentName);
            Objects.requireNonNull(moduleName);
            assert (kind.componentName == null || kind.componentName.equals(componentName));
        }

        public static PolicyScope unknown(String moduleName) {
            return new PolicyScope(ComponentKind.UNKNOWN, ComponentKind.UNKNOWN.componentName, moduleName);
        }

        public static PolicyScope server(String moduleName) {
            return new PolicyScope(ComponentKind.SERVER, ComponentKind.SERVER.componentName, moduleName);
        }

        public static PolicyScope apmAgent(String moduleName) {
            return new PolicyScope(ComponentKind.APM_AGENT, ComponentKind.APM_AGENT.componentName, moduleName);
        }

        public static PolicyScope plugin(String componentName, String moduleName) {
            return new PolicyScope(ComponentKind.PLUGIN, componentName, moduleName);
        }
    }
}

