/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.TransportCancelTasksAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.DeleteDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.action.KillProcessAction;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.job.config.Blocked;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public class TransportDeleteJobAction
extends AcknowledgedTransportMasterNodeAction<DeleteJobAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteJobAction.class);
    private final Client client;
    private final PersistentTasksService persistentTasksService;
    private final AnomalyDetectionAuditor auditor;
    private final JobConfigProvider jobConfigProvider;
    private final JobManager jobManager;
    private final DatafeedConfigProvider datafeedConfigProvider;
    private final MlMemoryTracker memoryTracker;
    private final ProjectResolver projectResolver;
    private final Map<String, List<ActionListener<AcknowledgedResponse>>> listenersByJobId;

    @Inject
    public TransportDeleteJobAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, PersistentTasksService persistentTasksService, Client client, AnomalyDetectionAuditor auditor, JobConfigProvider jobConfigProvider, DatafeedConfigProvider datafeedConfigProvider, MlMemoryTracker memoryTracker, JobManager jobManager, ProjectResolver projectResolver) {
        super("cluster:admin/xpack/ml/job/delete", transportService, clusterService, threadPool, actionFilters, DeleteJobAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        this.persistentTasksService = persistentTasksService;
        this.auditor = auditor;
        this.jobConfigProvider = jobConfigProvider;
        this.datafeedConfigProvider = datafeedConfigProvider;
        this.memoryTracker = memoryTracker;
        this.listenersByJobId = new HashMap<String, List<ActionListener<AcknowledgedResponse>>>();
        this.jobManager = jobManager;
        this.projectResolver = projectResolver;
    }

    protected ClusterBlockException checkBlock(DeleteJobAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void masterOperation(Task task, DeleteJobAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        logger.debug(() -> "[" + request.getJobId() + "] deleting job ");
        if (!request.isForce()) {
            TransportDeleteJobAction.checkJobIsNotOpen(request.getJobId(), state);
        }
        TaskId taskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        ParentTaskAssigningClient parentTaskClient = new ParentTaskAssigningClient(this.client, taskId);
        Map<String, List<ActionListener<AcknowledgedResponse>>> map = this.listenersByJobId;
        synchronized (map) {
            if (this.listenersByJobId.containsKey(request.getJobId())) {
                logger.debug(() -> Strings.format((String)"[%s] Deletion task [%s] will wait for existing deletion task to complete", (Object[])new Object[]{request.getJobId(), task.getId()}));
                this.listenersByJobId.get(request.getJobId()).add(listener);
                return;
            }
            ArrayList<ActionListener<AcknowledgedResponse>> listeners = new ArrayList<ActionListener<AcknowledgedResponse>>();
            listeners.add(listener);
            this.listenersByJobId.put(request.getJobId(), listeners);
        }
        ActionListener finalListener = ActionListener.wrap(ack -> this.notifyListeners(request.getJobId(), (AcknowledgedResponse)ack, null), e -> {
            this.notifyListeners(request.getJobId(), null, (Exception)e);
            if (!(ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException)) {
                this.auditor.error(request.getJobId(), Messages.getMessage((String)"Error deleting job: {0}", (Object[])new Object[]{e.getMessage()}));
            }
        });
        ActionListener datafeedDeleteListener = finalListener.delegateFailureAndWrap((delegate, response) -> {
            if (request.isForce()) {
                this.forceDeleteJob(parentTaskClient, request, state, (ActionListener<AcknowledgedResponse>)delegate);
            } else {
                this.normalDeleteJob(parentTaskClient, request, state, (ActionListener<AcknowledgedResponse>)delegate);
            }
        }).delegateFailureAndWrap((delegate, response) -> {
            this.auditor.info(request.getJobId(), Messages.getMessage((String)"Deleting job by task with id ''{0}''", (Object[])new Object[]{taskId}));
            this.cancelResetTaskIfExists(request.getJobId(), (ActionListener<Boolean>)delegate.delegateFailureAndWrap((l, r) -> this.jobConfigProvider.updateJobBlockReason(request.getJobId(), new Blocked(Blocked.Reason.DELETE, taskId), (ActionListener<PutJobAction.Response>)l)));
        });
        ActionListener jobExistsListener = ActionListener.wrap(response -> this.deleteDatafeedIfNecessary(request, (ActionListener<AcknowledgedResponse>)datafeedDeleteListener), e -> {
            if (request.isForce() && MlTasks.getJobTask((String)request.getJobId(), (PersistentTasksCustomMetadata)((PersistentTasksCustomMetadata)state.getMetadata().getProject().custom("persistent_tasks"))) != null) {
                logger.info("[{}] config is missing but task exists. Attempting to delete tasks and stop process", (Object)request.getJobId());
                this.forceDeleteJob(parentTaskClient, request, state, (ActionListener<AcknowledgedResponse>)finalListener);
            } else {
                finalListener.onFailure(e);
            }
        });
        this.jobConfigProvider.jobExists(request.getJobId(), true, null, (ActionListener<Boolean>)jobExistsListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(String jobId, @Nullable AcknowledgedResponse ack, @Nullable Exception error) {
        Map<String, List<ActionListener<AcknowledgedResponse>>> map = this.listenersByJobId;
        synchronized (map) {
            List<ActionListener<AcknowledgedResponse>> listeners = this.listenersByJobId.remove(jobId);
            if (listeners == null) {
                logger.error("[{}] No deletion job listeners could be found", (Object)jobId);
                return;
            }
            for (ActionListener<AcknowledgedResponse> listener : listeners) {
                if (error != null) {
                    listener.onFailure(error);
                    continue;
                }
                listener.onResponse((Object)ack);
            }
        }
    }

    private void normalDeleteJob(ParentTaskAssigningClient parentTaskClient, DeleteJobAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        String jobId = request.getJobId();
        this.memoryTracker.removeAnomalyDetectorJob(jobId);
        this.jobManager.deleteJob(request, (Client)parentTaskClient, state, listener);
    }

    private void forceDeleteJob(ParentTaskAssigningClient parentTaskClient, DeleteJobAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        String jobId = request.getJobId();
        logger.debug(() -> "[" + jobId + "] force deleting job");
        ActionListener removeTaskListener = ActionListener.wrap(response -> this.normalDeleteJob(parentTaskClient, request, this.clusterService.state(), listener), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                this.normalDeleteJob(parentTaskClient, request, this.clusterService.state(), listener);
            } else {
                listener.onFailure(e);
            }
        });
        ActionListener killJobListener = ActionListener.wrap(response -> this.removePersistentTask(jobId, state, (ActionListener<Boolean>)removeTaskListener), e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ElasticsearchStatusException) {
                this.removePersistentTask(jobId, state, (ActionListener<Boolean>)removeTaskListener);
            } else {
                listener.onFailure(e);
            }
        });
        TransportDeleteJobAction.killProcess(parentTaskClient, jobId, (ActionListener<KillProcessAction.Response>)killJobListener);
    }

    private static void killProcess(ParentTaskAssigningClient parentTaskClient, String jobId, ActionListener<KillProcessAction.Response> listener) {
        KillProcessAction.Request killRequest = new KillProcessAction.Request(jobId);
        ClientHelper.executeAsyncWithOrigin((Client)parentTaskClient, (String)"ml", (ActionType)KillProcessAction.INSTANCE, (ActionRequest)killRequest, listener);
    }

    private void removePersistentTask(String jobId, ClusterState currentState, ActionListener<Boolean> listener) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)currentState.getMetadata().getProject().custom("persistent_tasks");
        PersistentTasksCustomMetadata.PersistentTask jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetadata)tasks);
        if (jobTask == null) {
            listener.onResponse(null);
        } else {
            this.persistentTasksService.sendRemoveRequest(jobTask.getId(), MachineLearning.HARD_CODED_MACHINE_LEARNING_MASTER_NODE_TIMEOUT, listener.safeMap(task -> true));
        }
    }

    private static void checkJobIsNotOpen(String jobId, ClusterState state) {
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)state.metadata().getProject().custom("persistent_tasks");
        PersistentTasksCustomMetadata.PersistentTask jobTask = MlTasks.getJobTask((String)jobId, (PersistentTasksCustomMetadata)tasks);
        if (jobTask != null) {
            JobTaskState jobTaskState = (JobTaskState)jobTask.getState();
            throw ExceptionsHelper.conflictStatusException((String)("Cannot delete job [" + jobId + "] because the job is " + String.valueOf(jobTaskState == null ? JobState.OPENING : jobTaskState.getState())), (Object[])new Object[0]);
        }
    }

    private void deleteDatafeedIfNecessary(DeleteJobAction.Request deleteJobRequest, ActionListener<AcknowledgedResponse> listener) {
        this.datafeedConfigProvider.findDatafeedIdsForJobIds(Collections.singletonList(deleteJobRequest.getJobId()), (ActionListener<Set<String>>)ActionListener.wrap(datafeedIds -> {
            assert (datafeedIds.size() <= 1) : "Expected at most 1 datafeed for a single job, got " + String.valueOf(datafeedIds);
            if (datafeedIds.isEmpty()) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
                return;
            }
            DeleteDatafeedAction.Request deleteDatafeedRequest = new DeleteDatafeedAction.Request((String)datafeedIds.iterator().next());
            deleteDatafeedRequest.setForce(deleteJobRequest.isForce());
            deleteDatafeedRequest.ackTimeout(deleteJobRequest.ackTimeout());
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)DeleteDatafeedAction.INSTANCE, (ActionRequest)deleteDatafeedRequest, (ActionListener)ActionListener.wrap(arg_0 -> ((ActionListener)listener).onResponse(arg_0), e -> {
                if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                    listener.onResponse((Object)AcknowledgedResponse.TRUE);
                } else {
                    listener.onFailure((Exception)((Object)ExceptionsHelper.conflictStatusException((String)"failed to delete job [{}] as its datafeed [{}] could not be deleted", (Throwable)e, (Object[])new Object[]{deleteJobRequest.getJobId(), deleteDatafeedRequest.getDatafeedId()})));
                }
            }));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void cancelResetTaskIfExists(String jobId, ActionListener<Boolean> listener) {
        ActionListener jobListener = ActionListener.wrap(jobBuilder -> {
            Job job = jobBuilder.build();
            if (job.getBlocked().getReason() == Blocked.Reason.RESET) {
                logger.info("[{}] Cancelling reset task [{}] because delete was requested", (Object)jobId, (Object)job.getBlocked().getTaskId());
                CancelTasksRequest cancelTasksRequest = new CancelTasksRequest();
                cancelTasksRequest.setReason("deleting job");
                cancelTasksRequest.setActions(new String[]{"cluster:admin/xpack/ml/job/reset"});
                cancelTasksRequest.setTargetTaskId(job.getBlocked().getTaskId());
                ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (ActionType)TransportCancelTasksAction.TYPE, (ActionRequest)cancelTasksRequest, (ActionListener)ActionListener.wrap(cancelTasksResponse -> listener.onResponse((Object)true), e -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof ResourceNotFoundException) {
                        listener.onResponse((Object)true);
                    } else {
                        listener.onFailure(e);
                    }
                }));
            } else {
                listener.onResponse((Object)false);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.jobConfigProvider.getJob(jobId, null, (ActionListener<Job.Builder>)jobListener);
    }
}

