/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.features.ResetFeatureStateResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.Processors;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.AssociatedIndexDescriptor;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.indices.breaker.BreakerSettings;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.CircuitBreakerPlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.plugins.ShutdownAwarePlugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.telemetry.TelemetryProvider;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ScalingExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.SetResetModeActionRequest;
import org.elasticsearch.xpack.core.action.XPackInfoFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.MlConfigIndex;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.MlMetaIndex;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlStatsIndex;
import org.elasticsearch.xpack.core.ml.action.AuditMlNotificationAction;
import org.elasticsearch.xpack.core.ml.action.CancelJobModelSnapshotUpgradeAction;
import org.elasticsearch.xpack.core.ml.action.ClearDeploymentCacheAction;
import org.elasticsearch.xpack.core.ml.action.CloseJobAction;
import org.elasticsearch.xpack.core.ml.action.CoordinatedInferenceAction;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.action.DeleteCalendarAction;
import org.elasticsearch.xpack.core.ml.action.DeleteCalendarEventAction;
import org.elasticsearch.xpack.core.ml.action.DeleteDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.DeleteDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.DeleteExpiredDataAction;
import org.elasticsearch.xpack.core.ml.action.DeleteFilterAction;
import org.elasticsearch.xpack.core.ml.action.DeleteForecastAction;
import org.elasticsearch.xpack.core.ml.action.DeleteJobAction;
import org.elasticsearch.xpack.core.ml.action.DeleteModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.DeleteTrainedModelAction;
import org.elasticsearch.xpack.core.ml.action.DeleteTrainedModelAliasAction;
import org.elasticsearch.xpack.core.ml.action.DeleteTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.action.EstimateModelMemoryAction;
import org.elasticsearch.xpack.core.ml.action.EvaluateDataFrameAction;
import org.elasticsearch.xpack.core.ml.action.ExplainDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.FinalizeJobExecutionAction;
import org.elasticsearch.xpack.core.ml.action.FlushJobAction;
import org.elasticsearch.xpack.core.ml.action.FlushTrainedModelCacheAction;
import org.elasticsearch.xpack.core.ml.action.ForecastJobAction;
import org.elasticsearch.xpack.core.ml.action.GetBucketsAction;
import org.elasticsearch.xpack.core.ml.action.GetCalendarEventsAction;
import org.elasticsearch.xpack.core.ml.action.GetCalendarsAction;
import org.elasticsearch.xpack.core.ml.action.GetCategoriesAction;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.GetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedRunningStateAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetDeploymentStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetFiltersAction;
import org.elasticsearch.xpack.core.ml.action.GetInfluencersAction;
import org.elasticsearch.xpack.core.ml.action.GetJobModelSnapshotsUpgradeStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetMlAutoscalingStats;
import org.elasticsearch.xpack.core.ml.action.GetModelSnapshotsAction;
import org.elasticsearch.xpack.core.ml.action.GetOverallBucketsAction;
import org.elasticsearch.xpack.core.ml.action.GetRecordsAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsAction;
import org.elasticsearch.xpack.core.ml.action.GetTrainedModelsStatsAction;
import org.elasticsearch.xpack.core.ml.action.InferModelAction;
import org.elasticsearch.xpack.core.ml.action.InferTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.action.IsolateDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.KillProcessAction;
import org.elasticsearch.xpack.core.ml.action.MlInfoAction;
import org.elasticsearch.xpack.core.ml.action.MlMemoryAction;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.PersistJobAction;
import org.elasticsearch.xpack.core.ml.action.PostCalendarEventsAction;
import org.elasticsearch.xpack.core.ml.action.PostDataAction;
import org.elasticsearch.xpack.core.ml.action.PreviewDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.PreviewDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.PutCalendarAction;
import org.elasticsearch.xpack.core.ml.action.PutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.PutFilterAction;
import org.elasticsearch.xpack.core.ml.action.PutJobAction;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelAction;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelAliasAction;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelDefinitionPartAction;
import org.elasticsearch.xpack.core.ml.action.PutTrainedModelVocabularyAction;
import org.elasticsearch.xpack.core.ml.action.ResetJobAction;
import org.elasticsearch.xpack.core.ml.action.RevertModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.SetResetModeAction;
import org.elasticsearch.xpack.core.ml.action.SetUpgradeModeAction;
import org.elasticsearch.xpack.core.ml.action.StartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.action.StopDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.StopDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.StopTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.action.TrainedModelCacheInfoAction;
import org.elasticsearch.xpack.core.ml.action.UpdateCalendarJobAction;
import org.elasticsearch.xpack.core.ml.action.UpdateDataFrameAnalyticsAction;
import org.elasticsearch.xpack.core.ml.action.UpdateDatafeedAction;
import org.elasticsearch.xpack.core.ml.action.UpdateFilterAction;
import org.elasticsearch.xpack.core.ml.action.UpdateJobAction;
import org.elasticsearch.xpack.core.ml.action.UpdateModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.UpdateProcessAction;
import org.elasticsearch.xpack.core.ml.action.UpdateTrainedModelAssignmentRoutingInfoAction;
import org.elasticsearch.xpack.core.ml.action.UpdateTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.action.UpgradeJobModelSnapshotAction;
import org.elasticsearch.xpack.core.ml.action.ValidateDetectorAction;
import org.elasticsearch.xpack.core.ml.action.ValidateJobConfigAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsTaskState;
import org.elasticsearch.xpack.core.ml.dataframe.analyses.MlDataFrameAnalysisNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.evaluation.MlEvaluationNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.dataframe.stats.AnalysisStatsNamedWriteablesProvider;
import org.elasticsearch.xpack.core.ml.inference.MlInferenceNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.inference.ModelAliasMetadata;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelCacheMetadata;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignmentMetadata;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskParams;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskState;
import org.elasticsearch.xpack.core.ml.ltr.MlLTRNamedXContentProvider;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.InferenceProcessorInfoExtractor;
import org.elasticsearch.xpack.core.ml.vectors.TextEmbeddingQueryVectorBuilder;
import org.elasticsearch.xpack.core.template.TemplateUtils;
import org.elasticsearch.xpack.ml.DefaultMachineLearningExtension;
import org.elasticsearch.xpack.ml.InvalidLicenseEnforcer;
import org.elasticsearch.xpack.ml.MachineLearningExtension;
import org.elasticsearch.xpack.ml.MachineLearningExtensionHolder;
import org.elasticsearch.xpack.ml.MachineLearningInfoTransportAction;
import org.elasticsearch.xpack.ml.MachineLearningUsageTransportAction;
import org.elasticsearch.xpack.ml.MlAnomaliesIndexUpdate;
import org.elasticsearch.xpack.ml.MlAssignmentNotifier;
import org.elasticsearch.xpack.ml.MlAutoUpdateService;
import org.elasticsearch.xpack.ml.MlConfigMigrationEligibilityCheck;
import org.elasticsearch.xpack.ml.MlIndexRollover;
import org.elasticsearch.xpack.ml.MlIndexTemplateRegistry;
import org.elasticsearch.xpack.ml.MlInitializationService;
import org.elasticsearch.xpack.ml.MlLifeCycleService;
import org.elasticsearch.xpack.ml.MlMetrics;
import org.elasticsearch.xpack.ml.MlUpgradeModeActionFilter;
import org.elasticsearch.xpack.ml.action.TransportAuditMlNotificationAction;
import org.elasticsearch.xpack.ml.action.TransportCancelJobModelSnapshotUpgradeAction;
import org.elasticsearch.xpack.ml.action.TransportClearDeploymentCacheAction;
import org.elasticsearch.xpack.ml.action.TransportCloseJobAction;
import org.elasticsearch.xpack.ml.action.TransportCoordinatedInferenceAction;
import org.elasticsearch.xpack.ml.action.TransportCreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteCalendarAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteCalendarEventAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteExpiredDataAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteFilterAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteForecastAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteJobAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteTrainedModelAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteTrainedModelAliasAction;
import org.elasticsearch.xpack.ml.action.TransportDeleteTrainedModelAssignmentAction;
import org.elasticsearch.xpack.ml.action.TransportEstimateModelMemoryAction;
import org.elasticsearch.xpack.ml.action.TransportEvaluateDataFrameAction;
import org.elasticsearch.xpack.ml.action.TransportExplainDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportExternalInferModelAction;
import org.elasticsearch.xpack.ml.action.TransportFinalizeJobExecutionAction;
import org.elasticsearch.xpack.ml.action.TransportFlushJobAction;
import org.elasticsearch.xpack.ml.action.TransportFlushTrainedModelCacheAction;
import org.elasticsearch.xpack.ml.action.TransportForecastJobAction;
import org.elasticsearch.xpack.ml.action.TransportGetBucketsAction;
import org.elasticsearch.xpack.ml.action.TransportGetCalendarEventsAction;
import org.elasticsearch.xpack.ml.action.TransportGetCalendarsAction;
import org.elasticsearch.xpack.ml.action.TransportGetCategoriesAction;
import org.elasticsearch.xpack.ml.action.TransportGetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportGetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.ml.action.TransportGetDatafeedRunningStateAction;
import org.elasticsearch.xpack.ml.action.TransportGetDatafeedsAction;
import org.elasticsearch.xpack.ml.action.TransportGetDatafeedsStatsAction;
import org.elasticsearch.xpack.ml.action.TransportGetDeploymentStatsAction;
import org.elasticsearch.xpack.ml.action.TransportGetFiltersAction;
import org.elasticsearch.xpack.ml.action.TransportGetInfluencersAction;
import org.elasticsearch.xpack.ml.action.TransportGetJobModelSnapshotsUpgradeStatsAction;
import org.elasticsearch.xpack.ml.action.TransportGetJobsAction;
import org.elasticsearch.xpack.ml.action.TransportGetJobsStatsAction;
import org.elasticsearch.xpack.ml.action.TransportGetMlAutoscalingStats;
import org.elasticsearch.xpack.ml.action.TransportGetModelSnapshotsAction;
import org.elasticsearch.xpack.ml.action.TransportGetOverallBucketsAction;
import org.elasticsearch.xpack.ml.action.TransportGetRecordsAction;
import org.elasticsearch.xpack.ml.action.TransportGetTrainedModelsAction;
import org.elasticsearch.xpack.ml.action.TransportGetTrainedModelsStatsAction;
import org.elasticsearch.xpack.ml.action.TransportInferTrainedModelDeploymentAction;
import org.elasticsearch.xpack.ml.action.TransportInternalInferModelAction;
import org.elasticsearch.xpack.ml.action.TransportIsolateDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportKillProcessAction;
import org.elasticsearch.xpack.ml.action.TransportMlInfoAction;
import org.elasticsearch.xpack.ml.action.TransportMlMemoryAction;
import org.elasticsearch.xpack.ml.action.TransportOpenJobAction;
import org.elasticsearch.xpack.ml.action.TransportPersistJobAction;
import org.elasticsearch.xpack.ml.action.TransportPostCalendarEventsAction;
import org.elasticsearch.xpack.ml.action.TransportPostDataAction;
import org.elasticsearch.xpack.ml.action.TransportPreviewDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportPreviewDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportPutCalendarAction;
import org.elasticsearch.xpack.ml.action.TransportPutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportPutDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportPutFilterAction;
import org.elasticsearch.xpack.ml.action.TransportPutJobAction;
import org.elasticsearch.xpack.ml.action.TransportPutTrainedModelAction;
import org.elasticsearch.xpack.ml.action.TransportPutTrainedModelAliasAction;
import org.elasticsearch.xpack.ml.action.TransportPutTrainedModelDefinitionPartAction;
import org.elasticsearch.xpack.ml.action.TransportPutTrainedModelVocabularyAction;
import org.elasticsearch.xpack.ml.action.TransportResetJobAction;
import org.elasticsearch.xpack.ml.action.TransportRevertModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.TransportSetResetModeAction;
import org.elasticsearch.xpack.ml.action.TransportSetUpgradeModeAction;
import org.elasticsearch.xpack.ml.action.TransportStartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportStartDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportStartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.ml.action.TransportStopDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportStopDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportStopTrainedModelDeploymentAction;
import org.elasticsearch.xpack.ml.action.TransportTrainedModelCacheInfoAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateCalendarJobAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateDatafeedAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateFilterAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateJobAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateProcessAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateTrainedModelAssignmentStateAction;
import org.elasticsearch.xpack.ml.action.TransportUpdateTrainedModelDeploymentAction;
import org.elasticsearch.xpack.ml.action.TransportUpgradeJobModelSnapshotAction;
import org.elasticsearch.xpack.ml.action.TransportValidateDetectorAction;
import org.elasticsearch.xpack.ml.action.TransportValidateJobConfigAction;
import org.elasticsearch.xpack.ml.aggs.categorization.CategorizeTextAggregationBuilder;
import org.elasticsearch.xpack.ml.aggs.categorization.InternalCategorizationAggregation;
import org.elasticsearch.xpack.ml.aggs.changepoint.ChangePointAggregationBuilder;
import org.elasticsearch.xpack.ml.aggs.changepoint.ChangePointNamedContentProvider;
import org.elasticsearch.xpack.ml.aggs.changepoint.InternalChangePointAggregation;
import org.elasticsearch.xpack.ml.aggs.correlation.BucketCorrelationAggregationBuilder;
import org.elasticsearch.xpack.ml.aggs.correlation.CorrelationNamedContentProvider;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.FrequentItemSetsAggregationBuilder;
import org.elasticsearch.xpack.ml.aggs.frequentitemsets.FrequentItemSetsAggregatorFactory;
import org.elasticsearch.xpack.ml.aggs.heuristic.PValueScore;
import org.elasticsearch.xpack.ml.aggs.inference.InferencePipelineAggregationBuilder;
import org.elasticsearch.xpack.ml.aggs.kstest.BucketCountKSTestAggregationBuilder;
import org.elasticsearch.xpack.ml.aggs.kstest.InternalKSTestAggregation;
import org.elasticsearch.xpack.ml.annotations.AnnotationPersister;
import org.elasticsearch.xpack.ml.autoscaling.AbstractNodeAvailabilityZoneMapper;
import org.elasticsearch.xpack.ml.autoscaling.MlAutoscalingDeciderService;
import org.elasticsearch.xpack.ml.autoscaling.MlAutoscalingNamedWritableProvider;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfigAutoUpdater;
import org.elasticsearch.xpack.ml.datafeed.DatafeedContextProvider;
import org.elasticsearch.xpack.ml.datafeed.DatafeedJobBuilder;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;
import org.elasticsearch.xpack.ml.datafeed.DatafeedRunner;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;
import org.elasticsearch.xpack.ml.dataframe.DataFrameAnalyticsManager;
import org.elasticsearch.xpack.ml.dataframe.persistence.DataFrameAnalyticsConfigProvider;
import org.elasticsearch.xpack.ml.dataframe.process.AnalyticsProcessManager;
import org.elasticsearch.xpack.ml.dataframe.process.MemoryUsageEstimationProcessManager;
import org.elasticsearch.xpack.ml.dataframe.process.NativeAnalyticsProcessFactory;
import org.elasticsearch.xpack.ml.dataframe.process.NativeMemoryUsageEstimationProcessFactory;
import org.elasticsearch.xpack.ml.inference.TrainedModelStatsService;
import org.elasticsearch.xpack.ml.inference.adaptiveallocations.AdaptiveAllocationsScalerService;
import org.elasticsearch.xpack.ml.inference.assignment.TrainedModelAssignmentClusterService;
import org.elasticsearch.xpack.ml.inference.assignment.TrainedModelAssignmentService;
import org.elasticsearch.xpack.ml.inference.deployment.DeploymentManager;
import org.elasticsearch.xpack.ml.inference.ingest.InferenceProcessor;
import org.elasticsearch.xpack.ml.inference.loadingservice.ModelLoadingService;
import org.elasticsearch.xpack.ml.inference.ltr.LearningToRankRescorerBuilder;
import org.elasticsearch.xpack.ml.inference.ltr.LearningToRankService;
import org.elasticsearch.xpack.ml.inference.modelsize.MlModelSizeNamedXContentProvider;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelCacheMetadataService;
import org.elasticsearch.xpack.ml.inference.persistence.TrainedModelProvider;
import org.elasticsearch.xpack.ml.inference.pytorch.process.BlackHolePyTorchProcess;
import org.elasticsearch.xpack.ml.inference.pytorch.process.NativePyTorchProcessFactory;
import org.elasticsearch.xpack.ml.inference.pytorch.process.PyTorchProcessFactory;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.JobManagerHolder;
import org.elasticsearch.xpack.ml.job.NodeLoadDetector;
import org.elasticsearch.xpack.ml.job.UpdateJobProcessNotifier;
import org.elasticsearch.xpack.ml.job.categorization.FirstLineWithLettersCharFilterFactory;
import org.elasticsearch.xpack.ml.job.categorization.FirstNonBlankLineCharFilterFactory;
import org.elasticsearch.xpack.ml.job.categorization.MlClassicTokenizerFactory;
import org.elasticsearch.xpack.ml.job.categorization.MlStandardTokenizerFactory;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobDataCountsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsPersister;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectBuilder;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessFactory;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.job.process.autodetect.BlackHoleAutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.NativeAutodetectProcessFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.MultiplyingNormalizerProcess;
import org.elasticsearch.xpack.ml.job.process.normalizer.NativeNormalizerProcessFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerFactory;
import org.elasticsearch.xpack.ml.job.process.normalizer.NormalizerProcessFactory;
import org.elasticsearch.xpack.ml.job.retention.WritableIndexExpander;
import org.elasticsearch.xpack.ml.job.snapshot.upgrader.SnapshotUpgradeTaskExecutor;
import org.elasticsearch.xpack.ml.job.task.OpenJobPersistentTasksExecutor;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.notifications.InferenceAuditor;
import org.elasticsearch.xpack.ml.notifications.SystemAuditor;
import org.elasticsearch.xpack.ml.process.DummyController;
import org.elasticsearch.xpack.ml.process.MlController;
import org.elasticsearch.xpack.ml.process.MlControllerHolder;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;
import org.elasticsearch.xpack.ml.process.NativeController;
import org.elasticsearch.xpack.ml.process.NativeStorageProvider;
import org.elasticsearch.xpack.ml.rest.RestDeleteExpiredDataAction;
import org.elasticsearch.xpack.ml.rest.RestMlInfoAction;
import org.elasticsearch.xpack.ml.rest.RestMlMemoryAction;
import org.elasticsearch.xpack.ml.rest.RestSetUpgradeModeAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestDeleteCalendarAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestDeleteCalendarEventAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestDeleteCalendarJobAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestGetCalendarEventsAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestGetCalendarsAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestPostCalendarEventAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestPutCalendarAction;
import org.elasticsearch.xpack.ml.rest.calendar.RestPutCalendarJobAction;
import org.elasticsearch.xpack.ml.rest.cat.RestCatDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.cat.RestCatDatafeedsAction;
import org.elasticsearch.xpack.ml.rest.cat.RestCatJobsAction;
import org.elasticsearch.xpack.ml.rest.cat.RestCatTrainedModelsAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestDeleteDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestGetDatafeedStatsAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestGetDatafeedsAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestPreviewDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestPutDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestStartDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestStopDatafeedAction;
import org.elasticsearch.xpack.ml.rest.datafeeds.RestUpdateDatafeedAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestDeleteDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestEvaluateDataFrameAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestExplainDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestGetDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestGetDataFrameAnalyticsStatsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestPostDataFrameAnalyticsUpdateAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestPreviewDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestPutDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestStartDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.dataframe.RestStopDataFrameAnalyticsAction;
import org.elasticsearch.xpack.ml.rest.filter.RestDeleteFilterAction;
import org.elasticsearch.xpack.ml.rest.filter.RestGetFiltersAction;
import org.elasticsearch.xpack.ml.rest.filter.RestPutFilterAction;
import org.elasticsearch.xpack.ml.rest.filter.RestUpdateFilterAction;
import org.elasticsearch.xpack.ml.rest.inference.RestClearDeploymentCacheAction;
import org.elasticsearch.xpack.ml.rest.inference.RestDeleteTrainedModelAction;
import org.elasticsearch.xpack.ml.rest.inference.RestDeleteTrainedModelAliasAction;
import org.elasticsearch.xpack.ml.rest.inference.RestGetTrainedModelsAction;
import org.elasticsearch.xpack.ml.rest.inference.RestGetTrainedModelsStatsAction;
import org.elasticsearch.xpack.ml.rest.inference.RestInferTrainedModelAction;
import org.elasticsearch.xpack.ml.rest.inference.RestPutTrainedModelAction;
import org.elasticsearch.xpack.ml.rest.inference.RestPutTrainedModelAliasAction;
import org.elasticsearch.xpack.ml.rest.inference.RestPutTrainedModelDefinitionPartAction;
import org.elasticsearch.xpack.ml.rest.inference.RestPutTrainedModelVocabularyAction;
import org.elasticsearch.xpack.ml.rest.inference.RestStartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.ml.rest.inference.RestStopTrainedModelDeploymentAction;
import org.elasticsearch.xpack.ml.rest.inference.RestUpdateTrainedModelDeploymentAction;
import org.elasticsearch.xpack.ml.rest.job.RestCloseJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestDeleteForecastAction;
import org.elasticsearch.xpack.ml.rest.job.RestDeleteJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestEstimateModelMemoryAction;
import org.elasticsearch.xpack.ml.rest.job.RestFlushJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestForecastJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestGetJobStatsAction;
import org.elasticsearch.xpack.ml.rest.job.RestGetJobsAction;
import org.elasticsearch.xpack.ml.rest.job.RestOpenJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestPostDataAction;
import org.elasticsearch.xpack.ml.rest.job.RestPostJobUpdateAction;
import org.elasticsearch.xpack.ml.rest.job.RestPutJobAction;
import org.elasticsearch.xpack.ml.rest.job.RestResetJobAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestDeleteModelSnapshotAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestGetJobModelSnapshotsUpgradeStatsAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestGetModelSnapshotsAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestRevertModelSnapshotAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestUpdateModelSnapshotAction;
import org.elasticsearch.xpack.ml.rest.modelsnapshots.RestUpgradeJobModelSnapshotAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetBucketsAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetCategoriesAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetInfluencersAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetOverallBucketsAction;
import org.elasticsearch.xpack.ml.rest.results.RestGetRecordsAction;
import org.elasticsearch.xpack.ml.rest.validate.RestValidateDetectorAction;
import org.elasticsearch.xpack.ml.rest.validate.RestValidateJobConfigAction;
import org.elasticsearch.xpack.ml.utils.NativeMemoryCalculator;
import org.elasticsearch.xpack.ml.utils.persistence.ResultsPersisterService;

public class MachineLearning
extends Plugin
implements SystemIndexPlugin,
AnalysisPlugin,
CircuitBreakerPlugin,
IngestPlugin,
PersistentTaskPlugin,
SearchPlugin,
ShutdownAwarePlugin,
ExtensiblePlugin {
    public static final String NAME = "ml";
    public static final String BASE_PATH = "/_ml/";
    public static final String PRE_V7_BASE_PATH = "/_xpack/ml/";
    public static final String DATAFEED_THREAD_POOL_NAME = "ml_datafeed";
    public static final String JOB_COMMS_THREAD_POOL_NAME = "ml_job_comms";
    public static final String NATIVE_INFERENCE_COMMS_THREAD_POOL_NAME = "ml_native_inference_comms";
    public static final String UTILITY_THREAD_POOL_NAME = "ml_utility";
    public static final String TRAINED_MODEL_CIRCUIT_BREAKER_NAME = "model_inference";
    public static final TimeValue HARD_CODED_MACHINE_LEARNING_MASTER_NODE_TIMEOUT = TimeValue.THIRTY_SECONDS;
    private static final long DEFAULT_MODEL_CIRCUIT_BREAKER_LIMIT = (long)(0.5 * (double)JvmInfo.jvmInfo().getMem().getHeapMax().getBytes());
    private static final double DEFAULT_MODEL_CIRCUIT_BREAKER_OVERHEAD = 1.0;
    public static final LicensedFeature.Persistent ML_ANOMALY_JOBS_FEATURE = LicensedFeature.persistent((String)"machine-learning", (String)"anomaly-detection-job", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Persistent ML_ANALYTICS_JOBS_FEATURE = LicensedFeature.persistent((String)"machine-learning", (String)"data-frame-analytics-job", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Persistent ML_MODEL_INFERENCE_FEATURE = LicensedFeature.persistent((String)"machine-learning", (String)"model-inference", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Persistent ML_PYTORCH_MODEL_INFERENCE_FEATURE = LicensedFeature.persistent((String)"machine-learning", (String)"pytorch-model-inference", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Momentary CATEGORIZE_TEXT_AGG_FEATURE = LicensedFeature.momentary((String)"machine-learning", (String)"categorize-text-agg", (License.OperationMode)License.OperationMode.PLATINUM);
    private static final LicensedFeature.Momentary FREQUENT_ITEM_SETS_AGG_FEATURE = LicensedFeature.momentary((String)"machine-learning", (String)"frequent-items-agg", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Momentary INFERENCE_AGG_FEATURE = LicensedFeature.momentary((String)"machine-learning", (String)"inference-agg", (License.OperationMode)License.OperationMode.PLATINUM);
    public static final LicensedFeature.Momentary CHANGE_POINT_AGG_FEATURE = LicensedFeature.momentary((String)"machine-learning", (String)"change-point-agg", (License.OperationMode)License.OperationMode.PLATINUM);
    private static final LicensedFeature.Momentary BUCKET_CORRELATION_AGG_FEATURE = LicensedFeature.momentary((String)"machine-learning", (String)"bucket-correlation-agg", (License.OperationMode)License.OperationMode.PLATINUM);
    private static final LicensedFeature.Momentary BUCKET_COUNT_KS_TEST_AGG_FEATURE = LicensedFeature.momentary((String)"machine-learning", (String)"bucket-count-ks-test-agg", (License.OperationMode)License.OperationMode.PLATINUM);
    private static final FeatureFlag NEW_ML_MEMORY_COMPUTATION_FEATURE_FLAG = new FeatureFlag("new_ml_memory_computation");
    private static final String PRE_V8_MAX_OPEN_JOBS_NODE_ATTR = "ml.max_open_jobs";
    public static final String MACHINE_MEMORY_NODE_ATTR = "ml.machine_memory";
    public static final String MAX_JVM_SIZE_NODE_ATTR = "ml.max_jvm_size";
    public static final String PRE_V_8_5_ALLOCATED_PROCESSORS_NODE_ATTR = "ml.allocated_processors";
    public static final String ALLOCATED_PROCESSORS_NODE_ATTR = "ml.allocated_processors_double";
    public static final Setting<Integer> ALLOCATED_PROCESSORS_SCALE = Setting.intSetting((String)"xpack.ml.allocated_processors_scale", (int)1, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final String ML_CONFIG_VERSION_NODE_ATTR = "ml.config_version";
    public static final Setting<Integer> CONCURRENT_JOB_ALLOCATIONS = Setting.intSetting((String)"xpack.ml.node_concurrent_job_allocations", (int)2, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final ByteSizeValue NATIVE_EXECUTABLE_CODE_OVERHEAD = ByteSizeValue.ofMb((long)30L);
    public static final Setting<Integer> MAX_MACHINE_MEMORY_PERCENT = Setting.intSetting((String)"xpack.ml.max_machine_memory_percent", (int)30, (int)5, (int)200, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    private static final int MAX_MAX_OPEN_JOBS_PER_NODE = 512;
    public static final int DEFAULT_MAX_OPEN_JOBS_PER_NODE = 512;
    public static final Setting<Integer> MAX_OPEN_JOBS_PER_NODE = Setting.intSetting((String)"xpack.ml.max_open_jobs", (int)512, (int)1, (int)512, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> DUMMY_ENTITY_MEMORY = Setting.memorySizeSetting((String)"xpack.ml.dummy_entity_memory", (ByteSizeValue)ByteSizeValue.ZERO, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<Integer> DUMMY_ENTITY_PROCESSORS = Setting.intSetting((String)"xpack.ml.dummy_entity_processors", (int)0, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> PROCESS_CONNECT_TIMEOUT = Setting.timeSetting((String)"xpack.ml.process_connect_timeout", (TimeValue)TimeValue.timeValueSeconds((long)10L), (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> MIN_DISK_SPACE_OFF_HEAP = Setting.byteSizeSetting((String)"xpack.ml.min_disk_space_off_heap", (ByteSizeValue)ByteSizeValue.ofGb((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Float> NIGHTLY_MAINTENANCE_REQUESTS_PER_SECOND = new Setting("xpack.ml.nightly_maintenance_requests_per_second", s -> Float.toString(-1.0f), s -> {
        float value = Float.parseFloat(s);
        if (value <= 0.0f && value != -1.0f) {
            throw new IllegalArgumentException("Failed to parse value [" + s + "] for setting [xpack.ml.nightly_maintenance_requests_per_second] must be > 0.0 or exactly equal to -1.0");
        }
        return Float.valueOf(value);
    }, new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> MAX_ML_NODE_SIZE = Setting.byteSizeSetting((String)"xpack.ml.max_ml_node_size", (ByteSizeValue)ByteSizeValue.ZERO, (Setting.Property[])new Setting.Property[]{Setting.Property.OperatorDynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> DELAYED_DATA_CHECK_FREQ = Setting.timeSetting((String)"xpack.ml.delayed_data_check_freq", (TimeValue)TimeValue.timeValueMinutes((long)15L), (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> SCALE_UP_COOLDOWN_TIME = Setting.timeSetting((String)"xpack.ml.trained_models.adaptive_allocations.scale_up_cooldown_time", (TimeValue)TimeValue.timeValueMinutes((long)5L), (TimeValue)TimeValue.timeValueMinutes((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final Setting<TimeValue> SCALE_TO_ZERO_AFTER_NO_REQUESTS_TIME = Setting.timeSetting((String)"xpack.ml.trained_models.adaptive_allocations.scale_to_zero_time", (TimeValue)TimeValue.timeValueHours((long)24L), (TimeValue)TimeValue.timeValueMinutes((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    public static final int MAX_TRAINED_MODEL_DEPLOYMENTS = 100;
    public static final int MAX_LOW_PRIORITY_MODELS_PER_NODE = 100;
    private static final Logger logger = LogManager.getLogger(MachineLearning.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(MachineLearning.class);
    private final Settings settings;
    private final boolean enabled;
    private final SetOnce<AutodetectProcessManager> autodetectProcessManager = new SetOnce();
    private final SetOnce<DatafeedConfigProvider> datafeedConfigProvider = new SetOnce();
    private final SetOnce<DatafeedRunner> datafeedRunner = new SetOnce();
    private final SetOnce<DataFrameAnalyticsManager> dataFrameAnalyticsManager = new SetOnce();
    private final SetOnce<DataFrameAnalyticsAuditor> dataFrameAnalyticsAuditor = new SetOnce();
    private final SetOnce<AnomalyDetectionAuditor> anomalyDetectionAuditor = new SetOnce();
    private final SetOnce<InferenceAuditor> inferenceAuditor = new SetOnce();
    private final SetOnce<MlMemoryTracker> memoryTracker = new SetOnce();
    private final SetOnce<ActionFilter> mlUpgradeModeActionFilter = new SetOnce();
    private final SetOnce<MlLifeCycleService> mlLifeCycleService = new SetOnce();
    private final SetOnce<CircuitBreaker> inferenceModelBreaker = new SetOnce();
    private final SetOnce<ModelLoadingService> modelLoadingService = new SetOnce();
    private final SetOnce<LearningToRankService> learningToRankService = new SetOnce();
    private final SetOnce<MlAutoscalingDeciderService> mlAutoscalingDeciderService = new SetOnce();
    private final SetOnce<DeploymentManager> deploymentManager = new SetOnce();
    private final SetOnce<TrainedModelAssignmentClusterService> trainedModelAllocationClusterServiceSetOnce = new SetOnce();
    private final SetOnce<MachineLearningExtension> machineLearningExtension = new SetOnce();
    private static final Collection<AssociatedIndexDescriptor> ASSOCIATED_INDEX_DESCRIPTORS = List.of(new AssociatedIndexDescriptor(".ml-anomalies-*", "Results indices"), new AssociatedIndexDescriptor(".ml-state*", "State indices"), new AssociatedIndexDescriptor(MlStatsIndex.indexPattern(), "ML stats index"), new AssociatedIndexDescriptor(".ml-notifications*", "ML notifications indices"), new AssociatedIndexDescriptor(".ml-annotations*", "ML annotations indices"));

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        if (!this.enabled) {
            return Map.of();
        }
        InferenceProcessor.Factory inferenceFactory = new InferenceProcessor.Factory(parameters.client, parameters.ingestService.getClusterService(), this.settings, this.inferenceAuditor);
        parameters.ingestService.addIngestClusterStateListener((Consumer)inferenceFactory);
        return Map.of("inference", inferenceFactory);
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        if (loader != null) {
            loader.loadExtensions(MachineLearningExtension.class).forEach(arg_0 -> this.machineLearningExtension.set(arg_0));
        }
        if (this.machineLearningExtension.get() == null) {
            this.machineLearningExtension.set((Object)new DefaultMachineLearningExtension());
        }
    }

    public MachineLearning(Settings settings) {
        this.settings = settings;
        this.enabled = (Boolean)XPackSettings.MACHINE_LEARNING_ENABLED.get(settings);
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public static boolean isMlNode(DiscoveryNode node) {
        return node.getRoles().contains(DiscoveryNodeRole.ML_ROLE);
    }

    public List<Setting<?>> getSettings() {
        return List.of(ALLOCATED_PROCESSORS_SCALE, MachineLearningField.AUTODETECT_PROCESS, PROCESS_CONNECT_TIMEOUT, CONCURRENT_JOB_ALLOCATIONS, MachineLearningField.MAX_MODEL_MEMORY_LIMIT, MachineLearningField.MAX_LAZY_ML_NODES, MAX_MACHINE_MEMORY_PERCENT, AutodetectBuilder.MAX_ANOMALY_RECORDS_SETTING_DYNAMIC, MAX_OPEN_JOBS_PER_NODE, MIN_DISK_SPACE_OFF_HEAP, MlConfigMigrationEligibilityCheck.ENABLE_CONFIG_MIGRATION, InferenceProcessor.MAX_INFERENCE_PROCESSORS, ModelLoadingService.INFERENCE_MODEL_CACHE_SIZE, ModelLoadingService.INFERENCE_MODEL_CACHE_TTL, ResultsPersisterService.PERSIST_RESULTS_MAX_RETRIES, NIGHTLY_MAINTENANCE_REQUESTS_PER_SECOND, MachineLearningField.USE_AUTO_MACHINE_MEMORY_PERCENT, MAX_ML_NODE_SIZE, DELAYED_DATA_CHECK_FREQ, DUMMY_ENTITY_MEMORY, DUMMY_ENTITY_PROCESSORS, SCALE_UP_COOLDOWN_TIME, SCALE_TO_ZERO_AFTER_NO_REQUESTS_TIME);
    }

    public Settings additionalSettings() {
        String maxOpenJobsPerNodeNodeAttrName = "node.attr.ml.max_open_jobs";
        String machineMemoryAttrName = "node.attr.ml.machine_memory";
        String jvmSizeAttrName = "node.attr.ml.max_jvm_size";
        String deprecatedAllocatedProcessorsAttrName = "node.attr.ml.allocated_processors";
        String allocatedProcessorsAttrName = "node.attr.ml.allocated_processors_double";
        String mlConfigVersionAttrName = "node.attr.ml.config_version";
        Settings.Builder additionalSettings = Settings.builder();
        this.addMlNodeAttribute(additionalSettings, mlConfigVersionAttrName, MlConfigVersion.CURRENT.toString());
        if (this.enabled && DiscoveryNode.hasRole((Settings)this.settings, (DiscoveryNodeRole)DiscoveryNodeRole.ML_ROLE)) {
            this.addMlNodeAttribute(additionalSettings, machineMemoryAttrName, Long.toString(OsProbe.getInstance().osStats().getMem().getAdjustedTotal().getBytes()));
            long jvmSize = Runtime.getRuntime().maxMemory();
            if (NEW_ML_MEMORY_COMPUTATION_FEATURE_FLAG.isEnabled()) {
                jvmSize = JvmInfo.jvmInfo().getMem().getTotalMax().getBytes();
            }
            this.addMlNodeAttribute(additionalSettings, jvmSizeAttrName, Long.toString(jvmSize));
            this.addMlNodeAttribute(additionalSettings, deprecatedAllocatedProcessorsAttrName, Integer.toString(EsExecutors.allocatedProcessors((Settings)this.settings)));
            this.addMlNodeAttribute(additionalSettings, allocatedProcessorsAttrName, Double.toString(this.getAllocatedProcessors().count()));
            this.disallowMlNodeAttributes(maxOpenJobsPerNodeNodeAttrName);
        } else {
            this.disallowMlNodeAttributes(maxOpenJobsPerNodeNodeAttrName, machineMemoryAttrName, jvmSizeAttrName, deprecatedAllocatedProcessorsAttrName, allocatedProcessorsAttrName);
        }
        return additionalSettings.build();
    }

    private void addMlNodeAttribute(Settings.Builder additionalSettings, String attrName, String value) {
        String oldValue = this.settings.get(attrName);
        if (oldValue == null) {
            additionalSettings.put(attrName, value);
        } else {
            MachineLearning.reportClashingNodeAttribute(attrName);
        }
    }

    private Processors getAllocatedProcessors() {
        return EsExecutors.nodeProcessors((Settings)this.settings);
    }

    private void disallowMlNodeAttributes(String ... mlNodeAttributes) {
        for (String attrName : mlNodeAttributes) {
            if (this.settings.get(attrName) == null) continue;
            MachineLearning.reportClashingNodeAttribute(attrName);
        }
    }

    private static void reportClashingNodeAttribute(String attrName) {
        throw new IllegalArgumentException("Directly setting [" + attrName + "] is not permitted - it is reserved for machine learning. If your intention was to customize machine learning, set the [" + attrName.replace("node.attr.", "xpack.") + "] setting instead.");
    }

    public List<SearchPlugin.RescorerSpec<?>> getRescorers() {
        if (this.enabled) {
            return List.of(new SearchPlugin.RescorerSpec(LearningToRankRescorerBuilder.NAME, in -> new LearningToRankRescorerBuilder(in, (LearningToRankService)this.learningToRankService.get()), parser -> LearningToRankRescorerBuilder.fromXContent(parser, (LearningToRankService)this.learningToRankService.get())));
        }
        return List.of();
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        MlController mlController;
        PyTorchProcessFactory pyTorchProcessFactory;
        NativeMemoryUsageEstimationProcessFactory memoryEstimationProcessFactory;
        NativeAnalyticsProcessFactory analyticsProcessFactory;
        NormalizerProcessFactory normalizerProcessFactory;
        AutodetectProcessFactory autodetectProcessFactory;
        Client client = services.client();
        ClusterService clusterService = services.clusterService();
        ThreadPool threadPool = services.threadPool();
        Environment environment = services.environment();
        NamedXContentRegistry xContentRegistry = services.xContentRegistry();
        IndexNameExpressionResolver indexNameExpressionResolver = services.indexNameExpressionResolver();
        TelemetryProvider telemetryProvider = services.telemetryProvider();
        WritableIndexExpander.initialize(clusterService, indexNameExpressionResolver);
        if (!this.enabled) {
            return List.of(new JobManagerHolder(), new MachineLearningExtensionHolder());
        }
        ((MachineLearningExtension)this.machineLearningExtension.get()).configure(environment.settings());
        this.mlUpgradeModeActionFilter.set((Object)new MlUpgradeModeActionFilter(clusterService));
        MlIndexTemplateRegistry registry = new MlIndexTemplateRegistry(this.settings, clusterService, threadPool, client, ((MachineLearningExtension)this.machineLearningExtension.get()).useIlm(), xContentRegistry);
        registry.initialize();
        AnomalyDetectionAuditor anomalyDetectionAuditor = new AnomalyDetectionAuditor(client, clusterService, indexNameExpressionResolver, ((MachineLearningExtension)this.machineLearningExtension.get()).includeNodeInfo());
        this.anomalyDetectionAuditor.set((Object)anomalyDetectionAuditor);
        DataFrameAnalyticsAuditor dataFrameAnalyticsAuditor = new DataFrameAnalyticsAuditor(client, clusterService, indexNameExpressionResolver, ((MachineLearningExtension)this.machineLearningExtension.get()).includeNodeInfo());
        InferenceAuditor inferenceAuditor = new InferenceAuditor(client, clusterService, indexNameExpressionResolver, ((MachineLearningExtension)this.machineLearningExtension.get()).includeNodeInfo());
        this.inferenceAuditor.set((Object)inferenceAuditor);
        SystemAuditor systemAuditor = new SystemAuditor(client, clusterService, indexNameExpressionResolver);
        this.dataFrameAnalyticsAuditor.set((Object)dataFrameAnalyticsAuditor);
        OriginSettingClient originSettingClient = new OriginSettingClient(client, NAME);
        ResultsPersisterService resultsPersisterService = new ResultsPersisterService(threadPool, originSettingClient, clusterService, this.settings);
        AnnotationPersister anomalyDetectionAnnotationPersister = new AnnotationPersister(resultsPersisterService);
        JobResultsProvider jobResultsProvider = new JobResultsProvider(client, this.settings, indexNameExpressionResolver);
        JobResultsPersister jobResultsPersister = new JobResultsPersister(originSettingClient, resultsPersisterService);
        JobDataCountsPersister jobDataCountsPersister = new JobDataCountsPersister(client, resultsPersisterService, anomalyDetectionAuditor);
        JobConfigProvider jobConfigProvider = new JobConfigProvider(client, xContentRegistry);
        DatafeedConfigProvider datafeedConfigProvider = new DatafeedConfigProvider(client, xContentRegistry, clusterService);
        this.datafeedConfigProvider.set((Object)datafeedConfigProvider);
        UpdateJobProcessNotifier notifier = new UpdateJobProcessNotifier(client, clusterService, threadPool);
        JobManager jobManager = new JobManager(jobResultsProvider, jobResultsPersister, clusterService, anomalyDetectionAuditor, threadPool, client, notifier, xContentRegistry, indexNameExpressionResolver, () -> NativeMemoryCalculator.getMaxModelMemoryLimit(clusterService));
        DatafeedManager datafeedManager = new DatafeedManager(datafeedConfigProvider, jobConfigProvider, xContentRegistry, this.settings, client);
        JobManagerHolder jobManagerHolder = new JobManagerHolder(jobManager);
        NativeStorageProvider nativeStorageProvider = new NativeStorageProvider(environment, (ByteSizeValue)MIN_DISK_SPACE_OFF_HEAP.get(this.settings));
        if (((Boolean)MachineLearningField.AUTODETECT_PROCESS.get(this.settings)).booleanValue()) {
            try {
                NativeController nativeController = NativeController.makeNativeController(clusterService.getNodeName(), environment, xContentRegistry);
                autodetectProcessFactory = new NativeAutodetectProcessFactory(environment, this.settings, nativeController, clusterService, resultsPersisterService, anomalyDetectionAuditor);
                normalizerProcessFactory = new NativeNormalizerProcessFactory(environment, nativeController, clusterService);
                analyticsProcessFactory = new NativeAnalyticsProcessFactory(environment, nativeController, clusterService, xContentRegistry, resultsPersisterService, dataFrameAnalyticsAuditor);
                memoryEstimationProcessFactory = new NativeMemoryUsageEstimationProcessFactory(environment, nativeController, clusterService);
                pyTorchProcessFactory = new NativePyTorchProcessFactory(environment, nativeController, clusterService);
                mlController = nativeController;
            }
            catch (IOException e) {
                logger.trace("Failed to connect to ML native controller", (Throwable)e);
                throw new ElasticsearchException("Failure running machine learning native code. This could be due to running on an unsupported OS or distribution, missing OS libraries, or a problem with the temp directory. To bypass this problem by running Elasticsearch without machine learning functionality set [" + XPackSettings.MACHINE_LEARNING_ENABLED.getKey() + ": false].", new Object[0]);
            }
        } else {
            mlController = new DummyController();
            autodetectProcessFactory = (pipelineId, job, autodetectParams, executorService, onProcessCrash) -> new BlackHoleAutodetectProcess(pipelineId, onProcessCrash);
            normalizerProcessFactory = (jobId, quantilesState, bucketSpan, executorService) -> new MultiplyingNormalizerProcess(1.0);
            analyticsProcessFactory = (jobId, analyticsProcessConfig, hasState, executorService, onProcessCrash) -> null;
            memoryEstimationProcessFactory = (jobId, analyticsProcessConfig, hasState, executorService, onProcessCrash) -> null;
            pyTorchProcessFactory = (task, executorService, afterInputStreamClose, onProcessCrash) -> new BlackHolePyTorchProcess();
        }
        NormalizerFactory normalizerFactory = new NormalizerFactory(normalizerProcessFactory, threadPool.executor(UTILITY_THREAD_POOL_NAME));
        AutodetectProcessManager autodetectProcessManager = new AutodetectProcessManager(this.settings, client, threadPool, xContentRegistry, anomalyDetectionAuditor, clusterService, jobManager, jobResultsProvider, jobResultsPersister, jobDataCountsPersister, anomalyDetectionAnnotationPersister, autodetectProcessFactory, normalizerFactory, nativeStorageProvider, indexNameExpressionResolver);
        this.autodetectProcessManager.set((Object)autodetectProcessManager);
        DatafeedJobBuilder datafeedJobBuilder = new DatafeedJobBuilder(client, xContentRegistry, anomalyDetectionAuditor, anomalyDetectionAnnotationPersister, System::currentTimeMillis, jobResultsPersister, this.settings, clusterService);
        DatafeedContextProvider datafeedContextProvider = new DatafeedContextProvider(jobConfigProvider, datafeedConfigProvider, jobResultsProvider);
        DatafeedRunner datafeedRunner = new DatafeedRunner(threadPool, client, clusterService, datafeedJobBuilder, System::currentTimeMillis, anomalyDetectionAuditor, autodetectProcessManager, datafeedContextProvider);
        this.datafeedRunner.set((Object)datafeedRunner);
        TrainedModelStatsService trainedModelStatsService = new TrainedModelStatsService(resultsPersisterService, originSettingClient, indexNameExpressionResolver, clusterService, threadPool);
        TrainedModelCacheMetadataService trainedModelCacheMetadataService = new TrainedModelCacheMetadataService(clusterService, client);
        TrainedModelProvider trainedModelProvider = new TrainedModelProvider(client, trainedModelCacheMetadataService, xContentRegistry);
        ModelLoadingService modelLoadingService = new ModelLoadingService(trainedModelProvider, inferenceAuditor, threadPool, clusterService, trainedModelStatsService, this.settings, clusterService.getNodeName(), (CircuitBreaker)this.inferenceModelBreaker.get(), this.getLicenseState());
        this.modelLoadingService.set((Object)modelLoadingService);
        this.learningToRankService.set((Object)new LearningToRankService(modelLoadingService, trainedModelProvider, services.scriptService(), services.xContentRegistry()));
        this.deploymentManager.set((Object)new DeploymentManager(client, xContentRegistry, threadPool, pyTorchProcessFactory, this.getMaxModelDeploymentsPerNode(), inferenceAuditor));
        AnalyticsProcessManager analyticsProcessManager = new AnalyticsProcessManager(this.settings, client, threadPool, analyticsProcessFactory, dataFrameAnalyticsAuditor, trainedModelProvider, resultsPersisterService, EsExecutors.allocatedProcessors((Settings)this.settings));
        MemoryUsageEstimationProcessManager memoryEstimationProcessManager = new MemoryUsageEstimationProcessManager(threadPool.generic(), threadPool.executor(UTILITY_THREAD_POOL_NAME), memoryEstimationProcessFactory);
        DataFrameAnalyticsConfigProvider dataFrameAnalyticsConfigProvider = new DataFrameAnalyticsConfigProvider(client, xContentRegistry, dataFrameAnalyticsAuditor, clusterService);
        assert (client instanceof NodeClient);
        DataFrameAnalyticsManager dataFrameAnalyticsManager = new DataFrameAnalyticsManager(this.settings, (NodeClient)client, threadPool, clusterService, dataFrameAnalyticsConfigProvider, analyticsProcessManager, dataFrameAnalyticsAuditor, indexNameExpressionResolver, resultsPersisterService, modelLoadingService, ((MachineLearningExtension)this.machineLearningExtension.get()).getAnalyticsDestIndexAllowedSettings());
        this.dataFrameAnalyticsManager.set((Object)dataFrameAnalyticsManager);
        MlMemoryTracker memoryTracker = new MlMemoryTracker(this.settings, clusterService, threadPool, jobManager, jobResultsProvider, dataFrameAnalyticsConfigProvider);
        this.memoryTracker.set((Object)memoryTracker);
        MlLifeCycleService mlLifeCycleService = new MlLifeCycleService(clusterService, datafeedRunner, mlController, autodetectProcessManager, dataFrameAnalyticsManager, memoryTracker);
        this.mlLifeCycleService.set((Object)mlLifeCycleService);
        MlAssignmentNotifier mlAssignmentNotifier = new MlAssignmentNotifier(anomalyDetectionAuditor, dataFrameAnalyticsAuditor, threadPool, clusterService);
        MlAutoUpdateService mlAutoUpdateService = new MlAutoUpdateService(threadPool, List.of(new DatafeedConfigAutoUpdater(datafeedConfigProvider, indexNameExpressionResolver), new MlIndexRollover(List.of(new MlIndexRollover.IndexPatternAndAlias(AnomalyDetectorsIndex.jobStateIndexPattern(), AnomalyDetectorsIndex.jobStateIndexWriteAlias()), new MlIndexRollover.IndexPatternAndAlias(MlStatsIndex.indexPattern(), MlStatsIndex.writeAlias()), new MlIndexRollover.IndexPatternAndAlias(".ml-annotations-*", ".ml-annotations-write")), indexNameExpressionResolver, client), new MlAnomaliesIndexUpdate(indexNameExpressionResolver, client)));
        clusterService.addListener((ClusterStateListener)mlAutoUpdateService);
        InvalidLicenseEnforcer enforcer = new InvalidLicenseEnforcer(this.getLicenseState(), threadPool, datafeedRunner, autodetectProcessManager);
        enforcer.listenForLicenseStateChanges();
        nativeStorageProvider.cleanupLocalTmpStorageInCaseOfUncleanShutdown();
        AbstractNodeAvailabilityZoneMapper nodeAvailabilityZoneMapper = ((MachineLearningExtension)this.machineLearningExtension.get()).getNodeAvailabilityZoneMapper(this.settings, clusterService.getClusterSettings());
        clusterService.addListener((ClusterStateListener)nodeAvailabilityZoneMapper);
        TrainedModelAssignmentService trainedModelAssignmentService = new TrainedModelAssignmentService(client, clusterService, threadPool);
        this.trainedModelAllocationClusterServiceSetOnce.set((Object)new TrainedModelAssignmentClusterService(this.settings, clusterService, threadPool, new NodeLoadDetector(memoryTracker), systemAuditor, nodeAvailabilityZoneMapper, client));
        this.mlAutoscalingDeciderService.set((Object)new MlAutoscalingDeciderService(memoryTracker, this.settings, nodeAvailabilityZoneMapper, clusterService));
        AdaptiveAllocationsScalerService adaptiveAllocationsScalerService = new AdaptiveAllocationsScalerService(threadPool, clusterService, client, inferenceAuditor, telemetryProvider.getMeterRegistry(), ((MachineLearningExtension)this.machineLearningExtension.get()).isNlpEnabled(), this.settings);
        MlInitializationService mlInitializationService = new MlInitializationService(this.settings, threadPool, clusterService, client, adaptiveAllocationsScalerService, mlAssignmentNotifier, ((MachineLearningExtension)this.machineLearningExtension.get()).isAnomalyDetectionEnabled(), ((MachineLearningExtension)this.machineLearningExtension.get()).isDataFrameAnalyticsEnabled(), ((MachineLearningExtension)this.machineLearningExtension.get()).isNlpEnabled());
        MlMetrics mlMetrics = new MlMetrics(telemetryProvider.getMeterRegistry(), clusterService, this.settings, autodetectProcessManager, dataFrameAnalyticsManager);
        return List.of(new Object[]{mlLifeCycleService, new MlControllerHolder(mlController), jobResultsProvider, jobResultsPersister, jobConfigProvider, datafeedConfigProvider, jobManager, jobManagerHolder, autodetectProcessManager, mlInitializationService, adaptiveAllocationsScalerService, jobDataCountsPersister, datafeedRunner, datafeedManager, anomalyDetectionAuditor, dataFrameAnalyticsAuditor, inferenceAuditor, systemAuditor, mlAssignmentNotifier, mlAutoUpdateService, memoryTracker, analyticsProcessManager, memoryEstimationProcessManager, dataFrameAnalyticsConfigProvider, nativeStorageProvider, modelLoadingService, trainedModelCacheMetadataService, trainedModelProvider, trainedModelAssignmentService, this.trainedModelAllocationClusterServiceSetOnce.get(), this.deploymentManager.get(), nodeAvailabilityZoneMapper, new MachineLearningExtensionHolder((MachineLearningExtension)this.machineLearningExtension.get()), mlMetrics});
    }

    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule, IndexNameExpressionResolver expressionResolver) {
        if (!this.enabled) {
            return List.of();
        }
        return List.of(new OpenJobPersistentTasksExecutor(this.settings, clusterService, (AutodetectProcessManager)this.autodetectProcessManager.get(), (DatafeedConfigProvider)this.datafeedConfigProvider.get(), (MlMemoryTracker)this.memoryTracker.get(), client, expressionResolver, this.getLicenseState(), (AnomalyDetectionAuditor)((Object)this.anomalyDetectionAuditor.get())), new TransportStartDatafeedAction.StartDatafeedPersistentTasksExecutor((DatafeedRunner)this.datafeedRunner.get(), expressionResolver, threadPool), new TransportStartDataFrameAnalyticsAction.TaskExecutor(this.settings, client, clusterService, (DataFrameAnalyticsManager)this.dataFrameAnalyticsManager.get(), (DataFrameAnalyticsAuditor)((Object)this.dataFrameAnalyticsAuditor.get()), (MlMemoryTracker)this.memoryTracker.get(), expressionResolver, this.getLicenseState()), new SnapshotUpgradeTaskExecutor(this.settings, clusterService, (AutodetectProcessManager)this.autodetectProcessManager.get(), (MlMemoryTracker)this.memoryTracker.get(), expressionResolver, client, this.getLicenseState(), (AnomalyDetectionAuditor)((Object)this.anomalyDetectionAuditor.get())));
    }

    public List<RestHandler> getRestHandlers(Settings unused, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        if (!this.enabled) {
            return List.of();
        }
        ArrayList<RestHandler> restHandlers = new ArrayList<RestHandler>();
        restHandlers.add((RestHandler)new RestMlInfoAction());
        restHandlers.add((RestHandler)new RestMlMemoryAction());
        restHandlers.add((RestHandler)new RestSetUpgradeModeAction());
        if (((MachineLearningExtension)this.machineLearningExtension.get()).isAnomalyDetectionEnabled()) {
            restHandlers.add((RestHandler)new RestGetJobsAction());
            restHandlers.add((RestHandler)new RestGetJobStatsAction());
            restHandlers.add((RestHandler)new RestPutJobAction());
            restHandlers.add((RestHandler)new RestPostJobUpdateAction());
            restHandlers.add((RestHandler)new RestDeleteJobAction());
            restHandlers.add((RestHandler)new RestOpenJobAction());
            restHandlers.add((RestHandler)new RestGetFiltersAction());
            restHandlers.add((RestHandler)new RestPutFilterAction());
            restHandlers.add((RestHandler)new RestUpdateFilterAction());
            restHandlers.add((RestHandler)new RestDeleteFilterAction());
            restHandlers.add((RestHandler)new RestGetInfluencersAction());
            restHandlers.add((RestHandler)new RestGetRecordsAction());
            restHandlers.add((RestHandler)new RestGetBucketsAction());
            restHandlers.add((RestHandler)new RestGetOverallBucketsAction());
            restHandlers.add((RestHandler)new RestPostDataAction());
            restHandlers.add((RestHandler)new RestCloseJobAction());
            restHandlers.add((RestHandler)new RestFlushJobAction());
            restHandlers.add((RestHandler)new RestResetJobAction());
            restHandlers.add((RestHandler)new RestValidateDetectorAction());
            restHandlers.add((RestHandler)new RestValidateJobConfigAction());
            restHandlers.add((RestHandler)new RestEstimateModelMemoryAction());
            restHandlers.add((RestHandler)new RestGetCategoriesAction());
            restHandlers.add((RestHandler)new RestGetModelSnapshotsAction());
            restHandlers.add((RestHandler)new RestRevertModelSnapshotAction());
            restHandlers.add((RestHandler)new RestUpdateModelSnapshotAction());
            restHandlers.add((RestHandler)new RestGetDatafeedsAction());
            restHandlers.add((RestHandler)new RestGetDatafeedStatsAction());
            restHandlers.add((RestHandler)new RestPutDatafeedAction());
            restHandlers.add((RestHandler)new RestUpdateDatafeedAction());
            restHandlers.add((RestHandler)new RestDeleteDatafeedAction());
            restHandlers.add((RestHandler)new RestPreviewDatafeedAction());
            restHandlers.add((RestHandler)new RestStartDatafeedAction());
            restHandlers.add((RestHandler)new RestStopDatafeedAction());
            restHandlers.add((RestHandler)new RestDeleteModelSnapshotAction());
            restHandlers.add((RestHandler)new RestForecastJobAction());
            restHandlers.add((RestHandler)new RestDeleteForecastAction());
            restHandlers.add((RestHandler)new RestGetCalendarsAction());
            restHandlers.add((RestHandler)new RestPutCalendarAction());
            restHandlers.add((RestHandler)new RestDeleteCalendarAction());
            restHandlers.add((RestHandler)new RestDeleteCalendarEventAction());
            restHandlers.add((RestHandler)new RestDeleteCalendarJobAction());
            restHandlers.add((RestHandler)new RestPutCalendarJobAction());
            restHandlers.add((RestHandler)new RestGetCalendarEventsAction());
            restHandlers.add((RestHandler)new RestPostCalendarEventAction());
            restHandlers.add((RestHandler)new RestUpgradeJobModelSnapshotAction());
            restHandlers.add((RestHandler)new RestGetJobModelSnapshotsUpgradeStatsAction());
            restHandlers.add((RestHandler)new RestDeleteExpiredDataAction());
            restHandlers.add((RestHandler)new RestCatJobsAction());
            restHandlers.add((RestHandler)new RestCatDatafeedsAction());
        }
        if (((MachineLearningExtension)this.machineLearningExtension.get()).isDataFrameAnalyticsEnabled() || ((MachineLearningExtension)this.machineLearningExtension.get()).isNlpEnabled()) {
            restHandlers.add((RestHandler)new RestGetTrainedModelsAction());
            restHandlers.add((RestHandler)new RestDeleteTrainedModelAction());
            restHandlers.add((RestHandler)new RestGetTrainedModelsStatsAction());
            restHandlers.add((RestHandler)new RestPutTrainedModelAction());
            restHandlers.add((RestHandler)new RestPutTrainedModelAliasAction());
            restHandlers.add((RestHandler)new RestDeleteTrainedModelAliasAction());
            restHandlers.add((RestHandler)new RestPutTrainedModelDefinitionPartAction());
            restHandlers.add((RestHandler)new RestInferTrainedModelAction());
            restHandlers.add((RestHandler)new RestCatTrainedModelsAction());
            if (((MachineLearningExtension)this.machineLearningExtension.get()).isDataFrameAnalyticsEnabled()) {
                restHandlers.add((RestHandler)new RestGetDataFrameAnalyticsAction());
                restHandlers.add((RestHandler)new RestGetDataFrameAnalyticsStatsAction());
                restHandlers.add((RestHandler)new RestPutDataFrameAnalyticsAction());
                restHandlers.add((RestHandler)new RestPostDataFrameAnalyticsUpdateAction());
                restHandlers.add((RestHandler)new RestDeleteDataFrameAnalyticsAction());
                restHandlers.add((RestHandler)new RestStartDataFrameAnalyticsAction());
                restHandlers.add((RestHandler)new RestStopDataFrameAnalyticsAction());
                restHandlers.add((RestHandler)new RestEvaluateDataFrameAction());
                restHandlers.add((RestHandler)new RestExplainDataFrameAnalyticsAction());
                restHandlers.add((RestHandler)new RestPreviewDataFrameAnalyticsAction());
                restHandlers.add((RestHandler)new RestCatDataFrameAnalyticsAction());
            }
            if (((MachineLearningExtension)this.machineLearningExtension.get()).isNlpEnabled()) {
                restHandlers.add((RestHandler)new RestStartTrainedModelDeploymentAction(((MachineLearningExtension)this.machineLearningExtension.get()).disableInferenceProcessCache()));
                restHandlers.add((RestHandler)new RestStopTrainedModelDeploymentAction());
                restHandlers.add((RestHandler)new RestUpdateTrainedModelDeploymentAction());
                restHandlers.add((RestHandler)new RestPutTrainedModelVocabularyAction());
                restHandlers.add((RestHandler)new RestClearDeploymentCacheAction());
            }
        }
        return restHandlers;
    }

    public List<ActionPlugin.ActionHandler> getActions() {
        ArrayList<ActionPlugin.ActionHandler> actionHandlers = new ArrayList<ActionPlugin.ActionHandler>();
        actionHandlers.add(new ActionPlugin.ActionHandler(XPackUsageFeatureAction.MACHINE_LEARNING, MachineLearningUsageTransportAction.class));
        actionHandlers.add(new ActionPlugin.ActionHandler(XPackInfoFeatureAction.MACHINE_LEARNING, MachineLearningInfoTransportAction.class));
        if (!this.enabled) {
            return actionHandlers;
        }
        actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)AuditMlNotificationAction.INSTANCE, TransportAuditMlNotificationAction.class));
        actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)MlInfoAction.INSTANCE, TransportMlInfoAction.class));
        actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)MlMemoryAction.INSTANCE, TransportMlMemoryAction.class));
        actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)SetUpgradeModeAction.INSTANCE, TransportSetUpgradeModeAction.class));
        actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)SetResetModeAction.INSTANCE, TransportSetResetModeAction.class));
        actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)TrainedModelCacheInfoAction.INSTANCE, TransportTrainedModelCacheInfoAction.class));
        actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetMlAutoscalingStats.INSTANCE, TransportGetMlAutoscalingStats.class));
        if (((MachineLearningExtension)this.machineLearningExtension.get()).isAnomalyDetectionEnabled()) {
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetJobsAction.INSTANCE, TransportGetJobsAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetJobsStatsAction.INSTANCE, TransportGetJobsStatsAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)PutJobAction.INSTANCE, TransportPutJobAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)UpdateJobAction.INSTANCE, TransportUpdateJobAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)DeleteJobAction.INSTANCE, TransportDeleteJobAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)OpenJobAction.INSTANCE, TransportOpenJobAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetFiltersAction.INSTANCE, TransportGetFiltersAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)PutFilterAction.INSTANCE, TransportPutFilterAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)UpdateFilterAction.INSTANCE, TransportUpdateFilterAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)DeleteFilterAction.INSTANCE, TransportDeleteFilterAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)KillProcessAction.INSTANCE, TransportKillProcessAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetBucketsAction.INSTANCE, TransportGetBucketsAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetInfluencersAction.INSTANCE, TransportGetInfluencersAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetOverallBucketsAction.INSTANCE, TransportGetOverallBucketsAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetRecordsAction.INSTANCE, TransportGetRecordsAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)PostDataAction.INSTANCE, TransportPostDataAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)CloseJobAction.INSTANCE, TransportCloseJobAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)FinalizeJobExecutionAction.INSTANCE, TransportFinalizeJobExecutionAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)FlushJobAction.INSTANCE, TransportFlushJobAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)ResetJobAction.INSTANCE, TransportResetJobAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)ValidateDetectorAction.INSTANCE, TransportValidateDetectorAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)ValidateJobConfigAction.INSTANCE, TransportValidateJobConfigAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)EstimateModelMemoryAction.INSTANCE, TransportEstimateModelMemoryAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetCategoriesAction.INSTANCE, TransportGetCategoriesAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetModelSnapshotsAction.INSTANCE, TransportGetModelSnapshotsAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)RevertModelSnapshotAction.INSTANCE, TransportRevertModelSnapshotAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)UpdateModelSnapshotAction.INSTANCE, TransportUpdateModelSnapshotAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetDatafeedsAction.INSTANCE, TransportGetDatafeedsAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetDatafeedsStatsAction.INSTANCE, TransportGetDatafeedsStatsAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)PutDatafeedAction.INSTANCE, TransportPutDatafeedAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)UpdateDatafeedAction.INSTANCE, TransportUpdateDatafeedAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)DeleteDatafeedAction.INSTANCE, TransportDeleteDatafeedAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)PreviewDatafeedAction.INSTANCE, TransportPreviewDatafeedAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)StartDatafeedAction.INSTANCE, TransportStartDatafeedAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)StopDatafeedAction.INSTANCE, TransportStopDatafeedAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)IsolateDatafeedAction.INSTANCE, TransportIsolateDatafeedAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)DeleteModelSnapshotAction.INSTANCE, TransportDeleteModelSnapshotAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)UpdateProcessAction.INSTANCE, TransportUpdateProcessAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)ForecastJobAction.INSTANCE, TransportForecastJobAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)DeleteForecastAction.INSTANCE, TransportDeleteForecastAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetCalendarsAction.INSTANCE, TransportGetCalendarsAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)PutCalendarAction.INSTANCE, TransportPutCalendarAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)DeleteCalendarAction.INSTANCE, TransportDeleteCalendarAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)DeleteCalendarEventAction.INSTANCE, TransportDeleteCalendarEventAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)UpdateCalendarJobAction.INSTANCE, TransportUpdateCalendarJobAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetCalendarEventsAction.INSTANCE, TransportGetCalendarEventsAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)PostCalendarEventsAction.INSTANCE, TransportPostCalendarEventsAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)PersistJobAction.INSTANCE, TransportPersistJobAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)UpgradeJobModelSnapshotAction.INSTANCE, TransportUpgradeJobModelSnapshotAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)CancelJobModelSnapshotUpgradeAction.INSTANCE, TransportCancelJobModelSnapshotUpgradeAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetJobModelSnapshotsUpgradeStatsAction.INSTANCE, TransportGetJobModelSnapshotsUpgradeStatsAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetDatafeedRunningStateAction.INSTANCE, TransportGetDatafeedRunningStateAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)DeleteExpiredDataAction.INSTANCE, TransportDeleteExpiredDataAction.class));
        }
        if (((MachineLearningExtension)this.machineLearningExtension.get()).isDataFrameAnalyticsEnabled() || ((MachineLearningExtension)this.machineLearningExtension.get()).isNlpEnabled()) {
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetTrainedModelsAction.INSTANCE, TransportGetTrainedModelsAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)DeleteTrainedModelAction.INSTANCE, TransportDeleteTrainedModelAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetTrainedModelsStatsAction.INSTANCE, TransportGetTrainedModelsStatsAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)PutTrainedModelAction.INSTANCE, TransportPutTrainedModelAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)PutTrainedModelAliasAction.INSTANCE, TransportPutTrainedModelAliasAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)DeleteTrainedModelAliasAction.INSTANCE, TransportDeleteTrainedModelAliasAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)PutTrainedModelDefinitionPartAction.INSTANCE, TransportPutTrainedModelDefinitionPartAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)FlushTrainedModelCacheAction.INSTANCE, TransportFlushTrainedModelCacheAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)InferModelAction.INSTANCE, TransportInternalInferModelAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)InferModelAction.EXTERNAL_INSTANCE, TransportExternalInferModelAction.class));
            actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetDeploymentStatsAction.INSTANCE, TransportGetDeploymentStatsAction.class));
            if (((MachineLearningExtension)this.machineLearningExtension.get()).isDataFrameAnalyticsEnabled()) {
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetDataFrameAnalyticsAction.INSTANCE, TransportGetDataFrameAnalyticsAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)GetDataFrameAnalyticsStatsAction.INSTANCE, TransportGetDataFrameAnalyticsStatsAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)PutDataFrameAnalyticsAction.INSTANCE, TransportPutDataFrameAnalyticsAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)UpdateDataFrameAnalyticsAction.INSTANCE, TransportUpdateDataFrameAnalyticsAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)DeleteDataFrameAnalyticsAction.INSTANCE, TransportDeleteDataFrameAnalyticsAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)StartDataFrameAnalyticsAction.INSTANCE, TransportStartDataFrameAnalyticsAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)StopDataFrameAnalyticsAction.INSTANCE, TransportStopDataFrameAnalyticsAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)EvaluateDataFrameAction.INSTANCE, TransportEvaluateDataFrameAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)ExplainDataFrameAnalyticsAction.INSTANCE, TransportExplainDataFrameAnalyticsAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)PreviewDataFrameAnalyticsAction.INSTANCE, TransportPreviewDataFrameAnalyticsAction.class));
            }
            if (((MachineLearningExtension)this.machineLearningExtension.get()).isNlpEnabled()) {
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)StartTrainedModelDeploymentAction.INSTANCE, TransportStartTrainedModelDeploymentAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)StopTrainedModelDeploymentAction.INSTANCE, TransportStopTrainedModelDeploymentAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)InferTrainedModelDeploymentAction.INSTANCE, TransportInferTrainedModelDeploymentAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)UpdateTrainedModelDeploymentAction.INSTANCE, TransportUpdateTrainedModelDeploymentAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)PutTrainedModelVocabularyAction.INSTANCE, TransportPutTrainedModelVocabularyAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)ClearDeploymentCacheAction.INSTANCE, TransportClearDeploymentCacheAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)CreateTrainedModelAssignmentAction.INSTANCE, TransportCreateTrainedModelAssignmentAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)DeleteTrainedModelAssignmentAction.INSTANCE, TransportDeleteTrainedModelAssignmentAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)UpdateTrainedModelAssignmentRoutingInfoAction.INSTANCE, TransportUpdateTrainedModelAssignmentStateAction.class));
                actionHandlers.add(new ActionPlugin.ActionHandler((ActionType)CoordinatedInferenceAction.INSTANCE, TransportCoordinatedInferenceAction.class));
            }
        }
        return actionHandlers;
    }

    public List<ActionFilter> getActionFilters() {
        if (!this.enabled) {
            return List.of();
        }
        return List.of((ActionFilter)this.mlUpgradeModeActionFilter.get());
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings unused) {
        if (!this.enabled) {
            return List.of();
        }
        ScalingExecutorBuilder jobComms = new ScalingExecutorBuilder(JOB_COMMS_THREAD_POOL_NAME, 4, 2048, TimeValue.timeValueMinutes((long)1L), false, "xpack.ml.job_comms_thread_pool");
        ScalingExecutorBuilder pytorchComms = new ScalingExecutorBuilder(NATIVE_INFERENCE_COMMS_THREAD_POOL_NAME, 3, this.getMaxModelDeploymentsPerNode() * 3, TimeValue.timeValueMinutes((long)1L), false, "xpack.ml.native_inference_comms_thread_pool");
        ScalingExecutorBuilder utility = new ScalingExecutorBuilder(UTILITY_THREAD_POOL_NAME, 1, 2048, TimeValue.timeValueMinutes((long)10L), false, "xpack.ml.utility_thread_pool");
        ScalingExecutorBuilder datafeed = new ScalingExecutorBuilder(DATAFEED_THREAD_POOL_NAME, 1, 512, TimeValue.timeValueMinutes((long)1L), false, "xpack.ml.datafeed_thread_pool");
        return List.of(jobComms, pytorchComms, utility, datafeed);
    }

    private int getMaxModelDeploymentsPerNode() {
        return this.getAllocatedProcessors().roundUp() + 100;
    }

    public Map<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> getCharFilters() {
        return Map.of("first_non_blank_line", FirstNonBlankLineCharFilterFactory::new, "first_line_with_letters", FirstLineWithLettersCharFilterFactory::new);
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> getTokenizers() {
        return Map.of("ml_classic", MlClassicTokenizerFactory::new, "ml_standard", MlStandardTokenizerFactory::new);
    }

    public List<SearchPlugin.PipelineAggregationSpec> getPipelineAggregations() {
        return List.of(InferencePipelineAggregationBuilder.buildSpec(this.modelLoadingService, this.getLicenseState(), this.settings), new SearchPlugin.PipelineAggregationSpec(BucketCorrelationAggregationBuilder.NAME, BucketCorrelationAggregationBuilder::new, this.checkAggLicense((ContextParser)BucketCorrelationAggregationBuilder.PARSER, BUCKET_CORRELATION_AGG_FEATURE)), new SearchPlugin.PipelineAggregationSpec(BucketCountKSTestAggregationBuilder.NAME, BucketCountKSTestAggregationBuilder::new, this.checkAggLicense((ContextParser)BucketCountKSTestAggregationBuilder.PARSER, BUCKET_COUNT_KS_TEST_AGG_FEATURE)).addResultReader(InternalKSTestAggregation::new), new SearchPlugin.PipelineAggregationSpec(ChangePointAggregationBuilder.NAME, ChangePointAggregationBuilder::new, this.checkAggLicense((ContextParser)ChangePointAggregationBuilder.PARSER, CHANGE_POINT_AGG_FEATURE)).addResultReader(InternalChangePointAggregation::new));
    }

    public List<SearchPlugin.SignificanceHeuristicSpec<?>> getSignificanceHeuristics() {
        return List.of(new SearchPlugin.SignificanceHeuristicSpec("p_value", PValueScore::new, PValueScore.PARSER));
    }

    public List<SearchPlugin.QueryVectorBuilderSpec<?>> getQueryVectorBuilders() {
        return List.of(new SearchPlugin.QueryVectorBuilderSpec("text_embedding", TextEmbeddingQueryVectorBuilder::new, (BiFunction)TextEmbeddingQueryVectorBuilder.PARSER));
    }

    private <T> ContextParser<String, T> checkAggLicense(ContextParser<String, T> realParser, LicensedFeature.Momentary feature) {
        return (parser, name) -> {
            if (!feature.check(this.getLicenseState())) {
                throw LicenseUtils.newComplianceException((String)feature.getName());
            }
            return realParser.parse(parser, name);
        };
    }

    public List<SearchPlugin.AggregationSpec> getAggregations() {
        return List.of(new SearchPlugin.AggregationSpec("categorize_text", CategorizeTextAggregationBuilder::new, this.checkAggLicense((ContextParser)CategorizeTextAggregationBuilder.PARSER, CATEGORIZE_TEXT_AGG_FEATURE)).addResultReader(InternalCategorizationAggregation::new).setAggregatorRegistrar(s -> s.registerUsage("categorize_text")), new SearchPlugin.AggregationSpec(new ParseField("frequent_item_sets", new String[]{"frequent_items"}), FrequentItemSetsAggregationBuilder::new, this.checkAggLicense((ContextParser)FrequentItemSetsAggregationBuilder.PARSER, FREQUENT_ITEM_SETS_AGG_FEATURE)).addResultReader(FrequentItemSetsAggregatorFactory.getResultReader()).setAggregatorRegistrar(FrequentItemSetsAggregationBuilder::registerAggregators));
    }

    public static boolean criticalTemplatesInstalled(ClusterState clusterState) {
        boolean allPresent = true;
        List<String> templateNames = List.of(".ml-state", AnomalyDetectorsIndex.jobResultsIndexPrefix());
        for (String templateName : templateNames) {
            allPresent = allPresent && TemplateUtils.checkTemplateExistsAndVersionIsGTECurrentVersion((String)templateName, (ClusterState)clusterState, (long)10000004L);
        }
        return allPresent;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        ArrayList<NamedXContentRegistry.Entry> namedXContent = new ArrayList<NamedXContentRegistry.Entry>();
        namedXContent.addAll(new MlEvaluationNamedXContentProvider().getNamedXContentParsers());
        namedXContent.addAll(new MlDataFrameAnalysisNamedXContentProvider().getNamedXContentParsers());
        namedXContent.addAll(new MlInferenceNamedXContentProvider().getNamedXContentParsers());
        namedXContent.addAll(new MlModelSizeNamedXContentProvider().getNamedXContentParsers());
        namedXContent.add(new NamedXContentRegistry.Entry(Metadata.ProjectCustom.class, new ParseField("trained_model_cache_metadata", new String[0]), TrainedModelCacheMetadata::fromXContent));
        namedXContent.add(new NamedXContentRegistry.Entry(Metadata.ProjectCustom.class, new ParseField("trained_model_alias", new String[0]), ModelAliasMetadata::fromXContent));
        namedXContent.add(new NamedXContentRegistry.Entry(Metadata.ProjectCustom.class, new ParseField("trained_model_assignment", new String[0]), TrainedModelAssignmentMetadata::fromXContent));
        namedXContent.add(new NamedXContentRegistry.Entry(Metadata.ProjectCustom.class, new ParseField("trained_model_allocation", new String[0]), TrainedModelAssignmentMetadata::fromXContent));
        namedXContent.addAll(new CorrelationNamedContentProvider().getNamedXContentParsers());
        namedXContent.addAll(new MlLTRNamedXContentProvider().getNamedXContentParsers());
        return namedXContent;
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();
        namedWriteables.add(new NamedWriteableRegistry.Entry(Metadata.ProjectCustom.class, NAME, MlMetadata::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(NamedDiff.class, NAME, MlMetadata.MlMetadataDiff::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(Metadata.ProjectCustom.class, "trained_model_cache_metadata", TrainedModelCacheMetadata::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "trained_model_cache_metadata", TrainedModelCacheMetadata::readDiffFrom));
        namedWriteables.add(new NamedWriteableRegistry.Entry(Metadata.ProjectCustom.class, "trained_model_alias", ModelAliasMetadata::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "trained_model_alias", ModelAliasMetadata::readDiffFrom));
        namedWriteables.add(new NamedWriteableRegistry.Entry(Metadata.ProjectCustom.class, "trained_model_assignment", TrainedModelAssignmentMetadata::fromStream));
        namedWriteables.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "trained_model_assignment", TrainedModelAssignmentMetadata::readDiffFrom));
        namedWriteables.add(new NamedWriteableRegistry.Entry(Metadata.ProjectCustom.class, "trained_model_allocation", TrainedModelAssignmentMetadata::fromStreamOld));
        namedWriteables.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "trained_model_allocation", TrainedModelAssignmentMetadata::readDiffFromOld));
        namedWriteables.add(new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/ml/datafeed", StartDatafeedAction.DatafeedParams::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/ml/job", OpenJobAction.JobParams::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/ml/data_frame/analytics", StartDataFrameAnalyticsAction.TaskParams::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(PersistentTaskParams.class, "xpack/ml/job/snapshot/upgrade", SnapshotUpgradeTaskParams::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(PersistentTaskState.class, "xpack/ml/job", JobTaskState::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(PersistentTaskState.class, "xpack/ml/datafeed", DatafeedState::fromStream));
        namedWriteables.add(new NamedWriteableRegistry.Entry(PersistentTaskState.class, "xpack/ml/data_frame/analytics", DataFrameAnalyticsTaskState::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(PersistentTaskState.class, "xpack/ml/job/snapshot/upgrade", SnapshotUpgradeTaskState::new));
        namedWriteables.addAll(new MlDataFrameAnalysisNamedXContentProvider().getNamedWriteables());
        namedWriteables.addAll(new AnalysisStatsNamedWriteablesProvider().getNamedWriteables());
        namedWriteables.addAll(MlEvaluationNamedXContentProvider.getNamedWriteables());
        namedWriteables.addAll(new MlInferenceNamedXContentProvider().getNamedWriteables());
        namedWriteables.addAll(MlAutoscalingNamedWritableProvider.getNamedWriteables());
        namedWriteables.addAll(new CorrelationNamedContentProvider().getNamedWriteables());
        namedWriteables.addAll(new ChangePointNamedContentProvider().getNamedWriteables());
        namedWriteables.addAll(new MlLTRNamedXContentProvider().getNamedWriteables());
        return namedWriteables;
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings unused) {
        return List.of(SystemIndexDescriptor.builder().setIndexPattern(MlMetaIndex.indexName() + "*").setPrimaryIndex(MlMetaIndex.indexName()).setDescription("Contains scheduling and anomaly tracking metadata").setMappings(MlMetaIndex.mapping()).setSettings(MlMetaIndex.settings()).setOrigin(NAME).build(), SystemIndexDescriptor.builder().setIndexPattern(MlConfigIndex.indexName() + "*").setPrimaryIndex(MlConfigIndex.indexName()).setDescription("Contains ML configuration data").setMappings(MlConfigIndex.mapping()).setSettings(MlConfigIndex.settings()).setOrigin(NAME).build(), MachineLearning.getInferenceIndexSystemIndexDescriptor());
    }

    public static SystemIndexDescriptor getInferenceIndexSystemIndexDescriptor() {
        return SystemIndexDescriptor.builder().setIndexPattern(".ml-inference-*").setPrimaryIndex(".ml-inference-000005").setDescription("Contains ML model configuration and statistics").setMappings(InferenceIndexConstants.mapping()).setSettings(InferenceIndexConstants.settings()).setOrigin(NAME).build();
    }

    public void prepareForIndicesMigration(ClusterService clusterService, Client client, ActionListener<Map<String, Object>> listener) {
        boolean isAlreadyInUpgradeMode = MlMetadata.getMlMetadata((ClusterState)clusterService.state()).isUpgradeMode();
        if (isAlreadyInUpgradeMode) {
            listener.onResponse(Collections.singletonMap("already_in_upgrade_mode", true));
            return;
        }
        OriginSettingClient originClient = new OriginSettingClient(client, NAME);
        originClient.execute((ActionType)SetUpgradeModeAction.INSTANCE, (ActionRequest)new SetUpgradeModeAction.Request(true), listener.delegateFailureAndWrap((l, r) -> l.onResponse(Collections.singletonMap("already_in_upgrade_mode", false))));
    }

    public void indicesMigrationComplete(Map<String, Object> preUpgradeMetadata, ClusterService clusterService, Client client, ActionListener<Boolean> listener) {
        boolean wasAlreadyInUpgradeMode = (Boolean)preUpgradeMetadata.getOrDefault("already_in_upgrade_mode", false);
        if (wasAlreadyInUpgradeMode) {
            listener.onResponse((Object)true);
            return;
        }
        OriginSettingClient originClient = new OriginSettingClient(client, NAME);
        originClient.execute((ActionType)SetUpgradeModeAction.INSTANCE, (ActionRequest)new SetUpgradeModeAction.Request(false), listener.delegateFailureAndWrap((l, r) -> l.onResponse((Object)r.isAcknowledged())));
    }

    public Collection<AssociatedIndexDescriptor> getAssociatedIndexDescriptors() {
        return ASSOCIATED_INDEX_DESCRIPTORS;
    }

    public static String[] getMlHiddenIndexPatterns() {
        return (String[])ASSOCIATED_INDEX_DESCRIPTORS.stream().map(AssociatedIndexDescriptor::getIndexPattern).toArray(String[]::new);
    }

    public UnaryOperator<Map<String, IndexTemplateMetadata>> getIndexTemplateMetadataUpgrader() {
        return templates -> {
            templates.remove(".ml-anomalies-");
            templates.remove(".ml-config");
            templates.remove(".ml-inference-000001");
            templates.remove(".ml-inference-000002");
            templates.remove(".ml-inference-000003");
            templates.remove(".ml-meta");
            templates.remove(".ml-notifications");
            templates.remove(".ml-notifications-000001");
            templates.remove(".ml-state");
            templates.remove(".ml-stats");
            return templates;
        };
    }

    public String getFeatureName() {
        return "machine_learning";
    }

    public String getFeatureDescription() {
        return "Provides anomaly detection and forecasting functionality";
    }

    public void cleanUpFeature(ClusterService clusterService, ProjectResolver projectResolver, Client unwrappedClient, ActionListener<ResetFeatureStateResponse.ResetFeatureStateStatus> finalListener) {
        if (!this.enabled) {
            super.cleanUpFeature(clusterService, projectResolver, unwrappedClient, finalListener);
            return;
        }
        logger.info("Starting machine learning feature reset");
        OriginSettingClient client = new OriginSettingClient(unwrappedClient, NAME);
        ConcurrentHashMap results = new ConcurrentHashMap();
        ActionListener unsetResetModeListener = ActionListener.wrap(success -> {
            this.resetAuditors();
            client.execute((ActionType)SetResetModeAction.INSTANCE, (ActionRequest)SetResetModeActionRequest.disabled((boolean)true), ActionListener.wrap(resetSuccess -> {
                finalListener.onResponse(success);
                logger.info("Finished machine learning feature reset");
            }, resetFailure -> {
                logger.error("failed to disable reset mode after state otherwise successful machine learning reset", (Throwable)resetFailure);
                finalListener.onFailure((Exception)ExceptionsHelper.serverError((String)"failed to disable reset mode after state otherwise successful machine learning reset", (Throwable)resetFailure));
            }));
        }, failure -> {
            logger.error("failed to reset machine learning", (Throwable)failure);
            client.execute((ActionType)SetResetModeAction.INSTANCE, (ActionRequest)SetResetModeActionRequest.disabled((boolean)false), ActionListener.wrap(resetSuccess -> finalListener.onFailure(failure), resetFailure -> {
                logger.error("failed to disable reset mode after state clean up failure", (Throwable)resetFailure);
                finalListener.onFailure(failure);
            }));
        });
        ActionListener pipelineValidation = unsetResetModeListener.delegateFailureAndWrap((delegate, listTasksResponse) -> {
            listTasksResponse.rethrowFailures("Waiting for indexing requests for .ml-* indices");
            if (results.values().stream().allMatch(b -> b)) {
                if (this.memoryTracker.get() != null) {
                    ((MlMemoryTracker)this.memoryTracker.get()).awaitAndClear((ActionListener<Void>)ActionListener.wrap(cacheCleared -> super.cleanUpFeature(clusterService, projectResolver, (Client)client, delegate), clearFailed -> {
                        logger.error("failed to clear memory tracker cache via machine learning reset feature API", (Throwable)clearFailed);
                        super.cleanUpFeature(clusterService, projectResolver, (Client)client, delegate);
                    }));
                    return;
                }
                super.cleanUpFeature(clusterService, projectResolver, (Client)client, delegate);
            } else {
                List<String> failedComponents = results.entrySet().stream().filter(result -> (Boolean)result.getValue() == false).map(Map.Entry::getKey).toList();
                delegate.onFailure((Exception)new RuntimeException("Some machine learning components failed to reset: " + String.valueOf(failedComponents)));
            }
        }).delegateFailureAndWrap((delegate, dataFrameStopResponse) -> {
            results.put("data_frame/analytics", dataFrameStopResponse.isStopped());
            if (results.values().stream().allMatch(b -> b)) {
                ((ListTasksRequestBuilder)client.admin().cluster().prepareListTasks(new String[0]).setActions(new String[]{"xpack/ml/*"})).setWaitForCompletion(true).execute(delegate.delegateFailureAndWrap((l, listMlTasks) -> {
                    listMlTasks.rethrowFailures("Waiting for machine learning tasks");
                    ((ListTasksRequestBuilder)client.admin().cluster().prepareListTasks(new String[0]).setActions(new String[]{"indices:data/write/bulk"})).setDetailed(true).setWaitForCompletion(true).setDescriptions(new String[]{"*.ml-*"}).execute(l);
                }));
            } else {
                List<String> failedComponents = results.entrySet().stream().filter(result -> (Boolean)result.getValue() == false).map(Map.Entry::getKey).toList();
                delegate.onFailure((Exception)new RuntimeException("Some machine learning components failed to reset: " + String.valueOf(failedComponents)));
            }
        }).delegateFailureAndWrap((delegate, closeJobResponse) -> {
            results.put("anomaly_detectors", closeJobResponse.isClosed());
            if (!((MachineLearningExtension)this.machineLearningExtension.get()).isDataFrameAnalyticsEnabled()) {
                delegate.onResponse((Object)new StopDataFrameAnalyticsAction.Response(true));
                return;
            }
            StopDataFrameAnalyticsAction.Request stopDataFramesReq = new StopDataFrameAnalyticsAction.Request("_all").setAllowNoMatch(true);
            client.execute((ActionType)StopDataFrameAnalyticsAction.INSTANCE, (ActionRequest)stopDataFramesReq, ActionListener.wrap(arg_0 -> ((ActionListener)delegate).onResponse(arg_0), failure -> {
                logger.warn("failed stopping data frame analytics jobs for machine learning feature reset. Attempting with force=true", (Throwable)failure);
                client.execute((ActionType)StopDataFrameAnalyticsAction.INSTANCE, (ActionRequest)stopDataFramesReq.setForce(true), delegate);
            }));
        }).delegateFailureAndWrap((delegate, datafeedResponse) -> {
            results.put("datafeeds", datafeedResponse.isStopped());
            if (!((MachineLearningExtension)this.machineLearningExtension.get()).isAnomalyDetectionEnabled()) {
                delegate.onResponse((Object)new CloseJobAction.Response(true));
                return;
            }
            CloseJobAction.Request closeJobsRequest = new CloseJobAction.Request().setAllowNoMatch(true).setJobId("_all");
            client.execute((ActionType)KillProcessAction.INSTANCE, (ActionRequest)new KillProcessAction.Request("*"), delegate.delegateFailureAndWrap((l, success) -> client.execute((ActionType)CloseJobAction.INSTANCE, (ActionRequest)closeJobsRequest, ActionListener.wrap(arg_0 -> ((ActionListener)l).onResponse(arg_0), failure -> {
                logger.warn("failed closing anomaly jobs for machine learning feature reset. Attempting with force=true", (Throwable)failure);
                client.execute((ActionType)CloseJobAction.INSTANCE, (ActionRequest)closeJobsRequest.setForce(true), l);
            }))));
        }).delegateFailureAndWrap((delegate, cancelUpgradesResponse) -> {
            if (!((MachineLearningExtension)this.machineLearningExtension.get()).isAnomalyDetectionEnabled()) {
                delegate.onResponse((Object)new StopDatafeedAction.Response(true));
                return;
            }
            StopDatafeedAction.Request stopDatafeedsReq = new StopDatafeedAction.Request("_all").setAllowNoMatch(true);
            client.execute((ActionType)StopDatafeedAction.INSTANCE, (ActionRequest)stopDatafeedsReq, ActionListener.wrap(arg_0 -> ((ActionListener)delegate).onResponse(arg_0), failure -> {
                logger.warn("failed stopping datafeeds for machine learning feature reset. Attempting with force=true", (Throwable)failure);
                client.execute((ActionType)StopDatafeedAction.INSTANCE, (ActionRequest)stopDatafeedsReq.setForce(true), delegate);
            }));
        }).delegateFailureAndWrap((delegate, acknowledgedResponse) -> {
            if (!((MachineLearningExtension)this.machineLearningExtension.get()).isAnomalyDetectionEnabled()) {
                delegate.onResponse((Object)new CancelJobModelSnapshotUpgradeAction.Response(true));
                return;
            }
            CancelJobModelSnapshotUpgradeAction.Request cancelSnapshotUpgradesReq = new CancelJobModelSnapshotUpgradeAction.Request("_all", "_all");
            client.execute((ActionType)CancelJobModelSnapshotUpgradeAction.INSTANCE, (ActionRequest)cancelSnapshotUpgradesReq, delegate);
        }).delegateFailureAndWrap((delegate, acknowledgedResponse) -> {
            if (this.trainedModelAllocationClusterServiceSetOnce.get() == null || !((MachineLearningExtension)this.machineLearningExtension.get()).isNlpEnabled()) {
                delegate.onResponse((Object)AcknowledgedResponse.TRUE);
                return;
            }
            ((TrainedModelAssignmentClusterService)this.trainedModelAllocationClusterServiceSetOnce.get()).removeAllModelAssignments((ActionListener<AcknowledgedResponse>)delegate);
        });
        ActionListener afterResetModeSet = ActionListener.wrap(acknowledgedResponse -> {
            int numberInferenceProcessors = InferenceProcessorInfoExtractor.countInferenceProcessors((ClusterState)clusterService.state());
            if (numberInferenceProcessors > 0) {
                unsetResetModeListener.onFailure((Exception)new RuntimeException("Unable to reset machine learning feature as there are ingest pipelines still referencing trained machine learning models"));
                return;
            }
            pipelineValidation.onResponse((Object)AcknowledgedResponse.of((boolean)true));
        }, arg_0 -> finalListener.onFailure(arg_0));
        client.execute((ActionType)SetResetModeAction.INSTANCE, (ActionRequest)SetResetModeActionRequest.enabled(), afterResetModeSet);
    }

    private void resetAuditors() {
        if (this.anomalyDetectionAuditor.get() != null) {
            ((AnomalyDetectionAuditor)((Object)this.anomalyDetectionAuditor.get())).reset();
        }
        if (this.dataFrameAnalyticsAuditor.get() != null) {
            ((DataFrameAnalyticsAuditor)((Object)this.dataFrameAnalyticsAuditor.get())).reset();
        }
        if (this.inferenceAuditor.get() != null) {
            ((InferenceAuditor)((Object)this.inferenceAuditor.get())).reset();
        }
    }

    public BreakerSettings getCircuitBreaker(Settings settingsToUse) {
        return BreakerSettings.updateFromSettings((BreakerSettings)new BreakerSettings(TRAINED_MODEL_CIRCUIT_BREAKER_NAME, DEFAULT_MODEL_CIRCUIT_BREAKER_LIMIT, 1.0, CircuitBreaker.Type.MEMORY, CircuitBreaker.Durability.TRANSIENT), (Settings)settingsToUse);
    }

    public void setCircuitBreaker(CircuitBreaker circuitBreaker) {
        assert (circuitBreaker.getName().equals(TRAINED_MODEL_CIRCUIT_BREAKER_NAME));
        this.inferenceModelBreaker.set((Object)circuitBreaker);
    }

    public Collection<AutoscalingDeciderService> deciders() {
        if (this.enabled) {
            assert (this.mlAutoscalingDeciderService.get() != null);
            return List.of((AutoscalingDeciderService)this.mlAutoscalingDeciderService.get());
        }
        return List.of();
    }

    public boolean safeToShutdown(String nodeId, SingleNodeShutdownMetadata.Type shutdownType) {
        if (!this.enabled) {
            return true;
        }
        return ((MlLifeCycleService)this.mlLifeCycleService.get()).isNodeSafeToShutdown(nodeId);
    }

    public void signalShutdown(Collection<String> shutdownNodeIds) {
        if (this.enabled) {
            ((MlLifeCycleService)this.mlLifeCycleService.get()).signalGracefulShutdown(shutdownNodeIds);
        }
    }
}

