/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.compute.operator.DriverCompletionInfo;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.indices.IndicesExpressionGrouper;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.analysis.Analyzer;
import org.elasticsearch.xpack.esql.index.IndexResolution;
import org.elasticsearch.xpack.esql.plan.IndexPattern;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.session.EsqlLicenseChecker;
import org.elasticsearch.xpack.esql.session.NoClustersToSearchException;
import org.elasticsearch.xpack.esql.session.Result;

public class EsqlCCSUtils {
    private EsqlCCSUtils() {
    }

    static Map<String, List<FieldCapabilitiesFailure>> groupFailuresPerCluster(List<FieldCapabilitiesFailure> failures) {
        HashMap<String, List<FieldCapabilitiesFailure>> perCluster = new HashMap<String, List<FieldCapabilitiesFailure>>();
        for (FieldCapabilitiesFailure failure : failures) {
            String cluster = RemoteClusterAware.parseClusterAlias((String)failure.getIndices()[0]);
            perCluster.computeIfAbsent(cluster, k -> new ArrayList()).add(failure);
        }
        return perCluster;
    }

    static Map<String, FieldCapabilitiesFailure> determineUnavailableRemoteClusters(Map<String, List<FieldCapabilitiesFailure>> failures) {
        HashMap<String, FieldCapabilitiesFailure> unavailableRemotes = new HashMap<String, FieldCapabilitiesFailure>(failures.size());
        for (Map.Entry<String, List<FieldCapabilitiesFailure>> e : failures.entrySet()) {
            if (Strings.isEmpty((CharSequence)e.getKey()) || !e.getValue().stream().allMatch(f -> ExceptionsHelper.isRemoteUnavailableException((Exception)f.getException()))) continue;
            unavailableRemotes.put(e.getKey(), e.getValue().get(0));
        }
        return unavailableRemotes;
    }

    static boolean returnSuccessWithEmptyResult(EsqlExecutionInfo executionInfo, Exception e) {
        if (!executionInfo.isCrossClusterSearch()) {
            return false;
        }
        if (e instanceof NoClustersToSearchException || ExceptionsHelper.isRemoteUnavailableException((Exception)e)) {
            for (String clusterAlias : executionInfo.clusterAliases()) {
                if (executionInfo.isSkipUnavailable(clusterAlias) || clusterAlias.equals("")) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static void updateExecutionInfoToReturnEmptyResult(EsqlExecutionInfo executionInfo, Exception e) {
        executionInfo.markEndQuery();
        Exception exceptionForResponse = e instanceof ConnectTransportException ? new RemoteTransportException("connect_transport_exception - unable to connect to remote cluster", null) : e;
        for (String clusterAlias : executionInfo.clusterAliases()) {
            executionInfo.swapCluster(clusterAlias, (k, v) -> {
                EsqlExecutionInfo.Cluster.Builder builder = new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setTook(executionInfo.overallTook()).setTotalShards(0).setSuccessfulShards(0).setSkippedShards(0).setFailedShards(0);
                if ("".equals(clusterAlias)) {
                    builder.setStatus(EsqlExecutionInfo.Cluster.Status.SUCCESSFUL);
                } else {
                    builder.setStatus(EsqlExecutionInfo.Cluster.Status.SKIPPED);
                    if (v.getFailures().isEmpty()) {
                        builder.addFailures(List.of(new ShardSearchFailure(exceptionForResponse)));
                    }
                }
                return builder.build();
            });
        }
    }

    static String createIndexExpressionFromAvailableClusters(EsqlExecutionInfo executionInfo) {
        StringBuilder sb = new StringBuilder();
        for (String clusterAlias : executionInfo.clusterAliases()) {
            EsqlExecutionInfo.Cluster cluster = executionInfo.getCluster(clusterAlias);
            if (cluster.getStatus() == EsqlExecutionInfo.Cluster.Status.SKIPPED || cluster.getStatus() == EsqlExecutionInfo.Cluster.Status.SUCCESSFUL) continue;
            if (cluster.getClusterAlias().equals("")) {
                sb.append(executionInfo.getCluster(clusterAlias).getIndexExpression()).append(',');
                continue;
            }
            String indexExpression = executionInfo.getCluster(clusterAlias).getIndexExpression();
            for (String index : indexExpression.split(",")) {
                sb.append(clusterAlias).append(':').append(index).append(',');
            }
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    static void updateExecutionInfoWithUnavailableClusters(EsqlExecutionInfo execInfo, Map<String, List<FieldCapabilitiesFailure>> failures) {
        Map<String, FieldCapabilitiesFailure> unavailable = EsqlCCSUtils.determineUnavailableRemoteClusters(failures);
        for (Map.Entry<String, FieldCapabilitiesFailure> entry : unavailable.entrySet()) {
            String clusterAlias = entry.getKey();
            boolean skipUnavailable = execInfo.getCluster(clusterAlias).isSkipUnavailable();
            RemoteTransportException e = new RemoteTransportException(Strings.format((String)"Remote cluster [%s] (with setting skip_unavailable=%s) is not available", (Object[])new Object[]{clusterAlias, skipUnavailable}), (Throwable)entry.getValue().getException());
            if (skipUnavailable) {
                EsqlCCSUtils.markClusterWithFinalStateAndNoShards(execInfo, clusterAlias, EsqlExecutionInfo.Cluster.Status.SKIPPED, (Exception)e);
                continue;
            }
            throw e;
        }
    }

    static void updateExecutionInfoWithClustersWithNoMatchingIndices(EsqlExecutionInfo executionInfo, IndexResolution indexResolution, boolean usedFilter) {
        Set clustersWithNoMatchingIndices = executionInfo.getClusterStates(EsqlExecutionInfo.Cluster.Status.RUNNING).map(EsqlExecutionInfo.Cluster::getClusterAlias).collect(Collectors.toSet());
        for (String indexName : indexResolution.resolvedIndices()) {
            clustersWithNoMatchingIndices.remove(RemoteClusterAware.parseClusterAlias((String)indexName));
        }
        Object fatalErrorMessage = null;
        for (String c : clustersWithNoMatchingIndices) {
            String indexExpression = executionInfo.getCluster(c).getIndexExpression();
            if (EsqlCCSUtils.concreteIndexRequested(executionInfo.getCluster(c).getIndexExpression())) {
                String error = Strings.format((String)"Unknown index [%s]", (Object[])new Object[]{c.equals("") ? indexExpression : c + ":" + indexExpression});
                if (!executionInfo.isSkipUnavailable(c) || usedFilter) {
                    fatalErrorMessage = fatalErrorMessage == null ? error : (String)fatalErrorMessage + "; " + error;
                }
                if (usedFilter) continue;
                EsqlCCSUtils.markClusterWithFinalStateAndNoShards(executionInfo, c, executionInfo.isSkipUnavailable(c) ? EsqlExecutionInfo.Cluster.Status.SKIPPED : EsqlExecutionInfo.Cluster.Status.FAILED, (Exception)((Object)new VerificationException(error, new Object[0])));
                continue;
            }
            if (!indexResolution.isValid()) continue;
            List failures = indexResolution.failures().getOrDefault(c, List.of());
            if (failures.isEmpty()) {
                EsqlCCSUtils.markClusterWithFinalStateAndNoShards(executionInfo, c, EsqlExecutionInfo.Cluster.Status.SUCCESSFUL, null);
                continue;
            }
            Exception nonIndexNotFound = failures.stream().map(FieldCapabilitiesFailure::getException).filter(ex -> ExceptionsHelper.unwrap((Throwable)ex, (Class[])new Class[]{IndexNotFoundException.class}) == null).findAny().orElse(null);
            EsqlCCSUtils.markClusterWithFinalStateAndNoShards(executionInfo, c, EsqlExecutionInfo.Cluster.Status.SKIPPED, nonIndexNotFound);
        }
        if (fatalErrorMessage != null) {
            throw new VerificationException((String)fatalErrorMessage, new Object[0]);
        }
    }

    static void updateExecutionInfoWithClustersWithNoMatchingIndices(EsqlExecutionInfo executionInfo, IndexResolution indexResolution) {
        EsqlCCSUtils.updateExecutionInfoWithClustersWithNoMatchingIndices(executionInfo, indexResolution, false);
    }

    static boolean concreteIndexRequested(String indexExpression) {
        if (Strings.isNullOrBlank((String)indexExpression)) {
            return false;
        }
        for (String expr : indexExpression.split(",")) {
            if (expr.charAt(0) == '<' || expr.startsWith("-<") || expr.indexOf(42) >= 0) continue;
            return true;
        }
        return false;
    }

    static void updateExecutionInfoAtEndOfPlanning(EsqlExecutionInfo execInfo) {
        execInfo.markEndPlanning();
        if (execInfo.isCrossClusterSearch()) {
            for (String clusterAlias : execInfo.clusterAliases()) {
                EsqlExecutionInfo.Cluster cluster = execInfo.getCluster(clusterAlias);
                if (cluster.getStatus() != EsqlExecutionInfo.Cluster.Status.SKIPPED) continue;
                execInfo.swapCluster(clusterAlias, (k, v) -> new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setTook(execInfo.planningTookTime()).setTotalShards(0).setSuccessfulShards(0).setSkippedShards(0).setFailedShards(0).build());
            }
        }
    }

    public static void checkForCcsLicense(EsqlExecutionInfo executionInfo, List<IndexPattern> indices, IndicesExpressionGrouper indicesGrouper, Set<String> configuredClusters, XPackLicenseState licenseState) {
        for (IndexPattern index : indices) {
            Map groupedIndices;
            try {
                groupedIndices = indicesGrouper.groupIndices(configuredClusters, IndicesOptions.DEFAULT, index.indexPattern());
            }
            catch (NoSuchRemoteClusterException e) {
                if (EsqlLicenseChecker.isCcsAllowed(licenseState)) {
                    throw e;
                }
                throw EsqlLicenseChecker.invalidLicenseForCcsException(licenseState);
            }
            if (groupedIndices.size() <= 1 && groupedIndices.containsKey("") || EsqlLicenseChecker.isCcsAllowed(licenseState)) continue;
            for (Map.Entry entry : groupedIndices.entrySet()) {
                executionInfo.swapCluster((String)entry.getKey(), (k, v) -> new EsqlExecutionInfo.Cluster((String)entry.getKey(), Strings.arrayToCommaDelimitedString((Object[])((OriginalIndices)entry.getValue()).indices())));
            }
            throw EsqlLicenseChecker.invalidLicenseForCcsException(licenseState);
        }
    }

    public static void markClusterWithFinalStateAndNoShards(EsqlExecutionInfo executionInfo, String clusterAlias, EsqlExecutionInfo.Cluster.Status status, @Nullable Exception ex) {
        assert (status != EsqlExecutionInfo.Cluster.Status.RUNNING) : "status must be a final state, not RUNNING";
        executionInfo.swapCluster(clusterAlias, (k, v) -> {
            EsqlExecutionInfo.Cluster.Builder builder = new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v).setStatus(status).setTook(executionInfo.tookSoFar()).setTotalShards(Objects.requireNonNullElse(v.getTotalShards(), 0)).setSuccessfulShards(Objects.requireNonNullElse(v.getSuccessfulShards(), 0)).setSkippedShards(Objects.requireNonNullElse(v.getSkippedShards(), 0)).setFailedShards(Objects.requireNonNullElse(v.getFailedShards(), 0));
            if (ex != null) {
                builder.addFailures(List.of(new ShardSearchFailure(ex)));
            }
            return builder.build();
        });
    }

    public static boolean shouldIgnoreRuntimeError(EsqlExecutionInfo executionInfo, String clusterAlias, Exception e) {
        return executionInfo.isSkipUnavailable(clusterAlias);
    }

    public static boolean canAllowPartial(Exception e) {
        Throwable unwrapped = ExceptionsHelper.unwrapCause((Throwable)e);
        return !(unwrapped instanceof IndexNotFoundException) && !(unwrapped instanceof ElasticsearchSecurityException);
    }

    static abstract class CssPartialErrorsActionListener
    implements ActionListener<LogicalPlan> {
        private final EsqlExecutionInfo executionInfo;
        private final ActionListener<Result> listener;

        CssPartialErrorsActionListener(EsqlExecutionInfo executionInfo, ActionListener<Result> listener) {
            this.executionInfo = executionInfo;
            this.listener = listener;
        }

        public void onFailure(Exception e) {
            if (EsqlCCSUtils.returnSuccessWithEmptyResult(this.executionInfo, e)) {
                EsqlCCSUtils.updateExecutionInfoToReturnEmptyResult(this.executionInfo, e);
                this.listener.onResponse((Object)new Result(Analyzer.NO_FIELDS, Collections.emptyList(), DriverCompletionInfo.EMPTY, this.executionInfo));
            } else {
                this.listener.onFailure(e);
            }
        }
    }
}

