/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeotile;

public final class StGeotileFromFieldDocValuesAndLiteralAndLiteralEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator encoded;
    private final StGeotile.GeoTileBoundedGrid bounds;
    private final DriverContext driverContext;
    private Warnings warnings;

    public StGeotileFromFieldDocValuesAndLiteralAndLiteralEvaluator(Source source, EvalOperator.ExpressionEvaluator encoded, StGeotile.GeoTileBoundedGrid bounds, DriverContext driverContext) {
        this.source = source;
        this.encoded = encoded;
        this.bounds = bounds;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock encodedBlock = (LongBlock)this.encoded.eval(page);){
            LongBlock longBlock = this.eval(page.getPositionCount(), encodedBlock);
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, LongBlock encodedBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!encodedBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                try {
                    StGeotile.fromFieldDocValuesAndLiteralAndLiteral(result, p, encodedBlock, this.bounds);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "StGeotileFromFieldDocValuesAndLiteralAndLiteralEvaluator[encoded=" + String.valueOf(this.encoded) + ", bounds=" + String.valueOf(this.bounds) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.encoded);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory encoded;
        private final StGeotile.GeoTileBoundedGrid bounds;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory encoded, StGeotile.GeoTileBoundedGrid bounds) {
            this.source = source;
            this.encoded = encoded;
            this.bounds = bounds;
        }

        public StGeotileFromFieldDocValuesAndLiteralAndLiteralEvaluator get(DriverContext context) {
            return new StGeotileFromFieldDocValuesAndLiteralAndLiteralEvaluator(this.source, this.encoded.get(context), this.bounds, context);
        }

        public String toString() {
            return "StGeotileFromFieldDocValuesAndLiteralAndLiteralEvaluator[encoded=" + String.valueOf(this.encoded) + ", bounds=" + String.valueOf(this.bounds) + "]";
        }
    }
}

