/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeohexToLong;

public final class StGeohexToLongFromStringEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private final EvalOperator.ExpressionEvaluator gridId;

    public StGeohexToLongFromStringEvaluator(Source source, EvalOperator.ExpressionEvaluator gridId, DriverContext driverContext) {
        super(driverContext, source);
        this.gridId = gridId;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.gridId;
    }

    @Override
    public Block evalVector(Vector v) {
        BytesRefVector vector = (BytesRefVector)v;
        int positionCount = v.getPositionCount();
        BytesRef scratchPad = new BytesRef();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantLongBlockWith(this.evalValue(vector, 0, scratchPad), positionCount);
        }
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendLong(this.evalValue(vector, p, scratchPad));
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private long evalValue(BytesRefVector container, int index, BytesRef scratchPad) {
        BytesRef value = container.getBytesRef(index, scratchPad);
        return StGeohexToLong.fromString(value);
    }

    @Override
    public Block evalBlock(Block b) {
        BytesRefBlock block = (BytesRefBlock)b;
        int positionCount = block.getPositionCount();
        try (LongBlock.Builder builder = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            BytesRef scratchPad = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    long value = this.evalValue(block, i, scratchPad);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendLong(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    private long evalValue(BytesRefBlock container, int index, BytesRef scratchPad) {
        BytesRef value = container.getBytesRef(index, scratchPad);
        return StGeohexToLong.fromString(value);
    }

    public String toString() {
        return "StGeohexToLongFromStringEvaluator[gridId=" + String.valueOf(this.gridId) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.gridId);
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory gridId;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory gridId) {
            this.source = source;
            this.gridId = gridId;
        }

        public StGeohexToLongFromStringEvaluator get(DriverContext context) {
            return new StGeohexToLongFromStringEvaluator(this.source, this.gridId.get(context), context);
        }

        public String toString() {
            return "StGeohexToLongFromStringEvaluator[gridId=" + String.valueOf(this.gridId) + "]";
        }
    }
}

