/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeohex;

public final class StGeohexFromFieldAndLiteralEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator wkbBlock;
    private final int precision;
    private final DriverContext driverContext;
    private Warnings warnings;

    public StGeohexFromFieldAndLiteralEvaluator(Source source, EvalOperator.ExpressionEvaluator wkbBlock, int precision, DriverContext driverContext) {
        this.source = source;
        this.wkbBlock = wkbBlock;
        this.precision = precision;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock wkbBlockBlock = (BytesRefBlock)this.wkbBlock.eval(page);){
            LongBlock longBlock = this.eval(page.getPositionCount(), wkbBlockBlock);
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, BytesRefBlock wkbBlockBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!wkbBlockBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                try {
                    StGeohex.fromFieldAndLiteral(result, p, wkbBlockBlock, this.precision);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "StGeohexFromFieldAndLiteralEvaluator[wkbBlock=" + String.valueOf(this.wkbBlock) + ", precision=" + this.precision + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.wkbBlock);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory wkbBlock;
        private final int precision;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory wkbBlock, int precision) {
            this.source = source;
            this.wkbBlock = wkbBlock;
            this.precision = precision;
        }

        public StGeohexFromFieldAndLiteralEvaluator get(DriverContext context) {
            return new StGeohexFromFieldAndLiteralEvaluator(this.source, this.wkbBlock.get(context), this.precision, context);
        }

        public String toString() {
            return "StGeohexFromFieldAndLiteralEvaluator[wkbBlock=" + String.valueOf(this.wkbBlock) + ", precision=" + this.precision + "]";
        }
    }
}

