/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeohex;

public final class StGeohexFromFieldAndLiteralAndLiteralEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator in;
    private final StGeohex.GeoHexBoundedGrid bounds;
    private final DriverContext driverContext;
    private Warnings warnings;

    public StGeohexFromFieldAndLiteralAndLiteralEvaluator(Source source, EvalOperator.ExpressionEvaluator in, StGeohex.GeoHexBoundedGrid bounds, DriverContext driverContext) {
        this.source = source;
        this.in = in;
        this.bounds = bounds;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock inBlock = (BytesRefBlock)this.in.eval(page);){
            LongBlock longBlock = this.eval(page.getPositionCount(), inBlock);
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, BytesRefBlock inBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                boolean allBlocksAreNulls = true;
                if (!inBlock.isNull(p)) {
                    allBlocksAreNulls = false;
                }
                if (allBlocksAreNulls) {
                    result.appendNull();
                    continue;
                }
                try {
                    StGeohex.fromFieldAndLiteralAndLiteral(result, p, inBlock, this.bounds);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.warnings().registerException((Exception)e);
                    result.appendNull();
                }
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public String toString() {
        return "StGeohexFromFieldAndLiteralAndLiteralEvaluator[in=" + String.valueOf(this.in) + ", bounds=" + String.valueOf(this.bounds) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.in);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory in;
        private final StGeohex.GeoHexBoundedGrid bounds;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory in, StGeohex.GeoHexBoundedGrid bounds) {
            this.source = source;
            this.in = in;
            this.bounds = bounds;
        }

        public StGeohexFromFieldAndLiteralAndLiteralEvaluator get(DriverContext context) {
            return new StGeohexFromFieldAndLiteralAndLiteralEvaluator(this.source, this.in.get(context), this.bounds, context);
        }

        public String toString() {
            return "StGeohexFromFieldAndLiteralAndLiteralEvaluator[in=" + String.valueOf(this.in) + ", bounds=" + String.valueOf(this.bounds) + "]";
        }
    }
}

