/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToInt;

public final class RoundToIntBinarySearchEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field;
    private final int[] points;
    private final DriverContext driverContext;
    private Warnings warnings;

    public RoundToIntBinarySearchEvaluator(Source source, EvalOperator.ExpressionEvaluator field, int[] points, DriverContext driverContext) {
        this.source = source;
        this.field = field;
        this.points = points;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (IntBlock fieldBlock = (IntBlock)this.field.eval(page);){
            IntVector fieldVector = fieldBlock.asVector();
            if (fieldVector == null) {
                IntBlock intBlock = this.eval(page.getPositionCount(), fieldBlock);
                return intBlock;
            }
            IntBlock intBlock = this.eval(page.getPositionCount(), fieldVector).asBlock();
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, IntBlock fieldBlock) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (fieldBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (fieldBlock.getValueCount(p) != 1) {
                    if (fieldBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendInt(RoundToInt.process(fieldBlock.getInt(fieldBlock.getFirstValueIndex(p)), this.points));
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntVector eval(int positionCount, IntVector fieldVector) {
        try (IntVector.FixedBuilder result = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendInt(p, RoundToInt.process(fieldVector.getInt(p), this.points));
            }
            IntVector intVector = result.build();
            return intVector;
        }
    }

    public String toString() {
        return "RoundToIntBinarySearchEvaluator[field=" + String.valueOf(this.field) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.field);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;
        private final int[] points;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field, int[] points) {
            this.source = source;
            this.field = field;
            this.points = points;
        }

        public RoundToIntBinarySearchEvaluator get(DriverContext context) {
            return new RoundToIntBinarySearchEvaluator(this.source, this.field.get(context), this.points, context);
        }

        public String toString() {
            return "RoundToIntBinarySearchEvaluator[field=" + String.valueOf(this.field) + "]";
        }
    }
}

