/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.OrdinalBytesRefBlock;
import org.elasticsearch.compute.data.OrdinalBytesRefVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToString;

public final class ToStringFromIPEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private final EvalOperator.ExpressionEvaluator ip;

    public ToStringFromIPEvaluator(Source source, EvalOperator.ExpressionEvaluator ip, DriverContext driverContext) {
        super(driverContext, source);
        this.ip = ip;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.ip;
    }

    @Override
    public Block evalVector(Vector v) {
        BytesRefVector vector = (BytesRefVector)v;
        OrdinalBytesRefVector ordinals = vector.asOrdinals();
        if (ordinals != null) {
            return this.evalOrdinals(ordinals);
        }
        int positionCount = v.getPositionCount();
        BytesRef scratchPad = new BytesRef();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantBytesRefBlockWith(this.evalValue(vector, 0, scratchPad), positionCount);
        }
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendBytesRef(this.evalValue(vector, p, scratchPad));
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private BytesRef evalValue(BytesRefVector container, int index, BytesRef scratchPad) {
        BytesRef value = container.getBytesRef(index, scratchPad);
        return ToString.fromIP(value);
    }

    @Override
    public Block evalBlock(Block b) {
        BytesRefBlock block = (BytesRefBlock)b;
        int positionCount = block.getPositionCount();
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            BytesRef scratchPad = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    BytesRef value = this.evalValue(block, i, scratchPad);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendBytesRef(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private BytesRef evalValue(BytesRefBlock container, int index, BytesRef scratchPad) {
        BytesRef value = container.getBytesRef(index, scratchPad);
        return ToString.fromIP(value);
    }

    private Block evalOrdinals(OrdinalBytesRefVector v) {
        int positionCount = v.getDictionaryVector().getPositionCount();
        BytesRef scratchPad = new BytesRef();
        try (BytesRefVector.Builder builder = this.driverContext.blockFactory().newBytesRefVectorBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendBytesRef(this.evalValue(v.getDictionaryVector(), p, scratchPad));
            }
            IntVector ordinals = v.getOrdinalsVector();
            ordinals.incRef();
            OrdinalBytesRefBlock ordinalBytesRefBlock = new OrdinalBytesRefVector(ordinals, builder.build()).asBlock();
            return ordinalBytesRefBlock;
        }
    }

    public String toString() {
        return "ToStringFromIPEvaluator[ip=" + String.valueOf(this.ip) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.ip);
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory ip;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory ip) {
            this.source = source;
            this.ip = ip;
        }

        public ToStringFromIPEvaluator get(DriverContext context) {
            return new ToStringFromIPEvaluator(this.source, this.ip.get(context), context);
        }

        public String toString() {
            return "ToStringFromIPEvaluator[ip=" + String.valueOf(this.ip) + "]";
        }
    }
}

