/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromAggregateMetricDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromCartesianPointEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromCartesianShapeEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromDateNanosEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromDatetimeEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromGeoPointEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromGeoShapeEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromIPEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToStringFromVersionEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public class ToString
extends AbstractConvertFunction
implements EvaluatorMapper {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "ToString", ToString::new);
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataType.KEYWORD, (source, fieldEval) -> fieldEval), Map.entry(DataType.BOOLEAN, ToStringFromBooleanEvaluator.Factory::new), Map.entry(DataType.DATETIME, ToStringFromDatetimeEvaluator.Factory::new), Map.entry(DataType.DATE_NANOS, ToStringFromDateNanosEvaluator.Factory::new), Map.entry(DataType.IP, ToStringFromIPEvaluator.Factory::new), Map.entry(DataType.DOUBLE, ToStringFromDoubleEvaluator.Factory::new), Map.entry(DataType.LONG, ToStringFromLongEvaluator.Factory::new), Map.entry(DataType.INTEGER, ToStringFromIntEvaluator.Factory::new), Map.entry(DataType.TEXT, (source, fieldEval) -> fieldEval), Map.entry(DataType.VERSION, ToStringFromVersionEvaluator.Factory::new), Map.entry(DataType.UNSIGNED_LONG, ToStringFromUnsignedLongEvaluator.Factory::new), Map.entry(DataType.GEO_POINT, ToStringFromGeoPointEvaluator.Factory::new), Map.entry(DataType.CARTESIAN_POINT, ToStringFromCartesianPointEvaluator.Factory::new), Map.entry(DataType.CARTESIAN_SHAPE, ToStringFromCartesianShapeEvaluator.Factory::new), Map.entry(DataType.GEO_SHAPE, ToStringFromGeoShapeEvaluator.Factory::new), Map.entry(DataType.AGGREGATE_METRIC_DOUBLE, ToStringFromAggregateMetricDoubleEvaluator.Factory::new));

    @FunctionInfo(returnType={"keyword"}, description="Converts an input value into a string.", examples={@Example(file="string", tag="to_string"), @Example(description="It also works fine on multivalued fields:", file="string", tag="to_string_multivalue")})
    public ToString(Source source, @Param(name="field", type={"aggregate_metric_double", "boolean", "cartesian_point", "cartesian_shape", "date", "date_nanos", "double", "geo_point", "geo_shape", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="Input value. The input can be a single- or multi-valued column or an expression.") Expression v) {
        super(source, v);
    }

    private ToString(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return ToString.ENTRY.name;
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataType.KEYWORD;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToString(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToString::new, (Object)this.field());
    }

    static BytesRef fromBoolean(boolean bool) {
        return EsqlDataTypeConverter.numericBooleanToString(bool);
    }

    static BytesRef fromIP(BytesRef ip) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.ipToString(ip));
    }

    static BytesRef fromDatetime(long datetime) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.dateTimeToString(datetime));
    }

    static BytesRef fromDateNanos(long datetime) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.nanoTimeToString(datetime));
    }

    static BytesRef fromDouble(double dbl) {
        return EsqlDataTypeConverter.numericBooleanToString(dbl);
    }

    static BytesRef fromDouble(long lng) {
        return EsqlDataTypeConverter.numericBooleanToString(lng);
    }

    static BytesRef fromDouble(int integer) {
        return EsqlDataTypeConverter.numericBooleanToString(integer);
    }

    static BytesRef fromVersion(BytesRef version) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.versionToString(version));
    }

    static BytesRef fromUnsignedLong(long lng) {
        return EsqlDataTypeConverter.unsignedLongToString(lng);
    }

    static BytesRef fromGeoPoint(BytesRef wkb) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.spatialToString(wkb));
    }

    static BytesRef fromCartesianPoint(BytesRef wkb) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.spatialToString(wkb));
    }

    static BytesRef fromCartesianShape(BytesRef wkb) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.spatialToString(wkb));
    }

    static BytesRef fromGeoShape(BytesRef wkb) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.spatialToString(wkb));
    }
}

