/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Avg;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;

public class AvgOverTime
extends TimeSeriesAggregateFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "AvgOverTime", AvgOverTime::new);

    @FunctionInfo(returnType={"double"}, description="The average over time of a numeric field.", type=FunctionType.AGGREGATE)
    public AvgOverTime(Source source, @Param(name="number", type={"double", "integer", "long"}, description="Expression that outputs values to average.") Expression field) {
        this(source, field, (Expression)Literal.TRUE);
    }

    public AvgOverTime(Source source, Expression field, Expression filter) {
        super(source, field, filter, Collections.emptyList());
    }

    private AvgOverTime(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return this.perTimeSeriesAggregation().resolveType();
    }

    public String getWriteableName() {
        return AvgOverTime.ENTRY.name;
    }

    public DataType dataType() {
        return this.perTimeSeriesAggregation().dataType();
    }

    protected NodeInfo<AvgOverTime> info() {
        return NodeInfo.create((Node)this, AvgOverTime::new, (Object)this.field(), (Object)this.filter());
    }

    public AvgOverTime replaceChildren(List<Expression> newChildren) {
        return new AvgOverTime(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    public AvgOverTime withFilter(Expression filter) {
        return new AvgOverTime(this.source(), this.field(), filter);
    }

    @Override
    public AggregateFunction perTimeSeriesAggregation() {
        return new Avg(this.source(), this.field(), this.filter());
    }
}

