/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene.read;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.AbstractPageMappingToIteratorOperator;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ValuesSourceReaderOperatorStatus
extends AbstractPageMappingToIteratorOperator.Status {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "values_source_reader", ValuesSourceReaderOperatorStatus::readFrom);
    private static final TransportVersion SPLIT_ON_BIG_VALUES = TransportVersion.fromName((String)"esql_split_on_big_values");
    private final Map<String, Integer> readersBuilt;
    private final long valuesLoaded;

    public ValuesSourceReaderOperatorStatus(Map<String, Integer> readersBuilt, long processNanos, int pagesReceived, int pagesEmitted, long rowsReceived, long rowsEmitted, long valuesLoaded) {
        super(processNanos, pagesReceived, pagesEmitted, rowsReceived, rowsEmitted);
        this.readersBuilt = readersBuilt;
        this.valuesLoaded = valuesLoaded;
    }

    static ValuesSourceReaderOperatorStatus readFrom(StreamInput in) throws IOException {
        long rowsEmitted;
        long rowsReceived;
        int pagesEmitted;
        int pagesReceived;
        long processNanos;
        if (ValuesSourceReaderOperatorStatus.supportsSplitOnBigValues(in.getTransportVersion())) {
            status = new AbstractPageMappingToIteratorOperator.Status(in);
            processNanos = ((AbstractPageMappingToIteratorOperator.Status)status).processNanos();
            pagesReceived = ((AbstractPageMappingToIteratorOperator.Status)status).pagesReceived();
            pagesEmitted = ((AbstractPageMappingToIteratorOperator.Status)status).pagesEmitted();
            rowsReceived = ((AbstractPageMappingToIteratorOperator.Status)status).rowsReceived();
            rowsEmitted = ((AbstractPageMappingToIteratorOperator.Status)status).rowsEmitted();
        } else {
            status = new AbstractPageMappingOperator.Status(in);
            processNanos = ((AbstractPageMappingOperator.Status)status).processNanos();
            pagesReceived = ((AbstractPageMappingOperator.Status)status).pagesProcessed();
            pagesEmitted = ((AbstractPageMappingOperator.Status)status).pagesProcessed();
            rowsReceived = ((AbstractPageMappingOperator.Status)status).rowsReceived();
            rowsEmitted = ((AbstractPageMappingOperator.Status)status).rowsEmitted();
        }
        Map readersBuilt = in.readOrderedMap(StreamInput::readString, StreamInput::readVInt);
        long valuesLoaded = ValuesSourceReaderOperatorStatus.supportsValuesLoaded(in.getTransportVersion()) ? in.readVLong() : 0L;
        return new ValuesSourceReaderOperatorStatus(readersBuilt, processNanos, pagesReceived, pagesEmitted, rowsReceived, rowsEmitted, valuesLoaded);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (ValuesSourceReaderOperatorStatus.supportsSplitOnBigValues(out.getTransportVersion())) {
            super.writeTo(out);
        } else {
            new AbstractPageMappingOperator.Status(this.processNanos(), this.pagesEmitted(), this.rowsReceived(), this.rowsEmitted()).writeTo(out);
        }
        out.writeMap(this.readersBuilt, StreamOutput::writeVInt);
        if (ValuesSourceReaderOperatorStatus.supportsValuesLoaded(out.getTransportVersion())) {
            out.writeVLong(this.valuesLoaded);
        }
    }

    private static boolean supportsSplitOnBigValues(TransportVersion version) {
        return version.supports(SPLIT_ON_BIG_VALUES);
    }

    private static boolean supportsValuesLoaded(TransportVersion version) {
        return version.onOrAfter((VersionId)TransportVersions.ESQL_DOCUMENTS_FOUND_AND_VALUES_LOADED) || version.isPatchFrom(TransportVersions.ESQL_DOCUMENTS_FOUND_AND_VALUES_LOADED_8_19);
    }

    @Override
    public String getWriteableName() {
        return ValuesSourceReaderOperatorStatus.ENTRY.name;
    }

    public Map<String, Integer> readersBuilt() {
        return this.readersBuilt;
    }

    @Override
    public long valuesLoaded() {
        return this.valuesLoaded;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("readers_built");
        for (Map.Entry<String, Integer> e : this.readersBuilt.entrySet()) {
            builder.field(e.getKey(), e.getValue());
        }
        builder.endObject();
        builder.field("values_loaded", this.valuesLoaded);
        this.innerToXContent(builder);
        return builder.endObject();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ValuesSourceReaderOperatorStatus status = (ValuesSourceReaderOperatorStatus)o;
        return this.readersBuilt.equals(status.readersBuilt) && this.valuesLoaded == status.valuesLoaded;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.readersBuilt, this.valuesLoaded);
    }

    @Override
    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

