/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.PercentileFloatAggregator;
import org.elasticsearch.compute.aggregation.QuantileStates;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class PercentileFloatGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("quart", ElementType.BYTES_REF));
    private final QuantileStates.GroupingState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;
    private final double percentile;

    public PercentileFloatGroupingAggregatorFunction(List<Integer> channels, QuantileStates.GroupingState state, DriverContext driverContext, double percentile) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
        this.percentile = percentile;
    }

    public static PercentileFloatGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext, double percentile) {
        return new PercentileFloatGroupingAggregatorFunction(channels, PercentileFloatAggregator.initGrouping(driverContext, percentile), driverContext, percentile);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final FloatBlock valuesBlock = (FloatBlock)page.getBlock(this.channels.get(0));
        final FloatVector valuesVector = valuesBlock.asVector();
        if (valuesVector == null) {
            if (valuesBlock.mayHaveNulls()) {
                this.state.enableGroupIdTracking(seenGroupIds);
            }
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                    PercentileFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock);
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                    PercentileFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    PercentileFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesBlock);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                PercentileFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                PercentileFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                PercentileFloatGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valuesVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, FloatBlock values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                if (values.isNull(groupPosition + positionOffset)) continue;
                int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
                int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
                for (int v = valuesStart; v < valuesEnd; ++v) {
                    PercentileFloatAggregator.combine(this.state, groupId, values.getFloat(v));
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, FloatVector values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                PercentileFloatAggregator.combine(this.state, groupId, values.getFloat(groupPosition + positionOffset));
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, FloatBlock values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                if (values.isNull(groupPosition + positionOffset)) continue;
                int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
                int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
                for (int v = valuesStart; v < valuesEnd; ++v) {
                    PercentileFloatAggregator.combine(this.state, groupId, values.getFloat(v));
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, FloatVector values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                PercentileFloatAggregator.combine(this.state, groupId, values.getFloat(groupPosition + positionOffset));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, FloatBlock values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            if (values.isNull(groupPosition + positionOffset)) continue;
            int valuesStart = values.getFirstValueIndex(groupPosition + positionOffset);
            int valuesEnd = valuesStart + values.getValueCount(groupPosition + positionOffset);
            for (int v = valuesStart; v < valuesEnd; ++v) {
                PercentileFloatAggregator.combine(this.state, groupId, values.getFloat(v));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, FloatVector values) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            PercentileFloatAggregator.combine(this.state, groupId, values.getFloat(groupPosition + positionOffset));
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object quartUncast = page.getBlock(this.channels.get(0));
        if (quartUncast.areAllValuesNull()) {
            return;
        }
        BytesRefVector quart = ((BytesRefBlock)quartUncast).asVector();
        BytesRef scratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            PercentileFloatAggregator.combineIntermediate(this.state, groupId, quart.getBytesRef(groupPosition + positionOffset, scratch));
        }
    }

    @Override
    public void addIntermediateRowInput(int groupId, GroupingAggregatorFunction input, int position) {
        if (input.getClass() != this.getClass()) {
            throw new IllegalArgumentException("expected " + String.valueOf(this.getClass()) + "; got " + String.valueOf(input.getClass()));
        }
        QuantileStates.GroupingState inState = ((PercentileFloatGroupingAggregatorFunction)input).state;
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        PercentileFloatAggregator.combineStates(this.state, groupId, inState, position);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext evaluatorContext) {
        blocks[offset] = PercentileFloatAggregator.evaluateFinal(this.state, selected, evaluatorContext.driverContext());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

