/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb.patternedtext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PatternedTextValueProcessor {
    private static final String TEXT_ARG_PLACEHOLDER = "%W";
    private static final String DELIMITER = "[\\s\\[\\]]";
    private static final String SPACE = " ";

    static Parts split(String text) {
        StringBuilder template = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>();
        String[] tokens = text.split(DELIMITER);
        int textIndex = 0;
        for (String token : tokens) {
            if (token.isEmpty()) {
                if (textIndex >= text.length() - 1) continue;
                template.append(text.charAt(textIndex++));
                continue;
            }
            if (PatternedTextValueProcessor.isArg(token)) {
                args.add(token);
                template.append(TEXT_ARG_PLACEHOLDER);
            } else {
                template.append(token);
            }
            if ((textIndex += token.length()) >= text.length()) continue;
            template.append(text.charAt(textIndex++));
        }
        while (textIndex < text.length()) {
            template.append(text.charAt(textIndex++));
        }
        return new Parts(template.toString(), args);
    }

    private static boolean isArg(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (!Character.isDigit(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    static String merge(Parts parts) {
        StringBuilder builder = new StringBuilder();
        String[] templateParts = parts.template.split(DELIMITER);
        int i = 0;
        int templateIndex = 0;
        for (String part : templateParts) {
            if (part.equals(TEXT_ARG_PLACEHOLDER)) {
                builder.append(parts.args.get(i++));
                templateIndex += TEXT_ARG_PLACEHOLDER.length();
            } else if (!part.isEmpty()) {
                builder.append(part);
                templateIndex += part.length();
            }
            if (templateIndex >= parts.template.length()) continue;
            builder.append(parts.template.charAt(templateIndex++));
        }
        assert (i == parts.args.size()) : "expected " + i + " but got " + parts.args.size();
        assert (!builder.toString().contains(TEXT_ARG_PLACEHOLDER)) : builder.toString();
        while (templateIndex < parts.template.length()) {
            builder.append(parts.template.charAt(templateIndex++));
        }
        return builder.toString();
    }

    static String encodeRemainingArgs(Parts parts) {
        return String.join((CharSequence)SPACE, parts.args);
    }

    static List<String> decodeRemainingArgs(String mergedArgs) {
        return Arrays.asList(mergedArgs.split(SPACE));
    }

    static int countArgs(String template) {
        int count = 0;
        for (int i = 0; i < template.length() - 1; ++i) {
            char next;
            if (template.charAt(i) != '%' || (next = template.charAt(i + 1)) != 'W') continue;
            ++count;
            ++i;
        }
        return count;
    }

    record Parts(String template, List<String> args) {
    }
}

