/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb.patternedtext;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.KeywordDocValuesField;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.logsdb.patternedtext.PatternedTextDocValues;
import org.elasticsearch.xpack.logsdb.patternedtext.PatternedTextFieldType;

public class PatternedTextIndexFieldData
implements IndexFieldData<LeafFieldData> {
    private final PatternedTextFieldType fieldType;

    PatternedTextIndexFieldData(PatternedTextFieldType fieldType) {
        this.fieldType = fieldType;
    }

    public String getFieldName() {
        return this.fieldType.name();
    }

    public ValuesSourceType getValuesSourceType() {
        return null;
    }

    public LeafFieldData load(LeafReaderContext context) {
        try {
            return this.loadDirect(context);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public LeafFieldData loadDirect(LeafReaderContext context) throws IOException {
        LeafReader leafReader = context.reader();
        final PatternedTextDocValues docValues = PatternedTextDocValues.from(leafReader, this.fieldType.templateFieldName(), this.fieldType.argsFieldName());
        return new LeafFieldData(){
            final ToScriptFieldFactory<SortedBinaryDocValues> factory = KeywordDocValuesField::new;

            public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
                return this.factory.getScriptFieldFactory((Object)this.getBytesValues(), name);
            }

            public SortedBinaryDocValues getBytesValues() {
                return new SortedBinaryDocValues(){

                    public boolean advanceExact(int doc) throws IOException {
                        return docValues.advanceExact(doc);
                    }

                    public int docValueCount() {
                        return 1;
                    }

                    public BytesRef nextValue() throws IOException {
                        return docValues.binaryValue();
                    }
                };
            }

            public long ramBytesUsed() {
                return 1L;
            }
        };
    }

    public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        throw new IllegalArgumentException("not supported for source patterned text field type");
    }

    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("only supported on numeric fields");
    }

    static class Builder
    implements IndexFieldData.Builder {
        final PatternedTextFieldType fieldType;

        Builder(PatternedTextFieldType fieldType) {
            this.fieldType = fieldType;
        }

        public PatternedTextIndexFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new PatternedTextIndexFieldData(this.fieldType);
        }
    }
}

