/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.voyageai.request;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.voyageai.embeddings.VoyageAIEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.voyageai.embeddings.VoyageAIEmbeddingsTaskSettings;

public record VoyageAIEmbeddingsRequestEntity(List<String> input, InputType inputType, VoyageAIEmbeddingsServiceSettings serviceSettings, VoyageAIEmbeddingsTaskSettings taskSettings, String model) implements ToXContentObject
{
    private static final String DOCUMENT = "document";
    private static final String QUERY = "query";
    private static final String INPUT_FIELD = "input";
    private static final String MODEL_FIELD = "model";
    public static final String INPUT_TYPE_FIELD = "input_type";
    public static final String TRUNCATION_FIELD = "truncation";
    public static final String OUTPUT_DIMENSION = "output_dimension";
    static final String OUTPUT_DTYPE_FIELD = "output_dtype";

    public VoyageAIEmbeddingsRequestEntity {
        Objects.requireNonNull(input);
        Objects.requireNonNull(model);
        Objects.requireNonNull(taskSettings);
        Objects.requireNonNull(serviceSettings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INPUT_FIELD, this.input);
        builder.field(MODEL_FIELD, this.model);
        if (InputType.isSpecified((InputType)this.inputType)) {
            builder.field(INPUT_TYPE_FIELD, VoyageAIEmbeddingsRequestEntity.convertToString(this.inputType));
        } else if (InputType.isSpecified((InputType)this.taskSettings.getInputType())) {
            builder.field(INPUT_TYPE_FIELD, VoyageAIEmbeddingsRequestEntity.convertToString(this.taskSettings.getInputType()));
        }
        if (this.taskSettings.getTruncation() != null) {
            builder.field(TRUNCATION_FIELD, this.taskSettings.getTruncation());
        }
        if (this.serviceSettings.dimensions() != null) {
            builder.field(OUTPUT_DIMENSION, this.serviceSettings.dimensions());
        }
        if (this.serviceSettings.getEmbeddingType() != null) {
            builder.field(OUTPUT_DTYPE_FIELD, this.serviceSettings.getEmbeddingType().toRequestString());
        }
        builder.endObject();
        return builder;
    }

    public static String convertToString(InputType inputType) {
        InputType inputType2 = inputType;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"INGEST", "INTERNAL_INGEST", "SEARCH", "INTERNAL_SEARCH"}, (InputType)inputType2, n)) {
            case -1 -> null;
            case 0, 1 -> DOCUMENT;
            case 2, 3 -> QUERY;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)InputType.invalidInputTypeMessage((InputType)inputType));
                }
                yield null;
            }
        };
    }
}

