/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.ibmwatsonx.rerank;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class IbmWatsonxRerankTaskSettings
implements TaskSettings {
    public static final String NAME = "ibm_watsonx_rerank_task_settings";
    public static final String RETURN_DOCUMENTS = "return_documents";
    public static final String TOP_N_DOCS_ONLY = "top_n";
    public static final String TRUNCATE_INPUT_TOKENS = "truncate_input_tokens";
    static final IbmWatsonxRerankTaskSettings EMPTY_SETTINGS = new IbmWatsonxRerankTaskSettings(null, null, null);
    private final Integer topNDocumentsOnly;
    private final Boolean returnDocuments;
    private final Integer truncateInputTokens;

    public static IbmWatsonxRerankTaskSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        if (map == null || map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        Boolean returnDocuments = ServiceUtils.extractOptionalBoolean(map, RETURN_DOCUMENTS, validationException);
        Integer topNDocumentsOnly = ServiceUtils.extractOptionalPositiveInteger(map, TOP_N_DOCS_ONLY, "task_settings", validationException);
        Integer truncateInputTokens = ServiceUtils.extractOptionalPositiveInteger(map, TRUNCATE_INPUT_TOKENS, "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return IbmWatsonxRerankTaskSettings.of(topNDocumentsOnly, returnDocuments, truncateInputTokens);
    }

    public static IbmWatsonxRerankTaskSettings of(IbmWatsonxRerankTaskSettings originalSettings, IbmWatsonxRerankTaskSettings requestTaskSettings) {
        return new IbmWatsonxRerankTaskSettings(requestTaskSettings.getTopNDocumentsOnly() != null ? requestTaskSettings.getTopNDocumentsOnly() : originalSettings.getTopNDocumentsOnly(), requestTaskSettings.getReturnDocuments() != null ? requestTaskSettings.getReturnDocuments() : originalSettings.getReturnDocuments(), requestTaskSettings.getTruncateInputTokens() != null ? requestTaskSettings.getTruncateInputTokens() : originalSettings.getTruncateInputTokens());
    }

    public static IbmWatsonxRerankTaskSettings of(Integer topNDocumentsOnly, Boolean returnDocuments, Integer maxChunksPerDoc) {
        return new IbmWatsonxRerankTaskSettings(topNDocumentsOnly, returnDocuments, maxChunksPerDoc);
    }

    public IbmWatsonxRerankTaskSettings(StreamInput in) throws IOException {
        this(in.readOptionalInt(), in.readOptionalBoolean(), in.readOptionalInt());
    }

    public IbmWatsonxRerankTaskSettings(@Nullable Integer topNDocumentsOnly, @Nullable Boolean doReturnDocuments, @Nullable Integer truncateInputTokens) {
        this.topNDocumentsOnly = topNDocumentsOnly;
        this.returnDocuments = doReturnDocuments;
        this.truncateInputTokens = truncateInputTokens;
    }

    public boolean isEmpty() {
        return this.topNDocumentsOnly == null && this.returnDocuments == null && this.truncateInputTokens == null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.topNDocumentsOnly != null) {
            builder.field(TOP_N_DOCS_ONLY, this.topNDocumentsOnly);
        }
        if (this.returnDocuments != null) {
            builder.field(RETURN_DOCUMENTS, this.returnDocuments);
        }
        if (this.truncateInputTokens != null) {
            builder.field(TRUNCATE_INPUT_TOKENS, this.truncateInputTokens);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_IBM_WATSONX_RERANK_ADDED;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.topNDocumentsOnly);
        out.writeOptionalBoolean(this.returnDocuments);
        out.writeOptionalInt(this.truncateInputTokens);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IbmWatsonxRerankTaskSettings that = (IbmWatsonxRerankTaskSettings)o;
        return Objects.equals(this.returnDocuments, that.returnDocuments) && Objects.equals(this.topNDocumentsOnly, that.topNDocumentsOnly) && Objects.equals(this.truncateInputTokens, that.truncateInputTokens);
    }

    public int hashCode() {
        return Objects.hash(this.returnDocuments, this.topNDocumentsOnly, this.truncateInputTokens);
    }

    public Boolean getDoesReturnDocuments() {
        return this.returnDocuments;
    }

    public Integer getTopNDocumentsOnly() {
        return this.topNDocumentsOnly;
    }

    public Boolean getReturnDocuments() {
        return this.returnDocuments;
    }

    public Integer getTruncateInputTokens() {
        return this.truncateInputTokens;
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        IbmWatsonxRerankTaskSettings updatedSettings = IbmWatsonxRerankTaskSettings.fromMap(new HashMap<String, Object>(newSettings));
        return IbmWatsonxRerankTaskSettings.of(this, updatedSettings);
    }
}

