/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.request;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.googlevertexai.completion.GoogleVertexAiChatCompletionModel;
import org.elasticsearch.xpack.inference.services.googlevertexai.request.GoogleVertexAiRequest;
import org.elasticsearch.xpack.inference.services.googlevertexai.request.GoogleVertexAiUnifiedChatCompletionRequestEntity;

public class GoogleVertexAiUnifiedChatCompletionRequest
implements GoogleVertexAiRequest {
    private final GoogleVertexAiChatCompletionModel model;
    private final UnifiedChatInput unifiedChatInput;
    private final URI uri;

    public GoogleVertexAiUnifiedChatCompletionRequest(UnifiedChatInput unifiedChatInput, GoogleVertexAiChatCompletionModel model) {
        this.model = Objects.requireNonNull(model);
        this.unifiedChatInput = Objects.requireNonNull(unifiedChatInput);
        this.uri = unifiedChatInput.stream() ? model.streamingURI() : model.nonStreamingUri();
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.uri);
        GoogleVertexAiUnifiedChatCompletionRequestEntity requestEntity = new GoogleVertexAiUnifiedChatCompletionRequestEntity(this.unifiedChatInput);
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)requestEntity).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaType());
        this.decorateWithAuth(httpPost);
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    public void decorateWithAuth(HttpPost httpPost) {
        GoogleVertexAiRequest.decorateWithBearerToken(httpPost, this.model.getSecretSettings());
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }

    @Override
    public boolean isStreaming() {
        return this.unifiedChatInput.stream();
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }
}

