/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.densetextembeddings;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.SimilarityMeasure;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class ElasticInferenceServiceDenseTextEmbeddingsServiceSettings
extends FilteredXContentObject
implements ServiceSettings,
ElasticInferenceServiceRateLimitServiceSettings {
    public static final String NAME = "elastic_inference_service_dense_embeddings_service_settings";
    public static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(10000L);
    private final String modelId;
    private final SimilarityMeasure similarity;
    private final Integer dimensions;
    private final Integer maxInputTokens;
    private final RateLimitSettings rateLimitSettings;

    public static ElasticInferenceServiceDenseTextEmbeddingsServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        return switch (context) {
            default -> throw new MatchException(null, null);
            case ConfigurationParseContext.REQUEST -> ElasticInferenceServiceDenseTextEmbeddingsServiceSettings.fromRequestMap(map, context);
            case ConfigurationParseContext.PERSISTENT -> ElasticInferenceServiceDenseTextEmbeddingsServiceSettings.fromPersistentMap(map, context);
        };
    }

    private static ElasticInferenceServiceDenseTextEmbeddingsServiceSettings fromRequestMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String modelId = ServiceUtils.extractRequiredString(map, "model_id", "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "elastic", context);
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer dims = ServiceUtils.removeAsType(map, "dimensions", Integer.class);
        Integer maxInputTokens = ServiceUtils.removeAsType(map, "max_input_tokens", Integer.class);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new ElasticInferenceServiceDenseTextEmbeddingsServiceSettings(modelId, similarity, dims, maxInputTokens, rateLimitSettings);
    }

    private static ElasticInferenceServiceDenseTextEmbeddingsServiceSettings fromPersistentMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String modelId = ServiceUtils.extractRequiredString(map, "model_id", "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "elastic", context);
        SimilarityMeasure similarity = ServiceUtils.extractSimilarity(map, "service_settings", validationException);
        Integer dims = ServiceUtils.removeAsType(map, "dimensions", Integer.class);
        Integer maxInputTokens = ServiceUtils.removeAsType(map, "max_input_tokens", Integer.class);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new ElasticInferenceServiceDenseTextEmbeddingsServiceSettings(modelId, similarity, dims, maxInputTokens, rateLimitSettings);
    }

    public ElasticInferenceServiceDenseTextEmbeddingsServiceSettings(String modelId, @Nullable SimilarityMeasure similarity, @Nullable Integer dimensions, @Nullable Integer maxInputTokens, RateLimitSettings rateLimitSettings) {
        this.modelId = modelId;
        this.similarity = similarity;
        this.dimensions = dimensions;
        this.maxInputTokens = maxInputTokens;
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public ElasticInferenceServiceDenseTextEmbeddingsServiceSettings(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.similarity = (SimilarityMeasure)in.readOptionalEnum(SimilarityMeasure.class);
        this.dimensions = in.readOptionalVInt();
        this.maxInputTokens = in.readOptionalVInt();
        this.rateLimitSettings = new RateLimitSettings(in);
    }

    public SimilarityMeasure similarity() {
        return this.similarity;
    }

    public Integer dimensions() {
        return this.dimensions;
    }

    public Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    @Override
    public String modelId() {
        return this.modelId;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public DenseVectorFieldMapper.ElementType elementType() {
        return DenseVectorFieldMapper.ElementType.FLOAT;
    }

    public RateLimitSettings getRateLimitSettings() {
        return this.rateLimitSettings;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("model_id", this.modelId);
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.similarity != null) {
            builder.field("similarity", (Enum)this.similarity);
        }
        if (this.dimensions != null) {
            builder.field("dimensions", this.dimensions);
        }
        if (this.maxInputTokens != null) {
            builder.field("max_input_tokens", this.maxInputTokens);
        }
        this.toXContentFragmentOfExposedFields(builder, params);
        builder.endObject();
        return builder;
    }

    public TransportVersion getMinimalSupportedVersion() {
        assert (false) : "should never be called when supportsVersion is used";
        return TransportVersions.ML_INFERENCE_ELASTIC_DENSE_TEXT_EMBEDDINGS_ADDED;
    }

    public boolean supportsVersion(TransportVersion version) {
        return version.onOrAfter((VersionId)TransportVersions.ML_INFERENCE_ELASTIC_DENSE_TEXT_EMBEDDINGS_ADDED) || version.isPatchFrom(TransportVersions.ML_INFERENCE_ELASTIC_DENSE_TEXT_EMBEDDINGS_ADDED_8_19);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeOptionalEnum((Enum)SimilarityMeasure.translateSimilarity((SimilarityMeasure)this.similarity, (TransportVersion)out.getTransportVersion()));
        out.writeOptionalVInt(this.dimensions);
        out.writeOptionalVInt(this.maxInputTokens);
        this.rateLimitSettings.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElasticInferenceServiceDenseTextEmbeddingsServiceSettings that = (ElasticInferenceServiceDenseTextEmbeddingsServiceSettings)o;
        return Objects.equals(this.modelId, that.modelId) && this.similarity == that.similarity && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.maxInputTokens, that.maxInputTokens) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.similarity, this.dimensions, this.maxInputTokens, this.rateLimitSettings);
    }
}

