/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.authorization;

import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchWrapperException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceResponseHandler;
import org.elasticsearch.xpack.inference.services.elastic.authorization.ElasticInferenceServiceAuthorizationModel;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceAuthorizationRequest;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceRequest;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceRequestMetadata;
import org.elasticsearch.xpack.inference.services.elastic.response.ElasticInferenceServiceAuthorizationResponseEntity;
import org.elasticsearch.xpack.inference.telemetry.TraceContext;

public class ElasticInferenceServiceAuthorizationRequestHandler {
    private static final String FAILED_TO_RETRIEVE_MESSAGE = "Failed to retrieve the authorization information from the Elastic Inference Service.";
    private static final TimeValue DEFAULT_AUTH_TIMEOUT = TimeValue.timeValueMinutes((long)1L);
    private static final ResponseHandler AUTH_RESPONSE_HANDLER = ElasticInferenceServiceAuthorizationRequestHandler.createAuthResponseHandler();
    private final String baseUrl;
    private final ThreadPool threadPool;
    private final Logger logger;
    private final CountDownLatch requestCompleteLatch = new CountDownLatch(1);

    private static ResponseHandler createAuthResponseHandler() {
        return new ElasticInferenceServiceResponseHandler(Strings.format((String)"%s authorization", (Object[])new Object[]{"Elastic Inference Service"}), ElasticInferenceServiceAuthorizationResponseEntity::fromResponse);
    }

    public ElasticInferenceServiceAuthorizationRequestHandler(@Nullable String baseUrl, ThreadPool threadPool) {
        this.baseUrl = baseUrl;
        this.threadPool = Objects.requireNonNull(threadPool);
        this.logger = LogManager.getLogger(ElasticInferenceServiceAuthorizationRequestHandler.class);
    }

    ElasticInferenceServiceAuthorizationRequestHandler(@Nullable String baseUrl, ThreadPool threadPool, Logger logger) {
        this.baseUrl = baseUrl;
        this.threadPool = Objects.requireNonNull(threadPool);
        this.logger = Objects.requireNonNull(logger);
    }

    public void getAuthorization(ActionListener<ElasticInferenceServiceAuthorizationModel> listener, Sender sender) {
        try {
            this.logger.debug("Retrieving authorization information from the Elastic Inference Service.");
            if (Strings.isNullOrEmpty((String)this.baseUrl)) {
                this.logger.debug("The base URL for the authorization service is not valid, rejecting authorization.");
                listener.onResponse((Object)ElasticInferenceServiceAuthorizationModel.newDisabledService());
                return;
            }
            sender.start();
            ActionListener newListener = ActionListener.wrap(results -> {
                if (results instanceof ElasticInferenceServiceAuthorizationResponseEntity) {
                    ElasticInferenceServiceAuthorizationResponseEntity authResponseEntity = (ElasticInferenceServiceAuthorizationResponseEntity)results;
                    listener.onResponse((Object)ElasticInferenceServiceAuthorizationModel.of(authResponseEntity));
                } else {
                    this.logger.warn(Strings.format((String)"Failed to retrieve the authorization information from the Elastic Inference Service. Received an invalid response type: %s", (Object[])new Object[]{results.getClass().getSimpleName()}));
                    listener.onResponse((Object)ElasticInferenceServiceAuthorizationModel.newDisabledService());
                }
                this.requestCompleteLatch.countDown();
            }, e -> {
                Throwable exception = e;
                if (e instanceof ElasticsearchWrapperException) {
                    ElasticsearchWrapperException wrapperException = (ElasticsearchWrapperException)e;
                    exception = wrapperException.getCause();
                }
                this.logger.warn(Strings.format((String)"Failed to retrieve the authorization information from the Elastic Inference Service. Encountered an exception: %s", (Object[])new Object[]{exception}));
                listener.onResponse((Object)ElasticInferenceServiceAuthorizationModel.newDisabledService());
                this.requestCompleteLatch.countDown();
            });
            ElasticInferenceServiceRequestMetadata requestMetadata = ElasticInferenceServiceRequest.extractRequestMetadataFromThreadContext(this.threadPool.getThreadContext());
            ElasticInferenceServiceAuthorizationRequest request = new ElasticInferenceServiceAuthorizationRequest(this.baseUrl, this.getCurrentTraceInfo(), requestMetadata);
            sender.sendWithoutQueuing(this.logger, request, AUTH_RESPONSE_HANDLER, DEFAULT_AUTH_TIMEOUT, (ActionListener<InferenceServiceResults>)newListener);
        }
        catch (Exception e2) {
            this.logger.warn(Strings.format((String)"Retrieving the authorization information encountered an exception: %s", (Object[])new Object[]{e2}));
            this.requestCompleteLatch.countDown();
        }
    }

    private TraceContext getCurrentTraceInfo() {
        String traceParent = this.threadPool.getThreadContext().getHeader("traceparent");
        String traceState = this.threadPool.getThreadContext().getHeader("tracestate");
        return new TraceContext(traceParent, traceState);
    }

    void waitForAuthRequestCompletion(TimeValue timeValue) throws IllegalStateException {
        try {
            if (!this.requestCompleteLatch.await(timeValue.getMillis(), TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException("The wait time has expired for authorization to complete.");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Waiting for authorization to complete was interrupted");
        }
    }
}

