/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic;

import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.EmbeddingsInput;
import org.elasticsearch.xpack.inference.external.http.sender.ExecutableInferenceRequest;
import org.elasticsearch.xpack.inference.external.http.sender.InferenceInputs;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceRequestManager;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceResponseHandler;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceSparseEmbeddingsRequest;
import org.elasticsearch.xpack.inference.services.elastic.response.ElasticInferenceServiceSparseEmbeddingsResponseEntity;
import org.elasticsearch.xpack.inference.services.elastic.sparseembeddings.ElasticInferenceServiceSparseEmbeddingsModel;
import org.elasticsearch.xpack.inference.telemetry.TraceContext;

public class ElasticInferenceServiceSparseEmbeddingsRequestManager
extends ElasticInferenceServiceRequestManager {
    private static final Logger logger = LogManager.getLogger(ElasticInferenceServiceSparseEmbeddingsRequestManager.class);
    private static final ResponseHandler HANDLER = ElasticInferenceServiceSparseEmbeddingsRequestManager.createSparseEmbeddingsHandler();
    private final ElasticInferenceServiceSparseEmbeddingsModel model;
    private final Truncator truncator;
    private final TraceContext traceContext;

    private static ResponseHandler createSparseEmbeddingsHandler() {
        return new ElasticInferenceServiceResponseHandler(String.format(Locale.ROOT, "%s sparse embeddings", "Elastic Inference Service"), ElasticInferenceServiceSparseEmbeddingsResponseEntity::fromResponse);
    }

    public ElasticInferenceServiceSparseEmbeddingsRequestManager(ElasticInferenceServiceSparseEmbeddingsModel model, ServiceComponents serviceComponents, TraceContext traceContext) {
        super(serviceComponents.threadPool(), model);
        this.model = model;
        this.truncator = serviceComponents.truncator();
        this.traceContext = traceContext;
    }

    @Override
    public void execute(InferenceInputs inferenceInputs, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, ActionListener<InferenceServiceResults> listener) {
        EmbeddingsInput input = EmbeddingsInput.of(inferenceInputs);
        List<String> docsInput = input.getStringInputs();
        InputType inputType = input.getInputType();
        Truncator.TruncationResult truncatedInput = Truncator.truncate(docsInput, this.model.getServiceSettings().maxInputTokens());
        ElasticInferenceServiceSparseEmbeddingsRequest request = new ElasticInferenceServiceSparseEmbeddingsRequest(this.truncator, truncatedInput, this.model, this.traceContext, this.requestMetadata(), inputType);
        this.execute(new ExecutableInferenceRequest(requestSender, logger, request, HANDLER, hasRequestCompletedFunction, listener));
    }
}

